// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __SEARCH_H
#define __SEARCH_H

#include "project.h"


// a class to manage searches

typedef struct tagSEARCHDATA
{
  CProject *project;                                          // the project pointer
  CString *keystr;                                            // the key string
  char *result;                                               // space to pass back a result
  int abortnow;                                               // flag to indicate an abort
} SEARCHDATA;


class CSearch
{
protected:
  CStringArray m_KnownTypes;                                  // array of type strings with known speeds
  CDWordArray m_KeysPerSecond;                                // corresponding array of speeds

  int GetKeysPerSecond(const CString& type);                  // get keys/second

public:
  CPtrArray m_Threads;                                        // running threads
  CPtrArray m_ThreadData;                                     // corresponding SEARCHDATA structs
  CWordArray m_SuspendedThreads;

  CSearch();                                                  // constructor
  ~CSearch();                                                 // destructor

  BOOL IsKnownType(const CString& type) const;                // is a known project type
  void Start(const CProject *project,const CString& keystr);  // start a search
  int Recalibrate(const CString& type);                       // update keys/sec
  CString GetTime(const CString& keystr,const CString& type,int keyspersec);
  void Write(CFile& file);                                    // write to disk
  void Read(CFile& file);                                     // read from disk
};


#endif
