// Simple Key Search Protocol Client
// (c) Andy Brown 1995
  

#ifndef __PROJECT_H
#define __PROJECT_H


// a class to hold the details of a project

class CProject
{
protected:
  time_t m_Date;                                // date of last update

  CString m_ID;                                 // project ID
  CString m_Type;                               // project type
  CString m_Description;                        // project description
  CString m_Status;                             // status of project
  CString m_Email;                              // manager email

  CString m_KeyServer;                          // server to contact for keys
  unsigned short m_KeyPort;                     // port number of key server

  CString m_WorkServer;                         // server to call for work
  unsigned short m_WorkPort;                    // port number of work server

  CStringArray m_Allocated;                     // keys currently allocated
  CString m_Work;                               // project file

  void Assign(const CProject& src);             // assign src to this

public:
  CProject(CFile& file);                        // construct from file
  CProject(const CString& id,
           const CString& type,
           const CString& description,
           const CString& status,
           const CString& email,
           const CString& keyserverport,
           const CString& workserver,
           const unsigned short workport);      // constructor
  CProject(const CProject& src);                // copy constructor

  ~CProject();                                  // destructor

  void Set(const CString& id,                   // set details
           const CString& type,
           const CString& description,
           const CString& status,
           const CString& email,
           const CString& keyserverport,
           const CString& workserver,
           const unsigned short workport);

  time_t GetDate(void) const;                   // member access functions
  CString GetID(void) const;
  CString GetType(void) const;
  CString GetDescription(void) const;
  CString GetStatus(void) const;
  CString GetEmail(void) const;

  CString GetKeyServer(void) const;
  unsigned short GetKeyPort(void) const;

  CString GetWorkServer(void) const;
  unsigned short GetWorkPort(void) const;

  CString GetWork(void) const;
  unsigned short GetChecksum(void);             // calculate the WORK checksum
  CStringArray *GetAllocated(void);

  void UpdateWork(CStringArray *array);         // update the work
  void AddKeys(const CString &keystr);          // add keys

  void Write(CFile& file);                      // write project to disk
  void Read(CFile& file);                       // read project from disk

  CProject& operator=(const CProject& src);     // overloaded = operator
};


// include the inline members

#include "project.inl"

#endif
