// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "project.h"
#include "utils.h"


/***********************/
/* Construct from file */
/***********************/

CProject::CProject(CFile& file)
{
  Read(file);
}


/***************/
/* Constructor */
/***************/

CProject::CProject(const CString& id,const CString& type,const CString& description,
                   const CString& status,const CString& email,const CString& serverport,
                   const CString& workserver,const unsigned short workport)
{
  Set(id,type,description,status,email,serverport,workserver,workport);
}


/***************/
/* Set details */
/***************/

void CProject::Set(const CString& id,const CString& type,const CString& description,
                   const CString& status,const CString& email,const CString& serverport,
                   const CString& workserver,const unsigned short workport)
{
  m_ID=id;
  m_Type=type;
  m_Description=description;
  m_Status=status;
  m_Email=email;

  m_WorkServer=workserver;
  m_WorkPort=workport;

// split up key server/port into server and port

  int index=serverport.Find('/');
  if(index==-1)
  {
    m_KeyServer=serverport;
    m_KeyPort=19957;
  }
  else
  {
    m_KeyServer=serverport.Left(index);
    char buffer[100];
    lstrcpy(buffer,(const char *)serverport.Right(serverport.GetLength()-index-1));
    sscanf(buffer,"%hu",&m_KeyPort);
  }
}


/********************/
/* Copy constructor */
/********************/

CProject::CProject(const CProject& src)
{
  Assign(src);
}


/**********************/
/* Assign src to this */
/**********************/

void CProject::Assign(const CProject& src)
{
  m_ID=src.GetID();
  m_Type=src.GetType();
  m_Description=src.GetDescription();
  m_Status=src.GetStatus();
  m_Email=src.GetEmail();
  m_Date=src.GetDate();

  m_KeyServer=src.GetKeyServer();
  m_KeyPort=src.GetKeyPort();

  m_WorkServer=src.GetWorkServer();
  m_WorkPort=src.GetWorkPort();

  m_Work=src.GetWork();

  CStringArray *array=((CProject&)src).GetAllocated();
  m_Allocated.RemoveAll();
  for(int i=0;i<array->GetSize();i++)
    m_Allocated.Add((*array)[i]);
}


/**************/
/* Destructor */
/**************/

CProject::~CProject()
{
}


/***********************************/
/* Update the work for the project */
/***********************************/

void CProject::UpdateWork(CStringArray *array)
{
  m_Work.Empty();

  for(int i=0;i<array->GetSize();i++)
    m_Work+=((*array)[i])+"\r\n";

  m_Date=time(NULL);
}


/*****************************/
/* Write the project to disk */
/*****************************/

void CProject::Write(CFile& file)
{
  ut_WriteLong(file,(unsigned long)m_Date);
  ut_WriteString(file,m_ID);
  ut_WriteString(file,m_Type);
  ut_WriteString(file,m_Description);
  ut_WriteString(file,m_Status);
  ut_WriteString(file,m_Email);

  ut_WriteString(file,m_KeyServer);
  ut_WriteLong(file,(unsigned long)m_KeyPort);

  ut_WriteString(file,m_WorkServer);
  ut_WriteLong(file,(unsigned long)m_WorkPort);

  ut_WriteStringArray(file,m_Allocated);
  ut_WriteString(file,m_Work);
}


/****************************/
/* Read a project from disk */
/****************************/

void CProject::Read(CFile& file)
{
  m_Date=(time_t)ut_ReadLong(file);
  m_ID=ut_ReadString(file);
  m_Type=ut_ReadString(file);
  m_Description=ut_ReadString(file);
  m_Status=ut_ReadString(file);
  m_Email=ut_ReadString(file);

  m_KeyServer=ut_ReadString(file);
  m_KeyPort=(unsigned short)ut_ReadLong(file);

  m_WorkServer=ut_ReadString(file);
  m_WorkPort=(unsigned short)ut_ReadLong(file);

  ut_ReadStringArray(file,m_Allocated);
  m_Work=ut_ReadString(file);
}


/****************************************/
/* Calculate the checksum for a project */
/****************************************/

unsigned short CProject::GetChecksum(void)
{
  unsigned short checksum=0;
  int index=0;
  BOOL use;

  for(int i=0;i<m_Work.GetLength();i++)
  {
    if(!index)
      use=(m_Work[i]!='#');
    
    if(use && !isspace(m_Work[i]))
      checksum+=m_Work[i];

    index=m_Work[i]=='\n' ? 0 : index+1;
  }

  return checksum;
}


/*************************/
/* Overloaded = operator */
/*************************/

CProject& CProject::operator=(const CProject& src)
{
  Assign(src);
  return *this;
}
