// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __PRJARRAY_H
#define __PRJARRAY_H

#include "project.h"


// a class to hold an array of projects

class CProjectArray
{
protected:
  CPtrArray m_Projects;

public:
  CProjectArray();
  ~CProjectArray();

  void Cleanup(void);

  CProject *GetAt(const int index) const;
  void Add(CProject *project);
  void RemoveAt(const int index);
  int GetSize(void) const;

  void Read(CFile& file);
  void Write(CFile& file);

  CProject *operator[](const int index) const;
};


// include the inline members

#include "prjarray.inl"

#endif
