// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "prjarray.h"
#include "utils.h"


/***************/
/* Constructor */
/***************/

CProjectArray::CProjectArray()
{
}


/**************/
/* Destructor */
/**************/

CProjectArray::~CProjectArray()
{
  Cleanup();
}


/**********************/
/* Clean up the array */
/**********************/

void CProjectArray::Cleanup(void)
{
  for(int i=0;i<m_Projects.GetSize();i++)
    delete (CProject *)m_Projects[i];
}


/************************/
/* Get project at index */
/************************/

CProject *CProjectArray::GetAt(const int index) const
{
  ASSERT(index>=0 && index<GetSize());

  return (CProject *)m_Projects[index];
}


/**************************/
/* overloaded [] operator */
/**************************/

CProject *CProjectArray::operator[](const int index) const
{
  return GetAt(index);
}


/******************************/
/* Add a project to the array */
/******************************/

void CProjectArray::Add(CProject *project)
{
  m_Projects.Add(project);
}


/**********************************/
/* Remove a project from the list */
/**********************************/

void CProjectArray::RemoveAt(const int index)
{
  ASSERT(index>=0 && index<GetSize());

  delete (CProject *)m_Projects[index];
  m_Projects.RemoveAt(index);
}


/***********************************/
/* Write the project array to disk */
/***********************************/

void CProjectArray::Write(CFile& file)
{
// write the number of projects

  ut_WriteLong(file,(unsigned long)m_Projects.GetSize());

// write each project

  for(int i=0;i<m_Projects.GetSize();i++)
    ((CProject *)m_Projects[i])->Write(file);
}


/************************************/
/* Read the project array from disk */
/************************************/

void CProjectArray::Read(CFile& file)
{
// get rid of the old projects if any

  Cleanup();

// read the number of projects

  int count=(int)ut_ReadLong(file);

// read each project

  for(int i=0;i<count;i++)
  {
    CProject *prj=new CProject(file);
    Add(prj);
  }
}
