// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __CLVIEW_H
#define __CLVIEW_H

#include "resource.h"
#include "cldoc.h"


class CClientView : public CFormView
{
protected: // create from serialization only
	CClientView();
	DECLARE_DYNCREATE(CClientView)

  int GetProject(const CString& pid);
  void ProcessAck(void);
  void ProcessWork(void);
  void ProcessKeys(void);
  void ProcessInfo(void);

public:
	//{{AFX_DATA(CClientView)
	enum { IDD = IDD_SKSPCLNT_FORM };
	CComboBox	m_Servers;
	CEdit	m_Port;
	CStatic	m_Status;
	CListBox	m_Allocated;
	CButton	m_Search;
	CButton	m_Eliminate;
	CButton	m_Reject;
	CButton	m_FoundKey;
	CComboBox	m_Project;
	CButton	m_Update;
	CButton	m_Remove;
	CButton	m_Properties;
	CButton	m_GetKeys;
	CButton	m_Retrieve;
	CButton	m_Cancel;
	//}}AFX_DATA

// Attributes
public:
	CClientDoc *GetDocument();
  void EnableRetrieve(void);
  void EnableButtons(const BOOL bEnable);
  void ProcessMessage(UINT msg);
  void RefillProjectList(void);
  void RefillKeysList(void);
  void RefillServerList(void);
  void SetControls(void);

  CString GetServer(void);
  unsigned short GetPort(void);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CClientView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CClientView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CClientView)
	afx_msg void OnSelchangeProject();
	afx_msg void OnSelchangeAllocated();
	afx_msg void OnCancel();
	afx_msg void OnRetrieve();
	afx_msg void OnUpdate();
	afx_msg void OnProperties();
	afx_msg void OnGetkeys();
	afx_msg void OnRemove();
	afx_msg void OnReject();
	afx_msg void OnEliminate();
	afx_msg void OnFoundkey();
	afx_msg void OnChangePort();
	afx_msg void OnEditchangeServers();
	afx_msg void OnSelchangeServers();
	afx_msg void OnSearch();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in clview.cpp
inline CClientDoc* CClientView::GetDocument()
   { return (CClientDoc*)m_pDocument; }
#endif


#endif

