// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "SKSPclnt.h"
#include "cldoc.h"
#include "clview.h"
#include "propdlg.h"
#include "utils.h"
#include "srchdlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CClientDoc, CDocument)


/***************/
/* Message map */
/***************/

BEGIN_MESSAGE_MAP(CClientDoc, CDocument)
	//{{AFX_MSG_MAP(CClientDoc)
	ON_COMMAND(ID_FILE_PROPERTIES, OnFileProperties)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_SEARCHES, OnUpdateOptionsSearches)
	ON_COMMAND(ID_OPTIONS_SEARCHES, OnOptionsSearches)
	ON_COMMAND(ID_HELP_INDEX, OnHelpIndex)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/***************/
/* Constructor */
/***************/

CClientDoc::CClientDoc()
{
}


/**************/
/* Destructor */
/**************/

CClientDoc::~CClientDoc()
{
  Write();
}


/*************************/
/* New document override */
/*************************/

BOOL CClientDoc::OnNewDocument()
{
	if(!CDocument::OnNewDocument())
		return FALSE;

  Read();
	return TRUE;
}


/************************/
/* Unused serialisation */
/************************/

void CClientDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}


/**************************/
/* CClientDoc diagnostics */
/**************************/

#ifdef _DEBUG
void CClientDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CClientDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif


/**********************/
/* Name/Email address */
/**********************/

void CClientDoc::OnFileProperties() 
{
	CPropDlg dlg;

  dlg.m_Email=m_Email;
  dlg.m_Name=m_Name;

  if(dlg.DoModal()==IDOK)
  {
    m_Email=dlg.m_Email;
    m_Name=dlg.m_Name;

    POSITION pos=GetFirstViewPosition();
    ((CClientView *)GetNextView(pos))->EnableRetrieve();
  }
}


/******************************/
/* Write SKSPCLNT.INF to disk */
/******************************/

void CClientDoc::Write(void)
{
  TRY
  {
    CFile file("SKSPCLNT.INF",CFile::modeCreate|CFile::modeWrite);
    ut_WriteString(file,m_Email);
    ut_WriteString(file,m_Name);
    m_Projects.Write(file);
    m_Servers.Write(file);
    MYAPP->m_Search.Write(file);
  }
  CATCH(CFileException,theException)
  {
    CString err=ut_FileExceptionToString(theException->m_cause);
    AfxMessageBox(err);
	}
	END_CATCH
}


/*******************************/
/* Read SKSPCLNT.INF from disk */
/*******************************/

void CClientDoc::Read(void)
{
  TRY
  {
    CFile file("SKSPCLNT.INF",CFile::modeRead);
    m_Email=ut_ReadString(file);
    m_Name=ut_ReadString(file);
    m_Projects.Read(file);
    m_Servers.Read(file);
    MYAPP->m_Search.Read(file);
    SetTitle("SKSPclnt.INF");
  }
  CATCH(CFileException,theException)
  {
    AfxMessageBox(ERR_INF);
	}
	END_CATCH
}


/********************************/
/* View searches... menu option */
/********************************/

void CClientDoc::OnUpdateOptionsSearches(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(MYAPP->m_bViewingSearches==FALSE);
}


void CClientDoc::OnOptionsSearches() 
{
	CSearchDlg *pDlg=new CSearchDlg();
}


/***************************/
/* Check if frame can quit */
/***************************/

BOOL CClientDoc::CanCloseFrame(CFrameWnd* pFrame) 
{
// cannot quit if there's a network operation going on

  if(MYAPP->m_SKSP.IsRunning())
  {
    AfxMessageBox(ERR_NETWORK);
    return 0;
  }

// cannot quit if there are any searches present

  if(MYAPP->m_Search.m_Threads.GetSize())
  {
    AfxMessageBox(ERR_RUNNINGSEARCHES);
    return 0;
  }
	
	return CDocument::CanCloseFrame(pFrame);
}


/********************/
/* WinHelp commands */
/********************/

void CClientDoc::OnHelpIndex() 
{
  ::WinHelp(NULL,"SKSPclnt.HLP",HELP_CONTENTS,0);	
}
