/*----------------------------------------------------------------------------

                                brutessl 1.02

                        Copyright (C) 1995 Andrew Roos
                             All Rights Reserved

This program is licensed for academic and educational use only. It may not be
used  for  any commercial purpose. You may modify the program if you wish to,
provided that the original copyright  notice  and  license  restrictions  are
retained,  and  that  you include a notice stating that you have modified the
program and giving details of the changes that you have made. This program is
distributed  without  any warranty including, but not limited to, the implied 
warranty of merchantability or fitness for a particular purpose.  

synopsis:  A program for brute-force searching SSL data which has been 
           encrypted using 40-bit (export) RC4 keys.

usage:     brutessl [-q] -t [hh:[mm]]
           brutessl [-q] <file> <checksum> <start segment> <no of segments>
           brutessl [-q] -r <start segment> [<no of segments>]

Andrew Roos <andrewr@vironix.co.za>
----------------------------------------------------------------------------*/

#ifndef INCL_BRUTESSL
#define INCL_BRUTESSL

/* Add code here to select the fastest "word" size for each system.
 * Hardware	cc	char	short	int	long
 * MIPS irix	cc  -O2	35200<=	31000	28400	28400
 * ALPHA	cc  -O2	15000	13600	23000<=	18900
 * i486 linux	cc  -O2	11200<=	10200	10500	10500
 * HP700	gcc -O2	19800<-	19000	21600<<	21600
 * sun4		gcc -O2	 6900<=	 6100	 5400	 5400
 * MIPS ultrix	gcc -O2	 3700<-	 3800	 3400	 3600
 * HP300	gcc -O2	 1500<=	  900	 1300	 1300
 */

#if	!defined(RC4_BYTE) && (defined(__alpha) || defined(__alpha__))
#define	RC4_BYTE int
#endif

/* If none set, "char" is probably the best bet */
#ifndef	RC4_BYTE
#define	RC4_BYTE char
#endif

#if	!defined(WORD) && (defined(__DOS) || defined(__DOS__))
#define	WORD long
#endif

/* If none set, "int" is probably the best bet */
#ifndef	WORD
#define	WORD int
#endif

/* If your system does not have 32-bit integers, you need to change "word" */
typedef unsigned char byte; 	/* 8-bit unsigned integer */
typedef unsigned RC4_BYTE rc4_byte; /* "efficient" storage, for speed */
typedef unsigned WORD word;	/* 32-bit unsigned integer */

typedef struct 
{
	byte master[16];	/* Master key. First 11 bytes are known. */
	byte key_type;		/* '0' for client read, '1' for client write */
	byte challenge[16];	/* challenge data from client-hello message */
	byte conn_id[16];	/* connection id from server-hello message */
	byte pad[3];		/* MD5 padding, {0x80,0x00,0x00} */
} ssl_block;

/* We need a rotate_left(w,n) macro which rotates w, a 32-bit word, n bits  */
/* to the left. If your platform has a native rotate-left operation, then   */
/* you should make rotate_left use this. If rotate_left is undefined then a */
/* generic macro is used which should work on all platforms but which will  */
/* be slower than a native operation. I've included macros for 16-bit and   */
/* 32-bit Microsoft compilers. All but one should be commented out.         */

/* #define rotate_left(w,n) ((word)_lrotl((unsigned long)(w),(n))) */
/* #define rotate_left(w,n) ((word)_rotl((unsigned)(w),(n))) */

extern int big_endian;		/* true if platform is big-endian  */

int search_18_bits(ssl_block *ssl, const byte *stream);

/* If no rotate_left macro has been defined, use the generic one */

#ifndef rotate_left
#define rotate_left(w,n) (rot_tmp=(w),(rot_tmp<<(n))|(rot_tmp>>(32-(n))))
#define DECLARE_ROTATE_VARS word rot_tmp;
#else 
#define DECLARE_ROTATE_VARS
#endif

#endif /* INCL_BRUTESSL */
