/*----------------------------------------------------------------------------

                                brutessl 1.0

                        Copyright (C) 1995 Andrew Roos
                             All Rights Reserved

This program is licensed for academic and educational use only. It may not be
used  for  any commercial purpose. You may modify the program if you wish to,
provided that the original copyright  notice  and  license  restrictions  are
retained,  and  that  you include a notice stating that you have modified the
program and giving details of the changes that you have made. This program is
distributed  without  any warranty including, but not limited to, the implied 
warranty of merchantability or fitness for a particular purpose.  

synopsis:  A program for brute-force searching SSL data which has been 
           encrypted using 40-bit (export) RC4 keys.

usage:	   brutessl [-q] -t [hh:[mm]]
	   brutessl [-q] <file> <checksum> <start segment> <no of segments>
	   brutessl [-q] -r <start segment> [<no of segments>]

Andrew Roos <andrewr@vironix.co.za>
----------------------------------------------------------------------------*/

#include "brutessl.h"

/* Prepare one byte of state[] using the key byte */
/* in register reg. ebx is index, edi is state_p, */
/* cx used for temporary storage.                 */

#define prep_byte(reg) 				\
__asm	add	bl,reg 				\
__asm	mov	dl,byte ptr [edi] 		\
__asm	add	bl,dl 				\
__asm	mov	dh,byte ptr state[ebx] 		\
__asm	mov	byte ptr [edi],dh 		\
__asm	inc	edi 				\
__asm	mov	byte ptr state[ebx],dl	

/* Prepare four bytes of state[] using the next   */
/* 32 bits of the key which are stored at *wp.    */

#define prep_word(wp)				\
__asm	mov	eax,dword ptr [wp]		\
	prep_byte(al) 				\
	prep_byte(ah)				\
__asm	shr	eax,16				\
	prep_byte(al) 				\
	prep_byte(ah)

/* Skip the next generated byte of the RC4 stream.*/
/* ebx is index, edi is state_p, dl is tmp and al */
/* is used for temp storage so dh is not changed. */

#define skip_byte				\
__asm	inc	edi				\
__asm	mov	dl,byte ptr [edi]               \
__asm	add	bl,dl				\
__asm	mov	al,byte ptr state[ebx]		\
__asm	mov	byte ptr [edi],al		\
__asm	mov	byte ptr state[ebx],dl


int search_18_bits(ssl_block *ssl, const byte *stream)
{
	static byte initial_state[256];
	static byte state[256];
	word precomp[4];
	word digest[4];
	word loop_counter;
	int retval;
	
	__asm {
		/* Need to save ebp because we use it for working */
		/* storage in MD5 calculation. Flags are saved    */
		/* because we reset the direction flag. 	  */

		pushf
		push	ebp

		cld				/* auto increment string ops */

		/* Set up initial_state */

		sub	ecx,ecx

init_loop:	mov	byte ptr initial_state[ecx],cl
		inc	cl
		jnz	init_loop

		/* MD5 Precomputation */

		mov	eax,0x67452301		/* word_A */
		mov	ebx,0xefcdab89		/* word_B */
		mov	ecx,0x98badcfe		/* word_C */
		mov	edx,0x10325476		/* word_D */
		mov	esi,ssl			/* MD5 input block */

		mov	ebp,ebx			/* 1 */
		and	ebp,ecx
		mov	edi,ebx
		not	edi
		and	edi,edx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi]
		add	eax,0xd76aa478
		rol	eax,7
		add	eax,ebx

		mov	ebp,eax			/* 2 */
		and	ebp,ebx
		mov	edi,eax
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+4]
		add	edx,0xe8c7b756
		rol	edx,12
		add	edx,eax

		mov	ebp,edx			/* 3 */
		and	ebp,eax
		mov	edi,edx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+8]
		add	ecx,0x242070db
		rol	ecx,17
		add	ecx,edx

		mov	ebp,ecx			/* 4a */
		and	ebp,edx
		mov	edi,ecx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ebx,edi
		add	ebx,0xc1bdceee

		mov	ebp,dword ptr [esp]	/* needed to access local vars */

		mov	dword ptr [precomp],eax
		mov	dword ptr [precomp+4],ebx
		mov	dword ptr [precomp+8],ecx
		mov	dword ptr [precomp+12],edx

		mov	loop_counter,262144	/* search 18 bits of key space */

try_key_loop:	/* load precomputed values */

		mov	eax,dword ptr [precomp]
		mov	ebx,dword ptr [precomp+4]
		mov	ecx,dword ptr [precomp+8]
		mov	edx,dword ptr [precomp+12]

		/* complete "half done" forth calculation */

		add	ebx,dword ptr [esi+12]	
		rol	ebx,22
		add	ebx,ecx

		/* Start of generated code. We don't just use macros   */
		/* because of short-cuts taken with input words 13-15, */
		/* which don't really exist!                           */

		/* Round One */

		mov	ebp,ebx			/* 5 */
		and	ebp,ecx
		mov	edi,ebx
		not	edi
		and	edi,edx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+16]
		add	eax,0xf57c0faf
		rol	eax,7
		add	eax,ebx

		mov	ebp,eax			/* 6 */
		and	ebp,ebx
		mov	edi,eax
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+20]
		add	edx,0x4787c62a
		rol	edx,12
		add	edx,eax

		mov	ebp,edx			/* 7 */
		and	ebp,eax
		mov	edi,edx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+24]
		add	ecx,0xa8304613
		rol	ecx,17
		add	ecx,edx

		mov	ebp,ecx			/* 8 */
		and	ebp,edx
		mov	edi,ecx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi+28]
		add	ebx,0xfd469501
		rol	ebx,22
		add	ebx,ecx

		mov	ebp,ebx			/* 9 */
		and	ebp,ecx
		mov	edi,ebx
		not	edi
		and	edi,edx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+32]
		add	eax,0x698098d8
		rol	eax,7
		add	eax,ebx

		mov	ebp,eax			/* 10 */
		and	ebp,ebx
		mov	edi,eax
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+36]
		add	edx,0x8b44f7af
		rol	edx,12
		add	edx,eax

		mov	ebp,edx			/* 11 */
		and	ebp,eax
		mov	edi,edx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+40]
		add	ecx,0xffff5bb1
		rol	ecx,17
		add	ecx,edx

		mov	ebp,ecx			/* 12 */
		and	ebp,edx
		mov	edi,ecx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi+44]
		add	ebx,0x895cd7be
		rol	ebx,22
		add	ebx,ecx

		mov	ebp,ebx			/* 13 */
		and	ebp,ecx
		mov	edi,ebx
		not	edi
		and	edi,edx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+48]
		add	eax,0x6b901122
		rol	eax,7
		add	eax,ebx

		mov	ebp,eax			/* 14 */
		and	ebp,ebx
		mov	edi,eax
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	edx,edi
		add	edx,0xfd987193
		rol	edx,12
		add	edx,eax

		mov	ebp,edx			/* 15 */
		and	ebp,eax
		mov	edi,edx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	ecx,edi
		add	ecx,0xa6794516
		rol	ecx,17
		add	ecx,edx

		mov	ebp,ecx			/* 16 */
		and	ebp,edx
		mov	edi,ecx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ebx,edi
		add	ebx,0x49b40821
		rol	ebx,22
		add	ebx,ecx

		/* Round Two */

		mov	ebp,edx			/* 17 */
		and	ebp,ebx
		mov	edi,edx
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+4]
		add	eax,0xf61e2562
		rol	eax,5
		add	eax,ebx

		mov	ebp,ecx			/* 18 */
		and	ebp,eax
		mov	edi,ecx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+24]
		add	edx,0xc040b340
		rol	edx,9
		add	edx,eax

		mov	ebp,ebx			/* 19 */
		and	ebp,edx
		mov	edi,ebx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+44]
		add	ecx,0x265e5a51
		rol	ecx,14
		add	ecx,edx

		mov	ebp,eax			/* 20 */
		and	ebp,ecx
		mov	edi,eax
		not	edi
		and	edi,edx
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi]
		add	ebx,0xe9b6c7aa
		rol	ebx,20
		add	ebx,ecx

		mov	ebp,edx			/* 21 */
		and	ebp,ebx
		mov	edi,edx
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+20]
		add	eax,0xd62f105d
		rol	eax,5
		add	eax,ebx

		mov	ebp,ecx			/* 22 */
		and	ebp,eax
		mov	edi,ecx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+40]
		add	edx,0x02441453
		rol	edx,9
		add	edx,eax

		mov	ebp,ebx			/* 23 */
		and	ebp,edx
		mov	edi,ebx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ecx,edi
		add	ecx,0xd8a1e681
		rol	ecx,14
		add	ecx,edx

		mov	ebp,eax			/* 24 */
		and	ebp,ecx
		mov	edi,eax
		not	edi
		and	edi,edx
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi+16]
		add	ebx,0xe7d3fbc8
		rol	ebx,20
		add	ebx,ecx

		mov	ebp,edx			/* 25 */
		and	ebp,ebx
		mov	edi,edx
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	eax,edi
		add	eax,dword ptr [esi+36]
		add	eax,0x21e1cde6
		rol	eax,5
		add	eax,ebx

		mov	ebp,ecx			/* 26 */
		and	ebp,eax
		mov	edi,ecx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	edx,edi
		add	edx,0xc337095e
		rol	edx,9
		add	edx,eax

		mov	ebp,ebx			/* 27 */
		and	ebp,edx
		mov	edi,ebx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+12]
		add	ecx,0xf4d50d87
		rol	ecx,14
		add	ecx,edx

		mov	ebp,eax			/* 28 */
		and	ebp,ecx
		mov	edi,eax
		not	edi
		and	edi,edx
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi+32]
		add	ebx,0x455a14ed
		rol	ebx,20
		add	ebx,ecx

		mov	ebp,edx			/* 29 */
		and	ebp,ebx
		mov	edi,edx
		not	edi
		and	edi,ecx
		or	edi,ebp
		add	eax,edi
		add	eax,0xa9e3e905
		rol	eax,5
		add	eax,ebx

		mov	ebp,ecx			/* 30 */
		and	ebp,eax
		mov	edi,ecx
		not	edi
		and	edi,ebx
		or	edi,ebp
		add	edx,edi
		add	edx,dword ptr [esi+8]
		add	edx,0xfcefa3f8
		rol	edx,9
		add	edx,eax

		mov	ebp,ebx			/* 31 */
		and	ebp,edx
		mov	edi,ebx
		not	edi
		and	edi,eax
		or	edi,ebp
		add	ecx,edi
		add	ecx,dword ptr [esi+28]
		add	ecx,0x676f02d9
		rol	ecx,14
		add	ecx,edx

		mov	ebp,eax			/* 32 */
		and	ebp,ecx
		mov	edi,eax
		not	edi
		and	edi,edx
		or	edi,ebp
		add	ebx,edi
		add	ebx,dword ptr [esi+48]
		add	ebx,0x8d2a4c8a
		rol	ebx,20
		add	ebx,ecx

		/* Round Three */

		mov	edi,ebx			/* 33 */
		xor	edi,ecx
		xor	edi,edx
		add	eax,edi
		add	eax,dword ptr [esi+20]
		add	eax,0xfffa3942
		rol	eax,4
		add	eax,ebx

		mov	edi,eax			/* 34 */
		xor	edi,ebx
		xor	edi,ecx
		add	edx,edi
		add	edx,dword ptr [esi+32]
		add	edx,0x8771f681
		rol	edx,11
		add	edx,eax

		mov	edi,edx			/* 35 */
		xor	edi,eax
		xor	edi,ebx
		add	ecx,edi
		add	ecx,dword ptr [esi+44]
		add	ecx,0x6d9d6122
		rol	ecx,16
		add	ecx,edx

		mov	edi,ecx			/* 36 */
		xor	edi,edx
		xor	edi,eax
		add	ebx,edi
		add	ebx,0xfde53994
		rol	ebx,23
		add	ebx,ecx

		mov	edi,ebx			/* 37 */
		xor	edi,ecx
		xor	edi,edx
		add	eax,edi
		add	eax,dword ptr [esi+4]
		add	eax,0xa4beea44
		rol	eax,4
		add	eax,ebx

		mov	edi,eax			/* 38 */
		xor	edi,ebx
		xor	edi,ecx
		add	edx,edi
		add	edx,dword ptr [esi+16]
		add	edx,0x4bdecfa9
		rol	edx,11
		add	edx,eax

		mov	edi,edx			/* 39 */
		xor	edi,eax
		xor	edi,ebx
		add	ecx,edi
		add	ecx,dword ptr [esi+28]
		add	ecx,0xf6bb4b60
		rol	ecx,16
		add	ecx,edx

		mov	edi,ecx			/* 40 */
		xor	edi,edx
		xor	edi,eax
		add	ebx,edi
		add	ebx,dword ptr [esi+40]
		add	ebx,0xbebfbc70
		rol	ebx,23
		add	ebx,ecx

		mov	edi,ebx			/* 41 */
		xor	edi,ecx
		xor	edi,edx
		add	eax,edi
		add	eax,0x289b7ec6
		rol	eax,4
		add	eax,ebx

		mov	edi,eax			/* 42 */
		xor	edi,ebx
		xor	edi,ecx
		add	edx,edi
		add	edx,dword ptr [esi]
		add	edx,0xeaa127fa
		rol	edx,11
		add	edx,eax

		mov	edi,edx			/* 43 */
		xor	edi,eax
		xor	edi,ebx
		add	ecx,edi
		add	ecx,dword ptr [esi+12]
		add	ecx,0xd4ef3085
		rol	ecx,16
		add	ecx,edx

		mov	edi,ecx			/* 44 */
		xor	edi,edx
		xor	edi,eax
		add	ebx,edi
		add	ebx,dword ptr [esi+24]
		add	ebx,0x04881d05
		rol	ebx,23
		add	ebx,ecx

		mov	edi,ebx			/* 45 */
		xor	edi,ecx
		xor	edi,edx
		add	eax,edi
		add	eax,dword ptr [esi+36]
		add	eax,0xd9d4d039
		rol	eax,4
		add	eax,ebx

		mov	edi,eax			/* 46 */
		xor	edi,ebx
		xor	edi,ecx
		add	edx,edi
		add	edx,dword ptr [esi+48]
		add	edx,0xe6db99e5
		rol	edx,11
		add	edx,eax

		mov	edi,edx			/* 47 */
		xor	edi,eax
		xor	edi,ebx
		add	ecx,edi
		add	ecx,0x1fa27cf8
		rol	ecx,16
		add	ecx,edx

		mov	edi,ecx			/* 48 */
		xor	edi,edx
		xor	edi,eax
		add	ebx,edi
		add	ebx,dword ptr [esi+8]
		add	ebx,0xc4ac5665
		rol	ebx,23
		add	ebx,ecx

		/* Round Four */

		mov	edi,edx			/* 49 */
		not	edi
		or	edi,ebx
		xor	edi,ecx
		add	eax,edi
		add	eax,dword ptr [esi]
		add	eax,0xf4292244
		rol	eax,6
		add	eax,ebx

		mov	edi,ecx			/* 50 */
		not	edi
		or	edi,eax
		xor	edi,ebx
		add	edx,edi
		add	edx,dword ptr [esi+28]
		add	edx,0x432aff97
		rol	edx,10
		add	edx,eax

		mov	edi,ebx			/* 51 */
		not	edi
		or	edi,edx
		xor	edi,eax
		add	ecx,edi
		add	ecx,0xab94252f
		rol	ecx,15
		add	ecx,edx

		mov	edi,eax			/* 52 */
		not	edi
		or	edi,ecx
		xor	edi,edx
		add	ebx,edi
		add	ebx,dword ptr [esi+20]
		add	ebx,0xfc93a039
		rol	ebx,21
		add	ebx,ecx

		mov	edi,edx			/* 53 */
		not	edi
		or	edi,ebx
		xor	edi,ecx
		add	eax,edi
		add	eax,dword ptr [esi+48]
		add	eax,0x655b59c3
		rol	eax,6
		add	eax,ebx

		mov	edi,ecx			/* 54 */
		not	edi
		or	edi,eax
		xor	edi,ebx
		add	edx,edi
		add	edx,dword ptr [esi+12]
		add	edx,0x8f0ccc92
		rol	edx,10
		add	edx,eax

		mov	edi,ebx			/* 55 */
		not	edi
		or	edi,edx
		xor	edi,eax
		add	ecx,edi
		add	ecx,dword ptr [esi+40]
		add	ecx,0xffeff47d
		rol	ecx,15
		add	ecx,edx

		mov	edi,eax			/* 56 */
		not	edi
		or	edi,ecx
		xor	edi,edx
		add	ebx,edi
		add	ebx,dword ptr [esi+4]
		add	ebx,0x85845dd1
		rol	ebx,21
		add	ebx,ecx

		mov	edi,edx			/* 57 */
		not	edi
		or	edi,ebx
		xor	edi,ecx
		add	eax,edi
		add	eax,dword ptr [esi+32]
		add	eax,0x6fa87e4f
		rol	eax,6
		add	eax,ebx

		mov	edi,ecx			/* 58 */
		not	edi
		or	edi,eax
		xor	edi,ebx
		add	edx,edi
		add	edx,0xfe2ce6e0
		rol	edx,10
		add	edx,eax

		mov	edi,ebx			/* 59 */
		not	edi
		or	edi,edx
		xor	edi,eax
		add	ecx,edi
		add	ecx,dword ptr [esi+24]
		add	ecx,0xa3014314
		rol	ecx,15
		add	ecx,edx

		mov	edi,eax			/* 60 */
		not	edi
		or	edi,ecx
		xor	edi,edx
		add	ebx,edi
		add	ebx,0x4e0811a1
		rol	ebx,21
		add	ebx,ecx

		mov	edi,edx			/* 61 */
		not	edi
		or	edi,ebx
		xor	edi,ecx
		add	eax,edi
		add	eax,dword ptr [esi+16]
		add	eax,0xf7537e82
		rol	eax,6
		add	eax,ebx

		mov	edi,ecx			/* 62 */
		not	edi
		or	edi,eax
		xor	edi,ebx
		add	edx,edi
		add	edx,dword ptr [esi+44]
		add	edx,0xbd3af235
		rol	edx,10
		add	edx,eax

		mov	edi,ebx			/* 63 */
		not	edi
		or	edi,edx
		xor	edi,eax
		add	ecx,edi
		add	ecx,dword ptr [esi+8]
		add	ecx,0x2ad7d2bb
		rol	ecx,15
		add	ecx,edx

		mov	edi,eax			/* 64 */
		not	edi
		or	edi,ecx
		xor	edi,edx
		add	ebx,edi
		add	ebx,dword ptr [esi+36]
		add	ebx,0xeb86d391
		rol	ebx,21
		add	ebx,ecx

		/* end of generated code */

		/* Finish off MD5 calculation, save result in digest[] */

		add	eax,0x67452301
    		add	ebx,0xefcdab89
    		add	ecx,0x98badcfe
    		add	edx,0x10325476

		mov	ebp,dword ptr [esp]	/* needed to access local vars */

		mov	dword ptr [digest],eax
		mov	dword ptr [digest+4],ebx
		mov	dword ptr [digest+8],ecx
		mov	dword ptr [digest+12],edx

		/* Copy rc4_initial_state[] to state[] */

		mov	esi,offset initial_state	
		mov	edi,offset state
		mov	ecx,64
		rep	movsd
		
		/* Initialize registers for prep_key_loop */

		mov	edi,offset state		/* state_p = state */
		sub	ebx,ebx				/* index = 0 */
		mov	ecx,4				/* loop counter */

prep_key_loop:	/* This loop is the most time-crtical section of the */
		/* entire program, and probably takes about 70% of   */
		/* execution time. It seems to like being partially  */
		/* unrolled, at least on my system...                */

		prep_word(digest)
		prep_word(digest+4)
		prep_word(digest+8)
		prep_word(digest+12)

		prep_word(digest)
		prep_word(digest+4)
		prep_word(digest+8)
		prep_word(digest+12)

		prep_word(digest)
		prep_word(digest+4)
		prep_word(digest+8)
		prep_word(digest+12)

		prep_word(digest)
		prep_word(digest+4)
		prep_word(digest+8)
		prep_word(digest+12)

		dec	ecx
		jnz	prep_key_loop

		mov	edi,offset state		/* state_p = state */
		sub	ebx,ebx				/* index = 0 */

		/* skip first 16 generated bytes */

		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte
		skip_byte

		/* test generated stream */

		mov	esi,stream			/* the stream we're looking for */
		mov	ecx,8				/* no of bytes in stream */
		sub	edx,edx				/* clear high bits of xorindex */

test_loop:	/* compare next byte of generated stream */

		skip_byte				/* returns tmp in dl, *statep in al */

		add	dl,al				/* xorindex = *statep + tmp */
		mov	al,byte ptr state[edx]		/* compare state[xorindex]... */
		cmp	al,byte ptr [esi]		/* ...with *stream            */
		je	SHORT is_equal

		/* this is the wrong key, try the next one */

		mov	esi,ssl				
		add	dword ptr [esi+12],0x100	
		dec	loop_counter			
		jnz	try_key_loop

		/* tried all keys, no luck */

		mov	retval,0
		jmp	SHORT done

is_equal:	/* generated stream matches so far */

		inc	esi				/* stream++ */
		loop	test_loop

		/* all eight bytes match */

		mov	retval,1	

done:		pop	ebp				/* pop bp off stack */
		popf					/* restore direction flag (!) */
		
	}

	return retval;
}

