/*
 *	msnl_sar.h
 *	-----------
 *
 * $Id: msnl_sar.h,v 1.5 1993/05/21 11:42:46 rjb17 Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

#if !defined(LITTLE_ENDIAN) && !defined(BIG_ENDIAN)
#if defined(__mips) || defined(__vax) || defined(__arm)
#define LITTLE_ENDIAN
#endif
#if defined(__hp9000s300) || defined(__hppa) || defined(__sun3) || defined(__sun4)
#define BIG_ENDIAN
#endif
#endif

/*
 * -----------------------------------------------------------------------
 */

/*   W A R N I N G :
 *
 * When porting to a new architecture you MUST insist that sizeof(EDLSAR)
 * is two (2).
 */

/*
 * -----------------------------------------------------------------------
 */

#define MAXEDLCELLS		(44)
#define MAXEDLSEQ		(255)
#define EDLCELLS(x)		(((x) + 31) >> 5)
#define EDLPADNEEDED(x)		((-(x)) & 31)
#define BYTESPEREDLCELL		(32)

#define ETHERTYPE_MSDL		(0x6660)

/* EDLSAR: NB: Sar information goes on the ethernet backwards comapred
 * to MDL. This is because there is no hardware swapping performed like
 * there is on CBN/CFR. I have thought carefully about this structure.
 * do not go changing it without a _lot_ of thought.
 */

typedef union {
    unsigned short		all;
    struct {
#ifdef LITTLE_ENDIAN
	unsigned short		assemble:6;
	unsigned short		zero:1;
	unsigned short		startbit:1;
	unsigned short		sequence:8;
#endif
#ifdef BIG_ENDIAN
	unsigned short		startbit:1;
	unsigned short		zero:1;
	unsigned short		assemble:6;
	unsigned short		sequence:8;
#endif
    } bits;
} EDLSAR;

/* FDLSAR: This is the "right" way round.
 */

typedef union {
    unsigned short		all;
    struct {
#ifdef LITTLE_ENDIAN
	unsigned short		sequence:8;
	unsigned short		assemble:6;
	unsigned short		frameend:1;
	unsigned short		framestart:1;
#endif
#ifdef BIG_ENDIAN
	unsigned short		framestart:1;
	unsigned short		frameend:1;
	unsigned short		assemble:6;
	unsigned short		sequence:8;
#endif
    } bits;
} FDLSAR;

/*
 * ------------------------------------------------------------------------
 */

/* EDLQUEUE: The queue we put ethernet (system received) packets on.
 * The "src" nonsense is only needed because earps are so brain damaged.
 */

typedef struct 
{
    struct mbuf		*data;
    struct ifnet	*ifp;
    unsigned char	src[6];		/* To be expunged */
} EDLQUEUE;

/* FDLQUEUE: The queue we put other (eg yes) packets on.
 */

typedef struct 
{
    struct ifnet	*ifp;
    int			associd;
} FDLQUEUE;

/*
 * This is the structure that comes at the front of every ethernet packet.
 */

typedef struct {
    unsigned char	vci[2];
    unsigned char	count;
    unsigned char	ignore;
    EDLSAR		sar[MAXEDLCELLS];
} BlockEDL;

/*
 * ------------------------------------------------------------------------
 */

typedef union {
    EDLSAR		edlsar;
    FDLSAR		fdlsar;
} SAR;

/*
 * ------------------------------------------------------------------------
 * In face for FDL we really want the structure as including the VCI
 * (well we do for yes boards anyway). We expand the FDLSAR structure
 * here again otherwise we would spend our life doing .parts.sar.bits.
 */

typedef union {
    struct {
#ifdef LITTLE_ENDIAN
	unsigned short		vci;
	unsigned short		sequence:8;
	unsigned short		assemble:6;
	unsigned short		frameend:1;
	unsigned short		framestart:1;
#endif
#ifdef BIG_ENDIAN
	unsigned short		framestart:1;
	unsigned short		frameend:1;
	unsigned short		assemble:6;
	unsigned short		sequence:8;
	unsigned short		vci;
#endif
    } bits;
    struct {
#ifdef LITTLE_ENDIAN
	unsigned short		vci;
	unsigned short		fas;
#endif
#ifdef BIG_ENDIAN
	unsigned short		fas;
	unsigned short		vci;
#endif
    } parts;
    unsigned int		all;
} FDLHDR;
