/*
 *	msnl_pcb.h
 *	----------
 *
 * $Id: msnl_pcb.h,v 1.6 1993/04/02 13:20:53 rjb17 Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

struct msnl_pcb {
    struct msnl_manage		msp_man;
    int				msp_state;
    caddr_t			msp_so;
    struct sockaddr		msp_src;
    struct sockaddr		msp_dst;
    caddr_t			msp_tx_opaque;
    int				(* msp_tx_proc) ();
    int				(* msp_break_proc) ();
    int				msp_timeoutset;
    /*
     * these fields are used a bit like "methods" because this pcb
     * may have a socket, or may have an IP tunnel structure as its
     * "owner"
     */
    struct msnl_methods		*msp_methods;
    /*
     * A pointer to so->so_error
     */
    unsigned short		* msp_indirect_error;
};

typedef struct msnl_pcb MSPCB;

#define	sotomsnlpcb(so)	((MSPCB *)(so)->so_pcb)

/* Values for msp_state
 */

#define MSPS_NEW		(0)
#define MSPS_BOUND		(1)
#define MSPS_LISTENING		(2)
#define MSPS_CONNECTING		(3)
#define MSPS_CONNECTED		(4)
#define MSPS_ACCEPTABLE		(5)
#define MSPS_ACCEPTING		(6)
#define MSPS_DISCONNECTED	(7)
#define MSPS_DEAD		(8)

/*
 * ------------------------------------------------------------
 *
 * The method structure
 */

struct msnl_methods {
    void			(* meth_isconnecting) ();
    void			(* meth_isdisconnected) ();
    MSPCB		*	(* meth_newconn) ();
    void			(* meth_isconnected) ();
    int				(* meth_disconnect) ();
    int				(* meth_abort) ();
    void			(* meth_free) ();
    int				(* meth_recv) ();
    void			(* meth_isreallyconnected) ();
};

