/*
 *	msnl_manage.h
 *	-------------
 *
 * $Id: msnl_manage.h,v 1.9 1993/05/18 09:09:17 rjb17 Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

/* This structure must be at the front of any PCB managed by the msnl
 * managing mess. The reference that is traded witrh user space is the
 * address of this structure. The link pointer is to allow an addres
 * given from user space to be checked in an open hash table.
 * 
 * msm_idle ensures a single person is waiting for user space processing
 * when a valid message is got on the control socket then the msm_reply
 * field is filled in and woken. When the waiter wakes it should clear
 * msm_reply, set msm_idle and wakeup msm_idle.
 */

struct msnl_manage {
    struct msnl_manage		*msm_link;
};

/* These are the kernel fucntions for manipulating the manage structures
 * Note the hashing function is simple and knows that the addresses
 * will all be at the start of an mbuf.
 */

#define MANAGE_HASH_ARRAY (16)
#define MANAGE_HASH(X)		((((unsigned long)(X)) >> 7) & 15)

#ifdef __STDC__

void  manage_register	(struct msnl_manage *man);
void  manage_deregister	(struct msnl_manage *man);
int   manage_lookup	(struct msnl_manage *man);
void  manage_send	(struct mbuf *m);
int   manage_check	(int len);
int   manage_running	(void);

#endif

/* This is the structure which comes at the head of the communications
 * between user space and the kernel. For socket messages. The reply
 * field is 0 if the reply is to be given synchronously to the waiting
 * process and otherwise the code to be performed asynchronously.
 */

struct manage_msg {
    int			mm_type;
    int			mm_request;
    int			mm_reply;
    struct sockaddr	mm_addr;		/* Needed by both */
    union	{
	struct		{
	    struct msnl_manage		*mmus_manage;
	    int				mmus_error;
	} mmu_socket;
	struct {
	    unsigned int		mmua_associd;
	    unsigned int		mmua_pod;
	    struct msnl_manage		*mmua_pcb;
	    unsigned char		mmua_src[6];
	} mmu_assoc;
	char		mmu_whatsits[4];
    } mmu;
};

#define mm_manage  mmu.mmu_socket.mmus_manage
#define mm_error   mmu.mmu_socket.mmus_error

#define mm_src     mmu.mmu_assoc.mmua_src
#define mm_associd mmu.mmu_assoc.mmua_associd
#define mm_pod     mmu.mmu_assoc.mmua_pod
#define mm_pcb     mmu.mmu_assoc.mmua_pcb

#ifdef __STDC__

int   assoc_operation   (struct manage_msg *msg);
int   msnl_operation    (struct manage_msg *msg);

#endif

#define MMTYPE_SOCKET		(1)
#define MMTYPE_ASSOC		(2)
#define MMTYPE_PORT		(3)

#define MMUP_BIND		(10)
#define MMUP_LISTEN		(11)
#define MMUP_CONNECT		(12)
#define MMUP_ACCEPT		(13)
#define MMUP_DISCONNECT		(14)
#define MMUP_DETACH		(15)
#define MMUP_CONNECTTIMEDOUT	(16)

#define MMUP_EDL		(20)
#define MMUP_ASSOCBAD		(21)
#define MMUP_FDL		(22)

#define MMDOWN_NEWCONN		(50)
#define MMDOWN_ACCEPTED		(51)
#define MMDOWN_CONNECTED	(52)
#define MMDOWN_DISCONNECT	(53)
#define MMDOWN_ABORT		(54)
#define MMDOWN_FINAL		(55)
#define MMDOWN_SOCKETJOIN	(56)
#define MMDOWN_CONNECTFAIL	(57)

#define MMDOWN_ASSOCCREATE	(60)
#define MMDOWN_ASSOCSEND	(61)
#define MMDOWN_ASSOCIDLE	(62)

#define MMDOWN_HOSTSET		(70)

/*
 * This is for synchronous ones which need info right back.
 */

#define MMIOCTL		_IOWR('M',0,struct manage_msg)
