/*
 *	msnl_manage.c
 *	-------------
 *
 * $Id: msnl_manage.c,v 1.14 1993/12/03 10:34:50 maj Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

#include "../h/param.h"
#include "../h/protosw.h"
#include "../h/mbuf.h"
#include "../h/errno.h"
#include "../h/user.h"			/* for u. */
#include "../h/socket.h"
#include "../h/socketvar.h"
#include "../h/ioctl.h"

#include "msnl_manage.h"

/*
 * move these elsewhere!
 */

typedef struct socket SOCK;
typedef struct mbuf MBUF;
typedef MBUF *MBUFP;

#define msnlcontrolspace 8192

/*
 * Prototypes for local functions
 */

#ifdef __STDC__

int msnl_usrreq_control(SOCK *so, int req, MBUFP m, MBUFP snam, MBUFP rights);
MBUFP control_sendwait(MBUFP m, struct msnl_manage *man);
MBUFP control_send(MBUFP m, struct msnl_manage *man);

#endif

SOCK *msnl_control_sock = (SOCK *)0;

int msnl_usrreq_control(so, req, m, nam, rights)
    SOCK		*so;
    int			req;
    MBUFP		m, nam, rights;
{
    int			s = splnet();
    int			error = 0;
    struct manage_msg	*msg;
    
    switch (req)
    {
    case PRU_ATTACH:
	if (msnl_control_sock)
	{
	    error = EACCES;
	    break;
	}
	if (so->so_pcb)
	{
	    error = EISCONN;
	    break;
	}
	if (u.u_uid
#ifdef MSNL_PRIV_UID
                     && (u.u_uid != MSNL_PRIV_UID)
#endif
                                                   )
	{
	    error = EPERM;
	    break;
	}

	error = soreserve(so, msnlcontrolspace, msnlcontrolspace);
	if (error)
	    break;

	/*
	 * This is really silly. If we dont have a pcb then it doesn't tell
	 * us when the socket goes away so we never know. So we put a dummy
	 * value in it!
	 */
	so->so_pcb = (caddr_t)&msnl_control_sock;

	msnl_control_sock = so;

	/* It wont permit sending on a socket unless there it is connected
	 * or an address is specified. So we become "connected"
	 */
	soisconnected(so);
	break;


    case PRU_DISCONNECT:
	/* Likewise it will then try to disconnect us */
	error = soisdisconnected(so);
	break;
	
    case PRU_ABORT:
    case PRU_DETACH:
	/* Free our dummy pcb */
	so->so_pcb = (caddr_t)0;
	msnl_control_sock = (SOCK *)0;
	break;
	
    case PRU_SEND:
	if (m->m_len < sizeof(struct manage_msg))
	{
	    m_freem(m);
	    error = EMSGSIZE;
	    break;
	}
	msg = mtod(m, struct manage_msg *);
	switch (msg->mm_type)
	{
	case MMTYPE_SOCKET:
	    if (manage_lookup(msg->mm_manage))
	    {
		error = msnl_operation(msg);
	    }
	    else
	    {
		error = EFAULT;
	    }
	    break;

	case MMTYPE_ASSOC:
	    error = assoc_operation(msg);
	    break;
	    
	case MMTYPE_PORT:
	    msnl_set_host(&msg->mm_addr);
	    error = 0;
	    break;

	default:
	    error = EOPNOTSUPP;
	    break;
	}
	m_freem(m);
	break;
	
    case PRU_CONTROL:
	if (((unsigned int)m) != MMIOCTL)
	{
	    error = EOPNOTSUPP;
	    break;
	}
	msg = (struct manage_msg *)nam;
	switch (msg->mm_type)
	{
	case MMTYPE_SOCKET:
	    if (manage_lookup(msg->mm_manage))
	    {
		error = msnl_operation(msg);
	    }
	    else
	    {
		error = EFAULT;
	    }
	    break;

	case MMTYPE_ASSOC:
	    if (msg->mm_reply == MMDOWN_ASSOCIDLE)
		error = assoc_operation(msg);
	    else
		error = EFAULT;		/* assoc assumes an mbuf */
	    break;
	    
	case MMTYPE_PORT:
	    msnl_set_host(&msg->mm_addr);
	    error = 0;
	    break;

	default:
	    error = EOPNOTSUPP;
	    break;
	}
	break;
	
    default:
	error = EOPNOTSUPP;
    }
    splx(s);
    return error;
}

/*
 * ----------------------------------------------------------------------
 */

struct msnl_manage *manage_table[MANAGE_HASH_ARRAY] = {0, };

void manage_register(man)
    struct msnl_manage		*man;
{
    int			index;
    
    index = MANAGE_HASH(man);
    man->msm_link = manage_table[index];
    manage_table[index] = man;
}

void manage_deregister(man)
    struct msnl_manage		*man;
{
    int			index;
    struct msnl_manage	**ptr;

    index = MANAGE_HASH(man);
    ptr = &manage_table[index];
    while (ptr && ((*ptr) != man))
	ptr = &((*ptr)->msm_link);

    if (!ptr) panic("manage_deregister\n");
    
    *ptr = (*ptr)->msm_link;
}

int manage_lookup(man)
    struct msnl_manage		*man;
{
    int			index;
    struct msnl_manage	*ptr;
    
    if (man == 0)
	return 0;

    index = MANAGE_HASH(man);
    ptr = manage_table[index];
    while (ptr)
	if (ptr == man)
	    return 1;
	else
	    ptr = ptr->msm_link;
    return 0;
}

/*
 * ----------------------------------------------------------------------
 */

int manage_check(len)
    int			len;
{
    if (!msnl_control_sock)
	return 0;
    return (sbspace(&msnl_control_sock->so_rcv) > len);
}

void manage_send(m)
    MBUFP			m;
{
    if (!msnl_control_sock)
    {
	printf("manage_send(msnl): should have been caught by manage_check (serious)\n");
	return;
    }
    
    if (sorecv(msnl_control_sock, m) == 0)
	return;
    
    /* Oh NO. We cant pass the info up. Something horrible has happened!
     */

    sodisconnect(msnl_control_sock);
}

/*
 * ----------------------------------------------------------------------
 * This is called by the code being managed to ensure that the manager
 * is running.
 */

int manage_running()
{
    return (((unsigned int)msnl_control_sock) != 0);
}
