/*
 *	mclean.c
 *	--------
 *
 * $Id$
 *
 * Grub around in /dev/kmem. Its the unix way....
 *
 * This program opens a control socket and the pokes around in the kernel
 * to destroy and clean up all the sick sockets.
 */

#include <errno.h>
#include <nlist.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/socket.h>

#include "netmsnl/msnl_manage.h"
#include "netmsnl/msnl.h"

/************************************************************************/

struct nlist nl[] = 
{
    { "manage_table" },
    NULL
};

int kmemf, s;

static void usage()
{
    fprintf(stderr, "usage: mclean [<system>] [<core>]\n");
    exit(1);
}

static unsigned long read_indirect(unsigned long offset)
{
    if (lseek(kmemf, offset, 0) == -1)
    {
	perror("mnetstat: i-lseek");
	exit(1);
    }
    if (read(kmemf, &offset, sizeof(offset)) < 0)
    {
	perror("mnetstat: i-read");
	exit(1);
    }
    return offset;
}

void kseek(unsigned long offset)
{
    int rc;

    if ((rc = lseek(kmemf, offset, 0)) == -1)
    {
	perror("mnetstat: lseek");
	exit(1);
    }
}

void kread(unsigned long offset, int *ptr, int length)
{
    int rc;

    kseek(offset);
    rc = read(kmemf, ptr, length);

    if (rc < 0)
    {
        perror("mnetstat: read");
        exit(1);
    }
}

/************************************************************************/

void clean_list(unsigned long offset)
{
    struct msnl_manage		*man = 0, *previous = 0;
    struct manage_msg		msg;
    int				rc;

    while (
	   kread(offset, (int *)&man, sizeof(man)),
	   man && man != previous
	   )
    {
	printf("clean_list: cleaning %#x\n",man);
	
	msg.mm_type = MMTYPE_SOCKET;
	msg.mm_reply = MMDOWN_ABORT;
	msg.mm_manage = man;
	if (send(s, &msg, sizeof(msg), 0) < 0)
	{
	    /* It may have been awaiting destruction from some previous
	     * event
	     */
	    if (errno == ENOTSOCK)
		goto justkillit;

	    perror("send abort");
	    exit(1);
	}

    readanother:
	if ((rc = recv(s, &msg, sizeof(msg), 0)) != sizeof(msg))
	{
	    perror("recv mmup_detach");
	    exit(1);
	}
	
	if ((msg.mm_type != MMTYPE_SOCKET)
	    || (msg.mm_request != MMUP_DETACH)
	    || (msg.mm_manage != man))
	{
	    fprintf(stderr, "recv mmup_detach: wrong data %d.%d ignoring!\n",
		    msg.mm_type, msg.mm_request);
	    goto readanother;
	}

    justkillit:
	
	msg.mm_reply = MMDOWN_FINAL;
	if (send(s, &msg, sizeof(msg), 0) < 0)
	{
	    perror("send final");
	    exit(1);
	}
	previous = man;
    }
    
    if (man)
    {
	printf("man=%#x, previous=%#x\nThis indicates serious kernel error",
	       man,previous);
	exit(1);
    }
}

/************************************************************************/

int main(argc, argv)
    int			argc;
    char		**argv;
{
    char		*system = "/vmunix";
    char		*core = "/dev/kmem";
    int			rc, i;
    int                 adr;
    unsigned long	offset;

    switch (argc)
    {
    case 3:
	core = argv[2];
	/* FALLTHROUGH */

    case 2:
	system = argv[1];
	/* FALLTHROUGH */

    case 1:
	break;
	
    default:
	usage();
    }
    
    if (nlist(system, nl) != 0)
    {
	fprintf(stderr, "mclean: %s: bad namelist\n", system);
	exit(1);
    }

    kmemf = open(core, O_RDONLY, 0);

    if (kmemf < 0) 
    {
	fprintf(stderr, "mclean: cannot open");
	perror(core);
	exit(1);
    }

    s = socket(AF_MSNL, SOCK_RAW, MSNLPROTO_RAW);
    if (s < 0)
    {
	perror("management socket");
	exit(1);
    }

    for (i=0; i<MANAGE_HASH_ARRAY; i++)
    {
	printf("mclean: cleaning list %d...\n",i);
	clean_list(nl[0].n_value + (i * sizeof(struct msnl_manage *)));
    }
}
