#include <stdio.h>
#include <string.h>

typedef struct { unsigned long l, r; } Immense;

extern char *getpass(
#ifdef __STDC__
  char *prompt
#endif
);

char *crypt(
#ifdef __STDC__
  char *key, char *salt
#endif
);

extern void encrypt(
#ifdef __STDC__
  char *block
#endif
);

#ifdef __STDC__
#define RD_MODE  "rb"
#define WR_MODE  "wb"
#else
#define RD_MODE  "r"
#define WR_MODE  "w"
#endif


Immense Str2Immense(
#ifdef __STDC__
  char *s)
#else
  s) char *s;
#endif
{
  union {
    Immense immense;
    char string[8];
  } immenseStr;
  int i, n;

  for (i = 0; i < 8; i++)
    immenseStr.string[i] = '\177';

  n = strlen(s);
  if (n < 8)
    fputs("certify: warning, less than eight characters in password\n", stderr);

  /* Not a very good hashing function but it'll do for now */
  for (i = 0; i < n; i++)
    immenseStr.string[i%8] ^= s[i];

  return immenseStr.immense;
}


void Certify(
#ifdef __STDC__
  char *srcname, char *dstname)
#else
  srcname, dstname) char *srcname, *dstname;
#endif
{
  extern char *malloc();
  Immense seed;
  Immense key;
  char *passwd;
  char *verify;
  FILE *src, *dst;

  passwd = getpass("Passwd: ");
  if (passwd == 0  ||  *passwd == '\0')
    return;

  /* Unfortunately we need to copy the entire password */
  /* since getpass() returns a pointer to static data. */

  verify = malloc(strlen(passwd) + 1);
  strcpy(verify, passwd);

  passwd = getpass("Verify: ");
  if (passwd == 0  ||  *passwd == '\0')
    return;

  if (strcmp(passwd, verify) != 0) {
    fputs("certify: passwords don't match\n", stderr);
    return;
  }

  key = Str2Immense(passwd);

  src = fopen(srcname, RD_MODE);
  if (src == 0) {
    fprintf(stderr, "certify: can't open `%s' for reading\n", srcname);
    return;
  }

  dst = fopen(dstname, WR_MODE);
  if (dst == 0) {
    fprintf(stderr, "certify: can't open `%s' for writing\n", dstname);
    return;
  }

  seed = Str2Immense("TMALomas");

  for (;;) {
    static int newKey = 1;
    static int direction = 0;	/* i.e. encrypt */
    char buffer[8];
    unsigned n;
    int i;

    n = fread(buffer, sizeof(*buffer), 8, src);
    des(seed, key, &newKey, &direction, &seed);
    for (i = 0; i < 8; i++)
      buffer[i] ^= ((char *)&seed)[i];
    if (fwrite(buffer, sizeof(*buffer), n, dst) != n) {
      fprintf(stderr, "certify: can't write to `%s'\n", dstname);
      exit(1);
    }
    if (n < 8)
      return;
  }
}


int main(
#ifdef __STDC__
  int argc, char **argv)
#else
  argc, argv) int argc; char **argv;
#endif
{
  if (argc != 3) {
    fputs("Usage: certify <src> <dst>\n", stderr);
    exit(1);
  }

  Certify(argv[1], argv[2]);

  return 0;
}
