/* Statistical labeller: dump transitions in a readable form

   29-12-92	Created

   Copyright (C) David Elworthy 1995

   Usage: readtr tranname [mapping]
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "common.h"
#include "trans.h"
#include "map.h"

/*----------------------------------------------------------------------------
    main
----------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
    char  mapname[MAXFN];
    Trans t;
    InitTrans(t)
    InitOptions;

    if (argc < 2)
	error_exit("Usage: readtr trans [map]\n");

    /* Get mappings */
    strcpy(mapname, (argc < 3) ? "tags.map" : argv[2]);
    read_mapping(mapname);

    /* Read transitions */
    read_named_trans(argv[1], &t);

    /* Write them back out */
    write_readable_trans(stdout, &t);

    return 0;
}
