/* Program to allow interactive examination of dictionary.

   26-01-93	Created

   Copyright (C) David Elworthy 1995

   Usage:
	exdict dictionary trans
   
  Takes a list of words from stdin and reports information
  on them. Trans is used for normalisation.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "diction.h"
#include "trans.h"
#include "map.h"

/*-----------------------------------------------------------------------------
    main

    Entry point.
-----------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
#define MaxWord (100)
    Dict  dict;
    Trans trans;
    char buffer[MaxWord];

    /* Clear data structures */
    InitDict(dict)
    InitTrans(trans)
    InitOptions;

    /* Verify command line */
    if (argc <= 2)
	error_exit("Usage: exdict dict trans\n");

    /* Read mappings */
    read_mapping("tags.map");

    read_named_dict(argv[1], &dict, -1);
    read_named_trans(argv[2], &trans);

    /* Read from stdin until end of file */
    while (fgets(buffer, MaxWord-1, stdin) != NULL)
    {
	DictWord d;

	buffer[strlen(buffer)-1] = 0;
	if (buffer[0] != 0)
	{
/* ... this ought really to use find_dictword ... */
	    d = find_word(&dict, buffer, FALSE);
	    if (d == NULL)
	    {
		fprintf(stderr, "%s not found\n", buffer);
	    }
	    else
	    {
		TagScore t;

		printf("%s\n", buffer);
		for (t = d->tag ; t ; t = t->next)
		{
		    printf(" %s %g (%g)\n", unmap_tag(t->tag),
				t->score,
				t->score / trans.gamma[t->tag]);
		}
	    }
	}
    }

    return 0;
}
