/* Statistical labeller: dictionary and transitions file merging

   23-12-92	Created.

   Copyright (C) David Elworthy 1995

   A program to merge multiple dictionaries and transition matrices.

   Usage:
       dictmerge outroot options

   Options are:
   d - merge dictionaries
   t - merge transitions
   M - mappings file (default tags.map)
   r - remainder of command line is a list of root names
   A - dictionary size
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "map.h"
#include "diction.h"
#include "trans.h"


/* Default dictionary size */
#define DICTLEN (60000)

/*----------------------------------------------------------------------------
    main
----------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
    char  dictname[MAXFN], tranname[MAXFN], mapname[MAXFN];
    int   arg = 2, i = 0;
    BOOL  do_dict = FALSE, do_tran = FALSE, check_opt = TRUE;
    char  opt;
    Trans t;
    Dict  dict;
    int   dictsize = DICTLEN;

    InitTrans(t)
    InitDict(dict)
    InitOptions;
    strcpy(mapname, "tags.map");

    /* Check command line */
    if (argc <= 3)
	error_exit("Too few arguments\n");

    /* Set up run type */
    while (check_opt &&
		(opt = get_option(argc, argv, "dtM:r:A:", &arg, &i)) != 0)
    {
	switch (opt)
	{
	    case 'd': do_dict = TRUE; break;
	    case 't': do_tran = TRUE; break;
	    case 'M':
		get_opt_string(argv, mapname, MAXFN, &arg, &i, opt);
		break;
	    case 'r':
		check_opt = FALSE;
		break;
	    case 'A':
		if (!get_opt_int(argv, &dictsize, &arg, &i, opt))
		    dictsize = DICTLEN;
		break;
	}
    }

    if (!do_dict && !do_tran)
	error_exit("No valid options: need d or t or both\n");

    read_mapping(mapname);

    /* Read files */
    while (arg < argc)
    {
	make_names(argv[arg] + i, dictname, tranname, MAXFN);
	printf("Processing '%s'\n", argv[arg]);
	if (do_dict)
	    read_named_dict(dictname, &dict, dictsize);

	if (do_tran)
	    read_named_trans(tranname, &t);

	arg += 1;
	i    = 0;
    }

    /* Open outputs and write results */
    make_names(argv[1], dictname, tranname, MAXFN);
    if (do_dict)
    {
	printf("Sorting dictionary\n");
	sort_dict(&dict);

	printf("Writing dictionary (%d entries)\n", dict.size);
	write_named_dict(dictname, &dict, FALSE);
    }
    if (do_tran)
    {
	printf("Writing transitions\n");
	write_named_trans(tranname, &t);
    }

    return 0; /* Successful completion */    
}
