;;; use Logs to deal with underflow (cf Holmes "speech syn and recog"
;;; p. 149--150)

(defvar *log-precision* -300)

(defun anti-log (p)
;;;find anti log of prob encoded logarithmically.

  (let ((res 
	 (expt  10  p)))
    (if (not (validate-prob res))
	(rougher-anti-log p)
      res)))

(defun rougher-anti-log (p)
  (let ((res 
	 (expt  10  (round p))))
    (if (not (validate-prob res))
	(error "rougher anti-log failed ~A ~A" p res)
      res)))

(defun log-add (a b)

;;; if a and b are stored logarithmically (base 10), calc 
;;; log(a+b).

;;; this introduces numerical errors (expt) ...

  (if (null a) (return-from log-add b)
    (if (null b) (return-from log-add a)))

  (let ((temp nil)
	(temp2 nil)
	(temp3))
    (when (> b a)
	  (setf temp b)
	  (setf b a)
	  (setf a temp))

    (setf temp2 (- b a))

    (if (< temp2 *log-precision*)
	a
      (+ a (log (+ 1 (anti-log  temp2)) 10))))) 

(defun validate-prob (p)
  (and (>= p 0.0) (<= p 1.0)))



