;;; parse selection mechanism, modified JAC code.


(defun parse-selection-prob (entry name)
  

  (let* ((ent (fetch-rule-entry name)))
    (cond
     ((null ent) (car *production-probs*))
     ((not (rule-body ent))
      (+ (log (/ (rule-freq ent) (svref *rule-denom* (rule-mother ent)))
	   10) 0.0))

     ((rule-body ent)
      (let ((denom (svref *rule-denom* (rule-mother ent))))
	(if (= 0 denom)
	    (car *production-probs*)
	  (log (/ (rule-freq ent) 
		  (svref *rule-denom* (rule-mother ent))) 10)))))))

(defun daughter-selection-prob (d-entries mo-entry name)

  (let ((score 
	 (if (null name) ; word
	     (daughter-likelihood "word" mo-entry)
	   (daughter-likelihood name mo-entry))))
    score))
      
(defun psm-init nil
;;; no longer needed
  (return-from psm-init nil)
  (format t "Reading trees for PSM~%")
  (lr1-read-history-probs "../data/sustrtsg11.probs-2") )


(defun valid-tree (tree)

;;; true if all rules in tree are in grammar.

  (dolist (r (get-rules-from-tree tree) t)
	  (if (stringp r)
	      (if (not (fetch-rule-entry r))
		  (return-from valid-tree nil)))))

(defun keep-in-coverage (nonterms)
;;; keep nonterms that are in the grammar
  (let ((res nil))
    (dolist (r nonterms res)
	    (when (fetch-rule-entry (car r)) (push r res)))))








