;;; filter rules that overgenerate.

;;; expanded text grammar rules for tsg11

(defvar *overgen* t) ;;; true to filter.

(defvar *overgen-rules* 
'(
		       "T/s_ex_s/+" "T/rmta_a1" 
		       "T/lmta_prep" "Tacl/colon1" "T/txt-sc1/++-"
		    "T/txt-sc1/+-+" "T/txt-sc1/-++"  "T/npq"
		    "Tph/pp/-" "Taph/comma-b"
		    "Tacl/brack/+"  "Tacl/dash+/-"
		    "Tacl/dash-/+" "Tcl/interj_tph"  "T/rmta_s/--" 
		    "T/lmta_np" "Tacl/comma+"  "T/txt-sc1/+++"
		    "Tph/pp/+" "Tph/np/-" "Tacl/dash+/+" 
		    "T/rmta_s/+-" "T/rmta_s/-+" "T/txt-cl1/-" 
		    "T/txt-cl3" "Taph/colon" 
		    "T/txt-sc2/--" 
		    "T/rmta_n1" "T/txt-cl2" "Tph/np/+" "T/lmta_auxv"
		    "T/rmta_s/++" "T/txt-cl1/+"
		    "T/lmta_n" 
		    "Tph/a2/-"
		    "T/txt-sc2/+-"
		    "T/txt-sc2/-+" 
		    "T/s_qu_s/-"  "T/leta_cl" 
		    "N1/n1_dir" 
		    "Tacl/comma-e" 
		    "T/lmta_comp" "Tph/a2/+" 
		    "T/txt-sc2/++"
		    "T/s_qu_s/+"
		    "T/leta_s" 
		    "Taph/comma+/-" 
		    "Taph/brack" 
		    "Taph/dash-"  
		    "T/lmta_n1" 
		    "T/npqcj" "Taph/comma+/+" "Tph/n1/-" 
		    "Taph/dash+" "Tph/vp/-" "T/lmta_conj"
		    "Tph/n1/+" 
		    "T/txt-sc1/---" 
		    "Tph/vp/+"
		    "T/s_ex_s/-" "T/lmta_v" "T/Tph"
		    "T/txt-sc1/+--" "T/txt-sc1/-+-" "T/txt-sc1/--+" 
		    "T/lmta_adv" "Tacl/brack/-" "Tacl/dash-/-"))
	    

(defun filter-text-edges (edges)
  
;;; now done by drules.

  (return-from filter-text-edges edges)

  (unless *overgen* (return-from filter-text-edges edges))

  (let ((res nil)
	(overgen *overgen-rules*))
    (dolist (e edges res)	    
	    (let ((n1 (extract-name (g-chart-edge-found e))))	      
	      (unless (and (equalp (aref n1 0) #\T)  ;quick hack	       
			   (member n1 overgen :test #'string=))
		      
		      (push e res))))))
		      
		      
