;;; allow a person to do model selection.  Also, record what sort of 
;;; decisions are taken for feedback into learner.

(defvar *interaction-decisions* nil) ;;; record patterns of interactions.
(defvar *use-interface* t) ;;; true to use interface.

(defun open-interaction nil

;;; open file to record decisions.  

  (close-interaction)
  (format t "File to record interactions? ")
  (setf *use-interface* t)
  (let ((res (get-reply1 (read-line *query-io* nil "") t)))
    (if (probe-file (format nil "~A" (car res)))
	(progn
	  (format t "File exists already ~%")
	  (open-interaction))
      (setf *interaction-decisions*
	    (open (format nil "~A" (car res)) :direction :output)))))

(defun close-interaction nil

;;; close file.

  (when  *interaction-decisions*
	 (close  *interaction-decisions*))
  (setf *interaction-decisions* nil))

(defun manual-selection (models)

;;; allow a person to select a parse for the current sentence.

  (unless *use-interface*
	  (return-from manual-selection (car models)))

  ;;; open file of recorded decisions.
  (when (and (null *interaction-decisions*) *use-interface*)
	(open-interaction))
  (let ((index 1) (num (length models)))    
    (dolist (m models (record-reject m))
	    (force-output *interaction-decisions*)
	    (format t "Parse ~%")
	    (pprint (gloss-parse-tree (model-parse m)))
	    (format t  
		    "~%~% Model  ~A (of ~A)  Prior ~A Likelihood ~A Score ~A~%"	 
		    index num
		    (model-prior m)
		    (model-likelihood m)
		    (+ (model-prior m)
		       (model-likelihood m)))
	    (setf index (+ 1 index))
	    (format t "~%(A)ccept  (R)eject (Q)uit <CR> Next ? ")
	    (let ((res (get-reply1 (read-line *query-io* nil "")
				   t)))
	      (cond
	       ((or (equal (car res) '|a|) (equal (car res) 'A))
		(record-accept m)
		(return-from manual-selection m))	       
	       ((or (equal (car res) '|r|) (equal (car res) 'R))
		(record-mistag)
		(setf *current-parse-trees nil)
		(return-from manual-selection nil))
	       ((or (equal (car res) '|q|) (equal (car res) '|Q|))	       
		(close-interaction)
		(setf *use-interface* nil)
		(return-from manual-selection nil))
	       
	       (t
		(record-ignore m)))))))

(defun record-reject (models)
  (format *interaction-decisions* "Reject ~%")
  (format *interaction-decisions*
	  "~A~%"
	  *previous-sentence)
  (dolist (m models)
	  (format *interaction-decisions* "~A~%"
		  (model-parse m))))

(defun record-accept (model)
  (format *interaction-decisions* "Accept ~%")
  (format *interaction-decisions*
	  "~A~%"
	  *previous-sentence)
  (format *interaction-decisions* "~A~%"
		  (model-parse model)))

(defun record-mistag nil
  (format *interaction-decisions* "Mistag ~%")
  (format *interaction-decisions*
	  "~A~%"
	  *previous-sentence))

(defun record-ignore (model)
  (format *interaction-decisions* "Ignore ~%")
  (format *interaction-decisions* "~A~%"	  
	  (model-parse model)))

(defun update-rule-freqs (parses)

;;; redefinition, but allow person to pick best one.

  (let ((models (sort (calc-posterior parses) #'>
		      :key #'(lambda (x)
			       (+ (model-prior x) 
				  (model-likelihood x)))))		
	(best nil)
	(best-score -0)
	(index 0)
	(counter 0))
        
    (setf best (manual-selection models))
    
    (when best
	  (let ((likelihood-rules (model-rules best)))
	    ;;; keep parse.
	    (setf *parse-queue*
		  (add-to-bounded-lifo (get-learnt-rules likelihood-rules)
				       *parse-queue* *parse-length*))
	    (dolist (r-d likelihood-rules) 
		    (let* ((r (car r-d))
			   (d (cadr r-d))
			   (entry (fetch-rule-entry r))
			   (entry2 (gethash r *rule-info*))
			   (dfreqs (rule-daughters entry)))
		      
		      (when (and (null entry2) entry)
			    (when *trace*
				  (setf (rule-parse entry)
					(get-rule-labelling-from-parse-tree
					 (cdr (nth index
					     parses))))
				  (setf (rule-parse-number entry)
					*total-processed*))
			    (setf *grammar-size* (1+ *grammar-size*)))
		      
		      (when (rule-body entry)
			    (setf (svref *rule-denom* (rule-mother entry))
				  (1+ (svref *rule-denom* 
					     (rule-mother entry))))	       
			    (if entry2
				(setf (rule-freq entry2) (+ 1 
							    (rule-freq 
							     entry2)))
			      (setf (gethash r *rule-info*) entry))
			    (dolist (dau d)
				    (setf (car dfreqs)
					  (add-daughter dau (car dfreqs)))
				    (pop dfreqs)))))

	    (format t "Rules: ~A " 
		    *grammar-size*)

	    (when *verbose*
	      (format *verbose* "~A ~A ~A ~%" *total-learnt-parses* 
		      ;;; prior like
		      (model-prior best) (model-likelihood best)))))))


(defun reset-tables nil
;;; redefinition
  (close-interaction)
  ;;; file to record prior + like growth.
  (when *verbose* (close *verbose*))	

  (setf *parse-queue* nil)
  (dotimes (x *parse-length*)
	   (push nil *parse-queue*))  
  (reset-counters)
  (dotimes (x (length *rule-denom*))
	   (setf (svref *rule-denom* x) 0))
  (setf *grammar-size* 0)
  (evaluate-off)
  (setf *table* nil)
  (setf *freq-total* 0)
  (setf *rule-denom* nil)
  (clrhash *rule-info*))


