;;; hard filter rules 

;;; throws away rules containing [bar 0], [punct] in rhs or [minor] cats in rhs

;;; also throws away certain ternary rules 

(defvar *filter-block* t) ;; true to use blocks

(defvar *filter-ternary* t) ;;; true to block suspect tern rules

(defun filter-ternary (flag) (setf *filter-ternary* flag))

(defun set-filter-block-on nil (setf *filter-block* t))
(defun set-filter-block-off nil (setf *filter-block* nil))


(defun filter-block (rules)

  (unless *filter-block* (return-from filter-block rules))

  (let ((res nil))
    (dolist (r rules res)
	    (let ((mother 
		   (map-parser-cat-to-term-cat (g-chart-edge-res r)))
		  (d1 (map-parser-cat-to-term-cat 
		       (car (car (last (g-chart-edge-found r))))))
		  (d2  (map-parser-cat-to-term-cat 
			(car (if (= 3 (length (g-chart-edge-found r)))
				 (second (g-chart-edge-found r))
			       (car (g-chart-edge-found r))))))
		  (d3 (if (= 3 (length (g-chart-edge-found r)))
			  (map-parser-cat-to-term-cat 
			   (car (car (g-chart-edge-found r))))
			nil)))
	      
	      (unless
	       (or
		(minor-block mother)		
		(and d3 (ternary-block mother d1 d2 d3)))
	       (push r res))))))

(defun ternary-block (mother d1 d2 d3)
 ;;; true if ternary rule is bogus.
 ;;; Allow Xp --> H [punct comma] Xp[Conj +] and VP --> H Xp+.

  (unless *filter-ternary* (return-from ternary-block nil))

  (not 
   (and (equal mother d1)
	(or ;;; VP case
	 (let ((v nil) (bar nil) (n nil))
	   (dolist (f-v mother nil)
		   (let ((feat (car f-v)) (val (cdr f-v)))		   
		     (if (and (equal feat 'BAR) 
			     (member val '(|1| |2|)))
			 (setf bar t)
		       (if 
			   (and (equal feat 'V) (equal val '+))
			   (setf v t)
			 (if 
			     (and (equal feat 'N) (equal val '-))
			     (setf n t)))))
		   (when (and v bar n) (return-from 
					ternary-block nil))))
	 	    ;;; comma case	    
	(dolist (f-v d2 nil)
		(let ((feat (car f-v)) (val (cdr f-v)))		  
		  (when (and (equal feat 'PUNCT) (equal val 'COMMA))
			(dolist (f-v d3 nil)
				(let ((feat (car f-v)) 
				      (val (cdr f-v)))
				  (when (and (equal 
					      feat 'CONJ) 
					     (equal val '+))
					(return-from 
					 ternary-block  nil)))))))))))
        

(defun minor-block (feats)
;;; true if cat is minor (used to detect minor rhs cats)
;;; 
;;; also for punct and bar zero cats
  
  (dolist (f-v feats nil)
	 (let ((feat (car f-v)) (val (cdr f-v)))	   
	   (when (equal feat 'MINOR)
		 (return-from minor-block t))

	   (when (and (equal feat 'BAR)
		      (equal val '|0|))
		 (return-from minor-block t))

	   (when (equal feat 'PUNCT)
		 (return-from minor-block t)))))
	   




