;;; Encode the number of exceptions a rule has.  

;;; Currently just deals with LP rules and types.

;;; block right-headed rules that are not NPs.

(defvar *headed* t)
(defun set-headed-on nil (setf *headed* t))
(defun set-headed-off nil (setf *headed* nil))

;;; do type checking over rhs (in terms of <e,t> notation).
		   
(defvar *type-check* nil)
(defun set-type-check-on nil (setf *type-check* t))
(defun set-type-check-off nil (setf *type-check* nil))    

;;; control whether we use drules or not.

(defvar *use-drules* t)
(defun set-drules-on nil (setf *use-drules* t))
(defun set-drules-off nil (setf *use-drules* nil))    

(defvar *exceptions-weight* 10.0)

(defun exceptions (edge)

;;; greater than one  if rule (in edge) violates theory.  
;;; higher value, worse things are.


  (let ((count (lp-exceptions1 edge)))
    (* *exceptions-weight* count)))

(defun lp-exceptions1 (edge)
 
  (let* ((mother (map-parser-cat-to-term-cat 
		 (g-chart-edge-res edge)))
	 (cats nil)
	 (cat-number (length (g-chart-edge-found edge)))
	 (highest-binding-number (+ 1 cat-number))
	 (binding-no nil)
	 (faked-id-rule nil))
	    
    (dotimes (x (+ cat-number 1))
	     (push x binding-no))
    (setf binding-no (reverse binding-no))
    
    (dolist (c (g-chart-edge-found edge))
	    (push 
	     (make-category-binding 
	      :number cat-number 
	      :category (map-parser-cat-to-term-cat (car c))
	      :repetition '*once*) cats)
	    (setf cat-number (- cat-number 1)))
    
    (push (make-category-binding 
	   :number 0 
	   :category mother
	   :repetition '*once*) cats)

    (setf faked-id-rule 
	  (make-id-rule :binding-nos binding-no
			:name
			(make-top-rule-name
			 :base (make-sub-rule-name
				:base 'temp))
			:highest-binding-no highest-binding-number
			:binding-list 
			cats))
    
    (+ 
     (if *headed*
	 (headedness edge) 0)
     (if (and *type-check*
	      (type-check-semantic-form-learner 
	       binding-no ;; horrible hack
	       (id-rule-name faked-id-rule)
	       (svref (car
		       (g-chart-edge-res edge))
		      0)
	       (id-rule-binding-list faked-id-rule)))
	 
	 100 
       0)
     
     (if *use-drules*
	 (drule-match faked-id-rule)
       0))))

(defun print-faked-rule (r)
  (let ((cats (id-rule-binding-list r)))

    (terpri)
    (print-cat(category-binding-category (car cats)) )
    (format nil " --> ")
    (terpri)
    (print-cat (category-binding-category (second cats)))
    (terpri)
    (print-cat (category-binding-category (third cats)))))


(defun print-cat (cat)
  (format nil "[")
  (dolist (c cat)
	  (unless (g-varp (cdr c))
		  (format nil "~A ~A, " (car c) (cdr c))))
  (format nil "]"))

(defun type-check-semantic-form-learner
   (form construct-name mother-binding-no
      binding-list)
   (let
     ((a-types
          (translate-category-to-types
             1 binding-list))
      (b-types
       (translate-category-to-types
             2 binding-list)))

     (if (or (and (= 1 (length a-types))
		  (basic-type-p (car a-types))
		  (equal (basic-type-name (car a-types)) '*))
	     (and (= 1 (length b-types))
		  (basic-type-p (car b-types))
		  (equal (basic-type-name (car b-types)) '*)))
	 (return-from type-check-semantic-form-learner  t))

     (dolist (a a-types nil)
	     (dolist (b b-types nil)
		     (cond
		      ((and (complex-type-p a)
			    (match-type-expression 
			     (complex-type-arg a) b construct-name))
		       (return-from type-check-semantic-form-learner t))
		      ((and (complex-type-p b)
			    (match-type-expression 
			     (complex-type-arg b) a construct-name))
		       (return-from type-check-semantic-form-learner t)))))))
		      
		      ;;; hard filter rules 


(defun np (feats)
;;; N +, V -, Bar 2, BAR 1
  (let ((n nil)
	(bar nil)
	(v nil))

    (dolist (f-v feats nil)
	    (let ((feat (car f-v)) (val (cdr f-v)))
	      
	      (when (and (not n) (equalp feat 'N) (equalp val '+)) (setf n t))
	      (when (and (not bar) (equalp feat 'BAR) (or
						      (equalp val '|2|)
						      (equalp val '|1|)))
			 (setf bar t))
	      (when (and (not v) (equalp feat 'V) (equalp val '-)) (setf v t)))

	    (when (and n v bar) (return-from np t)))))
    
(defun vec-eq (a b)

;;; true if a and b are same cats
  (dotimes (x (length a) t)
	   (when (not (equalp (aref a x ) (aref b x )))
		 (return-from vec-eq nil))))

(defun headedness (r)
  (let ((mother (car (g-chart-edge-res r)))
	(d2 (car (caar (g-chart-edge-found r))))
	(d1 (car (second (g-chart-edge-found r)))))
    
    (cond
	       
     ((vec-eq mother d2) ;;; right-headed rule
      (let ((mother-feats
	     (map-parser-cat-to-term-cat (list
					  mother))))
	(if (np mother-feats)
	      0
	  1)))
     (t 0))))

