(defun stats nil
  (let ((right 0)
	(left 0))

    (maphash #'(lambda (key val)
		 (when (and key val (rule-body val))
		       (let ((mother (car (rule-body val)))
			     (d1 (second (rule-body val)))
			     (d2 (third (rule-body val))))

			 (if (cat-eq mother d2)
			     (setf right (1+ right))
			   (setf left (1+ left))))))
		       
	     *rule-info*)
    (/ right (+ left right))))

(defun cat-eq (a b)
  (dotimes (z (length a) t)
	   (if (not (equal (aref a z) (aref b z)))
	       (return-from cat-eq nil))))


(defun freq-freq nil
  (let ((freqs (make-array 1000))
	(max 0))
    (dotimes (x (length freqs))
	     (setf (aref freqs x) 0))

    (maphash #'(Lambda (key val)
		       (when (and key val (rule-body val))
			     (let ((f (rule-freq val)))
			       (if (< f 1000)
				   (progn
				     (setf (aref freqs f) (1+ 
							   (aref freqs f)))
				     (if (> f max)
					 (setf max f)))
				 (error "increase table size")))))
	     *rule-info*)

    (dotimes (x max)
	     (format t "~A ~A ~%" (1+ x) (aref freqs (1+ x))))))