;;; configure learner.

;;; If mdl is true, use prior, else assume uniform prior.
;;; If brack is true, assume input is sustr.trees1 format
;;; (ie sent-tree pairs) and not input from normal fparse.

(defun configure-learner (mdl brack)

  (setf *max-sent-length* 10) ;;; throw-out sentences longer than this.

  (reset-tables) ;;; initialise tsg freqs
  (create-rule-freq-table)  ;;; build compression info
  (reset-counters) ;;; various stats about num. parses seen etc.
  (pre-train (format nil "~A~A" 
		     *learner-base* "../data/sustr.trees1")) ;;; initialise parse selection.

  ;;; use bracketing?
  (setf *bracketing* brack) ;;; true to expect parsed corpora.

  ;;; use prior?
  (if mdl
      (progn
	(setf *q* 1.0) ;;; prior weighting.  See gamma.lisp.
	(structure-prior-on)
	(parameter-prior-on))
    (progn
      (parameter-prior-off)
      (structure-prior-off)))
            
  (evaluate-off) ;;; allow learning and use of learnt rules.
  (setf *use-drules* t) ;;; use drules.
  (set-filter-block-on ) ;;; disallow minor cats etc in lhs.

  (setf +n-best-retained+ 10) ;;; max number of models to consider
  (setf *parse-length* 3000) ;;; size of window  
  (setf *max-cont-edges* 250) ;;; max number of possible rule rhs to 
                              ;;; instantiate rules with.

  ;;; number of times to cycle around when rule inventing.
  (setf *counter* 3)

  ;;; decide which templates to use.
  ;;; true to use any given template.
  
  (setf *t1* nil) (setf *t2* nil) (setf *t3* nil) (setf *t4* nil) 
  (setf *t5* nil)


  (setf *b1* t) (setf *b2* t) (setf *b3* t) (setf *b4* t) 
  (setf *b5* t)

  (filter-ternary t)) ;;; disallow certain ternary rules.





