;;; Boot learner (and GDE if necessary).

;;; dir containing learner source.
;(defvar *learner-base* "/home/miles/anlt/src/")
(defvar *learner-base* "/usr/groups/nltools/annlt/learner/src/")

(defun boot-gde nil
  (load "/usr/local/annlt/gde/cgde/load.lsp")
  (load "/usr/local/annlt/gde/cpar/load.lsp")
  (load "/usr/local/annlt/gde/cmorph/load.lsp")
  (load "/usr/local/annlt/grams/cmeta-ops"))
  ;(gde-top-loop))

(defun boot-gde nil
  (load "/usr/groups/nltools//annlt/gde/cgde/load.lsp")
  (load "/usr/groups/nltools/annlt/gde/cpar/load.lsp")
  (load "/usr/groups/nltools/annlt/gde/cmorph/load.lsp")
  (load "/usr/groups/nltools/annlt/grams/cmeta-ops"))
  ;(gde-top-loop))


(defun boot-gde2 nil
  (load "../cgde/load.lsp")
  (load "../cpar/load.lsp")
  (load "../cmorph/load.lsp"))
  


(eval-when (compile)
	   (declaim (optimize (speed 3) (safety 1) (space 0) (debug 0))))

(defvar *files* '("hdr" "parse" "vparse-2" "generateEdges" "prior" "driver"
		  "backbone" "psm"  "smooth" "filter"
		  "exceptions" "eval-analysis"  "tables" "search" "gamma" 
		  "semantics" "../semco/semco" "configure" "gloss"
		  "../semco/bracketing" "drules"))

(defun compile-anlt-learner nil
  (dolist (f *files*)
	  (compile-file (format nil "~A~A.lisp" *learner-base* f))
	  (load (format nil "~A~A" *learner-base* f))))

(defun load-anlt-learner (extension)
  ;(setf *tagged-words t)
  (setf *generate-edges* t)
  (setf *g-compute-all-edges t) ;;; generate all substrings.
  (dolist (f *files*)
	  (load (format nil "~A~A.~A" *learner-base* f extension)))
  (report))


;;l linux allegro suffers from over-eager tenuring, so use JAC supplied tip:
#+allegro
(setf (sys:gsgc-parameter :auto-step) nil)




