;;; map unif rules to cfg backbone rules

;;; uses JAC cat index as backbone def

(defun map-rule-to-backbone (name)
  (let ((rule (fetch-rule-entry name)))
    (when (rule-body rule)
	  (if (rule-backbone rule)
	      rule
	    
	    ;;; must be learnt rule 
	    (let ((body (rule-body rule))
		  (syms nil))
	      (dolist (b body)
		      (push (svref b 0) syms))
	      (setf (rule-backbone rule)
		    (reverse syms)))))))

(defun create-given-backbone (rule)
  
;;; backbone rule for given, unif rule

  (let ((backbone nil))
    (dolist (cat rule (reverse backbone))
	    (push (svref (car cat) 0) backbone))))


(defun backbone-set (rules)
  (let ((res nil))
    (dolist (r rules res)
	    (unless (member (cdr r) res :test #'equalp)
		    (push (cdr r) res)))))

(defun gather-all-rules nil
  (let ((res nil))
    (maphash #'(lambda (k v)
		 (when k
		       (push (cons k (rule-backbone v)) res)))
	     *rule-info*)
    res))

(defun print-all-rules nil
  (let ((pairs (gather-all-rules)))
    (dolist (p pairs)
	    (format t "~A ~A --> ~A ~%" (car p) (cadr p) (cddr p)))
    (format t "~A backbone rules, ~A rules total ~%"
	    (length (backbone-set (gather-all-rules)))
	  (length (gather-all-rules)))))
  
