;;; MO additions to deal with learnt rules.

;Set +analysis-tree-type+ to susanne to get evaluation-type trees

(defparameter +analysis-tree-type+ 'susanne)

;;; redefinition from lr1/ask-stats.lsp

(defun lr1-parse-analysis-output-trees (sentence trees weights out-prob-trees)
   (when (and (null trees)) ; *** (null +analysis-tree-type+)
      (setq trees (list (cons nil (cons "X" sentence)))))
   (with-open-file (out-str out-prob-trees :direction :output :if-exists 
         :append :if-does-not-exist :create)
      (let ((nparses (length trees)) (*print-pretty* nil))
         #+procyon (set-right-margin out-str 32767)
         (format out-str "~S ~S ; (~{~6,4E~^ ~})" 
            (mapcar
               #'(lambda (word) (intern (string (if (consp word) (car word) word))))
               sentence)
            nparses weights)
         #+procyon (set-right-margin out-str 78)
         (dotimes (n nparses)
            (pprint
               (if trees (lr1-parse-analysis-rule-tree (cdr (pop trees))) nil)
               out-str))
         (terpri out-str))))


(defun lr1-parse-analysis-rule-tree (tree)
   (let ((res
          (cond
            ((and (consp tree) (equal (car tree) "X")) tree)
            ((eq +analysis-tree-type+ 'susanne) (phrasal-parse-structure-susanne tree))
            ((eq +analysis-tree-type+ 'standard) (phrasal-parse-structure-standard tree))
            (t (lr1-analysis-rule-tree tree)))))
      (unless (cdr res) (setq res (car res)))
      res))


(defun phrasal-parse-structure-susanne (tree &optional mother-major-cat)
   (cond
      ((and (cdr tree) (atom (cadr tree)))
         ;; strip tag if any
         (phrasal-parse-structure-word (string (cadr tree))))
      (t
         ;; don't output category if it contains just a single word -
         ;; always do if it's a a co-ord structure, or V/to_bse (infinitival
         ;; construction), NP/det_n, NP/n2_poss, Taph/brack (textual bracket) -
         ;; under an S, don't if it's another S or a P, otherwise do -
         ;; don't if at top level and only single daughter, or if a V under
         ;; an S mother, or category is same as mother -
         ;; otherwise do...

         (let*
            ((rule (let* ((name (string (cadar tree)))
			  (entry (fetch-rule-entry name)))
		     (if (and entry (rule-body entry)) ;;; learnt rule
			 (map-learnt-name name entry)
		       name)))
	     (slash (position #\/ rule))
	     (rcat (if slash (subseq rule 0 slash) rule))
	     (major-cat (subseq rule 0 1))
	     (cat nil)
	     (daughters
	      (mapcan
	       #'(lambda (d) (phrasal-parse-structure-susanne d major-cat))
	       (reverse (cdr tree)))))

            (cond
               ((and (null (cdr daughters)) (atom (car daughters)))
                  (setq cat nil))
               ((search "/cj_" rule)
                  (setq cat rcat))
               ((equal rule "V/to_bse")
                  (setq cat "VP"))
               ((member rule '("NP/det_n" "NP/n2_poss") :test #'equal)
                  (setq cat "NP"))
               ((equal rule "Taph/brack")
                  (setq cat "T"))
               ((equal major-cat "S")
                  (setq cat
                     (if (member mother-major-cat '("S" "P") :test #'equal)
                        nil rcat)))
               ((or (and (null mother-major-cat) (null (cdr daughters)))
                   (and (equal major-cat "V") (equal mother-major-cat "S"))
                   (equal major-cat mother-major-cat))
                  (setq cat nil))
               (t (setq cat rcat)))
            (if cat
               (list (cons cat daughters))
               daughters)))))


(defun phrasal-parse-structure-standard (tree &optional mother-major-cat)
   (cond
      ((and (cdr tree) (atom (cadr tree)))
         ;; strip tag if any
         (phrasal-parse-structure-word (string (cadr tree))))
      (t
         ;; don't output category if it contains just a single word -
         ;; always do if it's a a co-ord structure, appears after punctuation
         ;; at same level, or V/to_bse (infinitival
         ;; construction), NP/det_n, NP/n2_poss, Taph/brack (textual bracket) -
         ;; don't if at top level and only single daughter, or if category is
         ;; same as mother -
         ;; otherwise do...
         (let*
            ((rule (string (cadar tree))) 
               (slash (position #\/ rule))
               (rcat (if slash (subseq rule 0 slash) rule))
               (major-cat (subseq rule 0 1))
               (cat nil) (next-cat nil)
               (daughters
                  (mapcan
                     #'(lambda (d)
                         (phrasal-parse-structure-standard d
                            (cond
                               ((search "/cj_" rule)
                                  ;; force each conjunct always to be bracketed
                                  nil)
                               ((and (cdr d) (atom (cadr d))
                                   (member (intern (cadr d))
                                      '(|,_,| |;_;| |:_:| |-_-| |..._...|)))
                                  ;; also all constituents after punctuation
                                  (setq next-cat t)
                                  major-cat)
                               (next-cat nil)
                               (t major-cat))))
                     (reverse (cdr tree)))))
            (cond
                 ((equal rcat "N") (setq rcat "N1"))
                 ((equal rcat "V") (setq rcat "VP"))
                 ((equal rcat "A1") (setq rcat nil)))
            (cond
               ((search "/cj_" rule)
                  (setq cat rcat))
               ((equal rule "V/to_bse")
                  (setq cat "VP"))
               ((member rule '("NP/det_n" "NP/n2_poss") :test #'equal)
                  (setq cat "NP"))
               ((member rule '("Taph/brack" "Tacl/brack/-" "Tacl/brack/+")
                   :test #'equal)
                  (setq cat "T"))
               ((or (and (null mother-major-cat) (null (cdr daughters)))
                   (equal major-cat mother-major-cat))
                  (setq cat nil))
               (t (setq cat rcat)))
            (if cat
               (list (cons cat daughters))
               daughters)))))


(defparameter +phrasal-parse-buffer+
   (make-array 20 :element-type 'character :adjustable t :fill-pointer 0))

(defun phrasal-parse-structure-word (word)
   (let*
      ((underscore (position #\_ word))
         (base
            (if underscore (subseq word 0 underscore) word)))
      (if (every #'alphanumericp base)
         (list base)
         (let ((buffer +phrasal-parse-buffer+))
            (setf (fill-pointer buffer) 0)
            (do
               ((ind 0 (1+ ind)))
               ((eql ind (length base))
                  (list (replace (make-string (length buffer)) buffer)))
               (unless (not (member (schar base ind) '(#\; #\( #\))))
                  (vector-push-extend #\\ buffer))
               (vector-push-extend (schar base ind) buffer))))))

(defun map-learnt-name (name entry)

;;; determine if mother of rule is S, P, V or coord.  Otherwise, keep as
;;; it is.  Note this is tsg specific.

  (let ((feats (map-parser-cat-to-term-cat (list (car (rule-body entry))))))
    (cond
     ((f-match feats '((v . +) (n . -) (bar . |2|) (txtcat . unit)
		       (txt . cl)))
      "S/learnt")
     ((f-match feats '((v . -) (n . -)))
      "P/learnt")
     ((or (f-match feats '((v . +) (n . -) (bar . |0|)))
	  (f-match feats '((v . +) (n . -) (bar . |1|))))      
	"V/learnt")
     ((f-match feats '((conj . variable)))
      "learnt/cj_")
     (t name))))

(defun f-match (a b)
  (let ((res nil))
    (dolist (f-v b t)
	    (unless
		(dolist (f-v2 a nil)
			(when (equal (car f-v2) (car f-v)) ;;; feat match
			      (cond			   
			       ((equal (cdr f-v) 'variable)
				(return t))
			       ((g-varp (cdr f-v2))
				(return t))
			       ((equal (cdr f-v2) (cdr f-v))
				(return t))
			       (t nil))))
		(return-from f-match nil)))))

