;;; Code to tune grammar.  Parse some corpus and record
;;; which rules are used.  Write them
;;; to a file.  When required, read-them in later and delete object rules
;;; not in this list.

;;; Note this file re-defines g-parse, so afterwards, will need to 
;;; start new gde session (so exit).

;;; Load-in tune1.lisp to rem
(defvar *freq-table* (make-hash-table :test #'equal))

(defun d-checkfeaturepair (featurepair) t)

(defun tune-grammar (corpus out)


  (setf *generate-edges* nil) ;;; don't learn
  (reset-tables)
  (clrhash *freq-table*)
  (create-rule-freq-table)
  (set-n-best 20)
  (parse-file1 corpus nil nil)
  
  (with-open-file (out-fp out :direction :output)
		  (maphash #'(lambda (name freq)
			       (when (and name (> freq 0))
				     (format out-fp "~S~%" name)))
			   *freq-table*))
  (exit))
				    
					  
		  
(defun update-rule-freqs (parses)

  (dolist (p parses)
	  (let ((likelihood-rules (get-nonterms-from-tree 
				   (get-rule-labelling-from-parse-tree 
				    (cdr p)))))
		(dolist (r-d likelihood-rules) 
			(let* ((r (car r-d))
			       (d (cadr r-d)))

			  (let ((entry (gethash r *freq-table*)))
			    (if entry
				(setf (gethash r *freq-table*)
				      (+ 1 (gethash r *freq-table*)))
			      (setf (gethash r *freq-table*) 1))))))))
			       
		      		      		        
(defun g-parse (words &optional (top-indexes t))
  
  ;;; initialise various tables
  (unless *rule-denom* (create-rule-freq-table))

  (let ((res 
	 (g-parse1 words top-indexes)))
    
    (setf *total-processed* (+ 1 *total-processed*))

    (when res
	  (setf *total-parsed* (1+ *total-parsed*))          
	  (update-rule-freqs res))
    res))









