;;; Start of file LOAD

;;; ANLT CHART PARSER - LOAD FILE
;;; 
;;; Loading the parser. In systems with compile-file, the files
;;; loaded should have already have been compiled. On the other
;;; hand, in systems such as MCL, PROCYON, POPLOG which compile on-
;;; the-fly in load it is the source files that are loaded here.

(in-package #+(or cltl2 x3j13) common-lisp-user #-(or cltl2 x3j13) 'user)


#-gde-debug
(eval-when (compile load eval)
   (proclaim
      '(optimize (speed 2) (safety 1) (compilation-speed 0)
         (space 0) #+(or cltl2 x3j13) (debug 1))))


;;; *** Give Common Lisp pathname representing all but the name
;;; and type of the files to be compiled/loaded.

(defvar *parser-source-pathname*
   (pathname
      #+(OR UNIX SUNOS) "/usr/groups/nltools/annlt/gde/cpar/"      
      #+XEROX "{DSK}<lispfiles2>cpar>"
      #+(OR MACINTOSH :CORAL) "internal:cpar:"
      ))


;;; Specify the default compiler output file type to load for
;;; those systems which do not try looking for files of that type.

(eval-when (load eval)
   (mapc 
      #'(lambda (file)
         (load
            (merge-pathnames
               (make-pathname :name file .
                  #+(or MACINTOSH :CORAL POPLOG) (:type "lsp")
                  #+XEROX (:type "dfasl")
                  #-(or MACINTOSH :CORAL POPLOG XEROX) nil)
               *parser-source-pathname*)
            :verbose nil :print nil))
      '("hdr" "gindex" "unify" "parse")))


;;; End of file
