;;; Start of file DEFNAME.LSP

;;; GRAMMAR DEVELOPMENT ENVIRONMENT - NAMES OF FEATURES ETC
;;;
;;; Author: John Carroll
;;;
;;; Copyright: Ted Briscoe, Bran Boguraev,
;;;            John Carroll, Claire Grover  1986-91
;;;
;;; The functions in this file return the conventional names for
;;; certain important features, sets, feature values, and
;;; categories. These particular names are thus in a sense
;;; hard-wired into the environment.
;;;
;;; Entry points:
;;;
;;;  * (defmacro Bar-feature-name NIL ...
;;;  * (defmacro Head-feature-name NIL ...
;;;  * (defmacro Takes-feature-name NIL ...
;;;  * (defmacro Subcat-feature-name NIL ...
;;;  * (defmacro Null-feature-name NIL ...
;;;  * (defmacro Cat-feature-value NIL ...
;;;  * (defmacro W-category-name NIL ...
;;;  * (defmacro U-category-name NIL ...
;;;  * (defmacro F-variable-name NIL ...
;;;  * (defmacro Element-variable-name NIL ...
;;;  * (defmacro Alt-semantics-marker NIL
;;;  * (defmacro Unnamed-variable NIL ...
;;;  * (defmacro Rule-feature-name NIL ...
;;;  * (defmacro Kleene-feature-name NIL ...
;;;  * (defmacro Null-index-name NIL ...
;;;  * (defmacro Word-index-name NIL ...
;;;  * (defmacro Whead-set-name NIL ...
;;;  * (defmacro Wdaughter-set-name NIL ...
;;;  * (defmacro Morphologyonly-set-name NIL ...

(defmacro bar-feature-name nil ''|BAR|)


(defmacro head-feature-name nil ''|H|)


(defmacro takes-feature-name nil ''|TAKES|)


(defmacro subcat-feature-name nil ''|SUBCAT|)


(defmacro null-feature-name nil ''|NULL|)


(defmacro cat-feature-value nil ''|CAT|)


(defmacro w-category-name nil ''|W|)


(defmacro u-category-name nil ''|U|)


(defmacro f-variable-name nil ''|F|)


(defmacro element-variable-name nil ''|in|)


(defmacro alt-semantics-marker nil ''|alts|)


(defmacro unnamed-variable nil ''\@)


;;; Category index names needed when printing grammar to file
;;; for later use by parser.

(defmacro null-index-name nil ''|null|)


(defmacro word-index-name nil ''|word|)


;;; Set names used by morph package.

(defmacro whead-set-name nil ''|WHEAD|)


(defmacro wdaughter-set-name nil ''|WDAUGHTER|)


(defmacro morphologyonly-set-name nil ''|MORPHOLOGYONLY|)


;;; End of file

