/* Unknown words: dictionary functions

   18-09-95	Created

   Copyright (C) Larry Piano 1995

*/


/* Find a partial word, embedded in a dictword, using keys */
extern DictWord find_partial_dictword(DictWord d, Dict *dict);

/* Set location of the anchor, number and unknown words (create them if need
   be) */
extern void set_special_words(Dict *dict, Features features );

/* Dictionary lookup procedures */
extern DictWord lookup_word( int mode, Dict *dict, uchar *new_word, int testpos, int partial_len );

extern DictWord lookup_added_initial( Dict *dict, uchar *new_word, int testpos, int partial_len );

/* Free a dictionary's memory */
void free_dict(Dict *dict);

/* Add entry to a statistics dictionary. */
void add_stats(Dict *dict, uchar *text, BOOL correct, BOOL correct_in_hyp);

/* Add an unknown word and its tags. */
extern void add_unkword(Dict *dict, uchar *text, BOOL skip_closed, TagScore tagscore, uchar **feature_info);

/* Look up an indexed word in an indexed list. */
extern DictWord lookup_indexed_word( int mode, IndexList indexlist, Dict *dict, uchar *new_word, int testpos, int min_partial_len );

/* Add a '*' to the new_word and call lookup_indexed_word. */
extern DictWord lookup_indexed_added_initial( IndexList indexlist, Dict *dict, uchar *new_word, int testpos, int min_partial_len );

