/* Statistical labeller: common pharsal functions

   21-05-93	Created from other soruce files

   Copyright (C) David Elworthy 1995
*/


/* Type for a list of tags */
typedef struct tags_st TagsSt, *Tags;
struct tags_st
{
    Tags next;
    Tag  tag;
};

/* Add a tag to a sorted tags list */
extern Tags add_tag_to_list(Tags head, Tag tag);

/* Free a tags list */
extern void free_tags_list(Tags tags);

/* Match a Tags list and a score hyp list into an unscored hyp list */
extern Link match_tags_list(Tags tags, Link hyps, BOOL lex_only);

/* Dump out details of a phrase */
extern void dump_phrase_hyp(FILE *out, Hyp hyp);

/* Construct a node during phrase construction */
extern Node build_subsumed_node(Node succ, Hyp hyp);

/* Make a node with a list of hyps */
extern Node make_node(Node succ, Link hyps, Node start, Node end);

/* Call tagger on a phrasal hypothesis */
extern void tag_phrase(Hyp h, Trans *trans, Trans *new);
