/* Statistical labeller: Parser.

   31-03-93	Created
   22-04-93	Integrate chart with main data structures

   Copyright (C) David Elworthy 1995

   See the documentation for a specification of the syntax and semantics.
*/

/* Read parser rules */
extern void parser_read(FILE *in);
extern void parser_read_named(char *name);

/* Advance the parser; call when a new node has been set up. This may create
   phrases, which are then tagged if "trans" is non-NULL. "new" is needed only
   if re-estimation is being used. */
extern void parser_advance(Node node, Trans *trans, Trans *new);

/* Dump an active edge; called during chart/debugging output */
extern void parser_dump_edge(FILE *out, Hyp hyp);

/* Initialise an active hyp; called when a hypothesis created */
extern void parser_init_hyp(Hyp hyp);

/* Free an active hyp; called when a hypothesis is being freed */
extern void parser_free_hyp(Hyp hyp);

/* Tell labeller if tagging is allowed */
extern BOOL parser_may_tag(Lexeme top);
