/* Statistical labeller: FSMs.

   04-01-93	Created
   26-04-93	Interface changed

   Copyright (C) David Elworthy 1995
*/

/* Read the FSM definitions */
extern void fsm_read(FILE *in);
extern void fsm_read_named(uchar *name);

/* Advance FSMs on input; call on setting up a new node */
extern void fsm_advance(Node node, Trans *trans, Trans *new);

/* Dump a fsm state for chart/debugging */
extern void fsm_dump_state(FILE *out, int depth, FSMState state);

/* Initialise a fsm state; call on creating a node */
extern void fsm_init_node(Node node);

/* Free a fsm state; call on freeing a node */
extern void fsm_free_node(Node node);

/* Tell labeller if tagging is allowed */
extern BOOL fsm_may_tag(Lexeme top);
