/* Program to allow comparison of tag sequence probabilities

   26-01-93	Created

   Copyright (C) David Elworthy 1995

   Usage:
	cmptran trans
   
  Takes lines consisting of three tags and works out the probability of the
  sequence, and the ratio of this one to the last (on the second of each
  pair).
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "trans.h"
#include "map.h"

/*-----------------------------------------------------------------------------
    main

    Entry point.
-----------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
#define MaxLine (100)
    Trans trans;
    char buffer[MaxLine];
    int i = 0;
    Score s = 0;

    /* Clear data structures */
    InitTrans(trans)
    InitOptions;

    /* Verify command line */
    if (argc <= 1)
	error_exit("Usage: cmptran trans\n");

    read_mapping("tags.map");
    read_named_trans(argv[1], &trans);
    adjust_trans(&trans, NULL);

    /* Read from stdin until end of file */
    while (fgets(buffer, MaxLine-1, stdin) != NULL)
    {
	uchar *tag1, *tag2, *tag3;
	Tag  t1, t2, t3;
	Score t;

	tag1 = strtok(buffer, " \t:\n");
	tag2 = strtok(NULL,   " \t:\n");
	tag3 = strtok(NULL,   " \t:\n");
	t1 = map_tag(tag1);
	t2 = map_tag(tag2);
	t3 = map_tag(tag3);

	t = Trans_(trans.trans,t1,t2,trans.size)
		* Trans_(trans.trans,t2,t3,trans.size);
	printf("%s : %s : %s = %g", unmap_tag(t1), unmap_tag(t2),
			unmap_tag(t3), t);
	if (i == 0) s = t;
	else printf(" %g", t/s);
	printf("\n");
	i = 1 - i;
    }

    return 0;
}
