;;; adapted JAC code.  Timeout when unpacking.


(defparameter +parse-timeout+ 45)

#+allegro
(define-condition parse-timeout (simple-condition) ()
  (:documentation "Simple (non-error) condition to signal parser timeout"))

(defmacro execute-with-timeout (timeout-form &body body)
   #-allegro
   `(let ((*parse-timeout*
            (+ (get-internal-run-time)
               (* +parse-timeout+ internal-time-units-per-second))))
      (declare (special *parse-timeout*))
      (let ((.res. (catch 'parse-timeout ,@body)))
         (if (eq .res. 'parse-timeout)
            ,timeout-form
            .res.)))
   #+allegro
   ;; `(mp:with-timeout (+parse-timeout+ ,timeout-form) ,@body)
   `(let* ((.res. nil)
           (.parse-timeout.
              (+ (get-internal-run-time)
                (* +parse-timeout+ internal-time-units-per-second)))
           (.continuation. excl:*gc-after-hook*)
           (excl:*gc-after-hook*
              #'(lambda (&rest x)
                   (when (> (get-internal-run-time) .parse-timeout.)
                      (signal 'parse-timeout))
                   (when .continuation. (apply .continuation. x)))))
         (setf (sys:gsgc-switch :hook-after-gc) t)
         (handler-case
             (setq .res. (progn ,@body))
            (parse-timeout ()
               (setf (sys:gsgc-switch :hook-after-gc) nil)
               (setq .res. ,timeout-form))
            (storage-condition ()
               (format t "~%Memory overflow~%"))
            (serious-condition (c)
               (format t "~%Error:~%~A~%" c))
            (:no-error (&rest x) (declare (ignore x))
               ))
         (setq *chart-edges nil)
         (setf (sys:gsgc-switch :hook-after-gc) nil)
         .res.)
   )

#-allegro
(progn
   (embed g-insert-traces
      (lambda (word-no chart finishing)
         (declare (special *parse-timeout*) (optimize (speed 3) (safety 0)))
         (locally (declare (integer *parse-timeout*))
            (if (> (get-internal-run-time) *parse-timeout*)
               (throw 'parse-timeout 'parse-timeout)
               (g-insert-traces word-no chart finishing)))))
   (embed g-unpack
      (lambda (tree vt)
         (declare (special *parse-timeout*) (optimize (speed 3) (safety 0)))
         (locally (declare (integer *parse-timeout*))
            (if (> (get-internal-run-time) *parse-timeout*)
               (throw 'parse-timeout 'parse-timeout)
               (g-unpack tree vt))))))

(eval-when (load eval)
    (unembed v-unpack)
    (embed v-unpack 
	   (lambda (tree vt score)
	     (execute-with-timeout
	      (+parse-timeout+
	       ;;; ran out of time
	       (progn
		 (format t "-1 ~%")
		 0))
	      (v-unpack tree vt score)))))







