;;; Good-Turing Smoothing

;;; if n_r+1 is undefined, use n_r+j , j>i; if j is undefined, r* = r.

(defun smooth (params)

;;; params is a list of the form ( (param freq) (param freq) ...)

  (let ((buckets nil) (temp nil)
	(max 0))

    (dolist (p params)
	    (unless (member (cadr p) buckets)
		    (push (cadr p) buckets)))
    (dolist (b buckets)
	    (push (list b 0) temp))
    (dolist (p params)
	    (let ((num (cadr p)))
	      (dolist (tt temp)
		      (when (= (car tt) num)
			    (setf (cadr tt) (+ 1 (cadr tt)))
			    (return)))))
    (setf temp (sort temp #'< :key #'car))
    (let ((res nil))
      (dolist (p params res)
	      (let ((freq (cadr p)) (temp2 temp))
		(dotimes (x (length temp))
			(when (= (caar temp2) freq)
			      (let ((curr (car temp2))
				    (next (cadr temp2)))
				(if next
				    (push 
					  (list (car p)
						(* (car next)
						   (/ (cadr next)
						      (cadr curr)))) res)
				  (push p res)))
			      (return))
			(pop temp2)))))))

