;;; gloss tsg parse trees and rules.

(defvar *glossed-names* nil)


(defun gloss-parse-tree (tree)
  
  (unless *glossed-names*
	  (build-gloss-names))

  (cond
   ((null tree) nil)
   ((atom tree)
    (let ((gloss (gethash tree *glossed-names*)))
      (if gloss
	  gloss
	(gloss-learnt-rule tree))))		       
   ((listp (car tree))
    (let ((res (gloss-parse-tree (car tree))))
      (cons res (gloss-parse-tree (cdr tree)))))
   (t
    (let ((gloss (gethash (car tree) *glossed-names*)))
      (if gloss
	  (cons gloss (gloss-parse-tree (cdr tree)))
	(cons (gloss-learnt-rule (car tree))
	      (gloss-parse-tree (cdr tree))))))))

(defun gloss-learnt-rule (rule-name)
  (let ((entry (fetch-rule-entry rule-name)))
    (cond
     (entry
      (let ((mother (map-parser-cat-to-term-cat 
		     (list (car (rule-body entry))))))
	(format nil "~A*" (intern (gloss-category mother)))))
      ;;; word (ie not an entry)
     (t
      rule-name))))

;(defun gloss-learnt-rule (rule-name)
 ; rule-name)

(defun build-gloss-names nil

  (setf *glossed-names* (make-hash-table :test #'equal))

  (dolist (r *id-rules)
	  (let ((raw-rules (get-rules-given-name r)) 
		(name nil))

	    (dolist (r raw-rules)
		    (setf name (second (car r)))
		    (setf (gethash name *glossed-names*)
			  (gloss-category 
			   (map-parser-cat-to-cat
			    (car r))))))))

	    

(defun gloss-pprint-learnt-rule (fp rule)
  (let ((mother (map-parser-cat-to-term-cat (list (car (rule-body rule))))))
    (gloss-pprint-cat fp  mother)
    (format fp " --> ")
    (dolist (cat (cdr (rule-body rule)))
	    (gloss-pprint-cat fp (reverse 
				  (map-parser-cat-to-term-cat 
				   (list cat)))))))

(defun gloss-pprint-cat (fp fv)
  (format fp (gloss-category fv))
  (format fp " "))

(defun gloss-category (fv-list)

  (cond
   ((gloss-match fv-list '((N . +) (V . -)))
    (format nil "N~A"
	    (gloss-fetch-val-given-feat fv-list 'BAR)))
   ((gloss-match fv-list '((N . -) (V . +)))
    (format nil "V~A"
	    (gloss-fetch-val-given-feat fv-list 'BAR)))
   ((gloss-match fv-list '((N . -) (V . -)))
    (format nil "P~A"
	    (gloss-fetch-val-given-feat fv-list 'BAR)))
   ((gloss-match fv-list '((N . +) (V . +)))
    (format nil "A~A"
	    (gloss-fetch-val-given-feat fv-list 'BAR)))   
   ((gloss-fetch-val-given-feat  fv-list 'T)
    (format nil "Top"))
   ((gloss-fetch-val-given-feat  fv-list 'TXTCAT)
    (format nil "Txt"))
   (t
    (let ((minor (gloss-fetch-val-given-feat fv-list 'MINOR)))
      (if minor
	  (format nil "~A" minor)
	(let ((punct (gloss-fetch-val-given-feat fv-list 'PUNCT)))
	  (if punct
	      (format nil "~A" punct)
	    (format nil "X"))))))))
   
	    
(defun gloss-match (fv-list pattern)

;;; true if category (fv-list) contains feats named in pattern
;;; along with given values.

  (dolist (pat pattern t)
	  (unless (gloss-match1 pat fv-list)
		  (return-from gloss-match nil))))

(defun gloss-match1 (f-v fv-list)

  (let ((f (car f-v)) (v (cdr f-v)))
    (dolist (fv fv-list nil)
	    (when (and (equal f (car fv))
		       (equal v (cdr fv)))
		  (return-from gloss-match1 t)))))


(defun gloss-fetch-val-given-feat (fv-list feat)
  (dolist (f-v fv-list nil)
	  (when (equal (car f-v) feat)
		(return-from gloss-fetch-val-given-feat (cdr f-v)))))
























































































