;;; create a file of all sentences that can't be parsed.

(defvar *out* nil)

(setf *out* (open "/tmp/unparsed" :direction :output))

(defun g-parse (words &optional (top-indexes t))
  

  (let ((res 
	 (g-parse1 words top-indexes)))
    (unless res
	    (dolist (x words)
		    (format *out* "~A " x))
	    (format *out* " . ~%"))
    res))

(defun g-parse1 (words top-indexes )
   (let*
      ((nvertices (1+ (length words)))
         (ncats (1+ *current-category-index))
         (chart
            (cons
               (make-array (list nvertices ncats) :initial-element nil)
               (and g-packing
                  (make-array (list nvertices ncats) :initial-element nil))))
         (word-no 0)
         (g-result nil))
      (setq *chart-edges nil)
      (loop
         (cond
            ((null words)
               (g-insert-traces word-no chart t)
               (return
		(let ((res2 
		       (if g-packing
			   (let
			       ((res
				 (mapcan
				  #'(lambda (p)
				      (when
                                       (or (not (listp top-indexes))
					   (member (g-category-index (caadr p))
						   top-indexes))
                                       (g-unpack (cdr p) (car p))))
				  g-result)))
			     (dolist (p res) (g-rempack (cdr p)))
			     res)
			 g-result)))
		  (if res2
		      res2
		    (progn
		      ;(setf *succ* nil)
		      ;(invent-new-edges chart)
		      (let ((res3 
			     (if g-packing
				 (let
				     ((res
				       (mapcan
					#'(lambda (p)
					    (when
					     (or (not (listp top-indexes))
						 (member 
						  (g-category-index (caadr p))
						  top-indexes))
					     (g-unpack (cdr p) (car p))))
					g-result)))
				   (dolist (p res) (g-rempack (cdr p)))
				   res)
			 g-result)))
			res3))))))
		    
            ((and (not *g-compute-all-edges)
                  (> word-no 0)
                  (dotimes (n ncats t)
			   (when (aref (car chart) word-no n) 
				 (return nil))))
	     (return nil)))
         (g-insert-traces word-no chart nil)
         (dolist (defn (g-defns (car words)))
            (let ((cat (caar defn)))
               (when (g-category-index cat)
                  (multiple-value-bind (renamed-cat re-entrant-p)
                     (g-copy-category cat nil nil nil nil)
                     (g-process-inactive
                        (make-g-chart-edge nil
                           (cons (cons renamed-cat (cdar defn)) (cdr defn))
                           (1+ word-no) (cons nil nil) re-entrant-p word-no)
                        chart (null (cdr words)))))))
         (setq word-no (1+ word-no))
         (setq words (cdr words)))))