;;; After creating a list of seen object rules (using tune.lisp)
;;; start a new session and load this file in.  Next read-in the file
;;; containing seen object rules.

;;; Note this redefines g-indexrules and make-parse-rule-tree.

;;; Entry: (compact-grammar in) 

(when (and (fboundp 'make-parse-rule-tree)
	   (not (fboundp 'original-make-parse-rule-tree)))
      (setf (symbol-function 'original-make-parse-rule-tree) 
	    #'make-parse-rule-tree))


(when (and (fboundp 'g-indexrules)
	   (not (fboundp 'original-g-index-rules)))
      (setf (symbol-function 'original-g-indexrules) 
	    #'g-indexrules))

(defun compact-grammar (in)

  ;;; throw-away from grammar any rules not seen in file "in".
  ;;; This should be called after reading-in a grammar and prior 
  ;;; to entering the parse loop.

  (unless *id-rules
	  (error "Need to load-in a grammar first"))

  (let ((seen (read-in-seen-rules in)))

    (setf *current-parse-trees nil)
    (setf *chart-edges nil)
    (compile-world-stats1)
    (format t "~A Object rules left" (- (make-parse-rule-tree nil seen) 1))))

(defun make-parse-rule-tree (remove-cached &optional (seen nil))
  (if (not seen)
      (original-make-parse-rule-tree remove-cached)
    (g-indexrules
      (mapcan
         #'(lambda (idrule-name)
            (prog1
               (mapcar
                  #'(lambda (compiled-idrule)
                     (convert-idrule-to-parser
                        (if *term-unification
                           compiled-idrule
                           (fill-unrestricted-idrule compiled-idrule))))
                  (compile-idrule idrule-name))
               (when remove-cached
                  (remprop idrule-name 'compiled-idrules)
                  (remprop idrule-name 'expanded-idrules))))
         *id-rules)
      seen))
  (length seen))

	   
(defun g-indexrules (rules &optional (seen nil))

  (if (not seen)
      (original-g-indexrules rules)
    (progn
      (let ((pruned nil))
	(dolist (r rules)
		(let ((name (second (car r))))
		  (format t "~A~%" name)
		  (if (not (member name seen :test #'string=))
		      (format t "Deleting object rule ~S ~%" name)
		    (progn
		      (push r pruned)
		      (format t "~A is a member of ~A ~%" name seen)))))
	(setq g-tracerules nil)
	(setq g-gramtree nil)
	(setq g-gramtree
	      (g-makeruletree (mapcan #'g-ruleindex pruned)
			      (make-array (1+ *current-category-index) 
					  :initial-element nil)))
	(length pruned)))))
    
(defun read-in-seen-rules (in)

  ;;; read-in names of seen object rules.

  (unless (probe-file in)
	  (error "Seen object rule file does not exist"))

  (with-open-file 
   (in-fp in :direction :input)
   (let ((seen '(dummy))) ;; add dummy so we can compact grammar even with no
                          ;;; rules (else defaults to original)
     (loop
      (let ((rule (read in-fp nil 'eof nil)))
	(if (eq rule 'eof)
	    (return-from read-in-seen-rules seen)
	  (push (format nil "~S" rule) seen)))))))




