;;; disk-resident

;;; Claws-II open class tag lexicon for full N-ANLT grammar
;;; Eirik Hektoen 1998

;;; Includes only open class and number tags, on assumption that closed class
;;; words and punctuation are defined in a regular lexicon.

;;; The predicate -lemma- in semantic forms should be substituted by the
;;; relevant lemma or other suitable lexical predicate.

;;; STILL TO DO ???:
;;;  - For _ND1 etc, any feature for 'noun of direction'? Adv+?
;;;  - For _RA, based on ANLT 'else', check also 'ago' (see sus-tags)
;;;  - For _RGA, based on ANLT 'enough', check also 'indeed'
;;;  - Also include?  &FO &FW NN1$

;;; MO all lexica files have been concatenated together.


WORD _JA : ; predic adj 'afraid', 'tantamount' (selection of subcats)

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SFIN, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SINF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT VPINF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE READY, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT PP, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JB : ; attrib adj 'main', 'chief'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR ATT, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JBR : ; attrib adj compar 'upper'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, er, DISTR ATT,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JBT : ; attrib adj super 'utmost'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, est, DISTR ATT,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JJ : ; general adj (selection of subcats)

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SFIN, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SINF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT VPINF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE READY, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT PP, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR ATT, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JJR : ; general adj compar (selection of subcats)

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, er, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SFIN, CONJ NULL, PART -, er, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SINF, CONJ NULL, PART -, er, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT VPINF, CONJ NULL, PART -, er, DISTR PRD,
      SUBTYPE READY, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT PP, CONJ NULL, PART -, er, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, er, DISTR ATT,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JJT : ; general adj super (selection of subcats)

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, est, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SFIN, CONJ NULL, PART -, est, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SINF, CONJ NULL, PART -, est, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT VPINF, CONJ NULL, PART -, est, DISTR PRD,
      SUBTYPE READY, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT PP, CONJ NULL, PART -, est, DISTR PRD,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-,
   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, est, DISTR ATT,
      SUBTYPE NONE, AGR N2[NFORM NORM], GRADE +] : -lemma-.

WORD _JK : ; adj catenative (?) 'able' (in 'be able to')

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SC_INF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE RAIS] : -lemma-.

WORD _MC : ; cardinal number 'two', 'three', '123'

   [CN1 @x, CN2 SMALL, CN4 +] : -lemma-.

WORD _MC1 : ; cardinal number sg 'one'

   N[-PRD, -POSS, -ADV, +DEF, -PLU, +PRO, -NUM, SUBCAT NULL, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, PART -, AFORM NONE, WH NO, UB NO,
      EVER NO, REFL -, DEMON -] : (pro (the (x) (and (sg x) (human x)))),
   [CN3 ONE] : |1|.

WORD _MC2 : ; cardinal number pl '1990s'

   [CN1 @x, CN2 BIG, AND -, CN4 -] : -lemma-.

WORD _MD : ; ordinal number 'first', 'last', 'next'

   DetA[ORD, AFORM NONE, WH NO, UB NO, EVER NO] : -lemma-,
   A[-ADV, -NEG, -QUA, ORD, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR ATT, SUBTYPE NONE, AGR N2[NFORM NORM], GRADE -] : -lemma-,
   DetN[-POSS, +DEF, WH NO, UB NO, EVER NO, AGR N2[-PLU, +COUNT, QFEAT -],
      DEMON -] :
   (lambda (P) (dd (the (x) (and (sg x) (-lemma- x) (P x))))),
   [PLU @x, FRACT @y] : -lemma-.

WORD _MF : ; fraction 'quarter'

   [PLU @x, FRACT @y] : -lemma-.

WORD _NN1 : ; noun sg 'abbot'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NC2 : ; cited word pl (as noun) 'ifs', 'buts'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _ND1 : ; noun of direction sg 'north'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NN : ; noun (sg or pl) 'deer'

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM, PER 3,
      PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NN2 : ; noun pl 'abbots'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _NNJ : ; organisational noun (sg or pl) 'council'

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM, PER 3,
      PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNJ1 : ; organisational noun sg 'commonwealth'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNJ2 : ; organisational noun pl 'committees'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _NNL : ; locative noun (sg or pl) 'st.'

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM, PER 3,
      PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNL1 : ; locative noun sg 'street'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNL2 : ; locative noun pl 'streets'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _NNO : ; numeric noun (sg or pl) 'thousand', 'dozen'
   [CN1 @x, CN2 BIG, AND -, CN4 -] : -lemma-.

WORD _NNO1 : ; numeric noun sg
   [CN1 @x, CN2 BIG, AND -, CN4 -] : -lemma-.

WORD _NNO2 : ; numeric noun pl 'thousands', 'dozens'
   [CN1 @x, CN2 BIG, AND -, CN4 -] : -lemma-.

WORD _NNS : ; noun of style (sg or pl)

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM, PER 3,
      PN -, PROTYPE NONE, PART -, DEMON -, ADDRESS +] : -lemma-.

WORD _NNS1 : ; noun of style sg 'Mayor'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -, ADDRESS +] : -lemma-.

WORD _NNS2 : ; noun of style pl 'Chiefs'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, ADDRESS +] : -lemma-.

WORD _NNSA1 : ; following noun of style sg 'Jr.'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -, ADDRESS +] : -lemma-.

WORD _NNSA2 : ; following noun of style pl

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, ADDRESS +] : -lemma-.

WORD _NNSB : ; preceding noun of style (sg or pl) 'Rt.Hon.'

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM, PER 3,
      PN -, PROTYPE NONE, PART -, DEMON -, ADDRESS +] : -lemma-.

WORD _NNSB1 : ; preceding noun of style sg 'Prof.'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -, ADDRESS +] : -lemma-.

WORD _NNSB2 : ; preceding noun of style pl 'Reps.'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, ADDRESS +] : -lemma-.

WORD _NNT : ; temporal noun (sg or pl)

   N[-POSS, -ADV, -PRO, -NUM, SUBCAT NULL, CONJ NULL, NFORM NORM, PER
         3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNT1 : ; temporal noun sg 'day'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, SUBCAT NULL, CONJ NULL, NFORM
      NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PLU, -PRO, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PLU, -PRO, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-,
   N[-POSS, +ADV, -PLU, -PRO, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -, DEMON -] : -lemma-.

WORD _NNT2 : ; temporal noun pl 'days'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL, NFORM
      NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, +ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, +ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, +ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _NNU : ; unit of measurement (sg or pl) 'kg'

   N[-POSS, -ADV, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL, NFORM NORM, PER
         3, PN -, PROTYPE NONE, DEMON -, PART NO_OF] : -lemma-,
   N[-POSS, -ADV, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, DEMON -, PART OF] : -lemma-,
   N[-POSS, -ADV, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-,
   N[-POSS, -ADV, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-,
   N[-POSS, -ADV, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL, NFORM
         NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-.

WORD _NNU1 : ; unit of measurement sg 'gram'

   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL, NFORM
      NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART NO_OF] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART OF] :
   -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-,
   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, DEMON -, PART -] : -lemma-.

WORD _NNU2 : ; unit of measurement pl 'grams'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL, NFORM
      NORM, PER 3, PN -, PROTYPE NONE, PART NO_OF] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART OF] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PRT @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-,
   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, SUBCAT @x, PFORM @y, CONJ NULL,
      NFORM NORM, PER 3, PN -, PROTYPE NONE, PART -] : -lemma-.

WORD _NP : ; proper noun (sg or pl)

   N[-POSS, -ADV, -PRO, -NUM, +PN, SUBCAT NULL, CONJ NULL, NFORM NORM,
      PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   (name (the (x) (and (sg x) (named x -lemma-) (animate x)))).

WORD _NP1 : ; proper noun sg 'Kim'

   N[-POSS, -ADV, -PLU, -PRO, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   (name (the (x) (and (sg x) (named x -lemma-) (animate x)))).

WORD _NP2 : ; proper noun pl 'Americas'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -] :
   (name (the (x) (and (sg x) (named x -lemma-) (animate x)))).

WORD _NPD1 : ; weekday noun sg 'Sunday'

   N[-POSS, +ADV, -PLU, -PRO, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   -lemma-.

WORD _NPD2 : ; weekday noun pl 'Sundays'

   N[-POSS, +ADV, +PLU, -PRO, +COUNT, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -] : -lemma-.

WORD _NPM1 : ; month noun sg 'October'

   N[-POSS, +ADV, -PLU, -PRO, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   -lemma-.

WORD _NPM2 : ; month noun pl 'Octobers'

   N[-POSS, +ADV, +PLU, -PRO, +COUNT, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -] : -lemma-.

WORD _RA : ; adv after nominal head 'else' (in 'anyone else'), 'ago'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE NONE, AGR N2[NFORM NORM], COADV -, GRADE -] :
   -lemma-.

WORD _RGA : ; post-nom/adj/adv degree word 'indeed', 'enough'

   A[-PRD, -ADV, -NEG, -DEF, +QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -,
      AFORM NONE, DISTR ATT, SUBTYPE NONE, AGR N2[+PLU, +COUNT, QFEAT -],
      GRADE -] :
   (lambda (Q) (Q -lemma- (lambda (x) (lambda (P) (and (pl x) (P x)))))),
   A[-PRD, -ADV, -NEG, -DEF, +QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -,
      AFORM NONE, DISTR ATT, SUBTYPE NONE, AGR N2[-PLU, -COUNT, QFEAT -],
      GRADE -] :
   (lambda (Q) (Q -lemma- (lambda (x) (lambda (P) (and (ms x) (P x)))))).

WORD _RL : ; locative adv 'forward', 'alongside'

   A[+ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      SUBTYPE NONE, AGR N2[NFORM NORM]] : -lemma-.

WORD _RR : ; adv 'eagerly'

   A[+ADV, -NEG, -QUA, -NUM, SUBCAT NULL, CONJ NULL, PART -, AFORM NONE,
      SUBTYPE NONE, AGR N2[NFORM NORM]] : -lemma-.

WORD _RRR : ; compar adv 'longer'

   A[+ADV, -NEG, -QUA, -NUM, er, SUBCAT NULL, CONJ NULL, PART -, SUBTYPE NONE,
      AGR N2[NFORM NORM]] : -lemma-.

WORD _RRT : ; super adv 'longest'

   A[+ADV, -NEG, -QUA, -NUM, est, SUBCAT NULL, CONJ NULL, PART -, SUBTYPE
      NONE, AGR N2[NFORM NORM]] : -lemma-.

WORD _RT : ; time noun 'now', 'tomorrow'

   N[+PRD, -POSS, -ADV, +DEF, +PRO, -NUM, SUBCAT NULL, CONJ NULL, NFORM NORM,
      PER 3, PN -, PROTYPE PMOD, PART -, AFORM NONE, WH NO, UB NO, EVER NO,
      REFL -, DEMON +] :
   (lambda (Q) (Q dd the (lambda (x) (and (sg x) (-lemma- x) (time x)))
            AT)).

WORD _VV0 : ; verb base form (incl imp, non-s pres) 'give', 'work'

   V[BSE, -PRD, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PSVE -,
      AGR N2[NFORM NORM]] : -lemma-,
   V[IMP, -PRD, -INV, -NEG, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[+NOM, NFORM NORM]] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, +PLU, NFORM NORM]] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 1]] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 2]] : -lemma-,
   V[BSE, -PRD, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PSVE -,
      AGR N2[NFORM NORM], PRT @x] : -lemma-,
   V[IMP, -PRD, -INV, -NEG, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[+NOM, NFORM NORM], PRT @x] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, +PLU, NFORM NORM], PRT @x] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 1], PRT @x] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 2], PRT @x] :
   -lemma-,
   V[BSE, -PRD, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PSVE -,
      AGR N2[NFORM NORM], PFORM @y] : -lemma-,
   V[IMP, -PRD, -INV, -NEG, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[+NOM, NFORM NORM], PFORM @y] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, +PLU, NFORM NORM], PFORM @y] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 1], PFORM @y] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 2], PFORM @y] :
   -lemma-,
   V[BSE, -PRD, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PSVE -,
      AGR N2[NFORM NORM], PRT @x, PFORM @y] : -lemma-,
   V[IMP, -PRD, -INV, -NEG, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[+NOM, NFORM NORM], PRT @x, PFORM @y] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, +PLU, NFORM NORM], PRT @x, PFORM @y] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 1], PRT @x,
      PFORM @y] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 2], PRT @x,
      PFORM @y] : -lemma-.

WORD _VVD : ; verb past tense 'gave', 'worked'

   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST +, PSVE -, AGR N2[NFORM NORM]] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST +, PSVE -, AGR N2[NFORM NORM], PRT @x] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST +, PSVE -, AGR N2[NFORM NORM], PFORM @y] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST +, PSVE -, AGR N2[NFORM NORM], PRT @x, PFORM @y] : -lemma-.

WORD _VVG : ; 'helping'

   V[ING, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT, PSVE
      -, AGR N2[NFORM NORM]] : -lemma-,
   V[ING, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PRT @x] : -lemma-,
   V[ING, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PFORM @y] : -lemma-,
   V[ING, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PRT @x, PFORM @y] : -lemma-.

WORD _VVN : ; verb past participle 'given', 'worked'

   V[PSP, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT, PSVE
      -, AGR N2[NFORM NORM]] : -lemma-,
   V[PAS, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE +, AGR N2[NFORM NORM]] : -lemma-,
   V[PSP, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PRT @x] : -lemma-,
   V[PAS, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE +, AGR N2[NFORM NORM], PRT @x] : -lemma-,
   V[PSP, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PFORM @y] : -lemma-,
   V[PAS, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE +, AGR N2[NFORM NORM], PFORM @y] : -lemma-,
   V[PSP, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE -, AGR N2[NFORM NORM], PRT @x, PFORM @y] : -lemma-,
   V[PAS, -INV, -NEG, -FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, PAST NOT,
      PSVE +, AGR N2[NFORM NORM], PRT @x, PFORM @y] : -lemma-.

WORD _VVZ : ; verb s-form 'helps'

   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 3]] : -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 3], PRT @x] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 3], PFORM @y] :
   -lemma-,
   V[-PRD, -INV, -NEG, +FIN, -AUX, -PRO, SUBCAT @s, CONJ NULL, VFORM NOT,
      PAST -, PSVE -, AGR N2[+NOM, -PLU, NFORM NORM, PER 3], PRT @x,
      PFORM @y] : -lemma-.

WORD _VVGK : ; adj (ing-form catenative) 'going'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SC_INF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE RAIS, GRADE -] : GOING.

WORD _VVNK : ; adj (past participle catenative) 'bound'

   A[-ADV, -NEG, -QUA, -NUM, SUBCAT SC_INF, CONJ NULL, PART -, AFORM NONE,
      DISTR PRD, SUBTYPE RAIS, GRADE -] : BOUND.

WORD _ZZ1 : ; letter sg 'B'

   N[-POSS, -ADV, -PLU, -PRO, +COUNT, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   -lemma-.

WORD _ZZ2 : ; letter pl 'Bs'

   N[-POSS, -ADV, +PLU, -PRO, +COUNT, -NUM, +PN, SUBCAT NULL, CONJ NULL,
      NFORM NORM, PER 3, PROTYPE NONE, PART -, ADDRESS -, DEMON -] :
   -lemma-.
;;; OPEN WORDS LEXICON /homes/eh101/big/lex-open
;;; generated by open-lex.cl from:
;;;   /usr/groups/nltools/dict/adj.le
;;;   /usr/groups/nltools/dict/adv.le
;;;   /usr/groups/nltools/dict/n.le
;;;   /usr/groups/nltools/dict/v.le

WORD abandon : 
   [COORD @D56, AGR [COUNT @D55, PER @D54, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ABANDON, 
   [COORD @D58, AGR [COUNT @D57, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ABANDON, 
   [COORD @D60, AGR [COUNT @D59, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ABANDON, 
   [COORD @D64, AGR [COUNT @D63, PER @D62, PLU @D61, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ABANDON, 
   [COORD @D70, PAST @D69, AGR [CASE @D68, COUNT @D67, PER @D66, 
            PLU @D65, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM TO, LAT -, ARITY 3] : ABANDON, 
   [COORD @D73, AGR [COUNT @D72, PER @D71, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABANDON, 
   [COORD @D75, 
      AGR [COUNT @D74, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, PLU -], 
      VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, SUBTYPE NONE, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABANDON, 
   [COORD @D77, AGR [COUNT @D76, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABANDON, 
   [COORD @D81, 
      AGR [COUNT @D80, PER @D79, PLU @D78, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABANDON, 
   [COORD @D87, PAST @D86, 
      AGR [CASE @D85, COUNT @D84, PER @D83, PLU @D82, BAR 2, V -, N +, 
            NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABANDON.

WORD abandoned : 
   [COADV @D99, COORD @D98, DEF @D97, PRD @D96, AGR [CASE @D95, 
            COUNT @D94, PER @D93, PLU @D92, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, N +, GRADE +, ADV -, 
      AFORM NONE, PART -, NEG -, SUBCAT NULL, DISTR ATT, QUA -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : ABANDONED, 
   [COORD @D104, AGR [CASE @D103, COUNT @D102, PER @D101, PLU @D100, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ABANDON, 
   [COORD @D109, AGR [CASE @D108, COUNT @D107, PER @D106, PLU @D105, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ABANDON, 
   [COORD @D114, AGR [CASE @D113, COUNT @D112, PER @D111, PLU @D110, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ABANDON, 
   [COORD @D119, AGR [CASE @D118, COUNT @D117, PER @D116, PLU @D115, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ABANDON, 
   
   [COORD @D124, AGR [CASE @D123, COUNT @D122, PER @D121, PLU @D120, BAR 
               2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ABANDON, 
   [COORD @D129, AGR [CASE @D128, COUNT @D127, PER @D126, PLU @D125, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ABANDON.

WORD abandoning : 
   [COORD @D141, PRD @D140, AGR [CASE @D139, COUNT @D138, PER @D137, 
            PLU @D136, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ABANDON, 
   [COORD @D147, PRD @D146, AGR [CASE @D145, COUNT @D144, PER @D143, 
            PLU @D142, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ABANDON.

WORD abandons : 
   [COORD @D153, AGR [COUNT @D152, NFORM NORM, PLU -, PER 3, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ABANDON, 
   [COORD @D155, 
      AGR [COUNT @D154, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ABANDON.

WORD abuse : 
   [COORD @D165, REFL @D164, COUNT @D163, PRD @D162, CASE @D161, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ABUSE, 
   [COORD @D168, 
      AGR [COUNT @D167, PER @D166, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABUSE, 
   [COORD @D170, 
      AGR [COUNT @D169, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABUSE, 
   [COORD @D172, 
      AGR [COUNT @D171, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABUSE, 
   [COORD @D176, 
      AGR [COUNT @D175, PER @D174, PLU @D173, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABUSE, 
   [COORD @D182, PAST @D181, 
      AGR [CASE @D180, COUNT @D179, PER @D178, PLU @D177, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ABUSE.

WORD abused : 
   [COORD @D194, AGR [CASE @D193, COUNT @D192, PER @D191, PLU @D190, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ABUSE, 
   [COORD @D199, 
      AGR [CASE @D198, COUNT @D197, PER @D196, PLU @D195, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ABUSE, 
   [COORD @D204, 
      AGR [CASE @D203, COUNT @D202, PER @D201, PLU @D200, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ABUSE.

WORD abuses : 
   [COORD @D216, DEMON @D215, REFL @D214, PRD @D213, CASE @D212, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ABUSE, 
   [COORD @D218, 
      AGR [COUNT @D217, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ABUSE.

WORD abusing : 
   [COORD @D229, PRD @D228, AGR [CASE @D227, COUNT @D226, PER @D225, 
            PLU @D224, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ABUSE.

WORD accept : 
   [COORD @D235, AGR [COUNT @D234, PER @D233, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D237, 
      AGR [COUNT @D236, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D239, 
      AGR [COUNT @D238, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D243, 
      AGR [COUNT @D242, PER @D241, PLU @D240, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D249, PAST @D248, 
      AGR [CASE @D247, COUNT @D246, PER @D245, PLU @D244, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D252, 
      AGR [COUNT @D251, PER @D250, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D254, 
      AGR [COUNT @D253, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D256, 
      AGR [COUNT @D255, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D260, 
      AGR [COUNT @D259, PER @D258, PLU @D257, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D266, PAST @D265, 
      AGR [CASE @D264, COUNT @D263, PER @D262, PLU @D261, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCEPT, 
   [COORD @D269, 
      AGR [COUNT @D268, PER @D267, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACCEPT, 
   [COORD @D271, 
      AGR [COUNT @D270, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACCEPT, 
   [COORD @D273, 
      AGR [COUNT @D272, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACCEPT, 
   [COORD @D277, 
      AGR [COUNT @D276, PER @D275, PLU @D274, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACCEPT, 
   [COORD @D283, PAST @D282, 
      AGR [CASE @D281, COUNT @D280, PER @D279, PLU @D278, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACCEPT.

WORD accepted : 
   [COORD @D292, AGR [CASE @D291, COUNT @D290, PER @D289, PLU @D288, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCEPT, 
   [COORD @D297, AGR [CASE @D296, COUNT @D295, PER @D294, PLU @D293, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACCEPT, 
   [COORD @D302, AGR [UB @D301, VFORM @D300, SUBJ @D299, FIN @D298, N -, 
            V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, SUBCAT SFIN, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D307, 
      AGR [CASE @D306, COUNT @D305, PER @D304, PLU @D303, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D312, 
      AGR [CASE @D311, COUNT @D310, PER @D309, PLU @D308, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D317, 
      AGR [CASE @D316, COUNT @D315, PER @D314, PLU @D313, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D322, 
      AGR [CASE @D321, COUNT @D320, PER @D319, PLU @D318, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D327, 
      AGR [CASE @D326, COUNT @D325, PER @D324, PLU @D323, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ACCEPT.

WORD accepting : 
   [COORD @D339, PRD @D338, AGR [CASE @D337, COUNT @D336, PER @D335, 
            PLU @D334, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCEPT, 
   [COORD @D345, PRD @D344, AGR [CASE @D343, COUNT @D342, PER @D341, 
            PLU @D340, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACCEPT, 
   [COORD @D351, PRD @D350, AGR [CASE @D349, COUNT @D348, PER @D347, 
            PLU @D346, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCEPT.

WORD accepts : 
   [COORD @D357, AGR [COUNT @D356, NFORM NORM, PLU -, PER 3, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D359, 
      AGR [COUNT @D358, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCEPT, 
   [COORD @D361, 
      AGR [COUNT @D360, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCEPT.

WORD access : 
   [COORD @D369, REFL @D368, COUNT @D367, PRD @D366, CASE @D365, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ACCESS.

WORD accesses : 
   [COORD @D378, DEMON @D377, REFL @D376, PRD @D375, CASE @D374, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ACCESS.

WORD account : 
   [COORD @D386, REFL @D385, COUNT @D384, PRD @D383, CASE @D382, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ACCOUNT, 
   [COORD @D389, 
      AGR [COUNT @D388, PER @D387, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, 
      ARITY 3] : ACCOUNT, 
   [COORD @D391, AGR [COUNT @D390, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_TO, ARITY 3] : ACCOUNT, 
   [COORD @D393, AGR [COUNT @D392, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_TO, ARITY 3] : ACCOUNT, 
   [COORD @D397, AGR [COUNT @D396, PER @D395, PLU @D394, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_TO, ARITY 3] : ACCOUNT, 
   [COORD @D403, PAST @D402, 
      AGR [CASE @D401, COUNT @D400, PER @D399, PLU @D398, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, 
      ARITY 3] : ACCOUNT, 
   [COORD @D406, AGR [COUNT @D405, PER @D404, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D408, AGR [COUNT @D407, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D410, AGR [COUNT @D409, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D414, AGR [COUNT @D413, PER @D412, PLU @D411, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_NP, ARITY 2] : ACCOUNT, 
   [COORD @D420, PAST @D419, AGR [CASE @D418, COUNT @D417, PER @D416, 
            PLU @D415, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_NP, ARITY 2] : ACCOUNT, 
   [COORD @D423, AGR [COUNT @D422, PER @D421, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D425, AGR [COUNT @D424, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D427, AGR [COUNT @D426, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, 
      ARITY 2] : ACCOUNT, 
   [COORD @D431, AGR [COUNT @D430, PER @D429, PLU @D428, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, ARITY 2] : ACCOUNT, 
   [COORD @D437, PAST @D436, AGR [CASE @D435, COUNT @D434, PER @D433, 
            PLU @D432, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, ARITY 2] : ACCOUNT, 
   [COORD @D440, AGR [COUNT @D439, PER @D438, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, PREP FOR, 
      ARITY 2] : ACCOUNT, 
   [COORD @D442, AGR [COUNT @D441, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, PREP FOR, 
      ARITY 2] : ACCOUNT, 
   [COORD @D444, AGR [COUNT @D443, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, PREP FOR, 
      ARITY 2] : ACCOUNT, 
   [COORD @D448, AGR [COUNT @D447, PER @D446, PLU @D445, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, 
      PREP FOR, ARITY 2] : ACCOUNT, 
   [COORD @D454, PAST @D453, AGR [CASE @D452, COUNT @D451, PER @D450, 
            PLU @D449, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT WHS, PREP FOR, ARITY 2] : ACCOUNT, 
   [COORD @D457, AGR [COUNT @D456, PER @D455, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ACCOUNT, 
   [COORD @D459, AGR [COUNT @D458, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ACCOUNT, 
   [COORD @D461, AGR [COUNT @D460, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ACCOUNT, 
   [COORD @D465, AGR [COUNT @D464, PER @D463, PLU @D462, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ACCOUNT, 
   [COORD @D471, PAST @D470, AGR [CASE @D469, COUNT @D468, PER @D467, 
            PLU @D466, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, ARITY 2] : ACCOUNT, 
   [COORD @D474, AGR [COUNT @D473, PER @D472, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, ARITY 2] : ACCOUNT, 
   [COORD @D476, 
      AGR [COUNT @D475, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, 
      PFORM FOR, ORDER PRENP, ARITY 2] : ACCOUNT, 
   [COORD @D478, AGR [COUNT @D477, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, ARITY 2] : ACCOUNT, 
   [COORD @D482, 
      AGR [COUNT @D481, PER @D480, PLU @D479, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, 
      PFORM FOR, ORDER PRENP, ARITY 2] : ACCOUNT, 
   [COORD @D488, PAST @D487, 
      AGR [CASE @D486, COUNT @D485, PER @D484, PLU @D483, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, 
      ORDER PRENP, ARITY 2] : ACCOUNT.

WORD accounted : 
   [COORD @D498, AGR [CASE @D497, COUNT @D496, PER @D495, PLU @D494, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D503, AGR [CASE @D502, COUNT @D501, PER @D500, PLU @D499, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D508, AGR [CASE @D507, COUNT @D506, PER @D505, PLU @D504, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_NP, CONJ NULL, SUBTYPE RAIS, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D513, AGR [CASE @D512, COUNT @D511, PER @D510, PLU @D509, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACCOUNT, 
   [COORD @D518, AGR [CASE @D517, COUNT @D516, PER @D515, PLU @D514, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D523, AGR [CASE @D522, COUNT @D521, PER @D520, PLU @D519, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACCOUNT, 
   [COORD @D528, AGR [CASE @D527, COUNT @D526, PER @D525, PLU @D524, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D534, AGR [CASE @D533, NFORM @D532, COUNT @D531, PER @D530, 
            PLU @D529, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D539, AGR [UB @D538, VFORM @D537, SUBJ @D536, FIN @D535, N -, 
            V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT OC_AP, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D544, 
      AGR [CASE @D543, COUNT @D542, PER @D541, PLU @D540, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACCOUNT, 
   [COORD @D549, AGR [CASE @D548, COUNT @D547, PER @D546, PLU @D545, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D554, AGR [CASE @D553, COUNT @D552, PER @D551, PLU @D550, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D559, AGR [CASE @D558, COUNT @D557, PER @D556, PLU @D555, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D564, AGR [CASE @D563, COUNT @D562, PER @D561, PLU @D560, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D569, AGR [CASE @D568, COUNT @D567, PER @D566, PLU @D565, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_ING, CONJ NULL, SUBTYPE PVERB_OR, PFORM FOR, ORDER PRENP, 
      AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D574, AGR [CASE @D573, COUNT @D572, PER @D571, PLU @D570, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D579, AGR [CASE @D578, COUNT @D577, PER @D576, PLU @D575, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, 
      INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, 
      AT +, LAT +, PAST +, BAR 0, V +, N -] : ACCOUNT.

WORD accounting : 
   [COORD @D594, PRD @D593, AGR [CASE @D592, COUNT @D591, PER @D590, 
            PLU @D589, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D600, PRD @D599, AGR [CASE @D598, COUNT @D597, PER @D596, 
            PLU @D595, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D606, PRD @D605, AGR [CASE @D604, COUNT @D603, PER @D602, 
            PLU @D601, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACCOUNT, 
   [COORD @D612, PRD @D611, AGR [CASE @D610, COUNT @D609, PER @D608, 
            PLU @D607, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D618, PRD @D617, AGR [CASE @D616, COUNT @D615, PER @D614, 
            PLU @D613, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D624, PRD @D623, AGR [CASE @D622, COUNT @D621, PER @D620, 
            PLU @D619, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCOUNT.

WORD accounts : 
   [COORD @D634, DEMON @D633, REFL @D632, PRD @D631, CASE @D630, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ACCOUNT, 
   [COORD @D636, 
      AGR [COUNT @D635, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ACCOUNT, 
   [COORD @D638, AGR [COUNT @D637, NFORM NORM, PLU -, PER 3, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D640, 
      AGR [COUNT @D639, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D642, 
      AGR [COUNT @D641, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D644, 
      AGR [COUNT @D643, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCOUNT, 
   [COORD @D646, 
      AGR [COUNT @D645, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : ACCOUNT.

WORD accuse : 
   [COORD @D653, AGR [COUNT @D652, PER @D651, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM OF, LAT -, 
      ARITY 3] : ACCUSE, 
   [COORD @D655, AGR [COUNT @D654, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM OF, LAT -, 
      ARITY 3] : ACCUSE, 
   [COORD @D657, AGR [COUNT @D656, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM OF, LAT -, 
      ARITY 3] : ACCUSE, 
   [COORD @D661, AGR [COUNT @D660, PER @D659, PLU @D658, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM OF, 
      LAT -, ARITY 3] : ACCUSE, 
   [COORD @D667, PAST @D666, AGR [CASE @D665, COUNT @D664, PER @D663, 
            PLU @D662, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM OF, LAT -, ARITY 3] : ACCUSE, 
   [COORD @D670, AGR [COUNT @D669, PER @D668, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCUSE, 
   [COORD @D672, 
      AGR [COUNT @D671, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCUSE, 
   [COORD @D674, 
      AGR [COUNT @D673, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCUSE, 
   [COORD @D678, 
      AGR [COUNT @D677, PER @D676, PLU @D675, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCUSE, 
   [COORD @D684, PAST @D683, 
      AGR [CASE @D682, COUNT @D681, PER @D680, PLU @D679, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACCUSE.

WORD accused : 
   [COADV @D697, COORD @D696, DEF @D695, PRD @D694, AGR [CASE @D693, 
            COUNT @D692, PER @D691, PLU @D690, BAR 2, V -, N +, 
            NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, N +, 
      COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, SUBCAT NULL, 
      DISTR ATT, QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : 
   ACCUSED, 
   [COORD @D702, AGR [CASE @D701, COUNT @D700, PER @D699, PLU @D698, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM OF, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCUSE, 
   [COORD @D707, AGR [CASE @D706, COUNT @D705, PER @D704, PLU @D703, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACCUSE, 
   [COORD @D712, AGR [CASE @D711, COUNT @D710, PER @D709, PLU @D708, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACCUSE, 
   [COORD @D717, AGR [CASE @D716, COUNT @D715, PER @D714, PLU @D713, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCUSE, 
   [COORD @D722, 
      AGR [CASE @D721, COUNT @D720, PER @D719, PLU @D718, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACCUSE, 
   [COORD @D727, 
      AGR [CASE @D726, COUNT @D725, PER @D724, PLU @D723, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ACCUSE.

WORD accuses : 
   [COORD @D734, AGR [COUNT @D733, NFORM NORM, PLU -, PER 3, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCUSE, 
   [COORD @D736, 
      AGR [COUNT @D735, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACCUSE.

WORD accusing : 
   [COORD @D746, PRD @D745, AGR [CASE @D744, COUNT @D743, PER @D742, 
            PLU @D741, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACCUSE, 
   [COORD @D752, PRD @D751, AGR [CASE @D750, COUNT @D749, PER @D748, 
            PLU @D747, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACCUSE.

WORD achieve : 
   [COORD @D759, AGR [COUNT @D758, PER @D757, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACHIEVE, 
   [COORD @D761, 
      AGR [COUNT @D760, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACHIEVE, 
   [COORD @D763, 
      AGR [COUNT @D762, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACHIEVE, 
   [COORD @D767, 
      AGR [COUNT @D766, PER @D765, PLU @D764, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACHIEVE, 
   [COORD @D773, PAST @D772, 
      AGR [CASE @D771, COUNT @D770, PER @D769, PLU @D768, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACHIEVE.

WORD achieved : 
   [COORD @D783, AGR [CASE @D782, COUNT @D781, PER @D780, PLU @D779, 
            NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACHIEVE, 
   
   [COORD @D788, AGR [CASE @D787, COUNT @D786, PER @D785, PLU @D784, BAR 
               2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACHIEVE, 
   [COORD @D793, AGR [CASE @D792, COUNT @D791, PER @D790, PLU @D789, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ACHIEVE.

WORD achieves : 
   [COORD @D800, AGR [COUNT @D799, NFORM NORM, PLU -, PER 3, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACHIEVE.

WORD achieving : 
   [COORD @D810, PRD @D809, AGR [CASE @D808, COUNT @D807, PER @D806, 
            PLU @D805, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACHIEVE.

WORD act : 
   [COORD @D817, REFL @D816, PRD @D815, CASE @D814, FIX NOT, BAR 0, 
      SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, COUNT +] : ACT, 
   [COORD @D820, AGR [COUNT @D819, PER @D818, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ACT, 
   [COORD @D822, AGR [COUNT @D821, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ACT, 
   [COORD @D824, AGR [COUNT @D823, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ACT, 
   [COORD @D828, AGR [COUNT @D827, PER @D826, PLU @D825, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PRT UP, PFORM TO, ARITY 2] : ACT, 
   [COORD @D834, PAST @D833, AGR [CASE @D832, COUNT @D831, PER @D830, 
            PLU @D829, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, PRT UP, PFORM TO, ARITY 2] : ACT, 
   [COORD @D837, AGR [COUNT @D836, PER @D835, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AS, 
      ARITY 2] : ACT, 
   [COORD @D839, AGR [COUNT @D838, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AS, 
      ARITY 2] : ACT, 
   [COORD @D841, AGR [COUNT @D840, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AS, 
      ARITY 2] : ACT, 
   [COORD @D845, AGR [COUNT @D844, PER @D843, PLU @D842, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM AS, ARITY 2] : ACT, 
   [COORD @D851, PAST @D850, AGR [CASE @D849, COUNT @D848, PER @D847, 
            PLU @D846, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT PP, PFORM AS, ARITY 2] : ACT, 
   [COORD @D854, AGR [COUNT @D853, PER @D852, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OUT, 
      ARITY 2] : ACT, 
   [COORD @D856, AGR [COUNT @D855, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OUT, 
      ARITY 2] : ACT, 
   [COORD @D858, AGR [COUNT @D857, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OUT, 
      ARITY 2] : ACT, 
   [COORD @D862, AGR [COUNT @D861, PER @D860, PLU @D859, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT OUT, ARITY 2] : ACT, 
   [COORD @D868, PAST @D867, AGR [CASE @D866, COUNT @D865, PER @D864, 
            PLU @D863, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OUT, ARITY 2] : ACT, 
   [COORD @D871, AGR [COUNT @D870, PER @D869, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D873, AGR [COUNT @D872, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D875, AGR [COUNT @D874, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D879, AGR [COUNT @D878, PER @D877, PLU @D876, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, 
      ARITY 2] : ACT, 
   [COORD @D885, PAST @D884, AGR [CASE @D883, COUNT @D882, PER @D881, 
            PLU @D880, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, N -, 
      INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, 
      LAT -, ARITY 2] : ACT, 
   [COORD @D888, AGR [COUNT @D887, PER @D886, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACT, 
   [COORD @D890, 
      AGR [COUNT @D889, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACT, 
   [COORD @D892, 
      AGR [COUNT @D891, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACT, 
   [COORD @D896, 
      AGR [COUNT @D895, PER @D894, PLU @D893, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACT, 
   [COORD @D902, PAST @D901, 
      AGR [CASE @D900, COUNT @D899, PER @D898, PLU @D897, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ACT, 
   [COORD @D905, 
      AGR [COUNT @D904, PER @D903, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADVP, LAT -, ARITY 2] : ACT, 
   [COORD @D907, 
      AGR [COUNT @D906, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADVP, LAT -, ARITY 2] : ACT, 
   [COORD @D909, 
      AGR [COUNT @D908, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADVP, LAT -, ARITY 2] : ACT, 
   [COORD @D913, 
      AGR [COUNT @D912, PER @D911, PLU @D910, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADVP, LAT -, ARITY 2] : ACT, 
   [COORD @D919, PAST @D918, 
      AGR [CASE @D917, COUNT @D916, PER @D915, PLU @D914, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT ADVP, LAT -, ARITY 2] : ACT, 
   [COORD @D922, 
      AGR [COUNT @D921, PER @D920, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, LAT -, 
      ARITY 2] : ACT, 
   [COORD @D924, AGR [COUNT @D923, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, LAT -, 
      ARITY 2] : ACT, 
   [COORD @D926, AGR [COUNT @D925, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, LAT -, 
      ARITY 2] : ACT, 
   [COORD @D930, AGR [COUNT @D929, PER @D928, PLU @D927, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, 
      LAT -, ARITY 2] : ACT, 
   [COORD @D936, PAST @D935, AGR [CASE @D934, COUNT @D933, PER @D932, 
            PLU @D931, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      PFORM UPON, LAT -, ARITY 2] : ACT, 
   [COORD @D939, AGR [COUNT @D938, PER @D937, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D941, AGR [COUNT @D940, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D943, AGR [COUNT @D942, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D947, AGR [COUNT @D946, PER @D945, PLU @D944, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, 
      LAT -, ARITY 2] : ACT, 
   [COORD @D953, PAST @D952, AGR [CASE @D951, COUNT @D950, PER @D949, 
            PLU @D948, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      PFORM ON, LAT -, ARITY 2] : ACT, 
   [COORD @D956, AGR [COUNT @D955, PER @D954, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D958, AGR [COUNT @D957, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D960, AGR [COUNT @D959, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ACT, 
   [COORD @D964, AGR [COUNT @D963, PER @D962, PLU @D961, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : ACT, 
   [COORD @D970, PAST @D969, AGR [CASE @D968, COUNT @D967, PER @D966, 
            PLU @D965, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      PFORM FOR, LAT -, ARITY 2] : ACT, 
   [COORD @D973, AGR [COUNT @D972, PER @D971, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : ACT, 
   [COORD @D975, AGR [COUNT @D974, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : ACT, 
   [COORD @D977, AGR [COUNT @D976, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : ACT, 
   [COORD @D981, AGR [COUNT @D980, PER @D979, PLU @D978, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : ACT, 
   [COORD @D987, PAST @D986, AGR [CASE @D985, COUNT @D984, PER @D983, 
            PLU @D982, BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : ACT, 
   [COORD @D990, AGR [COUNT @D989, PER @D988, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : ACT, 
   [COORD @D992, AGR [COUNT @D991, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : ACT, 
   [COORD @D994, AGR [COUNT @D993, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : ACT, 
   [COORD @D998, AGR [COUNT @D997, PER @D996, PLU @D995, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : ACT, 
   [COORD @D1004, PAST @D1003, AGR 
         [CASE @D1002, COUNT @D1001, PER @D1000, PLU @D999, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, ARITY 1] : 
   ACT, 
   [COORD @D1007, AGR [COUNT @D1006, PER @D1005, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ACT, 
   [COORD @D1009, AGR [COUNT @D1008, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACT, 
   [COORD @D1011, 
      AGR [COUNT @D1010, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ACT, 
   [COORD @D1015, 
      AGR [COUNT @D1014, PER @D1013, PLU @D1012, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ACT, 
   [COORD @D1021, PAST @D1020, AGR [CASE @D1019, COUNT @D1018, 
            PER @D1017, PLU @D1016, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ACT.

WORD acted : 
   [COORD @D1031, AGR [CASE @D1030, COUNT @D1029, PER @D1028, PLU 
               @D1027, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1036, AGR [CASE @D1035, COUNT @D1034, PER @D1033, 
            PLU @D1032, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1041, AGR [CASE @D1040, COUNT @D1039, PER @D1038, 
            PLU @D1037, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PRT UP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1046, AGR [CASE @D1045, COUNT @D1044, PER @D1043, 
            PLU @D1042, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AS, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1051, AGR [CASE @D1050, COUNT @D1049, PER @D1048, 
            PLU @D1047, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AS, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1056, AGR [CASE @D1055, COUNT @D1054, PER @D1053, 
            PLU @D1052, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1061, AGR [CASE @D1060, COUNT @D1059, PER @D1058, 
            PLU @D1057, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1066, AGR [CASE @D1065, COUNT @D1064, PER @D1063, 
            PLU @D1062, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1071, AGR [CASE @D1070, COUNT @D1069, PER @D1068, 
            PLU @D1067, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1076, AGR [CASE @D1075, COUNT @D1074, PER @D1073, 
            PLU @D1072, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1081, AGR [CASE @D1080, COUNT @D1079, PER @D1078, 
            PLU @D1077, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACT, 
   [COORD @D1086, AGR [CASE @D1085, COUNT @D1084, PER @D1083, 
            PLU @D1082, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ACT, 
   [COORD @D1091, AGR [CASE @D1090, COUNT @D1089, PER @D1088, 
            PLU @D1087, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ACT, 
   [COORD @D1096, AGR [CASE @D1095, COUNT @D1094, PER @D1093, 
            PLU @D1092, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT ADVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1101, AGR [CASE @D1100, COUNT @D1099, PER @D1098, 
            PLU @D1097, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT ADVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1106, AGR [CASE @D1105, COUNT @D1104, PER @D1103, 
            PLU @D1102, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1111, AGR [CASE @D1110, COUNT @D1109, PER @D1108, 
            PLU @D1107, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1116, AGR [CASE @D1115, COUNT @D1114, PER @D1113, 
            PLU @D1112, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1121, AGR [CASE @D1120, COUNT @D1119, PER @D1118, 
            PLU @D1117, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1126, AGR [CASE @D1125, COUNT @D1124, PER @D1123, 
            PLU @D1122, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1131, AGR [CASE @D1130, COUNT @D1129, PER @D1128, 
            PLU @D1127, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1136, AGR [CASE @D1135, COUNT @D1134, PER @D1133, 
            PLU @D1132, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1141, AGR [CASE @D1140, COUNT @D1139, PER @D1138, 
            PLU @D1137, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1146, AGR [CASE @D1145, COUNT @D1144, PER @D1143, 
            PLU @D1142, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1151, AGR [CASE @D1150, COUNT @D1149, PER @D1148, 
            PLU @D1147, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ACT, 
   [COORD @D1156, AGR [CASE @D1155, COUNT @D1154, PER @D1153, 
            PLU @D1152, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1161, AGR [CASE @D1160, COUNT @D1159, PER @D1158, 
            PLU @D1157, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ACT.

WORD acting : 
   [COADV @D1178, COORD @D1177, DEF @D1176, PRD @D1175, AGR [CASE 
               @D1174, COUNT @D1173, PER @D1172, PLU @D1171, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, BAR 0, SUBCAT NULL, 
      INFL +, N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, 
      QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT, DISTR ATT] : 
   ACTING, 
   [COORD @D1182, REFL @D1181, PRD @D1180, CASE @D1179, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, COUNT -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : ACTING, 
   [COORD @D1188, PRD @D1187, 
      AGR [CASE @D1186, COUNT @D1185, PER @D1184, PLU @D1183, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1194, PRD @D1193, AGR [CASE @D1192, COUNT @D1191, 
            PER @D1190, PLU @D1189, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AS, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1200, PRD @D1199, 
      AGR [CASE @D1198, COUNT @D1197, PER @D1196, PLU @D1195, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   
   [COORD @D1206, PRD @D1205, AGR [CASE @D1204, COUNT @D1203, PER @D1202, 
            PLU @D1201, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACT, 
   [COORD @D1212, PRD @D1211, AGR [CASE @D1210, COUNT @D1209, 
            PER @D1208, PLU @D1207, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1218, PRD @D1217, AGR [CASE @D1216, COUNT @D1215, 
            PER @D1214, PLU @D1213, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT ADVP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1224, PRD @D1223, AGR [CASE @D1222, COUNT @D1221, 
            PER @D1220, PLU @D1219, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM UPON, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1230, PRD @D1229, 
      AGR [CASE @D1228, COUNT @D1227, PER @D1226, PLU @D1225, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   
   [COORD @D1236, PRD @D1235, AGR [CASE @D1234, COUNT @D1233, PER @D1232, 
            PLU @D1231, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ACT, 
   [COORD @D1242, PRD @D1241, AGR [CASE @D1240, COUNT @D1239, 
            PER @D1238, PLU @D1237, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   [COORD @D1248, PRD @D1247, 
      AGR [CASE @D1246, COUNT @D1245, PER @D1244, PLU @D1243, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ACT, 
   
   [COORD @D1254, PRD @D1253, AGR [CASE @D1252, COUNT @D1251, PER @D1250, 
            PLU @D1249, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ACT.

WORD acts : 
   [COORD @D1277, DEMON @D1276, REFL @D1275, PRD @D1274, CASE @D1273, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ACT, 
   [COORD @D1279, 
      AGR [COUNT @D1278, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ACT, 
   [COORD @D1281, AGR [COUNT @D1280, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM AS, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1283, 
      AGR [COUNT @D1282, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1285, 
      AGR [COUNT @D1284, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1287, 
      AGR [COUNT @D1286, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1289, 
      AGR [COUNT @D1288, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT ADVP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1291, 
      AGR [COUNT @D1290, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1293, 
      AGR [COUNT @D1292, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1295, 
      AGR [COUNT @D1294, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1297, 
      AGR [COUNT @D1296, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1299, 
      AGR [COUNT @D1298, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT, 
   [COORD @D1301, 
      AGR [COUNT @D1300, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ACT.

WORD add : 
   [COORD @D1307, AGR [COUNT @D1306, PER @D1305, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADD, 
   [COORD @D1309, AGR [COUNT @D1308, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADD, 
   [COORD @D1311, AGR [COUNT @D1310, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADD, 
   [COORD @D1315, AGR [COUNT @D1314, PER @D1313, PLU @D1312, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADD, 
   [COORD @D1321, PAST @D1320, AGR [CASE @D1319, COUNT @D1318, 
            PER @D1317, PLU @D1316, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ADD, 
   [COORD @D1324, AGR [COUNT @D1323, PER @D1322, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1326, AGR [COUNT @D1325, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1328, AGR [COUNT @D1327, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1332, AGR [COUNT @D1331, PER @D1330, PLU @D1329, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1338, PAST @D1337, AGR [CASE @D1336, COUNT @D1335, 
            PER @D1334, PLU @D1333, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, ARITY 2] : ADD, 
   [COORD @D1341, AGR 
         [COUNT @D1340, PER @D1339, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1343, AGR [COUNT @D1342, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1345, AGR [COUNT @D1344, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM TO, ARITY 2] : ADD, 
   [COORD @D1349, AGR [COUNT @D1348, PER @D1347, PLU @D1346, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT UP, PFORM TO, ARITY 2] : ADD, 
   [COORD @D1355, PAST @D1354, AGR [CASE @D1353, COUNT @D1352, 
            PER @D1351, PLU @D1350, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PRT UP, PFORM TO, ARITY 2] : ADD, 
   [COORD @D1358, 
      AGR [COUNT @D1357, PER @D1356, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   ADD, 
   [COORD @D1360, AGR [COUNT @D1359, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   ADD, 
   [COORD @D1362, AGR [COUNT @D1361, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   ADD, 
   [COORD @D1366, AGR [COUNT @D1365, PER @D1364, PLU @D1363, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : ADD, 
   [COORD @D1372, PAST @D1371, AGR [CASE @D1370, COUNT @D1369, 
            PER @D1368, PLU @D1367, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT UP, ARITY 2] : ADD, 
   [COORD @D1375, AGR [COUNT @D1374, PER @D1373, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1377, AGR [COUNT @D1376, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ADD, 
   [COORD @D1379, 
      AGR [COUNT @D1378, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ADD, 
   [COORD @D1383, 
      AGR [COUNT @D1382, PER @D1381, PLU @D1380, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1389, PAST @D1388, AGR [CASE @D1387, COUNT @D1386, 
            PER @D1385, PLU @D1384, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ADD, 
   [COORD @D1392, AGR [COUNT @D1391, PER @D1390, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1394, AGR [COUNT @D1393, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADD, 
   [COORD @D1396, 
      AGR [COUNT @D1395, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADD, 
   [COORD @D1400, 
      AGR [COUNT @D1399, PER @D1398, PLU @D1397, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1406, PAST @D1405, AGR [CASE @D1404, COUNT @D1403, 
            PER @D1402, PLU @D1401, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ADD, 
   [COORD @D1409, AGR [COUNT @D1408, PER @D1407, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT UP, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1411, AGR [COUNT @D1410, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT UP, LAT -, ARITY 2] : ADD, 
   [COORD @D1413, 
      AGR [COUNT @D1412, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT UP, LAT -, ARITY 2] : ADD, 
   [COORD @D1417, 
      AGR [COUNT @D1416, PER @D1415, PLU @D1414, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT UP, LAT -, 
      ARITY 2] : ADD, 
   [COORD @D1423, PAST @D1422, AGR [CASE @D1421, COUNT @D1420, 
            PER @D1419, PLU @D1418, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      PRT UP, LAT -, ARITY 2] : ADD, 
   [COORD @D1426, AGR [COUNT @D1425, PER @D1424, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT TOGETHER, 
      LAT -, ARITY 2] : ADD, 
   [COORD @D1428, AGR [COUNT @D1427, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT TOGETHER, LAT -, ARITY 2] : 
   ADD, 
   [COORD @D1430, AGR [COUNT @D1429, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT TOGETHER, LAT -, ARITY 2] : 
   ADD, 
   [COORD @D1434, AGR [COUNT @D1433, PER @D1432, PLU @D1431, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT TOGETHER, 
      LAT -, ARITY 2] : ADD, 
   [COORD @D1440, PAST @D1439, AGR [CASE @D1438, COUNT @D1437, 
            PER @D1436, PLU @D1435, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      PRT TOGETHER, LAT -, ARITY 2] : ADD, 
   [COORD @D1443, AGR [COUNT @D1442, PER @D1441, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : ADD, 
   [COORD @D1445, AGR [COUNT @D1444, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : ADD, 
   [COORD @D1447, AGR [COUNT @D1446, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : ADD, 
   [COORD @D1451, AGR [COUNT @D1450, PER @D1449, PLU @D1448, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : ADD, 
   [COORD @D1457, PAST @D1456, AGR [CASE @D1455, COUNT @D1454, 
            PER @D1453, PLU @D1452, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, PRT UP, ARITY 1] : ADD, 
   [COORD @D1460, AGR [COUNT @D1459, PER @D1458, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      LAT -, ARITY 1] : ADD, 
   [COORD @D1462, AGR [COUNT @D1461, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT UP, LAT -, ARITY 1] : 
   ADD, 
   [COORD @D1464, AGR [COUNT @D1463, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT UP, LAT -, ARITY 1] : 
   ADD, 
   [COORD @D1468, AGR [COUNT @D1467, PER @D1466, PLU @D1465, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      LAT -, ARITY 1] : ADD, 
   [COORD @D1474, PAST @D1473, AGR [CASE @D1472, COUNT @D1471, 
            PER @D1470, PLU @D1469, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, LAT -, ARITY 1] : ADD, 
   [COORD @D1477, AGR [COUNT @D1476, PER @D1475, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      PRT TOGETHER, LAT -, ARITY 1] : ADD, 
   [COORD @D1479, AGR [COUNT @D1478, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT TOGETHER, LAT -, 
      ARITY 1] : ADD, 
   [COORD @D1481, AGR [COUNT @D1480, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT TOGETHER, LAT -, 
      ARITY 1] : ADD, 
   [COORD @D1485, AGR [COUNT @D1484, PER @D1483, PLU @D1482, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      PRT TOGETHER, LAT -, ARITY 1] : ADD, 
   [COORD @D1491, PAST @D1490, AGR [CASE @D1489, COUNT @D1488, 
            PER @D1487, PLU @D1486, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, PRT TOGETHER, LAT -, ARITY 1] : ADD.

WORD added : 
   [COORD @D1500, AGR [CASE @D1499, COUNT @D1498, PER @D1497, PLU 
               @D1496, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1505, AGR [CASE @D1504, COUNT @D1503, PER @D1502, 
            PLU @D1501, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1510, AGR [CASE @D1509, COUNT @D1508, PER @D1507, 
            PLU @D1506, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1515, AGR [CASE @D1514, COUNT @D1513, PER @D1512, 
            PLU @D1511, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1520, AGR [CASE @D1519, COUNT @D1518, PER @D1517, 
            PLU @D1516, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1525, AGR [CASE @D1524, COUNT @D1523, PER @D1522, 
            PLU @D1521, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1530, AGR [CASE @D1529, COUNT @D1528, PER @D1527, 
            PLU @D1526, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1535, AGR [CASE @D1534, COUNT @D1533, PER @D1532, 
            PLU @D1531, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1540, AGR [CASE @D1539, COUNT @D1538, PER @D1537, 
            PLU @D1536, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1545, AGR [CASE @D1544, COUNT @D1543, PER @D1542, 
            PLU @D1541, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1550, AGR [CASE @D1549, COUNT @D1548, PER @D1547, 
            PLU @D1546, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1555, AGR [CASE @D1554, COUNT @D1553, PER @D1552, 
            PLU @D1551, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1560, AGR [CASE @D1559, COUNT @D1558, PER @D1557, 
            PLU @D1556, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1565, AGR [UB @D1564, VFORM @D1563, SUBJ @D1562, FIN @D1561, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1570, 
      AGR [CASE @D1569, COUNT @D1568, PER @D1567, PLU @D1566, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1575, 
      AGR [CASE @D1574, COUNT @D1573, PER @D1572, PLU @D1571, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1580, 
      AGR [CASE @D1579, COUNT @D1578, PER @D1577, PLU @D1576, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1585, 
      AGR [CASE @D1584, COUNT @D1583, PER @D1582, PLU @D1581, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1590, 
      AGR [CASE @D1589, COUNT @D1588, PER @D1587, PLU @D1586, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1595, 
      AGR [CASE @D1594, COUNT @D1593, PER @D1592, PLU @D1591, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : 
   ADD, 
   [COORD @D1600, AGR [CASE @D1599, COUNT @D1598, PER @D1597, PLU 
               @D1596, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT TOGETHER, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1605, AGR [CASE @D1604, COUNT @D1603, PER @D1602, 
            PLU @D1601, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT TOGETHER, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1610, AGR [CASE @D1609, COUNT @D1608, PER @D1607, 
            PLU @D1606, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT TOGETHER, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1615, AGR [CASE @D1614, COUNT @D1613, PER @D1612, 
            PLU @D1611, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1620, AGR [CASE @D1619, COUNT @D1618, PER @D1617, 
            PLU @D1616, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1625, AGR [CASE @D1624, COUNT @D1623, PER @D1622, 
            PLU @D1621, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1630, AGR [CASE @D1629, COUNT @D1628, PER @D1627, 
            PLU @D1626, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADD, 
   [COORD @D1635, AGR [CASE @D1634, COUNT @D1633, PER @D1632, 
            PLU @D1631, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT TOGETHER, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1640, AGR [CASE @D1639, COUNT @D1638, PER @D1637, 
            PLU @D1636, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT TOGETHER, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ADD.

WORD adding : 
   [COORD @D1652, PRD @D1651, AGR [CASE @D1650, COUNT @D1649, PER 
               @D1648, PLU @D1647, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1658, PRD @D1657, 
      AGR [CASE @D1656, COUNT @D1655, PER @D1654, PLU @D1653, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADD, 
   [COORD @D1664, PRD @D1663, AGR [CASE @D1662, COUNT @D1661, 
            PER @D1660, PLU @D1659, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT UP, 
      PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1670, PRD @D1669, 
      AGR [CASE @D1668, COUNT @D1667, PER @D1666, PLU @D1665, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   
   [COORD @D1676, PRD @D1675, AGR [CASE @D1674, COUNT @D1673, PER @D1672, 
            PLU @D1671, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADD, 
   [COORD @D1682, PRD @D1681, AGR [CASE @D1680, COUNT @D1679, 
            PER @D1678, PLU @D1677, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1688, PRD @D1687, AGR [CASE @D1686, COUNT @D1685, 
            PER @D1684, PLU @D1683, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1694, PRD @D1693, 
      AGR [CASE @D1692, COUNT @D1691, PER @D1690, PLU @D1689, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT TOGETHER, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   
   [COORD @D1700, PRD @D1699, AGR [CASE @D1698, COUNT @D1697, PER @D1696, 
            PLU @D1695, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADD, 
   [COORD @D1706, PRD @D1705, AGR [CASE @D1704, COUNT @D1703, 
            PER @D1702, PLU @D1701, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD, 
   [COORD @D1712, PRD @D1711, 
      AGR [CASE @D1710, COUNT @D1709, PER @D1708, PLU @D1707, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT TOGETHER, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADD.

WORD adds : 
   [COORD @D1718, AGR [COUNT @D1717, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1720, 
      AGR [COUNT @D1719, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1722, 
      AGR [COUNT @D1721, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT UP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ADD, 
   [COORD @D1724, AGR [COUNT @D1723, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1726, 
      AGR [COUNT @D1725, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1728, 
      AGR [COUNT @D1727, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1730, 
      AGR [COUNT @D1729, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1732, 
      AGR [COUNT @D1731, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT TOGETHER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1734, 
      AGR [COUNT @D1733, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1736, 
      AGR [COUNT @D1735, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADD, 
   [COORD @D1738, 
      AGR [COUNT @D1737, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT TOGETHER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ADD.

WORD admit : 
   [COORD @D1744, AGR [COUNT @D1743, PER @D1742, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADMIT, 
   [COORD @D1746, AGR [COUNT @D1745, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1748, AGR [COUNT @D1747, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1752, AGR [COUNT @D1751, PER @D1750, PLU @D1749, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADMIT, 
   [COORD @D1758, PAST @D1757, AGR [CASE @D1756, COUNT @D1755, 
            PER @D1754, PLU @D1753, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ADMIT, 
   [COORD @D1761, AGR [COUNT @D1760, PER @D1759, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM INTO, LAT -, ARITY 3] : ADMIT, 
   [COORD @D1763, AGR [COUNT @D1762, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM INTO, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1765, AGR [COUNT @D1764, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM INTO, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1769, AGR [COUNT @D1768, PER @D1767, PLU @D1766, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM INTO, LAT -, ARITY 3] : ADMIT, 
   [COORD @D1775, PAST @D1774, AGR [CASE @D1773, COUNT @D1772, 
            PER @D1771, PLU @D1770, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM INTO, LAT -, ARITY 3] : ADMIT, 
   [COORD @D1778, AGR [COUNT @D1777, PER @D1776, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, 
      LAT -, ARITY 3] : ADMIT, 
   [COORD @D1780, AGR [COUNT @D1779, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1782, AGR [COUNT @D1781, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, LAT -, 
      ARITY 3] : ADMIT, 
   [COORD @D1786, AGR [COUNT @D1785, PER @D1784, PLU @D1783, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, 
      LAT -, ARITY 3] : ADMIT, 
   [COORD @D1792, PAST @D1791, AGR [CASE @D1790, COUNT @D1789, 
            PER @D1788, PLU @D1787, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM IN, LAT -, ARITY 3] : ADMIT, 
   [COORD @D1795, AGR [COUNT @D1794, PER @D1793, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ADMIT, 
   [COORD @D1797, AGR [COUNT @D1796, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ADMIT, 
   [COORD @D1799, AGR [COUNT @D1798, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ADMIT, 
   [COORD @D1803, AGR [COUNT @D1802, PER @D1801, PLU @D1800, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ADMIT, 
   [COORD @D1809, PAST @D1808, AGR [CASE @D1807, COUNT @D1806, 
            PER @D1805, PLU @D1804, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM OF, ARITY 2] : ADMIT, 
   [COORD @D1812, 
      AGR [COUNT @D1811, PER @D1810, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1814, 
      AGR [COUNT @D1813, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1816, 
      AGR [COUNT @D1815, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1820, 
      AGR [COUNT @D1819, PER @D1818, PLU @D1817, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1826, PAST @D1825, AGR [CASE @D1824, COUNT @D1823, 
            PER @D1822, PLU @D1821, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1829, AGR [COUNT @D1828, PER @D1827, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1831, AGR [COUNT @D1830, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1833, AGR [COUNT @D1832, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1837, AGR [COUNT @D1836, PER @D1835, PLU @D1834, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1843, PAST @D1842, AGR [CASE @D1841, COUNT @D1840, 
            PER @D1839, PLU @D1838, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_ING, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1846, AGR [COUNT @D1845, PER @D1844, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1848, AGR [COUNT @D1847, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1850, AGR [COUNT @D1849, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1854, AGR [COUNT @D1853, PER @D1852, PLU @D1851, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1860, PAST @D1859, AGR [CASE @D1858, COUNT @D1857, 
            PER @D1856, PLU @D1855, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1863, AGR [COUNT @D1862, PER @D1861, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1865, AGR [COUNT @D1864, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1867, 
      AGR [COUNT @D1866, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1871, 
      AGR [COUNT @D1870, PER @D1869, PLU @D1868, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADMIT, 
   [COORD @D1877, PAST @D1876, AGR [CASE @D1875, COUNT @D1874, 
            PER @D1873, PLU @D1872, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1880, AGR [COUNT @D1879, PER @D1878, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : ADMIT, 
   [COORD @D1882, AGR [COUNT @D1881, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1884, AGR [COUNT @D1883, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   ADMIT, 
   [COORD @D1888, AGR [COUNT @D1887, PER @D1886, PLU @D1885, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : ADMIT, 
   [COORD @D1894, PAST @D1893, AGR [CASE @D1892, COUNT @D1891, 
            PER @D1890, PLU @D1889, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM TO, LAT -, ARITY 2] : ADMIT, 
   [COORD @D1897, AGR [COUNT @D1896, PER @D1895, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADMIT, 
   [COORD @D1899, AGR [COUNT @D1898, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ADMIT, 
   [COORD @D1901, 
      AGR [COUNT @D1900, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ADMIT, 
   [COORD @D1905, 
      AGR [COUNT @D1904, PER @D1903, PLU @D1902, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADMIT, 
   [COORD @D1911, PAST @D1910, AGR [CASE @D1909, COUNT @D1908, 
            PER @D1907, PLU @D1906, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ADMIT.

WORD admits : 
   [COORD @D1917, AGR [COUNT @D1916, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1919, 
      AGR [COUNT @D1918, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM INTO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ADMIT, 
   [COORD @D1921, AGR [COUNT @D1920, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1923, 
      AGR [COUNT @D1922, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1925, 
      AGR [COUNT @D1924, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1927, 
      AGR [COUNT @D1926, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1929, 
      AGR [COUNT @D1928, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1931, 
      AGR [COUNT @D1930, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1933, 
      AGR [COUNT @D1932, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1935, 
      AGR [COUNT @D1934, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADMIT.

WORD admitted : 
   [COADV @D1947, COORD @D1946, DEF @D1945, PRD @D1944, AGR 
            [CASE @D1943, COUNT @D1942, PER @D1941, PLU @D1940, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, BAR 0, 
      SUBCAT NULL, INFL +, N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, 
      PART -, NEG -, QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      DISTR ATT] : ADMITTED, 
   [COORD @D1952, AGR [CASE @D1951, COUNT @D1950, PER @D1949, 
            PLU @D1948, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADMIT, 
   [COORD @D1957, AGR [CASE @D1956, COUNT @D1955, PER @D1954, 
            PLU @D1953, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1962, AGR [CASE @D1961, COUNT @D1960, PER @D1959, 
            PLU @D1958, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1967, AGR [CASE @D1966, COUNT @D1965, PER @D1964, 
            PLU @D1963, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM INTO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADMIT, 
   [COORD @D1972, AGR [CASE @D1971, COUNT @D1970, PER @D1969, 
            PLU @D1968, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM INTO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1977, AGR [CASE @D1976, COUNT @D1975, PER @D1974, 
            PLU @D1973, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM INTO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1982, AGR [CASE @D1981, COUNT @D1980, PER @D1979, 
            PLU @D1978, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM IN, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADMIT, 
   [COORD @D1987, AGR [CASE @D1986, COUNT @D1985, PER @D1984, 
            PLU @D1983, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1992, AGR [CASE @D1991, COUNT @D1990, PER @D1989, 
            PLU @D1988, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D1997, AGR [CASE @D1996, COUNT @D1995, PER @D1994, 
            PLU @D1993, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2002, AGR [CASE @D2001, COUNT @D2000, PER @D1999, 
            PLU @D1998, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2007, AGR [CASE @D2006, COUNT @D2005, PER @D2004, 
            PLU @D2003, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM OF, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADMIT, 
   [COORD @D2012, AGR [UB @D2011, VFORM @D2010, SUBJ @D2009, FIN @D2008, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2017, 
      AGR [CASE @D2016, COUNT @D2015, PER @D2014, PLU @D2013, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2022, 
      AGR [CASE @D2021, COUNT @D2020, PER @D2019, PLU @D2018, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2027, 
      AGR [CASE @D2026, COUNT @D2025, PER @D2024, PLU @D2023, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2032, 
      AGR [CASE @D2031, COUNT @D2030, PER @D2029, PLU @D2028, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2037, 
      AGR [CASE @D2036, COUNT @D2035, PER @D2034, PLU @D2033, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2042, 
      AGR [CASE @D2041, COUNT @D2040, PER @D2039, PLU @D2038, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2048, 
      AGR [CASE @D2047, NFORM @D2046, COUNT @D2045, PER @D2044, 
            PLU @D2043, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADMIT, 
   [COORD @D2053, AGR [UB @D2052, VFORM @D2051, SUBJ @D2050, FIN @D2049, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2058, 
      AGR [CASE @D2057, COUNT @D2056, PER @D2055, PLU @D2054, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2063, 
      AGR [CASE @D2062, COUNT @D2061, PER @D2060, PLU @D2059, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2068, 
      AGR [CASE @D2067, COUNT @D2066, PER @D2065, PLU @D2064, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2073, 
      AGR [CASE @D2072, COUNT @D2071, PER @D2070, PLU @D2069, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADMIT, 
   [COORD @D2078, AGR [CASE @D2077, COUNT @D2076, PER @D2075, 
            PLU @D2074, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2083, AGR [CASE @D2082, COUNT @D2081, PER @D2080, 
            PLU @D2079, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADMIT, 
   [COORD @D2088, AGR [CASE @D2087, COUNT @D2086, PER @D2085, 
            PLU @D2084, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADMIT.

WORD admitting : 
   [COORD @D2100, PRD @D2099, AGR [CASE @D2098, COUNT @D2097, 
            PER @D2096, PLU @D2095, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2106, PRD @D2105, 
      AGR [CASE @D2104, COUNT @D2103, PER @D2102, PLU @D2101, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM INTO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADMIT, 
   [COORD @D2112, PRD @D2111, AGR [CASE @D2110, COUNT @D2109, PER 
               @D2108, PLU @D2107, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM IN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2118, PRD @D2117, 
      AGR [CASE @D2116, COUNT @D2115, PER @D2114, PLU @D2113, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADMIT, 
   [COORD @D2124, PRD @D2123, AGR [CASE @D2122, COUNT @D2121, 
            PER @D2120, PLU @D2119, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2130, PRD @D2129, AGR 
         [CASE @D2128, COUNT @D2127, PER @D2126, PLU @D2125, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2136, PRD @D2135, 
      AGR [CASE @D2134, COUNT @D2133, PER @D2132, PLU @D2131, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2142, PRD @D2141, 
      AGR [CASE @D2140, COUNT @D2139, PER @D2138, PLU @D2137, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADMIT, 
   [COORD @D2148, PRD @D2147, 
      AGR [CASE @D2146, COUNT @D2145, PER @D2144, PLU @D2143, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADMIT, 
   [COORD @D2154, PRD @D2153, AGR [CASE @D2152, COUNT @D2151, PER 
               @D2150, PLU @D2149, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADMIT.

WORD adopt : 
   [COORD @D2160, AGR [COUNT @D2159, PER @D2158, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, 
      LAT -, ARITY 3] : ADOPT, 
   [COORD @D2162, AGR [COUNT @D2161, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, LAT -, 
      ARITY 3] : ADOPT, 
   [COORD @D2164, AGR [COUNT @D2163, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, LAT -, 
      ARITY 3] : ADOPT, 
   [COORD @D2168, AGR [COUNT @D2167, PER @D2166, PLU @D2165, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, 
      LAT -, ARITY 3] : ADOPT, 
   [COORD @D2174, PAST @D2173, AGR [CASE @D2172, COUNT @D2171, 
            PER @D2170, PLU @D2169, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM AS, LAT -, ARITY 3] : ADOPT, 
   [COORD @D2177, AGR [COUNT @D2176, PER @D2175, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADOPT, 
   [COORD @D2179, AGR [COUNT @D2178, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADOPT, 
   [COORD @D2181, 
      AGR [COUNT @D2180, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADOPT, 
   [COORD @D2185, 
      AGR [COUNT @D2184, PER @D2183, PLU @D2182, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADOPT, 
   [COORD @D2191, PAST @D2190, AGR [CASE @D2189, COUNT @D2188, 
            PER @D2187, PLU @D2186, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ADOPT.

WORD adopted : 
   [COORD @D2200, AGR [CASE @D2199, COUNT @D2198, PER @D2197, 
            PLU @D2196, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE PVERB, PFORM AS, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADOPT, 
   [COORD @D2205, AGR [CASE @D2204, COUNT @D2203, PER @D2202, 
            PLU @D2201, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADOPT, 
   [COORD @D2210, AGR [CASE @D2209, COUNT @D2208, PER @D2207, 
            PLU @D2206, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADOPT, 
   [COORD @D2215, AGR [CASE @D2214, COUNT @D2213, PER @D2212, 
            PLU @D2211, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADOPT, 
   [COORD @D2220, AGR [CASE @D2219, COUNT @D2218, PER @D2217, 
            PLU @D2216, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADOPT, 
   [COORD @D2225, AGR [CASE @D2224, COUNT @D2223, PER @D2222, 
            PLU @D2221, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ADOPT.

WORD adopting : 
   [COORD @D2237, PRD @D2236, AGR [CASE @D2235, COUNT @D2234, 
            PER @D2233, PLU @D2232, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM AS, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADOPT, 
   [COORD @D2243, PRD @D2242, 
      AGR [CASE @D2241, COUNT @D2240, PER @D2239, PLU @D2238, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADOPT.

WORD adopts : 
   [COORD @D2249, AGR [COUNT @D2248, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT NP_PP, PFORM AS, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : ADOPT, 
   [COORD @D2251, AGR [COUNT @D2250, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADOPT.

WORD advance : 
   [COORD @D2258, AGR [COUNT @D2257, PER @D2256, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ADVANCE, 
   [COORD @D2260, AGR [COUNT @D2259, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : 
   ADVANCE, 
   [COORD @D2262, AGR [COUNT @D2261, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : 
   ADVANCE, 
   [COORD @D2266, AGR [COUNT @D2265, PER @D2264, PLU @D2263, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ADVANCE, 
   [COORD @D2272, PAST @D2271, AGR [CASE @D2270, COUNT @D2269, 
            PER @D2268, PLU @D2267, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_NP, LAT -, ARITY 3] : ADVANCE, 
   [COORD @D2275, AGR [COUNT @D2274, PER @D2273, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADVANCE, 
   [COORD @D2277, AGR [COUNT @D2276, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADVANCE, 
   [COORD @D2279, AGR [COUNT @D2278, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ADVANCE, 
   [COORD @D2283, AGR [COUNT @D2282, PER @D2281, PLU @D2280, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ADVANCE, 
   [COORD @D2289, PAST @D2288, AGR [CASE @D2287, COUNT @D2286, 
            PER @D2285, PLU @D2284, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ADVANCE, 
   [COORD @D2292, AGR [COUNT @D2291, PER @D2290, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2294, AGR [COUNT @D2293, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2296, 
      AGR [COUNT @D2295, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2300, 
      AGR [COUNT @D2299, PER @D2298, PLU @D2297, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2306, PAST @D2305, AGR [CASE @D2304, COUNT @D2303, 
            PER @D2302, PLU @D2301, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2309, AGR [COUNT @D2308, PER @D2307, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2311, AGR [COUNT @D2310, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2313, AGR [COUNT @D2312, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2317, AGR [COUNT @D2316, PER @D2315, PLU @D2314, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM UPON, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2323, PAST @D2322, AGR [CASE @D2321, COUNT @D2320, 
            PER @D2319, PLU @D2318, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM UPON, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2326, AGR [COUNT @D2325, PER @D2324, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2328, AGR [COUNT @D2327, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   ADVANCE, 
   [COORD @D2330, AGR [COUNT @D2329, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   ADVANCE, 
   [COORD @D2334, AGR [COUNT @D2333, PER @D2332, PLU @D2331, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2340, PAST @D2339, AGR [CASE @D2338, COUNT @D2337, 
            PER @D2336, PLU @D2335, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM TO, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2343, AGR [COUNT @D2342, PER @D2341, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2345, AGR [COUNT @D2344, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   ADVANCE, 
   [COORD @D2347, AGR [COUNT @D2346, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   ADVANCE, 
   [COORD @D2351, AGR [COUNT @D2350, PER @D2349, PLU @D2348, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, 
      LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2357, PAST @D2356, AGR [CASE @D2355, COUNT @D2354, 
            PER @D2353, PLU @D2352, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM ON, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2360, AGR [COUNT @D2359, PER @D2358, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      PFORM AGAINST, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2362, AGR [COUNT @D2361, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2364, AGR [COUNT @D2363, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, LAT -, 
      ARITY 2] : ADVANCE, 
   [COORD @D2368, AGR [COUNT @D2367, PER @D2366, PLU @D2365, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      PFORM AGAINST, LAT -, ARITY 2] : ADVANCE, 
   [COORD @D2374, PAST @D2373, 
      AGR [CASE @D2372, COUNT @D2371, PER @D2370, PLU @D2369, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, LAT -, ARITY 2] : 
   ADVANCE, 
   [COORD @D2377, AGR [COUNT @D2376, PER @D2375, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADVANCE, 
   [COORD @D2379, AGR [COUNT @D2378, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ADVANCE, 
   
   [COORD @D2381, AGR [COUNT @D2380, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ADVANCE, 
   
   [COORD @D2385, AGR [COUNT @D2384, PER @D2383, PLU @D2382, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADVANCE, 
   [COORD @D2391, PAST @D2390, AGR [CASE @D2389, COUNT @D2388, 
            PER @D2387, PLU @D2386, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ADVANCE.

WORD advanced : 
   [COADV @D2404, COORD @D2403, DEF @D2402, PRD @D2401, AGR 
            [CASE @D2400, COUNT @D2399, PER @D2398, PLU @D2397, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, 
      N +, GRADE +, ADV -, AFORM NONE, PART -, NEG -, SUBCAT NULL, DISTR ATT, 
      QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ADVANCED, 
   [COORD @D2409, 
      AGR [CASE @D2408, COUNT @D2407, PER @D2406, PLU @D2405, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP_NP, 
      SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVANCE, 
   
   [COORD @D2414, AGR [CASE @D2413, COUNT @D2412, PER @D2411, PLU @D2410, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2419, AGR [CASE @D2418, COUNT @D2417, PER @D2416, 
            PLU @D2415, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2424, AGR [CASE @D2423, COUNT @D2422, PER @D2421, 
            PLU @D2420, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE DMOVT, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2429, AGR [CASE @D2428, COUNT @D2427, PER @D2426, 
            PLU @D2425, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2434, AGR [CASE @D2433, COUNT @D2432, PER @D2431, 
            PLU @D2430, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2439, AGR [CASE @D2438, COUNT @D2437, PER @D2436, 
            PLU @D2435, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADVANCE, 
   [COORD @D2444, AGR [CASE @D2443, COUNT @D2442, PER @D2441, 
            PLU @D2440, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ADVANCE, 
   [COORD @D2449, AGR [CASE @D2448, COUNT @D2447, PER @D2446, 
            PLU @D2445, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADVANCE, 
   [COORD @D2454, AGR [CASE @D2453, COUNT @D2452, PER @D2451, 
            PLU @D2450, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2459, AGR [CASE @D2458, COUNT @D2457, PER @D2456, 
            PLU @D2455, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2464, AGR [CASE @D2463, COUNT @D2462, PER @D2461, 
            PLU @D2460, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2469, AGR [CASE @D2468, COUNT @D2467, PER @D2466, 
            PLU @D2465, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2474, AGR [CASE @D2473, COUNT @D2472, PER @D2471, 
            PLU @D2470, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2479, AGR [CASE @D2478, COUNT @D2477, PER @D2476, 
            PLU @D2475, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2484, AGR [CASE @D2483, COUNT @D2482, PER @D2481, 
            PLU @D2480, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2489, AGR [CASE @D2488, COUNT @D2487, PER @D2486, 
            PLU @D2485, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2494, AGR [CASE @D2493, COUNT @D2492, PER @D2491, 
            PLU @D2490, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2499, AGR [CASE @D2498, COUNT @D2497, PER @D2496, 
            PLU @D2495, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADVANCE.

WORD advances : 
   [COORD @D2506, AGR [COUNT @D2505, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2508, 
      AGR [COUNT @D2507, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2510, 
      AGR [COUNT @D2509, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2512, 
      AGR [COUNT @D2511, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2514, 
      AGR [COUNT @D2513, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2516, 
      AGR [COUNT @D2515, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2518, 
      AGR [COUNT @D2517, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ADVANCE, 
   [COORD @D2520, AGR [COUNT @D2519, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVANCE.

WORD advancing : 
   [COORD @D2531, PRD @D2530, AGR [CASE @D2529, COUNT @D2528, 
            PER @D2527, PLU @D2526, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2537, PRD @D2536, 
      AGR [CASE @D2535, COUNT @D2534, PER @D2533, PLU @D2532, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADVANCE, 
   [COORD @D2543, PRD @D2542, AGR [CASE @D2541, COUNT @D2540, 
            PER @D2539, PLU @D2538, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2549, PRD @D2548, 
      AGR [CASE @D2547, COUNT @D2546, PER @D2545, PLU @D2544, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM UPON, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADVANCE, 
   [COORD @D2555, PRD @D2554, AGR [CASE @D2553, COUNT @D2552, 
            PER @D2551, PLU @D2550, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2561, PRD @D2560, 
      AGR [CASE @D2559, COUNT @D2558, PER @D2557, PLU @D2556, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADVANCE, 
   [COORD @D2567, PRD @D2566, AGR [CASE @D2565, COUNT @D2564, 
            PER @D2563, PLU @D2562, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, 
      PFORM AGAINST, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVANCE, 
   [COORD @D2573, PRD @D2572, 
      AGR [CASE @D2571, COUNT @D2570, PER @D2569, PLU @D2568, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVANCE.

WORD advertise : 
   [COORD @D2580, AGR [COUNT @D2579, PER @D2578, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ADVERTISE, 
   [COORD @D2582, AGR [COUNT @D2581, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : 
   ADVERTISE, 
   [COORD @D2584, AGR [COUNT @D2583, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : 
   ADVERTISE, 
   [COORD @D2588, AGR [COUNT @D2587, PER @D2586, PLU @D2585, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ADVERTISE, 
   [COORD @D2594, PAST @D2593, AGR [CASE @D2592, COUNT @D2591, 
            PER @D2590, PLU @D2589, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ADVERTISE, 
   [COORD @D2597, AGR [COUNT @D2596, PER @D2595, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADVERTISE, 
   [COORD @D2599, AGR [COUNT @D2598, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADVERTISE, 
   
   [COORD @D2601, AGR [COUNT @D2600, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ADVERTISE, 
   
   [COORD @D2605, AGR [COUNT @D2604, PER @D2603, PLU @D2602, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ADVERTISE, 
   [COORD @D2611, PAST @D2610, AGR [CASE @D2609, COUNT @D2608, 
            PER @D2607, PLU @D2606, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ADVERTISE, 
   [COORD @D2614, AGR [COUNT @D2613, PER @D2612, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : ADVERTISE, 
   [COORD @D2616, AGR [COUNT @D2615, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ADVERTISE, 
   [COORD @D2618, AGR [COUNT @D2617, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ADVERTISE, 
   [COORD @D2622, AGR [COUNT @D2621, PER @D2620, PLU @D2619, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : ADVERTISE, 
   [COORD @D2628, PAST @D2627, AGR [CASE @D2626, COUNT @D2625, 
            PER @D2624, PLU @D2623, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : ADVERTISE, 
   [COORD @D2631, AGR [COUNT @D2630, PER @D2629, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADVERTISE, 
   [COORD @D2633, AGR [COUNT @D2632, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   ADVERTISE, 
   [COORD @D2635, AGR [COUNT @D2634, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   ADVERTISE, 
   [COORD @D2639, AGR [COUNT @D2638, PER @D2637, PLU @D2636, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ADVERTISE, 
   [COORD @D2645, PAST @D2644, AGR [CASE @D2643, COUNT @D2642, 
            PER @D2641, PLU @D2640, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ADVERTISE.

WORD advertised : 
   [COORD @D2655, AGR [CASE @D2654, COUNT @D2653, PER @D2652, 
            PLU @D2651, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2660, AGR [CASE @D2659, COUNT @D2658, PER @D2657, 
            PLU @D2656, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2665, AGR [UB @D2664, VFORM @D2663, SUBJ @D2662, FIN @D2661, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADVERTISE, 
   [COORD @D2670, AGR [CASE @D2669, COUNT @D2668, PER @D2667, 
            PLU @D2666, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ADVERTISE, 
   [COORD @D2675, AGR [CASE @D2674, COUNT @D2673, PER @D2672, 
            PLU @D2671, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ADVERTISE, 
   [COORD @D2680, AGR [CASE @D2679, COUNT @D2678, PER @D2677, 
            PLU @D2676, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ADVERTISE, 
   [COORD @D2685, AGR [CASE @D2684, COUNT @D2683, PER @D2682, 
            PLU @D2681, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2690, AGR [CASE @D2689, COUNT @D2688, PER @D2687, 
            PLU @D2686, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2695, AGR [CASE @D2694, COUNT @D2693, PER @D2692, 
            PLU @D2691, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2700, AGR [CASE @D2699, COUNT @D2698, PER @D2697, 
            PLU @D2696, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ADVERTISE.

WORD advertises : 
   [COORD @D2707, AGR [COUNT @D2706, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2709, 
      AGR [COUNT @D2708, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2711, 
      AGR [COUNT @D2710, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ADVERTISE, 
   [COORD @D2713, AGR [COUNT @D2712, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ADVERTISE.

WORD advertising : 
   [COORD @D2721, REFL @D2720, PRD @D2719, CASE @D2718, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, COUNT -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : ADVERTISING, 
   [COORD @D2727, PRD @D2726, 
      AGR [CASE @D2725, COUNT @D2724, PER @D2723, PLU @D2722, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2733, PRD @D2732, 
      AGR [CASE @D2731, COUNT @D2730, PER @D2729, PLU @D2728, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ADVERTISE, 
   [COORD @D2739, PRD @D2738, 
      AGR [CASE @D2737, COUNT @D2736, PER @D2735, PLU @D2734, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ADVERTISE, 
   [COORD @D2745, PRD @D2744, AGR [CASE @D2743, COUNT @D2742, 
            PER @D2741, PLU @D2740, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ADVERTISE.

WORD agree : 
   [COORD @D2758, AGR [COUNT @D2757, PER @D2756, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM WITH, LAT -, ARITY 3] : AGREE, 
   [COORD @D2760, AGR [COUNT @D2759, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM WITH, 
      LAT -, ARITY 3] : AGREE, 
   [COORD @D2762, AGR [COUNT @D2761, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM WITH, 
      LAT -, ARITY 3] : AGREE, 
   [COORD @D2766, AGR [COUNT @D2765, PER @D2764, PLU @D2763, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM WITH, LAT -, ARITY 3] : AGREE, 
   [COORD @D2772, PAST @D2771, AGR [CASE @D2770, COUNT @D2769, 
            PER @D2768, PLU @D2767, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_PP_INF, PFORM WITH, LAT -, ARITY 3] : AGREE, 
   [COORD @D2775, 
      AGR [COUNT @D2774, PER @D2773, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, 
      ARITY 3] : AGREE, 
   [COORD @D2777, AGR [COUNT @D2776, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, 
      ARITY 3] : AGREE, 
   [COORD @D2779, AGR [COUNT @D2778, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, 
      ARITY 3] : AGREE, 
   [COORD @D2783, AGR [COUNT @D2782, PER @D2781, PLU @D2780, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, 
      PFORM WITH, LAT -, ARITY 3] : AGREE, 
   [COORD @D2789, PAST @D2788, AGR [CASE @D2787, COUNT @D2786, 
            PER @D2785, PLU @D2784, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP_SFIN, PFORM WITH, LAT -, ARITY 3] : AGREE, 
   [COORD @D2792, 
      AGR [COUNT @D2791, PER @D2790, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM WITH, 
      ARITY 2] : AGREE, 
   [COORD @D2794, AGR [COUNT @D2793, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : AGREE, 
   [COORD @D2796, AGR [COUNT @D2795, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : AGREE, 
   [COORD @D2800, AGR [COUNT @D2799, PER @D2798, PLU @D2797, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : AGREE, 
   [COORD @D2806, PAST @D2805, AGR [CASE @D2804, COUNT @D2803, 
            PER @D2802, PLU @D2801, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM WITH, ARITY 2] : AGREE, 
   [COORD @D2809, 
      AGR [COUNT @D2808, PER @D2807, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : AGREE, 
   [COORD @D2811, 
      AGR [COUNT @D2810, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : AGREE, 
   [COORD @D2813, 
      AGR [COUNT @D2812, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : AGREE, 
   [COORD @D2817, 
      AGR [COUNT @D2816, PER @D2815, PLU @D2814, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2823, PAST @D2822, AGR [CASE @D2821, COUNT @D2820, 
            PER @D2819, PLU @D2818, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : AGREE, 
   [COORD @D2826, AGR [COUNT @D2825, PER @D2824, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2828, AGR [COUNT @D2827, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2830, AGR [COUNT @D2829, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2834, AGR [COUNT @D2833, PER @D2832, PLU @D2831, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2840, PAST @D2839, AGR [CASE @D2838, COUNT @D2837, 
            PER @D2836, PLU @D2835, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_INF, LAT -, ARITY 2] : AGREE, 
   [COORD @D2843, AGR [COUNT @D2842, PER @D2841, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2845, AGR [COUNT @D2844, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : AGREE, 
   [COORD @D2847, 
      AGR [COUNT @D2846, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : AGREE, 
   [COORD @D2851, 
      AGR [COUNT @D2850, PER @D2849, PLU @D2848, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2857, PAST @D2856, AGR [CASE @D2855, COUNT @D2854, 
            PER @D2853, PLU @D2852, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : AGREE, 
   [COORD @D2860, AGR [COUNT @D2859, PER @D2858, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2862, AGR [COUNT @D2861, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2864, AGR [COUNT @D2863, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2868, AGR [COUNT @D2867, PER @D2866, PLU @D2865, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2874, PAST @D2873, AGR [CASE @D2872, COUNT @D2871, 
            PER @D2870, PLU @D2869, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM WITH, LAT -, ARITY 2] : AGREE, 
   [COORD @D2877, AGR [COUNT @D2876, PER @D2875, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2879, AGR [COUNT @D2878, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2881, AGR [COUNT @D2880, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2885, AGR [COUNT @D2884, PER @D2883, PLU @D2882, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2891, PAST @D2890, AGR [CASE @D2889, COUNT @D2888, 
            PER @D2887, PLU @D2886, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM TO, LAT -, ARITY 2] : AGREE, 
   [COORD @D2894, AGR [COUNT @D2893, PER @D2892, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2896, AGR [COUNT @D2895, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2898, AGR [COUNT @D2897, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, LAT -, ARITY 2] : 
   AGREE, 
   [COORD @D2902, AGR [COUNT @D2901, PER @D2900, PLU @D2899, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ON, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2908, PAST @D2907, AGR [CASE @D2906, COUNT @D2905, 
            PER @D2904, PLU @D2903, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM ON, LAT -, ARITY 2] : AGREE, 
   [COORD @D2911, AGR [COUNT @D2910, PER @D2909, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ABOUT, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2913, AGR [COUNT @D2912, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ABOUT, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2915, AGR [COUNT @D2914, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ABOUT, LAT -, 
      ARITY 2] : AGREE, 
   [COORD @D2919, AGR [COUNT @D2918, PER @D2917, PLU @D2916, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM ABOUT, 
      LAT -, ARITY 2] : AGREE, 
   [COORD @D2925, PAST @D2924, AGR [CASE @D2923, COUNT @D2922, 
            PER @D2921, PLU @D2920, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM ABOUT, LAT -, ARITY 2] : AGREE, 
   [COORD @D2928, AGR [COUNT @D2927, PER @D2926, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : AGREE, 
   [COORD @D2930, AGR [COUNT @D2929, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : AGREE, 
   [COORD @D2932, 
      AGR [COUNT @D2931, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : AGREE, 
   [COORD @D2936, 
      AGR [COUNT @D2935, PER @D2934, PLU @D2933, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : AGREE, 
   [COORD @D2942, PAST @D2941, AGR [CASE @D2940, COUNT @D2939, 
            PER @D2938, PLU @D2937, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : AGREE, 
   [COORD @D2945, AGR [COUNT @D2944, PER @D2943, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      PRT TOGETHER, LAT -, ARITY 1] : AGREE, 
   [COORD @D2947, AGR [COUNT @D2946, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT TOGETHER, LAT -, 
      ARITY 1] : AGREE, 
   [COORD @D2949, AGR [COUNT @D2948, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT TOGETHER, LAT -, 
      ARITY 1] : AGREE, 
   [COORD @D2953, AGR [COUNT @D2952, PER @D2951, PLU @D2950, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      PRT TOGETHER, LAT -, ARITY 1] : AGREE, 
   [COORD @D2959, PAST @D2958, 
      AGR [CASE @D2957, COUNT @D2956, PER @D2955, PLU @D2954, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT TOGETHER, LAT -, ARITY 1] : 
   AGREE.

WORD agreed : 
   [COORD @D2969, AGR [CASE @D2968, COUNT @D2967, PER @D2966, PLU 
               @D2965, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2974, AGR [CASE @D2973, COUNT @D2972, PER @D2971, 
            PLU @D2970, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2979, AGR [CASE @D2978, COUNT @D2977, PER @D2976, 
            PLU @D2975, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2984, AGR [CASE @D2983, COUNT @D2982, PER @D2981, 
            PLU @D2980, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2989, AGR [CASE @D2988, COUNT @D2987, PER @D2986, 
            PLU @D2985, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2994, AGR [CASE @D2993, COUNT @D2992, PER @D2991, 
            PLU @D2990, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D2999, AGR [CASE @D2998, COUNT @D2997, PER @D2996, 
            PLU @D2995, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AGREE, 
   [COORD @D3004, AGR [CASE @D3003, COUNT @D3002, PER @D3001, 
            PLU @D3000, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AGREE, 
   [COORD @D3009, AGR [CASE @D3008, COUNT @D3007, PER @D3006, 
            PLU @D3005, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : AGREE, 
   [COORD @D3014, AGR [UB @D3013, VFORM @D3012, SUBJ @D3011, FIN @D3010, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3019, 
      AGR [CASE @D3018, COUNT @D3017, PER @D3016, PLU @D3015, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3024, 
      AGR [CASE @D3023, COUNT @D3022, PER @D3021, PLU @D3020, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3029, 
      AGR [CASE @D3028, COUNT @D3027, PER @D3026, PLU @D3025, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3034, 
      AGR [CASE @D3033, COUNT @D3032, PER @D3031, PLU @D3030, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3039, 
      AGR [CASE @D3038, COUNT @D3037, PER @D3036, PLU @D3035, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3044, 
      AGR [CASE @D3043, COUNT @D3042, PER @D3041, PLU @D3040, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : AGREE, 
   [COORD @D3049, AGR [CASE @D3048, COUNT @D3047, PER @D3046, 
            PLU @D3045, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3054, AGR [CASE @D3053, COUNT @D3052, PER @D3051, 
            PLU @D3050, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3059, AGR [CASE @D3058, COUNT @D3057, PER @D3056, 
            PLU @D3055, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3064, AGR [CASE @D3063, COUNT @D3062, PER @D3061, 
            PLU @D3060, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3069, AGR [CASE @D3068, COUNT @D3067, PER @D3066, 
            PLU @D3065, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3074, AGR [CASE @D3073, COUNT @D3072, PER @D3071, 
            PLU @D3070, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ABOUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3079, AGR [CASE @D3078, COUNT @D3077, PER @D3076, 
            PLU @D3075, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ABOUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3084, AGR [CASE @D3083, COUNT @D3082, PER @D3081, 
            PLU @D3080, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AGREE, 
   [COORD @D3089, AGR [CASE @D3088, COUNT @D3087, PER @D3086, 
            PLU @D3085, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : AGREE, 
   [COORD @D3094, AGR [CASE @D3093, COUNT @D3092, PER @D3091, 
            PLU @D3090, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT TOGETHER, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : AGREE, 
   [COORD @D3099, AGR [CASE @D3098, COUNT @D3097, PER @D3096, 
            PLU @D3095, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT TOGETHER, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : AGREE.

WORD agrees : 
   [COORD @D3106, AGR [COUNT @D3105, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   AGREE, 
   [COORD @D3108, AGR [COUNT @D3107, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   AGREE, 
   [COORD @D3110, AGR [COUNT @D3109, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : AGREE, 
   [COORD @D3112, AGR [COUNT @D3111, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3114, 
      AGR [COUNT @D3113, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3116, 
      AGR [COUNT @D3115, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3118, 
      AGR [COUNT @D3117, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3120, 
      AGR [COUNT @D3119, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3122, 
      AGR [COUNT @D3121, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3124, 
      AGR [COUNT @D3123, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ABOUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3126, 
      AGR [COUNT @D3125, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AGREE, 
   [COORD @D3128, 
      AGR [COUNT @D3127, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT TOGETHER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   AGREE.

WORD aim : 
   [COORD @D3140, REFL @D3139, COUNT @D3138, PRD @D3137, CASE @D3136, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : AIM, 
   [COORD @D3143, AGR 
         [COUNT @D3142, PER @D3141, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM AT, LAT -, 
      ARITY 3] : AIM, 
   [COORD @D3145, AGR [COUNT @D3144, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM AT, LAT -, 
      ARITY 3] : AIM, 
   [COORD @D3147, AGR [COUNT @D3146, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM AT, LAT -, 
      ARITY 3] : AIM, 
   [COORD @D3151, AGR [COUNT @D3150, PER @D3149, PLU @D3148, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM AT, 
      LAT -, ARITY 3] : AIM, 
   [COORD @D3157, PAST @D3156, AGR [CASE @D3155, COUNT @D3154, 
            PER @D3153, PLU @D3152, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM AT, LAT -, ARITY 3] : AIM, 
   [COORD @D3160, AGR [COUNT @D3159, PER @D3158, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP AT, ARITY 2] : AIM, 
   [COORD @D3162, AGR [COUNT @D3161, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP AT, ARITY 2] : AIM, 
   [COORD @D3164, AGR [COUNT @D3163, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP AT, ARITY 2] : AIM, 
   [COORD @D3168, AGR [COUNT @D3167, PER @D3166, PLU @D3165, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP AT, ARITY 2] : AIM, 
   [COORD @D3174, PAST @D3173, 
      AGR [CASE @D3172, COUNT @D3171, PER @D3170, PLU @D3169, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, PREP AT, 
      ARITY 2] : AIM, 
   [COORD @D3177, AGR [COUNT @D3176, PER @D3175, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : AIM, 
   [COORD @D3179, AGR [COUNT @D3178, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : AIM, 
   [COORD @D3181, AGR [COUNT @D3180, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : AIM, 
   [COORD @D3185, AGR [COUNT @D3184, PER @D3183, PLU @D3182, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : AIM, 
   [COORD @D3191, PAST @D3190, AGR [CASE @D3189, COUNT @D3188, 
            PER @D3187, PLU @D3186, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, ARITY 2] : AIM, 
   [COORD @D3194, 
      AGR [COUNT @D3193, PER @D3192, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM AT, 
      ARITY 2] : AIM, 
   [COORD @D3196, AGR [COUNT @D3195, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : AIM, 
   [COORD @D3198, AGR [COUNT @D3197, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : AIM, 
   [COORD @D3202, AGR [COUNT @D3201, PER @D3200, PLU @D3199, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : AIM, 
   [COORD @D3208, PAST @D3207, AGR [CASE @D3206, COUNT @D3205, 
            PER @D3204, PLU @D3203, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM AT, ARITY 2] : AIM, 
   [COORD @D3211, AGR 
         [COUNT @D3210, PER @D3209, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : AIM, 
   [COORD @D3213, 
      AGR [COUNT @D3212, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : AIM, 
   [COORD @D3215, 
      AGR [COUNT @D3214, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : AIM, 
   [COORD @D3219, 
      AGR [COUNT @D3218, PER @D3217, PLU @D3216, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : AIM, 
   [COORD @D3225, PAST @D3224, AGR [CASE @D3223, COUNT @D3222, 
            PER @D3221, PLU @D3220, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_INF, LAT -, ARITY 2] : AIM, 
   [COORD @D3228, AGR [COUNT @D3227, PER @D3226, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : AIM, 
   [COORD @D3230, AGR [COUNT @D3229, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : AIM, 
   [COORD @D3232, 
      AGR [COUNT @D3231, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : AIM, 
   [COORD @D3236, 
      AGR [COUNT @D3235, PER @D3234, PLU @D3233, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : AIM, 
   [COORD @D3242, PAST @D3241, AGR [CASE @D3240, COUNT @D3239, 
            PER @D3238, PLU @D3237, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : AIM, 
   [COORD @D3245, AGR [COUNT @D3244, PER @D3243, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : AIM, 
   [COORD @D3247, AGR [COUNT @D3246, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   AIM, 
   [COORD @D3249, AGR [COUNT @D3248, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   AIM, 
   [COORD @D3253, AGR [COUNT @D3252, PER @D3251, PLU @D3250, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : AIM, 
   [COORD @D3259, PAST @D3258, AGR [CASE @D3257, COUNT @D3256, 
            PER @D3255, PLU @D3254, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : AIM, 
   [COORD @D3262, AGR [COUNT @D3261, PER @D3260, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AT, 
      LAT -, ARITY 2] : AIM, 
   [COORD @D3264, AGR [COUNT @D3263, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AT, LAT -, ARITY 2] : 
   AIM, 
   [COORD @D3266, AGR [COUNT @D3265, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AT, LAT -, ARITY 2] : 
   AIM, 
   [COORD @D3270, AGR [COUNT @D3269, PER @D3268, PLU @D3267, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM AT, 
      LAT -, ARITY 2] : AIM, 
   [COORD @D3276, PAST @D3275, AGR [CASE @D3274, COUNT @D3273, 
            PER @D3272, PLU @D3271, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM AT, LAT -, ARITY 2] : AIM, 
   [COORD @D3279, AGR [COUNT @D3278, PER @D3277, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : AIM, 
   [COORD @D3281, AGR [COUNT @D3280, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : AIM, 
   [COORD @D3283, 
      AGR [COUNT @D3282, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : AIM, 
   [COORD @D3287, 
      AGR [COUNT @D3286, PER @D3285, PLU @D3284, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : AIM, 
   [COORD @D3293, PAST @D3292, AGR [CASE @D3291, COUNT @D3290, 
            PER @D3289, PLU @D3288, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : AIM.

WORD aimed : 
   [COORD @D3303, AGR [CASE @D3302, COUNT @D3301, PER @D3300, PLU 
               @D3299, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM AT, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3308, AGR [CASE @D3307, COUNT @D3306, PER @D3305, 
            PLU @D3304, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3313, AGR [CASE @D3312, COUNT @D3311, PER @D3310, 
            PLU @D3309, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3318, AGR [CASE @D3317, COUNT @D3316, PER @D3315, 
            PLU @D3314, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3323, AGR [CASE @D3322, COUNT @D3321, PER @D3320, 
            PLU @D3319, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3328, AGR [CASE @D3327, COUNT @D3326, PER @D3325, 
            PLU @D3324, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3333, AGR [CASE @D3332, COUNT @D3331, PER @D3330, 
            PLU @D3329, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3338, AGR [CASE @D3337, COUNT @D3336, PER @D3335, 
            PLU @D3334, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3343, AGR [CASE @D3342, COUNT @D3341, PER @D3340, 
            PLU @D3339, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3348, AGR [CASE @D3347, COUNT @D3346, PER @D3345, 
            PLU @D3344, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3353, AGR [CASE @D3352, COUNT @D3351, PER @D3350, 
            PLU @D3349, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM AT, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3358, AGR [CASE @D3357, COUNT @D3356, PER @D3355, 
            PLU @D3354, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3363, AGR [CASE @D3362, COUNT @D3361, PER @D3360, 
            PLU @D3359, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3368, AGR [CASE @D3367, COUNT @D3366, PER @D3365, 
            PLU @D3364, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : AIM, 
   [COORD @D3373, AGR [CASE @D3372, COUNT @D3371, PER @D3370, 
            PLU @D3369, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : AIM, 
   [COORD @D3378, AGR [CASE @D3377, COUNT @D3376, PER @D3375, 
            PLU @D3374, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : AIM, 
   [COORD @D3383, AGR [CASE @D3382, COUNT @D3381, PER @D3380, 
            PLU @D3379, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3388, AGR [CASE @D3387, COUNT @D3386, PER @D3385, 
            PLU @D3384, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3393, AGR [CASE @D3392, COUNT @D3391, PER @D3390, 
            PLU @D3389, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3398, AGR [CASE @D3397, COUNT @D3396, PER @D3395, 
            PLU @D3394, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AIM, 
   [COORD @D3403, AGR [CASE @D3402, COUNT @D3401, PER @D3400, 
            PLU @D3399, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3408, AGR [CASE @D3407, COUNT @D3406, PER @D3405, 
            PLU @D3404, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : AIM.

WORD aiming : 
   [COORD @D3423, PRD @D3422, AGR [CASE @D3421, COUNT @D3420, PER 
               @D3419, PLU @D3418, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM AT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3429, PRD @D3428, 
      AGR [CASE @D3427, COUNT @D3426, PER @D3425, PLU @D3424, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP AT, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   
   [COORD @D3435, PRD @D3434, AGR [CASE @D3433, COUNT @D3432, PER @D3431, 
            PLU @D3430, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3441, PRD @D3440, AGR [CASE @D3439, COUNT @D3438, 
            PER @D3437, PLU @D3436, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3447, PRD @D3446, 
      AGR [CASE @D3445, COUNT @D3444, PER @D3443, PLU @D3442, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3453, PRD @D3452, 
      AGR [CASE @D3451, COUNT @D3450, PER @D3449, PLU @D3448, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   [COORD @D3459, PRD @D3458, 
      AGR [CASE @D3457, COUNT @D3456, PER @D3455, PLU @D3454, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : AIM, 
   
   [COORD @D3465, PRD @D3464, AGR [CASE @D3463, COUNT @D3462, PER @D3461, 
            PLU @D3460, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : AIM, 
   [COORD @D3471, PRD @D3470, AGR [CASE @D3469, COUNT @D3468, 
            PER @D3467, PLU @D3466, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : AIM.

WORD aims : 
   [COORD @D3481, DEMON @D3480, REFL @D3479, PRD @D3478, CASE @D3477, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : AIM, 
   [COORD @D3483, 
      AGR [COUNT @D3482, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM AT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3485, 
      AGR [COUNT @D3484, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP AT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3487, 
      AGR [COUNT @D3486, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3489, 
      AGR [COUNT @D3488, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3491, 
      AGR [COUNT @D3490, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3493, 
      AGR [COUNT @D3492, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3495, 
      AGR [COUNT @D3494, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3497, 
      AGR [COUNT @D3496, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM, 
   [COORD @D3499, 
      AGR [COUNT @D3498, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AIM.

WORD alarm : 
   [COORD @D3507, REFL @D3506, COUNT @D3505, PRD @D3504, CASE @D3503, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ALARM, 
   [COORD @D3510, 
      AGR [COUNT @D3509, PER @D3508, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ALARM, 
   [COORD @D3512, AGR [COUNT @D3511, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ALARM, 
   [COORD @D3514, AGR [COUNT @D3513, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ALARM, 
   [COORD @D3518, AGR [COUNT @D3517, PER @D3516, PLU @D3515, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : ALARM, 
   [COORD @D3524, PAST @D3523, AGR [CASE @D3522, COUNT @D3521, 
            PER @D3520, PLU @D3519, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : ALARM.

WORD alarmed : 
   [COORD @D3534, AGR [CASE @D3533, COUNT @D3532, PER @D3531, 
            PLU @D3530, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ALARM, 
   [COORD @D3539, AGR [CASE @D3538, COUNT @D3537, PER @D3536, 
            PLU @D3535, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALARM, 
   [COORD @D3544, AGR [CASE @D3543, COUNT @D3542, PER @D3541, 
            PLU @D3540, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ALARM.

WORD alarming : 
   [COORD @D3559, PRD @D3558, AGR [CASE @D3557, COUNT @D3556, 
            PER @D3555, PLU @D3554, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ALARM.

WORD alarms : 
   [COORD @D3569, DEMON @D3568, REFL @D3567, PRD @D3566, CASE @D3565, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ALARM, 
   [COORD @D3571, 
      AGR [COUNT @D3570, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALARM.

WORD allow : 
   [COORD @D3578, AGR [COUNT @D3577, PER @D3576, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3580, AGR [COUNT @D3579, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : ALLOW, 
   [COORD @D3582, 
      AGR [COUNT @D3581, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : ALLOW, 
   [COORD @D3586, 
      AGR [COUNT @D3585, PER @D3584, PLU @D3583, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3592, PAST @D3591, AGR [CASE @D3590, COUNT @D3589, 
            PER @D3588, PLU @D3587, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_NP, LAT -, ARITY 3] : ALLOW, 
   [COORD @D3595, AGR [COUNT @D3594, PER @D3593, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_LOC, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3597, AGR [COUNT @D3596, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_LOC, LAT -, ARITY 3] : ALLOW, 
   
   [COORD @D3599, AGR [COUNT @D3598, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_LOC, LAT -, ARITY 3] : ALLOW, 
   
   [COORD @D3603, AGR [COUNT @D3602, PER @D3601, PLU @D3600, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_LOC, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3609, PAST @D3608, AGR [CASE @D3607, COUNT @D3606, 
            PER @D3605, PLU @D3604, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_LOC, LAT -, ARITY 3] : ALLOW, 
   [COORD @D3612, AGR [COUNT @D3611, PER @D3610, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ALLOW, 
   [COORD @D3614, AGR [COUNT @D3613, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3616, AGR [COUNT @D3615, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ALLOW, 
   [COORD @D3620, AGR [COUNT @D3619, PER @D3618, PLU @D3617, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ALLOW, 
   [COORD @D3626, PAST @D3625, AGR [CASE @D3624, COUNT @D3623, 
            PER @D3622, PLU @D3621, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM FOR, LAT -, ARITY 3] : ALLOW, 
   [COORD @D3629, AGR [COUNT @D3628, PER @D3627, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, 
      PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3631, AGR [COUNT @D3630, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, PREP FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3633, AGR [COUNT @D3632, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, PREP FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3637, AGR [COUNT @D3636, PER @D3635, PLU @D3634, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT WHS, 
      PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3643, PAST @D3642, AGR [CASE @D3641, COUNT @D3640, 
            PER @D3639, PLU @D3638, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT WHS, PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3646, 
      AGR [COUNT @D3645, PER @D3644, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, PREP FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3648, AGR [COUNT @D3647, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3650, AGR [COUNT @D3649, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3654, AGR [COUNT @D3653, PER @D3652, PLU @D3651, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP FOR, ARITY 2] : ALLOW, 
   [COORD @D3660, PAST @D3659, 
      AGR [CASE @D3658, COUNT @D3657, PER @D3656, PLU @D3655, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, PREP FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3663, AGR [COUNT @D3662, PER @D3661, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ALLOW, 
   [COORD @D3665, AGR [COUNT @D3664, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ALLOW, 
   [COORD @D3667, AGR [COUNT @D3666, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ALLOW, 
   [COORD @D3671, AGR [COUNT @D3670, PER @D3669, PLU @D3668, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM OF, ARITY 2] : ALLOW, 
   [COORD @D3677, PAST @D3676, AGR [CASE @D3675, COUNT @D3674, 
            PER @D3673, PLU @D3672, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM OF, ARITY 2] : ALLOW, 
   [COORD @D3680, 
      AGR [COUNT @D3679, PER @D3678, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3682, AGR [COUNT @D3681, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3684, AGR [COUNT @D3683, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3688, AGR [COUNT @D3687, PER @D3686, PLU @D3685, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3694, PAST @D3693, AGR [CASE @D3692, COUNT @D3691, 
            PER @D3690, PLU @D3689, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3697, 
      AGR [COUNT @D3696, PER @D3695, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_INF, 
      PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3699, AGR [COUNT @D3698, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_INF, PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3701, AGR [COUNT @D3700, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_INF, PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3705, AGR [COUNT @D3704, PER @D3703, PLU @D3702, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_INF, PFORM FOR, ARITY 2] : ALLOW, 
   [COORD @D3711, PAST @D3710, 
      AGR [CASE @D3709, COUNT @D3708, PER @D3707, PLU @D3706, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_INF, PFORM FOR, 
      ARITY 2] : ALLOW, 
   [COORD @D3714, AGR [COUNT @D3713, PER @D3712, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, ARITY 2] : ALLOW, 
   [COORD @D3716, 
      AGR [COUNT @D3715, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, 
      PFORM FOR, ORDER PRENP, ARITY 2] : ALLOW, 
   [COORD @D3718, AGR [COUNT @D3717, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, ARITY 2] : ALLOW, 
   [COORD @D3722, 
      AGR [COUNT @D3721, PER @D3720, PLU @D3719, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, ARITY 2] : ALLOW, 
   [COORD @D3728, PAST @D3727, 
      AGR [CASE @D3726, COUNT @D3725, PER @D3724, PLU @D3723, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, 
      ORDER PRENP, ARITY 2] : ALLOW, 
   [COORD @D3731, AGR [COUNT @D3730, PER @D3729, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3733, AGR [COUNT @D3732, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3735, 
      AGR [COUNT @D3734, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3739, 
      AGR [COUNT @D3738, PER @D3737, PLU @D3736, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3745, PAST @D3744, AGR [CASE @D3743, COUNT @D3742, 
            PER @D3741, PLU @D3740, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3748, AGR [COUNT @D3747, PER @D3746, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3750, AGR [COUNT @D3749, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3752, AGR [COUNT @D3751, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3756, AGR [COUNT @D3755, PER @D3754, PLU @D3753, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3762, PAST @D3761, AGR [CASE @D3760, COUNT @D3759, 
            PER @D3758, PLU @D3757, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_NP, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3765, AGR [COUNT @D3764, PER @D3763, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3767, AGR [COUNT @D3766, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3769, AGR [COUNT @D3768, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3773, AGR [COUNT @D3772, PER @D3771, PLU @D3770, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3779, PAST @D3778, AGR [CASE @D3777, COUNT @D3776, 
            PER @D3775, PLU @D3774, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3782, AGR [COUNT @D3781, PER @D3780, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3784, AGR [COUNT @D3783, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3786, AGR [COUNT @D3785, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, ARITY 2] : 
   ALLOW, 
   [COORD @D3790, AGR [COUNT @D3789, PER @D3788, PLU @D3787, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3796, PAST @D3795, AGR [CASE @D3794, COUNT @D3793, 
            PER @D3792, PLU @D3791, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3799, AGR [COUNT @D3798, PER @D3797, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3801, AGR [COUNT @D3800, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3803, 
      AGR [COUNT @D3802, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ALLOW, 
   [COORD @D3807, 
      AGR [COUNT @D3806, PER @D3805, PLU @D3804, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ALLOW, 
   [COORD @D3813, PAST @D3812, AGR [CASE @D3811, COUNT @D3810, 
            PER @D3809, PLU @D3808, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ALLOW.

WORD allowed : 
   [COORD @D3823, AGR [CASE @D3822, COUNT @D3821, PER @D3820, 
            PLU @D3819, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALLOW, 
   [COORD @D3828, AGR [CASE @D3827, COUNT @D3826, PER @D3825, 
            PLU @D3824, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3833, AGR [CASE @D3832, COUNT @D3831, PER @D3830, 
            PLU @D3829, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3838, AGR [CASE @D3837, COUNT @D3836, PER @D3835, 
            PLU @D3834, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_LOC, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALLOW, 
   [COORD @D3843, AGR [CASE @D3842, COUNT @D3841, PER @D3840, 
            PLU @D3839, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_LOC, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3848, AGR [CASE @D3847, COUNT @D3846, PER @D3845, 
            PLU @D3844, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_LOC, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3853, AGR [CASE @D3852, COUNT @D3851, PER @D3850, 
            PLU @D3849, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3858, AGR [CASE @D3857, COUNT @D3856, PER @D3855, 
            PLU @D3854, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3863, AGR [CASE @D3862, COUNT @D3861, PER @D3860, 
            PLU @D3859, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3868, AGR [CASE @D3867, COUNT @D3866, PER @D3865, 
            PLU @D3864, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3873, AGR [CASE @D3872, COUNT @D3871, PER @D3870, 
            PLU @D3869, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3878, AGR [CASE @D3877, COUNT @D3876, PER @D3875, 
            PLU @D3874, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3883, AGR [CASE @D3882, COUNT @D3881, PER @D3880, 
            PLU @D3879, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3888, AGR [CASE @D3887, COUNT @D3886, PER @D3885, 
            PLU @D3884, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM OF, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3893, AGR [CASE @D3892, COUNT @D3891, PER @D3890, 
            PLU @D3889, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3898, AGR [CASE @D3897, COUNT @D3896, PER @D3895, 
            PLU @D3894, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3903, AGR [CASE @D3902, COUNT @D3901, PER @D3900, 
            PLU @D3899, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3908, AGR [CASE @D3907, COUNT @D3906, PER @D3905, 
            PLU @D3904, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3913, AGR [CASE @D3912, COUNT @D3911, PER @D3910, 
            PLU @D3909, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ALLOW, 
   [COORD @D3918, AGR [CASE @D3917, COUNT @D3916, PER @D3915, 
            PLU @D3914, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_INF, CONJ NULL, SUBTYPE PVERB_OR, PFORM FOR, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3923, AGR [CASE @D3922, COUNT @D3921, PER @D3920, 
            PLU @D3919, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_INF, PFORM FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3928, AGR [CASE @D3927, COUNT @D3926, PER @D3925, 
            PLU @D3924, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_INF, PFORM FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3933, AGR [CASE @D3932, COUNT @D3931, PER @D3930, 
            PLU @D3929, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_ING, CONJ NULL, SUBTYPE PVERB_OR, PFORM FOR, ORDER PRENP, 
      AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3938, AGR [CASE @D3937, COUNT @D3936, PER @D3935, 
            PLU @D3934, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, 
      PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3943, 
      AGR [CASE @D3942, COUNT @D3941, PER @D3940, PLU @D3939, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, 
      INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, 
      AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3948, AGR [UB @D3947, VFORM @D3946, SUBJ @D3945, FIN @D3944, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3953, 
      AGR [CASE @D3952, COUNT @D3951, PER @D3950, PLU @D3949, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3958, 
      AGR [CASE @D3957, COUNT @D3956, PER @D3955, PLU @D3954, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3963, 
      AGR [CASE @D3962, COUNT @D3961, PER @D3960, PLU @D3959, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT OC_NP, CONJ NULL, 
      SUBTYPE RAIS, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3968, 
      AGR [CASE @D3967, COUNT @D3966, PER @D3965, PLU @D3964, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3973, 
      AGR [CASE @D3972, COUNT @D3971, PER @D3970, PLU @D3969, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3979, 
      AGR [CASE @D3978, NFORM @D3977, COUNT @D3976, PER @D3975, 
            PLU @D3974, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALLOW, 
   [COORD @D3984, AGR [UB @D3983, VFORM @D3982, SUBJ @D3981, FIN @D3980, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3989, 
      AGR [CASE @D3988, COUNT @D3987, PER @D3986, PLU @D3985, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3994, 
      AGR [CASE @D3993, COUNT @D3992, PER @D3991, PLU @D3990, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D3999, 
      AGR [CASE @D3998, COUNT @D3997, PER @D3996, PLU @D3995, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4004, 
      AGR [CASE @D4003, COUNT @D4002, PER @D4001, PLU @D4000, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4010, 
      AGR [CASE @D4009, NFORM @D4008, COUNT @D4007, PER @D4006, 
            PLU @D4005, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALLOW, 
   [COORD @D4015, AGR [UB @D4014, VFORM @D4013, SUBJ @D4012, FIN @D4011, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4020, 
      AGR [CASE @D4019, COUNT @D4018, PER @D4017, PLU @D4016, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4025, 
      AGR [CASE @D4024, COUNT @D4023, PER @D4022, PLU @D4021, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4030, 
      AGR [CASE @D4029, COUNT @D4028, PER @D4027, PLU @D4026, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ALLOW.

WORD allowing : 
   [COORD @D4043, PRD @D4042, AGR [CASE @D4041, COUNT @D4040, 
            PER @D4039, PLU @D4038, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4049, PRD @D4048, AGR 
         [CASE @D4047, COUNT @D4046, PER @D4045, PLU @D4044, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_LOC, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4055, PRD @D4054, 
      AGR [CASE @D4053, COUNT @D4052, PER @D4051, PLU @D4050, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ALLOW, 
   [COORD @D4061, PRD @D4060, AGR [CASE @D4059, COUNT @D4058, PER 
               @D4057, PLU @D4056, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT WHS, PREP FOR, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4067, PRD @D4066, 
      AGR [CASE @D4065, COUNT @D4064, PER @D4063, PLU @D4062, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ALLOW, 
   [COORD @D4073, PRD @D4072, AGR [CASE @D4071, COUNT @D4070, PER 
               @D4069, PLU @D4068, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM OF, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4079, PRD @D4078, 
      AGR [CASE @D4077, COUNT @D4076, PER @D4075, PLU @D4074, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ALLOW, 
   [COORD @D4085, PRD @D4084, AGR [CASE @D4083, COUNT @D4082, 
            PER @D4081, PLU @D4080, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_INF, 
      PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4091, PRD @D4090, 
      AGR [CASE @D4089, COUNT @D4088, PER @D4087, PLU @D4086, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4097, PRD @D4096, AGR 
         [CASE @D4095, COUNT @D4094, PER @D4093, PLU @D4092, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4103, PRD @D4102, 
      AGR [CASE @D4101, COUNT @D4100, PER @D4099, PLU @D4098, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4109, PRD @D4108, 
      AGR [CASE @D4107, COUNT @D4106, PER @D4105, PLU @D4104, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4115, PRD @D4114, 
      AGR [CASE @D4113, COUNT @D4112, PER @D4111, PLU @D4110, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4121, PRD @D4120, 
      AGR [CASE @D4119, COUNT @D4118, PER @D4117, PLU @D4116, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ALLOW.

WORD allows : 
   [COORD @D4128, AGR [COUNT @D4127, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4130, 
      AGR [COUNT @D4129, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_LOC, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4132, 
      AGR [COUNT @D4131, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4134, 
      AGR [COUNT @D4133, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, PREP FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4136, 
      AGR [COUNT @D4135, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4138, 
      AGR [COUNT @D4137, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4140, 
      AGR [COUNT @D4139, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4142, 
      AGR [COUNT @D4141, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_INF, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ALLOW, 
   [COORD @D4144, AGR [COUNT @D4143, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM FOR, ORDER PRENP, AUX -, 
      INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4146, AGR [COUNT @D4145, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4148, 
      AGR [COUNT @D4147, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4150, 
      AGR [COUNT @D4149, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4152, 
      AGR [COUNT @D4151, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW, 
   [COORD @D4154, 
      AGR [COUNT @D4153, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ALLOW.

WORD amnesties : 
   [COORD @D4165, DEMON @D4164, REFL @D4163, PRD @D4162, CASE @D4161, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : AMNESTY.

WORD amnesty : 
   [COORD @D4175, REFL @D4174, COUNT @D4173, PRD @D4172, CASE @D4171, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : AMNESTY.

WORD amount : 
   [COORD @D4183, REFL @D4182, PRD @D4181, CASE @D4180, FIX NOT, BAR 0, 
      SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, COUNT +] : AMOUNT, 
   [COORD @D4186, AGR [COUNT @D4185, PER @D4184, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM TO, ARITY 2] : AMOUNT, 
   [COORD @D4188, AGR [COUNT @D4187, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      ARITY 2] : AMOUNT, 
   [COORD @D4190, AGR [COUNT @D4189, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      ARITY 2] : AMOUNT, 
   [COORD @D4194, AGR [COUNT @D4193, PER @D4192, PLU @D4191, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM TO, ARITY 2] : AMOUNT, 
   [COORD @D4200, PAST @D4199, AGR [CASE @D4198, COUNT @D4197, 
            PER @D4196, PLU @D4195, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM TO, ARITY 2] : AMOUNT.

WORD amounted : 
   [COORD @D4211, AGR [CASE @D4210, COUNT @D4209, PER @D4208, 
            PLU @D4207, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : AMOUNT, 
   [COORD @D4216, AGR [CASE @D4215, COUNT @D4214, PER @D4213, 
            PLU @D4212, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : AMOUNT.

WORD amounting : 
   [COORD @D4232, PRD @D4231, AGR [CASE @D4230, COUNT @D4229, 
            PER @D4228, PLU @D4227, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : AMOUNT.

WORD amounts : 
   [COORD @D4243, DEMON @D4242, REFL @D4241, PRD @D4240, CASE @D4239, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : AMOUNT, 
   [COORD @D4245, 
      AGR [COUNT @D4244, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : AMOUNT.

WORD anger : 
   [COORD @D4254, REFL @D4253, PRD @D4252, CASE @D4251, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, COUNT -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : ANGER, 
   [COORD @D4257, AGR [COUNT @D4256, PER @D4255, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : ANGER, 
   [COORD @D4259, AGR [COUNT @D4258, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ANGER, 
   [COORD @D4261, AGR [COUNT @D4260, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ANGER, 
   [COORD @D4265, AGR [COUNT @D4264, PER @D4263, PLU @D4262, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : ANGER, 
   [COORD @D4271, PAST @D4270, AGR [CASE @D4269, COUNT @D4268, 
            PER @D4267, PLU @D4266, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : ANGER, 
   [COORD @D4274, AGR [COUNT @D4273, PER @D4272, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : ANGER, 
   [COORD @D4276, AGR [COUNT @D4275, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   ANGER, 
   [COORD @D4278, AGR [COUNT @D4277, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   ANGER, 
   [COORD @D4282, AGR [COUNT @D4281, PER @D4280, PLU @D4279, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : ANGER, 
   [COORD @D4288, PAST @D4287, AGR [CASE @D4286, COUNT @D4285, 
            PER @D4284, PLU @D4283, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : ANGER.

WORD angered : 
   [COORD @D4300, AGR [CASE @D4299, COUNT @D4298, PER @D4297, 
            PLU @D4296, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ANGER, 
   [COORD @D4305, AGR [CASE @D4304, COUNT @D4303, PER @D4302, 
            PLU @D4301, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ANGER, 
   [COORD @D4310, AGR [CASE @D4309, COUNT @D4308, PER @D4307, 
            PLU @D4306, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ANGER, 
   [COORD @D4315, AGR [CASE @D4314, COUNT @D4313, PER @D4312, 
            PLU @D4311, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANGER, 
   [COORD @D4320, AGR [CASE @D4319, COUNT @D4318, PER @D4317, 
            PLU @D4316, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ANGER.

WORD angering : 
   [COORD @D4335, PRD @D4334, AGR [CASE @D4333, COUNT @D4332, 
            PER @D4331, PLU @D4330, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ANGER, 
   [COORD @D4341, PRD @D4340, AGR 
         [CASE @D4339, COUNT @D4338, PER @D4337, PLU @D4336, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANGER.

WORD angers : 
   [COORD @D4350, AGR [COUNT @D4349, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANGER, 
   [COORD @D4352, 
      AGR [COUNT @D4351, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANGER.

WORD announce : 
   [COORD @D4361, AGR [COUNT @D4360, PER @D4359, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, 
      PFORM TO, LAT -, ARITY 3] : ANNOUNCE, 
   [COORD @D4363, AGR [COUNT @D4362, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM TO, LAT -, 
      ARITY 3] : ANNOUNCE, 
   [COORD @D4365, AGR [COUNT @D4364, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM TO, LAT -, 
      ARITY 3] : ANNOUNCE, 
   [COORD @D4369, AGR [COUNT @D4368, PER @D4367, PLU @D4366, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, 
      PFORM TO, LAT -, ARITY 3] : ANNOUNCE, 
   [COORD @D4375, PAST @D4374, AGR 
         [CASE @D4373, COUNT @D4372, PER @D4371, PLU @D4370, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM TO, LAT -, ARITY 3] : 
   ANNOUNCE, 
   [COORD @D4378, AGR [COUNT @D4377, PER @D4376, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ANNOUNCE, 
   [COORD @D4380, AGR [COUNT @D4379, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ANNOUNCE, 
   [COORD @D4382, AGR [COUNT @D4381, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ANNOUNCE, 
   [COORD @D4386, AGR [COUNT @D4385, PER @D4384, PLU @D4383, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ANNOUNCE, 
   [COORD @D4392, PAST @D4391, AGR [CASE @D4390, COUNT @D4389, 
            PER @D4388, PLU @D4387, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ANNOUNCE, 
   [COORD @D4395, AGR 
         [COUNT @D4394, PER @D4393, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : 
   ANNOUNCE, 
   [COORD @D4397, AGR [COUNT @D4396, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : 
   ANNOUNCE, 
   [COORD @D4399, AGR [COUNT @D4398, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : 
   ANNOUNCE, 
   [COORD @D4403, AGR [COUNT @D4402, PER @D4401, PLU @D4400, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ANNOUNCE, 
   [COORD @D4409, PAST @D4408, AGR [CASE @D4407, COUNT @D4406, 
            PER @D4405, PLU @D4404, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ANNOUNCE, 
   [COORD @D4412, AGR [COUNT @D4411, PER @D4410, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ANNOUNCE, 
   [COORD @D4414, AGR [COUNT @D4413, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ANNOUNCE, 
   [COORD @D4416, 
      AGR [COUNT @D4415, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ANNOUNCE, 
   [COORD @D4420, 
      AGR [COUNT @D4419, PER @D4418, PLU @D4417, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ANNOUNCE, 
   [COORD @D4426, PAST @D4425, AGR [CASE @D4424, COUNT @D4423, 
            PER @D4422, PLU @D4421, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ANNOUNCE.

WORD announced : 
   [COORD @D4438, AGR [CASE @D4437, COUNT @D4436, PER @D4435, 
            PLU @D4434, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4443, AGR [CASE @D4442, COUNT @D4441, PER @D4440, 
            PLU @D4439, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4448, AGR [CASE @D4447, COUNT @D4446, PER @D4445, 
            PLU @D4444, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4453, AGR [CASE @D4452, COUNT @D4451, PER @D4450, 
            PLU @D4449, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4458, AGR [CASE @D4457, COUNT @D4456, PER @D4455, 
            PLU @D4454, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4463, AGR [CASE @D4462, COUNT @D4461, PER @D4460, 
            PLU @D4459, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4468, AGR [CASE @D4467, COUNT @D4466, PER @D4465, 
            PLU @D4464, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4473, AGR [UB @D4472, VFORM @D4471, SUBJ @D4470, FIN @D4469, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ANNOUNCE, 
   [COORD @D4478, AGR [CASE @D4477, COUNT @D4476, PER @D4475, 
            PLU @D4474, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ANNOUNCE, 
   [COORD @D4483, AGR [CASE @D4482, COUNT @D4481, PER @D4480, 
            PLU @D4479, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ANNOUNCE, 
   [COORD @D4488, AGR [CASE @D4487, COUNT @D4486, PER @D4485, 
            PLU @D4484, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ANNOUNCE.

WORD announces : 
   [COORD @D4497, AGR [COUNT @D4496, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ANNOUNCE, 
   [COORD @D4499, AGR [COUNT @D4498, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANNOUNCE, 
   
   [COORD @D4501, AGR [COUNT @D4500, NFORM NORM, PLU -, PER 3, CASE NOM, N 
            +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4503, 
      AGR [COUNT @D4502, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANNOUNCE.

WORD announcing : 
   [COORD @D4516, PRD @D4515, AGR [CASE @D4514, COUNT @D4513, 
            PER @D4512, PLU @D4511, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, 
      PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4522, PRD @D4521, 
      AGR [CASE @D4520, COUNT @D4519, PER @D4518, PLU @D4517, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ANNOUNCE, 
   [COORD @D4528, PRD @D4527, AGR [CASE @D4526, COUNT @D4525, 
            PER @D4524, PLU @D4523, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ANNOUNCE, 
   [COORD @D4534, PRD @D4533, 
      AGR [CASE @D4532, COUNT @D4531, PER @D4530, PLU @D4529, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANNOUNCE.

WORD answer : 
   [COORD @D4544, REFL @D4543, COUNT @D4542, PRD @D4541, CASE @D4540, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ANSWER, 
   [COORD @D4549, REFL @D4548, COUNT @D4547, PRD @D4546, CASE @D4545, 
      FIX NOT, INFL +, BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO] : ANSWER, 
   [COORD @D4552, 
      AGR [COUNT @D4551, PER @D4550, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, ARITY 3] : 
   ANSWER, 
   [COORD @D4554, AGR [COUNT @D4553, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, ARITY 3] : 
   ANSWER, 
   [COORD @D4556, AGR [COUNT @D4555, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, ARITY 3] : 
   ANSWER, 
   [COORD @D4560, AGR [COUNT @D4559, PER @D4558, PLU @D4557, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_NP, ARITY 3] : ANSWER, 
   [COORD @D4566, PAST @D4565, AGR [CASE @D4564, COUNT @D4563, 
            PER @D4562, PLU @D4561, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP_NP, ARITY 3] : ANSWER, 
   [COORD @D4569, AGR [COUNT @D4568, PER @D4567, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM WITH, ARITY 3] : ANSWER, 
   [COORD @D4571, AGR [COUNT @D4570, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : ANSWER, 
   [COORD @D4573, AGR [COUNT @D4572, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : ANSWER, 
   [COORD @D4577, AGR [COUNT @D4576, PER @D4575, PLU @D4574, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM WITH, ARITY 3] : ANSWER, 
   [COORD @D4583, PAST @D4582, 
      AGR [CASE @D4581, COUNT @D4580, PER @D4579, PLU @D4578, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : ANSWER, 
   [COORD @D4586, AGR [COUNT @D4585, PER @D4584, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_TO, ARITY 3] : ANSWER, 
   [COORD @D4588, AGR [COUNT @D4587, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_TO, ARITY 3] : ANSWER, 
   [COORD @D4590, AGR [COUNT @D4589, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_TO, ARITY 3] : ANSWER, 
   [COORD @D4594, AGR [COUNT @D4593, PER @D4592, PLU @D4591, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_TO, ARITY 3] : ANSWER, 
   [COORD @D4600, PAST @D4599, 
      AGR [CASE @D4598, COUNT @D4597, PER @D4596, PLU @D4595, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, 
      ARITY 3] : ANSWER, 
   [COORD @D4603, AGR [COUNT @D4602, PER @D4601, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM FOR, ARITY 3] : ANSWER, 
   [COORD @D4605, AGR [COUNT @D4604, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      PFORM FOR, ARITY 3] : ANSWER, 
   [COORD @D4607, AGR [COUNT @D4606, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      PFORM FOR, ARITY 3] : ANSWER, 
   [COORD @D4611, AGR [COUNT @D4610, PER @D4609, PLU @D4608, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM FOR, ARITY 3] : ANSWER, 
   [COORD @D4617, PAST @D4616, 
      AGR [CASE @D4615, COUNT @D4614, PER @D4613, PLU @D4612, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM FOR, ARITY 3] : 
   ANSWER, 
   [COORD @D4620, AGR [COUNT @D4619, PER @D4618, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SFIN, ARITY 2] : ANSWER, 
   [COORD @D4622, AGR [COUNT @D4621, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SFIN, ARITY 2] : 
   ANSWER, 
   [COORD @D4624, AGR [COUNT @D4623, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SFIN, ARITY 2] : 
   ANSWER, 
   [COORD @D4628, AGR [COUNT @D4627, PER @D4626, PLU @D4625, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SFIN, ARITY 2] : ANSWER, 
   [COORD @D4634, PAST @D4633, AGR [CASE @D4632, COUNT @D4631, 
            PER @D4630, PLU @D4629, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT SFIN, ARITY 2] : ANSWER, 
   [COORD @D4637, AGR [COUNT @D4636, PER @D4635, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : ANSWER, 
   [COORD @D4639, AGR [COUNT @D4638, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ANSWER, 
   [COORD @D4641, AGR [COUNT @D4640, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   ANSWER, 
   [COORD @D4645, AGR [COUNT @D4644, PER @D4643, PLU @D4642, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : ANSWER, 
   [COORD @D4651, PAST @D4650, AGR [CASE @D4649, COUNT @D4648, 
            PER @D4647, PLU @D4646, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : ANSWER, 
   [COORD @D4654, AGR [COUNT @D4653, PER @D4652, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM WITH, ARITY 2] : ANSWER, 
   [COORD @D4656, AGR [COUNT @D4655, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      ARITY 2] : ANSWER, 
   [COORD @D4658, AGR [COUNT @D4657, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      ARITY 2] : ANSWER, 
   [COORD @D4662, AGR [COUNT @D4661, PER @D4660, PLU @D4659, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM WITH, ARITY 2] : ANSWER, 
   [COORD @D4668, PAST @D4667, AGR [CASE @D4666, COUNT @D4665, 
            PER @D4664, PLU @D4663, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM WITH, ARITY 2] : ANSWER, 
   [COORD @D4671, 
      AGR [COUNT @D4670, PER @D4669, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      ARITY 2] : ANSWER, 
   [COORD @D4673, AGR [COUNT @D4672, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      ARITY 2] : ANSWER, 
   [COORD @D4675, AGR [COUNT @D4674, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      ARITY 2] : ANSWER, 
   [COORD @D4679, AGR [COUNT @D4678, PER @D4677, PLU @D4676, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM TO, ARITY 2] : ANSWER, 
   [COORD @D4685, PAST @D4684, AGR [CASE @D4683, COUNT @D4682, 
            PER @D4681, PLU @D4680, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM TO, ARITY 2] : ANSWER, 
   [COORD @D4688, 
      AGR [COUNT @D4687, PER @D4686, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, 
      ARITY 2] : ANSWER, 
   [COORD @D4690, AGR [COUNT @D4689, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ANSWER, 
   [COORD @D4692, AGR [COUNT @D4691, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ANSWER, 
   [COORD @D4696, AGR [COUNT @D4695, PER @D4694, PLU @D4693, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ANSWER, 
   [COORD @D4702, PAST @D4701, AGR [CASE @D4700, COUNT @D4699, 
            PER @D4698, PLU @D4697, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, ARITY 2] : ANSWER, 
   [COORD @D4705, 
      AGR [COUNT @D4704, PER @D4703, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT BACK, 
      ARITY 2] : ANSWER, 
   [COORD @D4707, AGR [COUNT @D4706, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT BACK, 
      ARITY 2] : ANSWER, 
   [COORD @D4709, AGR [COUNT @D4708, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT BACK, 
      ARITY 2] : ANSWER, 
   [COORD @D4713, AGR [COUNT @D4712, PER @D4711, PLU @D4710, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT BACK, ARITY 2] : ANSWER, 
   [COORD @D4719, PAST @D4718, AGR [CASE @D4717, COUNT @D4716, 
            PER @D4715, PLU @D4714, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT BACK, ARITY 2] : ANSWER, 
   [COORD @D4722, AGR [COUNT @D4721, PER @D4720, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : ANSWER, 
   [COORD @D4724, AGR [COUNT @D4723, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   ANSWER, 
   [COORD @D4726, AGR [COUNT @D4725, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   ANSWER, 
   [COORD @D4730, AGR [COUNT @D4729, PER @D4728, PLU @D4727, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : ANSWER, 
   [COORD @D4736, PAST @D4735, AGR [CASE @D4734, COUNT @D4733, 
            PER @D4732, PLU @D4731, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : ANSWER, 
   [COORD @D4739, AGR [COUNT @D4738, PER @D4737, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT BACK, ARITY 1] : ANSWER, 
   [COORD @D4741, AGR [COUNT @D4740, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT BACK, 
      ARITY 1] : ANSWER, 
   [COORD @D4743, AGR [COUNT @D4742, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT BACK, 
      ARITY 1] : ANSWER, 
   [COORD @D4747, AGR [COUNT @D4746, PER @D4745, PLU @D4744, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT BACK, ARITY 1] : ANSWER, 
   [COORD @D4753, PAST @D4752, 
      AGR [CASE @D4751, COUNT @D4750, PER @D4749, PLU @D4748, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT BACK, ARITY 1] : 
   ANSWER.

WORD answered : 
   [COORD @D4765, AGR [CASE @D4764, COUNT @D4763, PER @D4762, 
            PLU @D4761, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ANSWER, 
   [COORD @D4770, AGR [CASE @D4769, COUNT @D4768, PER @D4767, 
            PLU @D4766, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4775, AGR [CASE @D4774, COUNT @D4773, PER @D4772, 
            PLU @D4771, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4780, AGR [CASE @D4779, COUNT @D4778, PER @D4777, 
            PLU @D4776, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4785, AGR [CASE @D4784, COUNT @D4783, PER @D4782, 
            PLU @D4781, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4790, AGR [CASE @D4789, COUNT @D4788, PER @D4787, 
            PLU @D4786, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4795, AGR [CASE @D4794, COUNT @D4793, PER @D4792, 
            PLU @D4791, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4800, AGR [CASE @D4799, COUNT @D4798, PER @D4797, 
            PLU @D4796, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4805, AGR [CASE @D4804, COUNT @D4803, PER @D4802, 
            PLU @D4801, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE DMOVT, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4810, AGR [CASE @D4809, COUNT @D4808, PER @D4807, 
            PLU @D4806, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4815, AGR [CASE @D4814, COUNT @D4813, PER @D4812, 
            PLU @D4811, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4820, AGR [CASE @D4819, COUNT @D4818, PER @D4817, 
            PLU @D4816, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4825, AGR [CASE @D4824, COUNT @D4823, PER @D4822, 
            PLU @D4821, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4830, AGR [UB @D4829, VFORM @D4828, SUBJ @D4827, FIN @D4826, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4835, 
      AGR [CASE @D4834, COUNT @D4833, PER @D4832, PLU @D4831, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4840, 
      AGR [CASE @D4839, COUNT @D4838, PER @D4837, PLU @D4836, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4845, 
      AGR [CASE @D4844, COUNT @D4843, PER @D4842, PLU @D4841, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4850, 
      AGR [CASE @D4849, COUNT @D4848, PER @D4847, PLU @D4846, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ANSWER, 
   [COORD @D4855, AGR [CASE @D4854, COUNT @D4853, PER @D4852, 
            PLU @D4851, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4860, AGR [CASE @D4859, COUNT @D4858, PER @D4857, 
            PLU @D4856, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4865, AGR [CASE @D4864, COUNT @D4863, PER @D4862, 
            PLU @D4861, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4870, AGR [CASE @D4869, COUNT @D4868, PER @D4867, 
            PLU @D4866, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4875, AGR [CASE @D4874, COUNT @D4873, PER @D4872, 
            PLU @D4871, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4880, AGR [CASE @D4879, COUNT @D4878, PER @D4877, 
            PLU @D4876, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4885, AGR [CASE @D4884, COUNT @D4883, PER @D4882, 
            PLU @D4881, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT BACK, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4890, AGR [CASE @D4889, COUNT @D4888, PER @D4887, 
            PLU @D4886, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT BACK, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4895, AGR [CASE @D4894, COUNT @D4893, PER @D4892, 
            PLU @D4891, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT BACK, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4900, AGR [CASE @D4899, COUNT @D4898, PER @D4897, 
            PLU @D4896, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4905, AGR [CASE @D4904, COUNT @D4903, PER @D4902, 
            PLU @D4901, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ANSWER, 
   [COORD @D4910, AGR [CASE @D4909, COUNT @D4908, PER @D4907, 
            PLU @D4906, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT BACK, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4915, AGR [CASE @D4914, COUNT @D4913, PER @D4912, 
            PLU @D4911, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT BACK, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ANSWER.

WORD answering : 
   [COORD @D4932, PRD @D4931, AGR [CASE @D4930, COUNT @D4929, 
            PER @D4928, PLU @D4927, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4938, PRD @D4937, 
      AGR [CASE @D4936, COUNT @D4935, PER @D4934, PLU @D4933, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ANSWER, 
   [COORD @D4944, PRD @D4943, AGR [CASE @D4942, COUNT @D4941, PER 
               @D4940, PLU @D4939, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4950, PRD @D4949, 
      AGR [CASE @D4948, COUNT @D4947, PER @D4946, PLU @D4945, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE DMOVT, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ANSWER, 
   [COORD @D4956, PRD @D4955, AGR [CASE @D4954, COUNT @D4953, 
            PER @D4952, PLU @D4951, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4962, PRD @D4961, 
      AGR [CASE @D4960, COUNT @D4959, PER @D4958, PLU @D4957, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4968, PRD @D4967, 
      AGR [CASE @D4966, COUNT @D4965, PER @D4964, PLU @D4963, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ANSWER, 
   [COORD @D4974, PRD @D4973, AGR [CASE @D4972, COUNT @D4971, PER 
               @D4970, PLU @D4969, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4980, PRD @D4979, 
      AGR [CASE @D4978, COUNT @D4977, PER @D4976, PLU @D4975, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ANSWER, 
   [COORD @D4986, PRD @D4985, AGR [CASE @D4984, COUNT @D4983, 
            PER @D4982, PLU @D4981, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT BACK, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4992, PRD @D4991, 
      AGR [CASE @D4990, COUNT @D4989, PER @D4988, PLU @D4987, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ANSWER, 
   [COORD @D4998, PRD @D4997, 
      AGR [CASE @D4996, COUNT @D4995, PER @D4994, PLU @D4993, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT BACK, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ANSWER.

WORD answers : 
   [COORD @D5010, DEMON @D5009, REFL @D5008, PRD @D5007, CASE @D5006, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ANSWER, 
   [COORD @D5015, DEMON @D5014, REFL @D5013, PRD @D5012, CASE @D5011, 
      COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, SUBCAT PP, 
      PFORM TO, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, 
      NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ANSWER, 
   [COORD @D5017, 
      AGR [COUNT @D5016, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5019, 
      AGR [COUNT @D5018, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ANSWER, 
   [COORD @D5021, AGR [COUNT @D5020, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : ANSWER, 
   [COORD @D5023, AGR [COUNT @D5022, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE DMOVT, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : ANSWER, 
   [COORD @D5025, AGR [COUNT @D5024, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5027, 
      AGR [COUNT @D5026, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5029, 
      AGR [COUNT @D5028, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5031, 
      AGR [COUNT @D5030, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5033, 
      AGR [COUNT @D5032, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5035, 
      AGR [COUNT @D5034, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT BACK, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5037, 
      AGR [COUNT @D5036, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER, 
   [COORD @D5039, 
      AGR [COUNT @D5038, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT BACK, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ANSWER.

WORD appeal : 
   [COORD @D5049, REFL @D5048, COUNT @D5047, PRD @D5046, CASE @D5045, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : APPEAL, 
   [COORD @D5052, 
      AGR [COUNT @D5051, PER @D5050, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_FOR, ARITY 3] : APPEAL, 
   [COORD @D5054, AGR [COUNT @D5053, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_FOR, ARITY 3] : APPEAL, 
   [COORD @D5056, AGR [COUNT @D5055, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_FOR, ARITY 3] : APPEAL, 
   [COORD @D5060, AGR [COUNT @D5059, PER @D5058, PLU @D5057, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT PP_PP, PFORM TO_FOR, ARITY 3] : APPEAL, 
   [COORD @D5066, PAST @D5065, 
      AGR [CASE @D5064, COUNT @D5063, PER @D5062, PLU @D5061, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, PFORM TO_FOR, 
      ARITY 3] : APPEAL, 
   [COORD @D5069, AGR [COUNT @D5068, PER @D5067, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT PP_PP, PFORM TO_AGAINST, ARITY 3] : APPEAL, 
   [COORD @D5071, AGR [COUNT @D5070, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_AGAINST, ARITY 3] : APPEAL, 
   [COORD @D5073, AGR [COUNT @D5072, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_AGAINST, ARITY 3] : APPEAL, 
   [COORD @D5077, AGR [COUNT @D5076, PER @D5075, PLU @D5074, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT PP_PP, PFORM TO_AGAINST, ARITY 3] : APPEAL, 
   [COORD @D5083, PAST @D5082, 
      AGR [CASE @D5081, COUNT @D5080, PER @D5079, PLU @D5078, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP_PP, PFORM TO_AGAINST, 
      ARITY 3] : APPEAL, 
   [COORD @D5086, AGR [COUNT @D5085, PER @D5084, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_PP_INF, PFORM TO, ARITY 3] : APPEAL, 
   [COORD @D5088, AGR [COUNT @D5087, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_PP_INF, 
      PFORM TO, ARITY 3] : APPEAL, 
   [COORD @D5090, AGR [COUNT @D5089, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_PP_INF, 
      PFORM TO, ARITY 3] : APPEAL, 
   [COORD @D5094, AGR [COUNT @D5093, PER @D5092, PLU @D5091, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_PP_INF, PFORM TO, ARITY 3] : APPEAL, 
   [COORD @D5100, PAST @D5099, 
      AGR [CASE @D5098, COUNT @D5097, PER @D5096, PLU @D5095, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_PP_INF, PFORM TO, 
      ARITY 3] : APPEAL, 
   [COORD @D5103, AGR [COUNT @D5102, PER @D5101, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : APPEAL, 
   [COORD @D5105, AGR [COUNT @D5104, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : APPEAL, 
   [COORD @D5107, AGR [COUNT @D5106, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : APPEAL, 
   [COORD @D5111, AGR [COUNT @D5110, PER @D5109, PLU @D5108, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : APPEAL, 
   [COORD @D5117, PAST @D5116, AGR [CASE @D5115, COUNT @D5114, 
            PER @D5113, PLU @D5112, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, ARITY 2] : APPEAL, 
   [COORD @D5120, 
      AGR [COUNT @D5119, PER @D5118, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      ARITY 2] : APPEAL, 
   [COORD @D5122, AGR [COUNT @D5121, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      ARITY 2] : APPEAL, 
   [COORD @D5124, AGR [COUNT @D5123, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      ARITY 2] : APPEAL, 
   [COORD @D5128, AGR [COUNT @D5127, PER @D5126, PLU @D5125, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM FOR, ARITY 2] : APPEAL, 
   [COORD @D5134, PAST @D5133, AGR [CASE @D5132, COUNT @D5131, 
            PER @D5130, PLU @D5129, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM FOR, ARITY 2] : APPEAL, 
   [COORD @D5137, 
      AGR [COUNT @D5136, PER @D5135, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, 
      ARITY 2] : APPEAL, 
   [COORD @D5139, AGR [COUNT @D5138, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, 
      ARITY 2] : APPEAL, 
   [COORD @D5141, AGR [COUNT @D5140, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM AGAINST, 
      ARITY 2] : APPEAL, 
   [COORD @D5145, AGR [COUNT @D5144, PER @D5143, PLU @D5142, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM AGAINST, ARITY 2] : APPEAL, 
   [COORD @D5151, PAST @D5150, AGR [CASE @D5149, COUNT @D5148, 
            PER @D5147, PLU @D5146, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM AGAINST, ARITY 2] : APPEAL, 
   [COORD @D5154, 
      AGR [COUNT @D5153, PER @D5152, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   APPEAL, 
   [COORD @D5156, AGR [COUNT @D5155, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   APPEAL, 
   [COORD @D5158, AGR [COUNT @D5157, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   APPEAL, 
   [COORD @D5162, AGR [COUNT @D5161, PER @D5160, PLU @D5159, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : APPEAL, 
   [COORD @D5168, PAST @D5167, AGR [CASE @D5166, COUNT @D5165, 
            PER @D5164, PLU @D5163, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : APPEAL.

WORD appealed : 
   [COORD @D5180, AGR [CASE @D5179, COUNT @D5178, PER @D5177, 
            PLU @D5176, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5185, AGR [CASE @D5184, COUNT @D5183, PER @D5182, 
            PLU @D5181, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5190, AGR [CASE @D5189, COUNT @D5188, PER @D5187, 
            PLU @D5186, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_AGAINST, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5195, AGR [CASE @D5194, COUNT @D5193, PER @D5192, 
            PLU @D5191, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_AGAINST, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5200, AGR [CASE @D5199, COUNT @D5198, PER @D5197, 
            PLU @D5196, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE EQUI, SUBCAT OC_PP_INF, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5205, AGR [CASE @D5204, COUNT @D5203, PER @D5202, 
            PLU @D5201, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE EQUI, SUBCAT OC_PP_INF, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5210, AGR [CASE @D5209, COUNT @D5208, PER @D5207, 
            PLU @D5206, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_INF, CONJ NULL, SUBTYPE EQUI, PFORM TO, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5215, AGR [CASE @D5214, COUNT @D5213, PER @D5212, 
            PLU @D5211, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5220, AGR [CASE @D5219, COUNT @D5218, PER @D5217, 
            PLU @D5216, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5225, AGR [CASE @D5224, COUNT @D5223, PER @D5222, 
            PLU @D5221, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAL, 
   [COORD @D5230, AGR [CASE @D5229, COUNT @D5228, PER @D5227, 
            PLU @D5226, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5235, AGR [CASE @D5234, COUNT @D5233, PER @D5232, 
            PLU @D5231, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5240, AGR [CASE @D5239, COUNT @D5238, PER @D5237, 
            PLU @D5236, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5245, AGR [CASE @D5244, COUNT @D5243, PER @D5242, 
            PLU @D5241, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5250, AGR [CASE @D5249, COUNT @D5248, PER @D5247, 
            PLU @D5246, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAL, 
   [COORD @D5255, AGR [CASE @D5254, COUNT @D5253, PER @D5252, 
            PLU @D5251, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPEAL.

WORD appealing : 
   [COORD @D5272, PRD @D5271, AGR [CASE @D5270, COUNT @D5269, 
            PER @D5268, PLU @D5267, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, 
      PFORM TO_FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5278, PRD @D5277, 
      AGR [CASE @D5276, COUNT @D5275, PER @D5274, PLU @D5273, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_PP, PFORM TO_AGAINST, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAL, 
   [COORD @D5284, PRD @D5283, AGR [CASE @D5282, COUNT @D5281, 
            PER @D5280, PLU @D5279, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, SUBCAT OC_PP_INF, 
      PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5290, PRD @D5289, 
      AGR [CASE @D5288, COUNT @D5287, PER @D5286, PLU @D5285, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAL, 
   [COORD @D5296, PRD @D5295, AGR [CASE @D5294, COUNT @D5293, 
            PER @D5292, PLU @D5291, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5302, PRD @D5301, 
      AGR [CASE @D5300, COUNT @D5299, PER @D5298, PLU @D5297, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   APPEAL, 
   [COORD @D5308, PRD @D5307, AGR [CASE @D5306, COUNT @D5305, PER 
               @D5304, PLU @D5303, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAL.

WORD appeals : 
   [COORD @D5320, DEMON @D5319, REFL @D5318, PRD @D5317, CASE @D5316, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : APPEAL, 
   [COORD @D5322, 
      AGR [COUNT @D5321, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAL, 
   [COORD @D5324, AGR [COUNT @D5323, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_PP, PFORM TO_AGAINST, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAL, 
   [COORD @D5326, AGR [COUNT @D5325, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, 
      SUBCAT OC_PP_INF, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAL, 
   [COORD @D5328, AGR [COUNT @D5327, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : APPEAL, 
   [COORD @D5330, AGR [COUNT @D5329, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAL, 
   [COORD @D5332, 
      AGR [COUNT @D5331, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM AGAINST, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAL, 
   [COORD @D5334, AGR [COUNT @D5333, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAL.

WORD appear : 
   [COORD @D5342, AGR [COUNT @D5341, PER @D5340, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5344, AGR [COUNT @D5343, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5346, 
      AGR [COUNT @D5345, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5350, 
      AGR [COUNT @D5349, PER @D5348, PLU @D5347, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5356, PAST @D5355, AGR [CASE @D5354, COUNT @D5353, 
            PER @D5352, PLU @D5351, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT LOC, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5358, AGR [COUNT @D5357, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM TO, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5360, AGR [COUNT @D5359, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM TO, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5364, AGR [NFORM @D5363, COUNT @D5362, PER @D5361, N +, V -, 
            BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM TO, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5368, AGR [COUNT @D5367, PER @D5366, PLU @D5365, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM TO, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5371, AGR @D5370, PAST @D5369, FIX NOT, V +, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_PP_INF, 
      PFORM TO, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5374, AGR [COUNT @D5373, PER @D5372, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : APPEAR, 
   [COORD @D5376, AGR [COUNT @D5375, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   APPEAR, 
   [COORD @D5378, AGR [COUNT @D5377, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   APPEAR, 
   [COORD @D5382, AGR [COUNT @D5381, PER @D5380, PLU @D5379, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : APPEAR, 
   [COORD @D5388, PAST @D5387, AGR [CASE @D5386, COUNT @D5385, 
            PER @D5384, PLU @D5383, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5391, AGR [COUNT @D5390, PER @D5389, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM BEFORE, 
      LAT -, ARITY 2] : APPEAR, 
   [COORD @D5393, AGR [COUNT @D5392, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM BEFORE, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5395, AGR [COUNT @D5394, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM BEFORE, LAT -, 
      ARITY 2] : APPEAR, 
   [COORD @D5399, AGR [COUNT @D5398, PER @D5397, PLU @D5396, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM BEFORE, 
      LAT -, ARITY 2] : APPEAR, 
   [COORD @D5405, PAST @D5404, AGR [CASE @D5403, COUNT @D5402, 
            PER @D5401, PLU @D5400, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM BEFORE, LAT -, ARITY 2] : APPEAR, 
   [COORD @D5407, AGR [COUNT @D5406, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, ARITY 1] : APPEAR, 
   
   [COORD @D5409, AGR [COUNT @D5408, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, ARITY 1] : APPEAR, 
   
   [COORD @D5413, AGR [NFORM @D5412, COUNT @D5411, PER @D5410, N +, V -, 
            BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5417, AGR [COUNT @D5416, PER @D5415, PLU @D5414, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_NP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5420, AGR @D5419, PAST @D5418, FIX NOT, V +, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_NP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5422, AGR [COUNT @D5421, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 1] : 
   APPEAR, 
   [COORD @D5424, AGR [COUNT @D5423, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 1] : 
   APPEAR, 
   [COORD @D5428, AGR [NFORM @D5427, COUNT @D5426, PER @D5425, N +, V -, 
            BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5432, AGR [COUNT @D5431, PER @D5430, PLU @D5429, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5435, AGR @D5434, PAST @D5433, FIX NOT, V +, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_INF, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5437, AGR [COUNT @D5436, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_AP, LAT -, ARITY 1] : APPEAR, 
   
   [COORD @D5439, AGR [COUNT @D5438, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, SUBTYPE RAIS, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_AP, LAT -, ARITY 1] : APPEAR, 
   
   [COORD @D5443, AGR [NFORM @D5442, COUNT @D5441, PER @D5440, N +, V -, 
            BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_AP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5447, AGR [COUNT @D5446, PER @D5445, PLU @D5444, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      SUBTYPE RAIS, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_AP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5450, AGR @D5449, PAST @D5448, FIX NOT, V +, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_AP, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5453, AGR [COUNT @D5452, PER @D5451, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5455, AGR [COUNT @D5454, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : APPEAR, 
   [COORD @D5457, 
      AGR [COUNT @D5456, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : APPEAR, 
   [COORD @D5461, 
      AGR [COUNT @D5460, PER @D5459, PLU @D5458, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPEAR, 
   [COORD @D5467, PAST @D5466, AGR [CASE @D5465, COUNT @D5464, 
            PER @D5463, PLU @D5462, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : APPEAR, 
   [COORD @D5472, PAST @D5471, 
      AGR [COUNT @D5470, PER @D5469, PLU @D5468, NFORM IT, CASE NOM, N +, 
            V -, BAR 2], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM TO, LAT -, ARITY 2] : 
   APPEAR, 
   [COORD @D5477, PAST @D5476, AGR [COUNT @D5475, PER @D5474, PLU 
               @D5473, NFORM IT, CASE NOM, N +, V -, BAR 2], FIX NOT, V +, 
      N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE ASIF, SUBCAT WHS, 
      LAT -, ARITY 1] : APPEAR, 
   [COORD @D5482, PAST @D5481, AGR [COUNT @D5480, PER @D5479, 
            PLU @D5478, NFORM IT, CASE NOM, N +, V -, BAR 2], FIX NOT, V +, 
      SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, 
      LAT -, ARITY 1] : APPEAR.

WORD appeared : 
   [COORD @D5493, AGR [CASE @D5492, COUNT @D5491, PER @D5490, 
            PLU @D5489, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5498, AGR [CASE @D5497, COUNT @D5496, PER @D5495, 
            PLU @D5494, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5500, AGR @D5499, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_PP_INF, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5502, AGR @D5501, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_PP_INF, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5507, AGR [CASE @D5506, COUNT @D5505, PER @D5504, 
            PLU @D5503, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5512, AGR [CASE @D5511, COUNT @D5510, PER @D5509, 
            PLU @D5508, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5517, AGR [CASE @D5516, COUNT @D5515, PER @D5514, 
            PLU @D5513, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5522, AGR [CASE @D5521, COUNT @D5520, PER @D5519, 
            PLU @D5518, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5524, AGR @D5523, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAR, 
   [COORD @D5526, AGR @D5525, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5528, AGR @D5527, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAR, 
   [COORD @D5530, AGR @D5529, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5532, AGR @D5531, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAR, 
   [COORD @D5534, AGR @D5533, COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT SC_AP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5539, AGR [CASE @D5538, COUNT @D5537, PER @D5536, 
            PLU @D5535, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5544, AGR [CASE @D5543, COUNT @D5542, PER @D5541, 
            PLU @D5540, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5548, AGR [COUNT @D5547, PER @D5546, PLU @D5545, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5552, AGR [COUNT @D5551, PER @D5550, PLU @D5549, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPEAR, 
   [COORD @D5556, AGR [COUNT @D5555, PER @D5554, PLU @D5553, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE ASIF, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAR, 
   [COORD @D5560, AGR [COUNT @D5559, PER @D5558, PLU @D5557, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE ASIF, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5564, AGR [COUNT @D5563, PER @D5562, PLU @D5561, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPEAR, 
   [COORD @D5568, AGR [COUNT @D5567, PER @D5566, PLU @D5565, NFORM IT, 
            CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : 
   APPEAR.

WORD appearing : 
   [COORD @D5582, PRD @D5581, AGR [CASE @D5580, COUNT @D5579, 
            PER @D5578, PLU @D5577, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5585, AGR @D5584, PRD @D5583, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_PP_INF, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5591, PRD @D5590, AGR [CASE @D5589, COUNT @D5588, 
            PER @D5587, PLU @D5586, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5597, PRD @D5596, 
      AGR [CASE @D5595, COUNT @D5594, PER @D5593, PLU @D5592, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   APPEAR, 
   [COORD @D5600, AGR @D5599, PRD @D5598, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5603, AGR @D5602, PRD @D5601, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5606, AGR @D5605, PRD @D5604, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_AP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5612, PRD @D5611, AGR [CASE @D5610, COUNT @D5609, 
            PER @D5608, PLU @D5607, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5617, PRD @D5616, 
      AGR [COUNT @D5615, PER @D5614, PLU @D5613, NFORM IT, CASE NOM, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   APPEAR, 
   [COORD @D5622, PRD @D5621, AGR [COUNT @D5620, PER @D5619, PLU @D5618, 
            NFORM IT, CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE ASIF, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5627, PRD @D5626, AGR [COUNT @D5625, PER @D5624, PLU @D5623, 
            NFORM IT, CASE NOM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPEAR.

WORD appears : 
   [COORD @D5635, AGR [COUNT @D5634, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5639, 
      AGR [CASE @D5638, NFORM @D5637, COUNT @D5636, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT SC_PP_INF, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5644, AGR [UB @D5643, VFORM @D5642, SUBJ @D5641, FIN @D5640, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT SC_PP_INF, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : APPEAR, 
   [COORD @D5646, AGR [COUNT @D5645, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5648, 
      AGR [COUNT @D5647, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5652, 
      AGR [CASE @D5651, NFORM @D5650, COUNT @D5649, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_NP, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5657, 
      AGR [UB @D5656, VFORM @D5655, SUBJ @D5654, FIN @D5653, N -, V +, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_NP, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5661, 
      AGR [CASE @D5660, NFORM @D5659, COUNT @D5658, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_INF, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5666, 
      AGR [UB @D5665, VFORM @D5664, SUBJ @D5663, FIN @D5662, N -, V +, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_INF, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5670, 
      AGR [CASE @D5669, NFORM @D5668, COUNT @D5667, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_AP, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5675, 
      AGR [UB @D5674, VFORM @D5673, SUBJ @D5672, FIN @D5671, N -, V +, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_AP, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5677, 
      AGR [COUNT @D5676, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR, 
   [COORD @D5680, 
      AGR [CASE @D5679, COUNT @D5678, N +, V -, BAR 2, NFORM IT, PLU -, 
            PER 3], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAR, 
   [COORD @D5683, AGR [CASE @D5682, COUNT @D5681, N +, V -, BAR 2, 
            NFORM IT, PLU -, PER 3], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE ASIF, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPEAR, 
   [COORD @D5686, AGR [CASE @D5685, COUNT @D5684, N +, V -, BAR 2, 
            NFORM IT, PLU -, PER 3], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPEAR.

WORD apple : 
   [COORD @D5696, REFL @D5695, PRD @D5694, CASE @D5693, FIX NOT, BAR 0, 
      SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, COUNT +] : APPLE.

WORD apples : 
   [COORD @D5708, DEMON @D5707, REFL @D5706, PRD @D5705, CASE @D5704, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : APPLE.

WORD applied : 
   [COADV @D5723, COORD @D5722, DEF @D5721, PRD @D5720, AGR 
            [CASE @D5719, COUNT @D5718, PER @D5717, PLU @D5716, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, 
      N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, SUBCAT NULL, 
      DISTR ATT, QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : 
   APPLIED, 
   [COORD @D5728, AGR [CASE @D5727, COUNT @D5726, PER @D5725, 
            PLU @D5724, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5733, AGR [CASE @D5732, COUNT @D5731, PER @D5730, 
            PLU @D5729, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5738, AGR [CASE @D5737, COUNT @D5736, PER @D5735, 
            PLU @D5734, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPLY, 
   [COORD @D5743, AGR [CASE @D5742, COUNT @D5741, PER @D5740, 
            PLU @D5739, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5748, AGR [CASE @D5747, COUNT @D5746, PER @D5745, 
            PLU @D5744, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5753, AGR [CASE @D5752, COUNT @D5751, PER @D5750, 
            PLU @D5749, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPLY, 
   [COORD @D5758, AGR [CASE @D5757, COUNT @D5756, PER @D5755, 
            PLU @D5754, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPLY, 
   [COORD @D5763, AGR [CASE @D5762, COUNT @D5761, PER @D5760, 
            PLU @D5759, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPLY, 
   [COORD @D5768, AGR [CASE @D5767, COUNT @D5766, PER @D5765, 
            PLU @D5764, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5773, AGR [CASE @D5772, COUNT @D5771, PER @D5770, 
            PLU @D5769, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5778, AGR [CASE @D5777, COUNT @D5776, PER @D5775, 
            PLU @D5774, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5783, AGR [CASE @D5782, COUNT @D5781, PER @D5780, 
            PLU @D5779, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5788, AGR [CASE @D5787, COUNT @D5786, PER @D5785, 
            PLU @D5784, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPLY, 
   [COORD @D5793, AGR [CASE @D5792, COUNT @D5791, PER @D5790, 
            PLU @D5789, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPLY.

WORD applies : 
   [COORD @D5802, AGR [COUNT @D5801, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_PP, PFORM TO_FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPLY, 
   [COORD @D5804, AGR [COUNT @D5803, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPLY, 
   [COORD @D5806, 
      AGR [COUNT @D5805, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPLY, 
   [COORD @D5808, 
      AGR [COUNT @D5807, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPLY, 
   [COORD @D5810, 
      AGR [COUNT @D5809, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPLY, 
   [COORD @D5812, 
      AGR [COUNT @D5811, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPLY.

WORD apply : 
   [COORD @D5821, AGR [COUNT @D5820, PER @D5819, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_FOR, LAT -, ARITY 3] : APPLY, 
   [COORD @D5823, AGR [COUNT @D5822, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_PP, PFORM TO_FOR, LAT -, 
      ARITY 3] : APPLY, 
   [COORD @D5825, AGR [COUNT @D5824, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_PP, PFORM TO_FOR, LAT -, 
      ARITY 3] : APPLY, 
   [COORD @D5829, AGR [COUNT @D5828, PER @D5827, PLU @D5826, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_PP, 
      PFORM TO_FOR, LAT -, ARITY 3] : APPLY, 
   [COORD @D5835, PAST @D5834, 
      AGR [CASE @D5833, COUNT @D5832, PER @D5831, PLU @D5830, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_PP, PFORM TO_FOR, LAT -, ARITY 3] : 
   APPLY, 
   [COORD @D5838, AGR [COUNT @D5837, PER @D5836, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : APPLY, 
   [COORD @D5840, AGR [COUNT @D5839, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : APPLY, 
   [COORD @D5842, AGR [COUNT @D5841, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : APPLY, 
   [COORD @D5846, AGR [COUNT @D5845, PER @D5844, PLU @D5843, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : APPLY, 
   [COORD @D5852, PAST @D5851, AGR [CASE @D5850, COUNT @D5849, 
            PER @D5848, PLU @D5847, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : APPLY, 
   [COORD @D5855, AGR [COUNT @D5854, PER @D5853, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : APPLY, 
   [COORD @D5857, AGR [COUNT @D5856, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : APPLY, 
   [COORD @D5859, 
      AGR [COUNT @D5858, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : APPLY, 
   [COORD @D5863, 
      AGR [COUNT @D5862, PER @D5861, PLU @D5860, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : APPLY, 
   [COORD @D5869, PAST @D5868, AGR [CASE @D5867, COUNT @D5866, 
            PER @D5865, PLU @D5864, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : APPLY, 
   [COORD @D5872, AGR [COUNT @D5871, PER @D5870, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : APPLY, 
   [COORD @D5874, AGR [COUNT @D5873, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   APPLY, 
   [COORD @D5876, AGR [COUNT @D5875, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, LAT -, ARITY 2] : 
   APPLY, 
   [COORD @D5880, AGR [COUNT @D5879, PER @D5878, PLU @D5877, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      LAT -, ARITY 2] : APPLY, 
   [COORD @D5886, PAST @D5885, AGR [CASE @D5884, COUNT @D5883, 
            PER @D5882, PLU @D5881, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM TO, LAT -, ARITY 2] : APPLY, 
   [COORD @D5889, AGR [COUNT @D5888, PER @D5887, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : APPLY, 
   [COORD @D5891, AGR [COUNT @D5890, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   APPLY, 
   [COORD @D5893, AGR [COUNT @D5892, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   APPLY, 
   [COORD @D5897, AGR [COUNT @D5896, PER @D5895, PLU @D5894, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : APPLY, 
   [COORD @D5903, PAST @D5902, AGR [CASE @D5901, COUNT @D5900, 
            PER @D5899, PLU @D5898, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : APPLY, 
   [COORD @D5906, AGR [COUNT @D5905, PER @D5904, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPLY, 
   [COORD @D5908, AGR [COUNT @D5907, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : APPLY, 
   [COORD @D5910, 
      AGR [COUNT @D5909, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : APPLY, 
   [COORD @D5914, 
      AGR [COUNT @D5913, PER @D5912, PLU @D5911, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPLY, 
   [COORD @D5920, PAST @D5919, AGR [CASE @D5918, COUNT @D5917, 
            PER @D5916, PLU @D5915, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : APPLY.

WORD applying : 
   [COORD @D5935, PRD @D5934, AGR [CASE @D5933, COUNT @D5932, 
            PER @D5931, PLU @D5930, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_PP, 
      PFORM TO_FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5941, PRD @D5940, 
      AGR [CASE @D5939, COUNT @D5938, PER @D5937, PLU @D5936, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   APPLY, 
   [COORD @D5947, PRD @D5946, AGR [CASE @D5945, COUNT @D5944, PER 
               @D5943, PLU @D5942, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5953, PRD @D5952, AGR 
         [CASE @D5951, COUNT @D5950, PER @D5949, PLU @D5948, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   APPLY, 
   [COORD @D5959, PRD @D5958, AGR [CASE @D5957, COUNT @D5956, PER 
               @D5955, PLU @D5954, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : APPLY, 
   [COORD @D5965, PRD @D5964, 
      AGR [CASE @D5963, COUNT @D5962, PER @D5961, PLU @D5960, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPLY.

WORD approach : 
   [COORD @D5974, REFL @D5973, COUNT @D5972, PRD @D5971, CASE @D5970, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : APPROACH, 
   [COORD @D5977, 
      AGR [COUNT @D5976, PER @D5975, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM ABOUT, LAT -, 
      ARITY 3] : APPROACH, 
   [COORD @D5979, AGR [COUNT @D5978, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM ABOUT, LAT -, 
      ARITY 3] : APPROACH, 
   [COORD @D5981, AGR [COUNT @D5980, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM ABOUT, LAT -, 
      ARITY 3] : APPROACH, 
   [COORD @D5985, AGR [COUNT @D5984, PER @D5983, PLU @D5982, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM ABOUT, LAT -, ARITY 3] : APPROACH, 
   [COORD @D5991, PAST @D5990, 
      AGR [CASE @D5989, COUNT @D5988, PER @D5987, PLU @D5986, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM ABOUT, LAT -, ARITY 3] : 
   APPROACH, 
   [COORD @D5994, AGR [COUNT @D5993, PER @D5992, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : APPROACH, 
   [COORD @D5996, AGR [COUNT @D5995, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : APPROACH, 
   [COORD @D5998, 
      AGR [COUNT @D5997, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : APPROACH, 
   [COORD @D6002, 
      AGR [COUNT @D6001, PER @D6000, PLU @D5999, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : APPROACH, 
   [COORD @D6008, PAST @D6007, AGR [CASE @D6006, COUNT @D6005, 
            PER @D6004, PLU @D6003, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : APPROACH, 
   [COORD @D6011, AGR [COUNT @D6010, PER @D6009, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPROACH, 
   [COORD @D6013, AGR [COUNT @D6012, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   APPROACH, 
   [COORD @D6015, AGR [COUNT @D6014, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   APPROACH, 
   [COORD @D6019, AGR [COUNT @D6018, PER @D6017, PLU @D6016, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : APPROACH, 
   [COORD @D6025, PAST @D6024, AGR [CASE @D6023, COUNT @D6022, 
            PER @D6021, PLU @D6020, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : APPROACH.

WORD approached : 
   [COORD @D6036, AGR [CASE @D6035, COUNT @D6034, PER @D6033, 
            PLU @D6032, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM ABOUT, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6041, AGR [CASE @D6040, COUNT @D6039, PER @D6038, 
            PLU @D6037, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM ABOUT, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6046, AGR [CASE @D6045, COUNT @D6044, PER @D6043, 
            PLU @D6042, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM ABOUT, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6051, AGR [CASE @D6050, COUNT @D6049, PER @D6048, 
            PLU @D6047, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : APPROACH, 
   [COORD @D6056, AGR [CASE @D6055, COUNT @D6054, PER @D6053, 
            PLU @D6052, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : APPROACH, 
   [COORD @D6061, AGR [CASE @D6060, COUNT @D6059, PER @D6058, 
            PLU @D6057, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : APPROACH, 
   [COORD @D6066, AGR [CASE @D6065, COUNT @D6064, PER @D6063, 
            PLU @D6062, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : APPROACH, 
   [COORD @D6071, AGR [CASE @D6070, COUNT @D6069, PER @D6068, 
            PLU @D6067, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : APPROACH.

WORD approaches : 
   [COORD @D6082, DEMON @D6081, REFL @D6080, PRD @D6079, CASE @D6078, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : APPROACH, 
   [COORD @D6084, 
      AGR [COUNT @D6083, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM ABOUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   APPROACH, 
   [COORD @D6086, AGR [COUNT @D6085, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6088, 
      AGR [COUNT @D6087, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : APPROACH.

WORD approaching : 
   [COORD @D6104, PRD @D6103, AGR [CASE @D6102, COUNT @D6101, 
            PER @D6100, PLU @D6099, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM ABOUT, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6110, PRD @D6109, 
      AGR [CASE @D6108, COUNT @D6107, PER @D6106, PLU @D6105, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPROACH, 
   [COORD @D6116, PRD @D6115, 
      AGR [CASE @D6114, COUNT @D6113, PER @D6112, PLU @D6111, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : APPROACH.

WORD arise : 
   [COORD @D6130, AGR [COUNT @D6129, PER @D6128, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, 
      LAT -, ARITY 2] : ARISE, 
   [COORD @D6132, AGR [COUNT @D6131, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, LAT -, 
      ARITY 2] : ARISE, 
   [COORD @D6134, AGR [COUNT @D6133, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, LAT -, 
      ARITY 2] : ARISE, 
   [COORD @D6138, AGR [COUNT @D6137, PER @D6136, PLU @D6135, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, 
      LAT -, ARITY 2] : ARISE, 
   [COORD @D6144, PAST @D6143, AGR [CASE @D6142, COUNT @D6141, 
            PER @D6140, PLU @D6139, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      REG -, PFORM FROM, LAT -, ARITY 2] : ARISE, 
   [COORD @D6147, AGR [COUNT @D6146, PER @D6145, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : ARISE, 
   [COORD @D6149, AGR [COUNT @D6148, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, ARITY 1] : ARISE, 
   [COORD @D6151, 
      AGR [COUNT @D6150, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, ARITY 1] : ARISE, 
   [COORD @D6155, 
      AGR [COUNT @D6154, PER @D6153, PLU @D6152, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : ARISE, 
   [COORD @D6161, PAST @D6160, AGR [CASE @D6159, COUNT @D6158, 
            PER @D6157, PLU @D6156, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      REG -, LAT -, ARITY 1] : ARISE.

WORD arises : 
   [COORD @D6175, AGR [COUNT @D6174, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FROM, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARISE, 
   [COORD @D6177, 
      AGR [COUNT @D6176, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARISE.

WORD arising : 
   [COORD @D6188, PRD @D6187, AGR [CASE @D6186, COUNT @D6185, 
            PER @D6184, PLU @D6183, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FROM, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ARISE, 
   [COORD @D6194, PRD @D6193, 
      AGR [CASE @D6192, COUNT @D6191, PER @D6190, PLU @D6189, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARISE.

WORD arrange : 
   [COORD @D6202, AGR [COUNT @D6201, PER @D6200, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_WITH, ARITY 3] : ARRANGE, 
   [COORD @D6204, AGR [COUNT @D6203, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_WITH, ARITY 3] : ARRANGE, 
   [COORD @D6206, AGR [COUNT @D6205, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_WITH, ARITY 3] : ARRANGE, 
   [COORD @D6210, AGR [COUNT @D6209, PER @D6208, PLU @D6207, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP_PP, PFORM FOR_WITH, ARITY 3] : ARRANGE, 
   [COORD @D6216, PAST @D6215, 
      AGR [CASE @D6214, COUNT @D6213, PER @D6212, PLU @D6211, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_WITH, 
      ARITY 3] : ARRANGE, 
   [COORD @D6219, AGR [COUNT @D6218, PER @D6217, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6221, AGR [COUNT @D6220, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM WITH, 
      LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6223, AGR [COUNT @D6222, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM WITH, 
      LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6227, AGR [COUNT @D6226, PER @D6225, PLU @D6224, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6233, PAST @D6232, 
      AGR [CASE @D6231, COUNT @D6230, PER @D6229, PLU @D6228, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_PP_INF, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6236, AGR [COUNT @D6235, PER @D6234, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHVP, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6238, AGR [COUNT @D6237, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHVP, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6240, AGR [COUNT @D6239, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHVP, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6244, AGR [COUNT @D6243, PER @D6242, PLU @D6241, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHVP, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6250, PAST @D6249, 
      AGR [CASE @D6248, COUNT @D6247, PER @D6246, PLU @D6245, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_WHVP, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6253, AGR [COUNT @D6252, PER @D6251, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHS, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6255, AGR [COUNT @D6254, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHS, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6257, AGR [COUNT @D6256, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHS, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6261, AGR [COUNT @D6260, PER @D6259, PLU @D6258, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_WHS, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6267, PAST @D6266, 
      AGR [CASE @D6265, COUNT @D6264, PER @D6263, PLU @D6262, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_WHS, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6270, AGR [COUNT @D6269, PER @D6268, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SINF, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6272, AGR [COUNT @D6271, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SINF, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6274, AGR [COUNT @D6273, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SINF, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6278, AGR [COUNT @D6277, PER @D6276, PLU @D6275, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SINF, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6284, PAST @D6283, 
      AGR [CASE @D6282, COUNT @D6281, PER @D6280, PLU @D6279, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_SINF, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6287, AGR [COUNT @D6286, PER @D6285, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6289, AGR [COUNT @D6288, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6291, AGR [COUNT @D6290, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6295, AGR [COUNT @D6294, PER @D6293, PLU @D6292, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6301, PAST @D6300, 
      AGR [CASE @D6299, COUNT @D6298, PER @D6297, PLU @D6296, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_SFIN, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6304, AGR [COUNT @D6303, PER @D6302, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SBSE, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6306, AGR [COUNT @D6305, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SBSE, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6308, AGR [COUNT @D6307, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SBSE, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6312, AGR [COUNT @D6311, PER @D6310, PLU @D6309, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP_SBSE, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6318, PAST @D6317, 
      AGR [CASE @D6316, COUNT @D6315, PER @D6314, PLU @D6313, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT PP_SBSE, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6321, AGR [COUNT @D6320, PER @D6319, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6323, AGR [COUNT @D6322, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6325, AGR [COUNT @D6324, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6329, AGR [COUNT @D6328, PER @D6327, PLU @D6326, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM WITH, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6335, PAST @D6334, 
      AGR [CASE @D6333, COUNT @D6332, PER @D6331, PLU @D6330, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, ARITY 3] : 
   ARRANGE, 
   [COORD @D6338, AGR [COUNT @D6337, PER @D6336, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6340, AGR [COUNT @D6339, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6342, AGR [COUNT @D6341, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ARRANGE, 
   [COORD @D6346, AGR [COUNT @D6345, PER @D6344, PLU @D6343, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6352, PAST @D6351, AGR [CASE @D6350, COUNT @D6349, 
            PER @D6348, PLU @D6347, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM FOR, LAT -, ARITY 3] : ARRANGE, 
   [COORD @D6355, AGR 
         [COUNT @D6354, PER @D6353, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, 
      ARITY 2] : ARRANGE, 
   [COORD @D6357, AGR [COUNT @D6356, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ARRANGE, 
   [COORD @D6359, AGR [COUNT @D6358, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ARRANGE, 
   [COORD @D6363, AGR [COUNT @D6362, PER @D6361, PLU @D6360, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ARRANGE, 
   [COORD @D6369, PAST @D6368, AGR [CASE @D6367, COUNT @D6366, 
            PER @D6365, PLU @D6364, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, ARITY 2] : ARRANGE, 
   [COORD @D6372, 
      AGR [COUNT @D6371, PER @D6370, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6374, AGR [COUNT @D6373, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6376, AGR [COUNT @D6375, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6380, AGR [COUNT @D6379, PER @D6378, PLU @D6377, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6386, PAST @D6385, AGR [CASE @D6384, COUNT @D6383, 
            PER @D6382, PLU @D6381, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT WHVP, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6389, AGR [COUNT @D6388, PER @D6387, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6391, AGR [COUNT @D6390, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6393, 
      AGR [COUNT @D6392, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6397, 
      AGR [COUNT @D6396, PER @D6395, PLU @D6394, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6403, PAST @D6402, AGR [CASE @D6401, COUNT @D6400, 
            PER @D6399, PLU @D6398, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT WHS, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6406, AGR [COUNT @D6405, PER @D6404, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6408, AGR [COUNT @D6407, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6410, AGR [COUNT @D6409, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6414, AGR [COUNT @D6413, PER @D6412, PLU @D6411, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6420, PAST @D6419, AGR [CASE @D6418, COUNT @D6417, 
            PER @D6416, PLU @D6415, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SINF, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6423, AGR [COUNT @D6422, PER @D6421, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6425, AGR [COUNT @D6424, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6427, AGR [COUNT @D6426, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6431, AGR [COUNT @D6430, PER @D6429, PLU @D6428, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6437, PAST @D6436, AGR [CASE @D6435, COUNT @D6434, 
            PER @D6433, PLU @D6432, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6440, AGR [COUNT @D6439, PER @D6438, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6442, AGR [COUNT @D6441, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ARRANGE, 
   [COORD @D6444, AGR [COUNT @D6443, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ARRANGE, 
   [COORD @D6448, AGR [COUNT @D6447, PER @D6446, PLU @D6445, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6454, PAST @D6453, AGR [CASE @D6452, COUNT @D6451, 
            PER @D6450, PLU @D6449, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_INF, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6457, AGR [COUNT @D6456, PER @D6455, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6459, AGR [COUNT @D6458, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6461, AGR [COUNT @D6460, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, ARITY 2] : ARRANGE, 
   
   [COORD @D6465, AGR [COUNT @D6464, PER @D6463, PLU @D6462, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6471, PAST @D6470, AGR [CASE @D6469, COUNT @D6468, 
            PER @D6467, PLU @D6466, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SBSE, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6474, AGR [COUNT @D6473, PER @D6472, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6476, AGR [COUNT @D6475, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6478, 
      AGR [COUNT @D6477, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ARRANGE, 
   [COORD @D6482, 
      AGR [COUNT @D6481, PER @D6480, PLU @D6479, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ARRANGE, 
   [COORD @D6488, PAST @D6487, AGR [CASE @D6486, COUNT @D6485, 
            PER @D6484, PLU @D6483, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ARRANGE.

WORD arranged : 
   [COORD @D6499, AGR [CASE @D6498, COUNT @D6497, PER @D6496, 
            PLU @D6495, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6504, AGR [CASE @D6503, COUNT @D6502, PER @D6501, 
            PLU @D6500, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6509, AGR [CASE @D6508, COUNT @D6507, PER @D6506, 
            PLU @D6505, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6514, AGR [CASE @D6513, COUNT @D6512, PER @D6511, 
            PLU @D6510, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6519, AGR [CASE @D6518, COUNT @D6517, PER @D6516, 
            PLU @D6515, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_WHVP, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6524, AGR [CASE @D6523, COUNT @D6522, PER @D6521, 
            PLU @D6520, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_WHVP, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6529, AGR [CASE @D6528, COUNT @D6527, PER @D6526, 
            PLU @D6525, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_WHS, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6534, AGR [CASE @D6533, COUNT @D6532, PER @D6531, 
            PLU @D6530, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_WHS, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6539, AGR [CASE @D6538, COUNT @D6537, PER @D6536, 
            PLU @D6535, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SINF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6544, AGR [CASE @D6543, COUNT @D6542, PER @D6541, 
            PLU @D6540, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SINF, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6549, AGR [CASE @D6548, COUNT @D6547, PER @D6546, 
            PLU @D6545, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6554, AGR [CASE @D6553, COUNT @D6552, PER @D6551, 
            PLU @D6550, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6559, AGR [CASE @D6558, COUNT @D6557, PER @D6556, 
            PLU @D6555, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SBSE, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6564, AGR [CASE @D6563, COUNT @D6562, PER @D6561, 
            PLU @D6560, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP_SBSE, PFORM WITH, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6569, AGR [CASE @D6568, COUNT @D6567, PER @D6566, 
            PLU @D6565, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6574, AGR [CASE @D6573, COUNT @D6572, PER @D6571, 
            PLU @D6570, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6579, AGR [CASE @D6578, COUNT @D6577, PER @D6576, 
            PLU @D6575, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6584, AGR [CASE @D6583, COUNT @D6582, PER @D6581, 
            PLU @D6580, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6589, AGR [CASE @D6588, COUNT @D6587, PER @D6586, 
            PLU @D6585, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6594, AGR [CASE @D6593, COUNT @D6592, PER @D6591, 
            PLU @D6590, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6599, AGR [CASE @D6598, COUNT @D6597, PER @D6596, 
            PLU @D6595, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6604, AGR [CASE @D6603, COUNT @D6602, PER @D6601, 
            PLU @D6600, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6609, AGR [CASE @D6608, COUNT @D6607, PER @D6606, 
            PLU @D6605, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6614, AGR [CASE @D6613, COUNT @D6612, PER @D6611, 
            PLU @D6610, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6619, AGR [CASE @D6618, COUNT @D6617, PER @D6616, 
            PLU @D6615, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6624, AGR [CASE @D6623, COUNT @D6622, PER @D6621, 
            PLU @D6620, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6629, AGR [CASE @D6628, COUNT @D6627, PER @D6626, 
            PLU @D6625, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6634, AGR [CASE @D6633, COUNT @D6632, PER @D6631, 
            PLU @D6630, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6639, AGR [CASE @D6638, COUNT @D6637, PER @D6636, 
            PLU @D6635, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6644, AGR [CASE @D6643, COUNT @D6642, PER @D6641, 
            PLU @D6640, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6649, AGR [CASE @D6648, COUNT @D6647, PER @D6646, 
            PLU @D6645, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6654, AGR [UB @D6653, VFORM @D6652, SUBJ @D6651, FIN @D6650, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   
   [COORD @D6659, AGR [CASE @D6658, COUNT @D6657, PER @D6656, PLU @D6655, 
            BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6664, AGR [CASE @D6663, COUNT @D6662, PER @D6661, 
            PLU @D6660, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6669, AGR [CASE @D6668, COUNT @D6667, PER @D6666, 
            PLU @D6665, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6674, AGR [CASE @D6673, COUNT @D6672, PER @D6671, 
            PLU @D6670, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6679, AGR [CASE @D6678, COUNT @D6677, PER @D6676, 
            PLU @D6675, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ARRANGE, 
   [COORD @D6684, AGR [CASE @D6683, COUNT @D6682, PER @D6681, 
            PLU @D6680, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ARRANGE, 
   [COORD @D6689, AGR [CASE @D6688, COUNT @D6687, PER @D6686, 
            PLU @D6685, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ARRANGE.

WORD arranges : 
   [COORD @D6697, AGR [COUNT @D6696, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP_PP, PFORM FOR_WITH, AUX -, INV -, NEG -, 
      PSVE -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, 
      BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6699, AGR [COUNT @D6698, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6701, AGR [COUNT @D6700, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_WHVP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6703, AGR [COUNT @D6702, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_WHS, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6705, AGR [COUNT @D6704, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SINF, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6707, AGR [COUNT @D6706, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6709, AGR [COUNT @D6708, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SBSE, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6711, AGR [COUNT @D6710, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6713, AGR [COUNT @D6712, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6715, 
      AGR [COUNT @D6714, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6717, 
      AGR [COUNT @D6716, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6719, 
      AGR [COUNT @D6718, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6721, 
      AGR [COUNT @D6720, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6723, 
      AGR [COUNT @D6722, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6725, 
      AGR [COUNT @D6724, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6727, 
      AGR [COUNT @D6726, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6729, 
      AGR [COUNT @D6728, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRANGE.

WORD arranging : 
   [COORD @D6740, PRD @D6739, AGR [CASE @D6738, COUNT @D6737, 
            PER @D6736, PLU @D6735, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP_PP, 
      PFORM FOR_WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6746, PRD @D6745, 
      AGR [CASE @D6744, COUNT @D6743, PER @D6742, PLU @D6741, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_PP_INF, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ARRANGE, 
   [COORD @D6752, PRD @D6751, AGR [CASE @D6750, COUNT @D6749, 
            PER @D6748, PLU @D6747, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_WHVP, 
      PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6758, PRD @D6757, 
      AGR [CASE @D6756, COUNT @D6755, PER @D6754, PLU @D6753, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_WHS, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6764, PRD @D6763, AGR [CASE @D6762, COUNT @D6761, 
            PER @D6760, PLU @D6759, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_SINF, 
      PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6770, PRD @D6769, 
      AGR [CASE @D6768, COUNT @D6767, PER @D6766, PLU @D6765, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP_SFIN, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6776, PRD @D6775, AGR [CASE @D6774, COUNT @D6773, 
            PER @D6772, PLU @D6771, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP_SBSE, 
      PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6782, PRD @D6781, 
      AGR [CASE @D6780, COUNT @D6779, PER @D6778, PLU @D6777, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ARRANGE, 
   [COORD @D6788, PRD @D6787, AGR [CASE @D6786, COUNT @D6785, 
            PER @D6784, PLU @D6783, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6794, PRD @D6793, 
      AGR [CASE @D6792, COUNT @D6791, PER @D6790, PLU @D6789, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ARRANGE, 
   [COORD @D6800, PRD @D6799, AGR [CASE @D6798, COUNT @D6797, 
            PER @D6796, PLU @D6795, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT WHVP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6806, PRD @D6805, 
      AGR [CASE @D6804, COUNT @D6803, PER @D6802, PLU @D6801, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6812, PRD @D6811, 
      AGR [CASE @D6810, COUNT @D6809, PER @D6808, PLU @D6807, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6818, PRD @D6817, 
      AGR [CASE @D6816, COUNT @D6815, PER @D6814, PLU @D6813, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6824, PRD @D6823, 
      AGR [CASE @D6822, COUNT @D6821, PER @D6820, PLU @D6819, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6830, PRD @D6829, 
      AGR [CASE @D6828, COUNT @D6827, PER @D6826, PLU @D6825, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE, 
   [COORD @D6836, PRD @D6835, 
      AGR [CASE @D6834, COUNT @D6833, PER @D6832, PLU @D6831, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRANGE.

WORD arrest : 
   [COORD @D6843, AGR [COUNT @D6842, PER @D6841, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ARREST, 
   [COORD @D6845, AGR [COUNT @D6844, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ARREST, 
   [COORD @D6847, 
      AGR [COUNT @D6846, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ARREST, 
   [COORD @D6851, 
      AGR [COUNT @D6850, PER @D6849, PLU @D6848, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ARREST, 
   [COORD @D6857, PAST @D6856, AGR [CASE @D6855, COUNT @D6854, 
            PER @D6853, PLU @D6852, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ARREST.

WORD arrested : 
   [COORD @D6867, AGR [CASE @D6866, COUNT @D6865, PER @D6864, 
            PLU @D6863, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ARREST, 
   [COORD @D6872, AGR [CASE @D6871, COUNT @D6870, PER @D6869, 
            PLU @D6868, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ARREST, 
   [COORD @D6877, AGR [CASE @D6876, COUNT @D6875, PER @D6874, 
            PLU @D6873, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ARREST.

WORD arresting : 
   [COORD @D6890, PRD @D6889, AGR [CASE @D6888, COUNT @D6887, 
            PER @D6886, PLU @D6885, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ARREST.

WORD arrests : 
   [COORD @D6897, AGR [COUNT @D6896, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARREST.

WORD arrive : 
   [COORD @D6905, AGR [COUNT @D6904, PER @D6903, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : ARRIVE, 
   [COORD @D6907, AGR [COUNT @D6906, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : ARRIVE, 
   [COORD @D6909, AGR [COUNT @D6908, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : ARRIVE, 
   [COORD @D6913, AGR [COUNT @D6912, PER @D6911, PLU @D6910, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AT, ARITY 2] : ARRIVE, 
   [COORD @D6919, PAST @D6918, AGR [CASE @D6917, COUNT @D6916, 
            PER @D6915, PLU @D6914, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM AT, ARITY 2] : ARRIVE, 
   [COORD @D6922, 
      AGR [COUNT @D6921, PER @D6920, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ARRIVE, 
   [COORD @D6924, 
      AGR [COUNT @D6923, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ARRIVE, 
   [COORD @D6926, 
      AGR [COUNT @D6925, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ARRIVE, 
   [COORD @D6930, 
      AGR [COUNT @D6929, PER @D6928, PLU @D6927, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ARRIVE, 
   [COORD @D6936, PAST @D6935, AGR [CASE @D6934, COUNT @D6933, 
            PER @D6932, PLU @D6931, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ARRIVE.

WORD arrived : 
   [COORD @D6947, AGR [CASE @D6946, COUNT @D6945, PER @D6944, 
            PLU @D6943, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ARRIVE, 
   [COORD @D6952, AGR [CASE @D6951, COUNT @D6950, PER @D6949, 
            PLU @D6948, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ARRIVE, 
   [COORD @D6957, AGR [CASE @D6956, COUNT @D6955, PER @D6954, 
            PLU @D6953, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM AT, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRIVE, 
   [COORD @D6962, AGR [CASE @D6961, COUNT @D6960, PER @D6959, 
            PLU @D6958, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ARRIVE, 
   [COORD @D6967, AGR [CASE @D6966, COUNT @D6965, PER @D6964, 
            PLU @D6963, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ARRIVE.

WORD arrives : 
   [COORD @D6975, AGR [COUNT @D6974, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM AT, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : ARRIVE, 
   [COORD @D6977, AGR [COUNT @D6976, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ARRIVE.

WORD arriving : 
   [COORD @D6988, PRD @D6987, AGR [CASE @D6986, COUNT @D6985, 
            PER @D6984, PLU @D6983, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRIVE, 
   [COORD @D6994, PRD @D6993, 
      AGR [CASE @D6992, COUNT @D6991, PER @D6990, PLU @D6989, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ARRIVE.

WORD ask : 
   [COORD @D7001, AGR [COUNT @D7000, PER @D6999, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7003, AGR [COUNT @D7002, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, LAT -, ARITY 3] : 
   ASK, 
   [COORD @D7005, AGR [COUNT @D7004, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, LAT -, ARITY 3] : 
   ASK, 
   [COORD @D7009, AGR [COUNT @D7008, PER @D7007, PLU @D7006, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7015, PAST @D7014, AGR [CASE @D7013, COUNT @D7012, 
            PER @D7011, PLU @D7010, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_INF, LAT -, ARITY 3] : ASK, 
   [COORD @D7018, AGR [COUNT @D7017, PER @D7016, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHVP, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7020, AGR [COUNT @D7019, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHVP, LAT -, ARITY 3] : ASK, 
   [COORD @D7022, 
      AGR [COUNT @D7021, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHVP, LAT -, ARITY 3] : ASK, 
   [COORD @D7026, 
      AGR [COUNT @D7025, PER @D7024, PLU @D7023, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHVP, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7032, PAST @D7031, AGR [CASE @D7030, COUNT @D7029, 
            PER @D7028, PLU @D7027, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_WHVP, LAT -, ARITY 3] : ASK, 
   [COORD @D7035, AGR [COUNT @D7034, PER @D7033, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHS, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7037, AGR [COUNT @D7036, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHS, LAT -, ARITY 3] : ASK, 
   [COORD @D7039, 
      AGR [COUNT @D7038, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHS, LAT -, ARITY 3] : ASK, 
   [COORD @D7043, 
      AGR [COUNT @D7042, PER @D7041, PLU @D7040, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_WHS, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7049, PAST @D7048, AGR [CASE @D7047, COUNT @D7046, 
            PER @D7045, PLU @D7044, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_WHS, LAT -, ARITY 3] : ASK, 
   [COORD @D7052, AGR [COUNT @D7051, PER @D7050, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7054, AGR [COUNT @D7053, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : ASK, 
   [COORD @D7056, 
      AGR [COUNT @D7055, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, ARITY 3] : ASK, 
   [COORD @D7060, 
      AGR [COUNT @D7059, PER @D7058, PLU @D7057, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7066, PAST @D7065, AGR [CASE @D7064, COUNT @D7063, 
            PER @D7062, PLU @D7061, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_NP, LAT -, ARITY 3] : ASK, 
   [COORD @D7069, AGR [COUNT @D7068, PER @D7067, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7071, AGR [COUNT @D7070, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7073, AGR [COUNT @D7072, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7077, AGR [COUNT @D7076, PER @D7075, PLU @D7074, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7083, PAST @D7082, AGR [CASE @D7081, COUNT @D7080, 
            PER @D7079, PLU @D7078, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ASK, 
   [COORD @D7086, AGR [COUNT @D7085, PER @D7084, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7088, AGR [COUNT @D7087, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7090, AGR [COUNT @D7089, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7094, AGR [COUNT @D7093, PER @D7092, PLU @D7091, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7100, PAST @D7099, AGR [CASE @D7098, COUNT @D7097, 
            PER @D7096, PLU @D7095, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM OF, LAT -, ARITY 3] : ASK, 
   [COORD @D7103, AGR [COUNT @D7102, PER @D7101, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7105, AGR [COUNT @D7104, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7107, AGR [COUNT @D7106, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, LAT -, 
      ARITY 3] : ASK, 
   [COORD @D7111, AGR [COUNT @D7110, PER @D7109, PLU @D7108, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM FOR, 
      LAT -, ARITY 3] : ASK, 
   [COORD @D7117, PAST @D7116, AGR [CASE @D7115, COUNT @D7114, 
            PER @D7113, PLU @D7112, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM FOR, LAT -, ARITY 3] : ASK, 
   [COORD @D7120, AGR [COUNT @D7119, PER @D7118, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ASK, 
   [COORD @D7122, AGR [COUNT @D7121, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ASK, 
   [COORD @D7124, AGR [COUNT @D7123, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ASK, 
   [COORD @D7128, AGR [COUNT @D7127, PER @D7126, PLU @D7125, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FOR, ARITY 2] : ASK, 
   [COORD @D7134, PAST @D7133, AGR [CASE @D7132, COUNT @D7131, 
            PER @D7130, PLU @D7129, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, ARITY 2] : ASK, 
   [COORD @D7137, 
      AGR [COUNT @D7136, PER @D7135, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM AFTER, 
      ARITY 2] : ASK, 
   [COORD @D7139, AGR [COUNT @D7138, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AFTER, ARITY 2] : ASK, 
   [COORD @D7141, AGR [COUNT @D7140, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AFTER, ARITY 2] : ASK, 
   [COORD @D7145, AGR [COUNT @D7144, PER @D7143, PLU @D7142, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AFTER, ARITY 2] : ASK, 
   [COORD @D7151, PAST @D7150, AGR [CASE @D7149, COUNT @D7148, 
            PER @D7147, PLU @D7146, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM AFTER, ARITY 2] : ASK, 
   [COORD @D7154, 
      AGR [COUNT @D7153, PER @D7152, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ASK, 
   [COORD @D7156, 
      AGR [COUNT @D7155, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ASK, 
   [COORD @D7158, 
      AGR [COUNT @D7157, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, ARITY 2] : ASK, 
   [COORD @D7162, 
      AGR [COUNT @D7161, PER @D7160, PLU @D7159, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHVP, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7168, PAST @D7167, AGR [CASE @D7166, COUNT @D7165, 
            PER @D7164, PLU @D7163, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT WHVP, LAT -, ARITY 2] : ASK, 
   [COORD @D7171, AGR [COUNT @D7170, PER @D7169, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7173, AGR [COUNT @D7172, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, ARITY 2] : ASK, 
   [COORD @D7175, 
      AGR [COUNT @D7174, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, ARITY 2] : ASK, 
   [COORD @D7179, 
      AGR [COUNT @D7178, PER @D7177, PLU @D7176, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT WHS, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7185, PAST @D7184, AGR [CASE @D7183, COUNT @D7182, 
            PER @D7181, PLU @D7180, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT WHS, LAT -, ARITY 2] : ASK, 
   [COORD @D7188, AGR [COUNT @D7187, PER @D7186, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7190, AGR [COUNT @D7189, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, ARITY 2] : ASK, 
   [COORD @D7192, 
      AGR [COUNT @D7191, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, ARITY 2] : ASK, 
   [COORD @D7196, 
      AGR [COUNT @D7195, PER @D7194, PLU @D7193, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SINF, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7202, PAST @D7201, AGR [CASE @D7200, COUNT @D7199, 
            PER @D7198, PLU @D7197, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SINF, LAT -, ARITY 2] : ASK, 
   [COORD @D7205, AGR [COUNT @D7204, PER @D7203, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7207, AGR [COUNT @D7206, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ASK, 
   [COORD @D7209, AGR [COUNT @D7208, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ASK, 
   [COORD @D7213, AGR [COUNT @D7212, PER @D7211, PLU @D7210, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7219, PAST @D7218, AGR [CASE @D7217, COUNT @D7216, 
            PER @D7215, PLU @D7214, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_INF, LAT -, ARITY 2] : ASK, 
   [COORD @D7222, AGR [COUNT @D7221, PER @D7220, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7224, AGR [COUNT @D7223, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, ARITY 2] : ASK, 
   [COORD @D7226, 
      AGR [COUNT @D7225, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, ARITY 2] : ASK, 
   [COORD @D7230, 
      AGR [COUNT @D7229, PER @D7228, PLU @D7227, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SBSE, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7236, PAST @D7235, AGR [CASE @D7234, COUNT @D7233, 
            PER @D7232, PLU @D7231, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SBSE, LAT -, ARITY 2] : ASK, 
   [COORD @D7239, AGR [COUNT @D7238, PER @D7237, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7241, AGR [COUNT @D7240, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASK, 
   [COORD @D7243, 
      AGR [COUNT @D7242, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASK, 
   [COORD @D7247, 
      AGR [COUNT @D7246, PER @D7245, PLU @D7244, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7253, PAST @D7252, AGR [CASE @D7251, COUNT @D7250, 
            PER @D7249, PLU @D7248, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ASK, 
   [COORD @D7256, AGR [COUNT @D7255, PER @D7254, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : ASK, 
   [COORD @D7258, AGR [COUNT @D7257, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ASK, 
   [COORD @D7260, AGR [COUNT @D7259, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : 
   ASK, 
   [COORD @D7264, AGR [COUNT @D7263, PER @D7262, PLU @D7261, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      LAT -, ARITY 2] : ASK, 
   [COORD @D7270, PAST @D7269, AGR [CASE @D7268, COUNT @D7267, 
            PER @D7266, PLU @D7265, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM FOR, LAT -, ARITY 2] : ASK, 
   [COORD @D7273, AGR [COUNT @D7272, PER @D7271, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT OUT, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7275, AGR [COUNT @D7274, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT OUT, LAT -, ARITY 2] : ASK, 
   
   [COORD @D7277, AGR [COUNT @D7276, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT OUT, LAT -, ARITY 2] : ASK, 
   
   [COORD @D7281, AGR [COUNT @D7280, PER @D7279, PLU @D7278, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, PRT OUT, LAT -, 
      ARITY 2] : ASK, 
   [COORD @D7287, PAST @D7286, AGR [CASE @D7285, COUNT @D7284, 
            PER @D7283, PLU @D7282, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      PRT OUT, LAT -, ARITY 2] : ASK, 
   [COORD @D7290, AGR [COUNT @D7289, PER @D7288, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ASK, 
   [COORD @D7292, AGR [COUNT @D7291, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ASK, 
   [COORD @D7294, 
      AGR [COUNT @D7293, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ASK, 
   [COORD @D7298, 
      AGR [COUNT @D7297, PER @D7296, PLU @D7295, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ASK, 
   [COORD @D7304, PAST @D7303, AGR [CASE @D7302, COUNT @D7301, 
            PER @D7300, PLU @D7299, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ASK, 
   [COORD @D7307, AGR [COUNT @D7306, PER @D7305, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      LAT -, ARITY 1] : ASK, 
   [COORD @D7309, AGR [COUNT @D7308, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT OUT, LAT -, ARITY 1] : 
   ASK, 
   [COORD @D7311, AGR [COUNT @D7310, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT OUT, LAT -, ARITY 1] : 
   ASK, 
   [COORD @D7315, AGR [COUNT @D7314, PER @D7313, PLU @D7312, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      LAT -, ARITY 1] : ASK, 
   [COORD @D7321, PAST @D7320, AGR [CASE @D7319, COUNT @D7318, 
            PER @D7317, PLU @D7316, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, LAT -, ARITY 1] : ASK.

WORD asked : 
   [COORD @D7331, AGR [CASE @D7330, COUNT @D7329, PER @D7328, PLU 
               @D7327, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE EQUI, SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7336, AGR [CASE @D7335, COUNT @D7334, PER @D7333, 
            PLU @D7332, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE EQUI, SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7342, AGR [CASE @D7341, NFORM @D7340, COUNT @D7339, 
            PER @D7338, PLU @D7337, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE EQUI, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7347, AGR [CASE @D7346, COUNT @D7345, PER @D7344, 
            PLU @D7343, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_WHVP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7352, AGR [CASE @D7351, COUNT @D7350, PER @D7349, 
            PLU @D7348, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7357, AGR [CASE @D7356, COUNT @D7355, PER @D7354, 
            PLU @D7353, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7362, AGR [CASE @D7361, COUNT @D7360, PER @D7359, 
            PLU @D7358, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_WHS, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7367, AGR [CASE @D7366, COUNT @D7365, PER @D7364, 
            PLU @D7363, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7372, AGR [CASE @D7371, COUNT @D7370, PER @D7369, 
            PLU @D7368, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7377, AGR [CASE @D7376, COUNT @D7375, PER @D7374, 
            PLU @D7373, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7382, AGR [CASE @D7381, COUNT @D7380, PER @D7379, 
            PLU @D7378, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7387, AGR [CASE @D7386, COUNT @D7385, PER @D7384, 
            PLU @D7383, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7392, AGR [CASE @D7391, COUNT @D7390, PER @D7389, 
            PLU @D7388, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7397, AGR [CASE @D7396, COUNT @D7395, PER @D7394, 
            PLU @D7393, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7402, AGR [CASE @D7401, COUNT @D7400, PER @D7399, 
            PLU @D7398, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7407, AGR [CASE @D7406, COUNT @D7405, PER @D7404, 
            PLU @D7403, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE DMOVT, PFORM OF, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7412, AGR [CASE @D7411, COUNT @D7410, PER @D7409, 
            PLU @D7408, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7417, AGR [CASE @D7416, COUNT @D7415, PER @D7414, 
            PLU @D7413, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7422, AGR [CASE @D7421, COUNT @D7420, PER @D7419, 
            PLU @D7418, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7427, AGR [CASE @D7426, COUNT @D7425, PER @D7424, 
            PLU @D7423, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7432, AGR [CASE @D7431, COUNT @D7430, PER @D7429, 
            PLU @D7428, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7437, AGR [CASE @D7436, COUNT @D7435, PER @D7434, 
            PLU @D7433, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7442, AGR [CASE @D7441, COUNT @D7440, PER @D7439, 
            PLU @D7438, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7447, AGR [CASE @D7446, COUNT @D7445, PER @D7444, 
            PLU @D7443, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7452, AGR [CASE @D7451, COUNT @D7450, PER @D7449, 
            PLU @D7448, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AFTER, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7457, AGR [CASE @D7456, COUNT @D7455, PER @D7454, 
            PLU @D7453, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM AFTER, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7462, AGR [CASE @D7461, COUNT @D7460, PER @D7459, 
            PLU @D7458, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM AFTER, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7467, AGR [CASE @D7466, COUNT @D7465, PER @D7464, 
            PLU @D7463, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7472, AGR [CASE @D7471, COUNT @D7470, PER @D7469, 
            PLU @D7468, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7477, AGR [CASE @D7476, COUNT @D7475, PER @D7474, 
            PLU @D7473, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7482, AGR [CASE @D7481, COUNT @D7480, PER @D7479, 
            PLU @D7478, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7487, AGR [CASE @D7486, COUNT @D7485, PER @D7484, 
            PLU @D7483, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7492, AGR [CASE @D7491, COUNT @D7490, PER @D7489, 
            PLU @D7488, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7497, AGR [CASE @D7496, COUNT @D7495, PER @D7494, 
            PLU @D7493, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7502, AGR [CASE @D7501, COUNT @D7500, PER @D7499, 
            PLU @D7498, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7507, AGR [CASE @D7506, COUNT @D7505, PER @D7504, 
            PLU @D7503, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7512, AGR [CASE @D7511, COUNT @D7510, PER @D7509, 
            PLU @D7508, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7517, AGR [CASE @D7516, COUNT @D7515, PER @D7514, 
            PLU @D7513, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ASK, 
   [COORD @D7522, AGR [CASE @D7521, COUNT @D7520, PER @D7519, 
            PLU @D7518, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7527, AGR [CASE @D7526, COUNT @D7525, PER @D7524, 
            PLU @D7523, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7532, AGR [CASE @D7531, COUNT @D7530, PER @D7529, 
            PLU @D7528, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7537, AGR [CASE @D7536, COUNT @D7535, PER @D7534, 
            PLU @D7533, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7542, AGR [CASE @D7541, COUNT @D7540, PER @D7539, 
            PLU @D7538, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7547, AGR [CASE @D7546, COUNT @D7545, PER @D7544, 
            PLU @D7543, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK, 
   [COORD @D7552, AGR [CASE @D7551, COUNT @D7550, PER @D7549, 
            PLU @D7548, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7557, AGR [CASE @D7556, COUNT @D7555, PER @D7554, 
            PLU @D7553, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7562, AGR [CASE @D7561, COUNT @D7560, PER @D7559, 
            PLU @D7558, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7567, AGR [CASE @D7566, COUNT @D7565, PER @D7564, 
            PLU @D7563, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7572, AGR [CASE @D7571, COUNT @D7570, PER @D7569, 
            PLU @D7568, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASK.

WORD asking : 
   [COORD @D7585, PRD @D7584, AGR [CASE @D7583, COUNT @D7582, PER 
               @D7581, PLU @D7580, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, SUBCAT OC_INF, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7591, PRD @D7590, AGR [CASE @D7589, COUNT @D7588, 
            PER @D7587, PLU @D7586, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHVP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7597, PRD @D7596, AGR [CASE @D7595, COUNT @D7594, 
            PER @D7593, PLU @D7592, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_WHS, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7603, PRD @D7602, AGR [CASE @D7601, COUNT @D7600, 
            PER @D7599, PLU @D7598, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7609, PRD @D7608, AGR [CASE @D7607, COUNT @D7606, 
            PER @D7605, PLU @D7604, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7615, PRD @D7614, 
      AGR [CASE @D7613, COUNT @D7612, PER @D7611, PLU @D7610, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE DMOVT, SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7621, PRD @D7620, AGR [CASE @D7619, COUNT @D7618, 
            PER @D7617, PLU @D7616, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7627, PRD @D7626, 
      AGR [CASE @D7625, COUNT @D7624, PER @D7623, PLU @D7622, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASK, 
   [COORD @D7633, PRD @D7632, AGR [CASE @D7631, COUNT @D7630, 
            PER @D7629, PLU @D7628, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, 
      PFORM AFTER, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7639, PRD @D7638, 
      AGR [CASE @D7637, COUNT @D7636, PER @D7635, PLU @D7634, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7645, PRD @D7644, 
      AGR [CASE @D7643, COUNT @D7642, PER @D7641, PLU @D7640, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7651, PRD @D7650, 
      AGR [CASE @D7649, COUNT @D7648, PER @D7647, PLU @D7646, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7657, PRD @D7656, 
      AGR [CASE @D7655, COUNT @D7654, PER @D7653, PLU @D7652, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7663, PRD @D7662, 
      AGR [CASE @D7661, COUNT @D7660, PER @D7659, PLU @D7658, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7669, PRD @D7668, 
      AGR [CASE @D7667, COUNT @D7666, PER @D7665, PLU @D7664, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7675, PRD @D7674, 
      AGR [CASE @D7673, COUNT @D7672, PER @D7671, PLU @D7670, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK, 
   
   [COORD @D7681, PRD @D7680, AGR [CASE @D7679, COUNT @D7678, PER @D7677, 
            PLU @D7676, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASK, 
   [COORD @D7687, PRD @D7686, AGR [CASE @D7685, COUNT @D7684, 
            PER @D7683, PLU @D7682, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASK, 
   [COORD @D7693, PRD @D7692, AGR [CASE @D7691, COUNT @D7690, 
            PER @D7689, PLU @D7688, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ASK.

WORD asks : 
   [COORD @D7700, AGR [COUNT @D7699, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7702, 
      AGR [COUNT @D7701, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_WHVP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7704, 
      AGR [COUNT @D7703, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_WHS, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7706, 
      AGR [COUNT @D7705, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7708, 
      AGR [COUNT @D7707, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7710, 
      AGR [COUNT @D7709, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM OF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7712, 
      AGR [COUNT @D7711, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7714, 
      AGR [COUNT @D7713, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7716, 
      AGR [COUNT @D7715, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM AFTER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7718, 
      AGR [COUNT @D7717, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHVP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7720, 
      AGR [COUNT @D7719, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT WHS, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7722, 
      AGR [COUNT @D7721, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SINF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7724, 
      AGR [COUNT @D7723, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7726, 
      AGR [COUNT @D7725, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SBSE, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7728, 
      AGR [COUNT @D7727, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7730, 
      AGR [COUNT @D7729, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7732, 
      AGR [COUNT @D7731, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7734, 
      AGR [COUNT @D7733, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK, 
   [COORD @D7736, 
      AGR [COUNT @D7735, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASK.

WORD associate : 
   [COORD @D7746, AGR [COUNT @D7745, PER @D7744, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM WITH, LAT -, ARITY 3] : ASSOCIATE, 
   [COORD @D7748, AGR [COUNT @D7747, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, 
      ARITY 3] : ASSOCIATE, 
   [COORD @D7750, AGR [COUNT @D7749, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, 
      ARITY 3] : ASSOCIATE, 
   [COORD @D7754, AGR [COUNT @D7753, PER @D7752, PLU @D7751, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      PFORM WITH, LAT -, ARITY 3] : ASSOCIATE, 
   [COORD @D7760, PAST @D7759, 
      AGR [CASE @D7758, COUNT @D7757, PER @D7756, PLU @D7755, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, LAT -, ARITY 3] : 
   ASSOCIATE, 
   [COORD @D7763, AGR [COUNT @D7762, PER @D7761, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASSOCIATE, 
   [COORD @D7765, AGR [COUNT @D7764, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASSOCIATE, 
   
   [COORD @D7767, AGR [COUNT @D7766, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASSOCIATE, 
   
   [COORD @D7771, AGR [COUNT @D7770, PER @D7769, PLU @D7768, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASSOCIATE, 
   [COORD @D7777, PAST @D7776, AGR [CASE @D7775, COUNT @D7774, 
            PER @D7773, PLU @D7772, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ASSOCIATE, 
   [COORD @D7780, AGR [COUNT @D7779, PER @D7778, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      LAT -, ARITY 2] : ASSOCIATE, 
   [COORD @D7782, AGR [COUNT @D7781, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, LAT -, 
      ARITY 2] : ASSOCIATE, 
   [COORD @D7784, AGR [COUNT @D7783, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, LAT -, 
      ARITY 2] : ASSOCIATE, 
   [COORD @D7788, AGR [COUNT @D7787, PER @D7786, PLU @D7785, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      LAT -, ARITY 2] : ASSOCIATE, 
   [COORD @D7794, PAST @D7793, AGR [CASE @D7792, COUNT @D7791, 
            PER @D7790, PLU @D7789, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT PP, PFORM WITH, LAT -, ARITY 2] : ASSOCIATE, 
   [COORD @D7797, AGR 
         [COUNT @D7796, PER @D7795, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   ASSOCIATE, 
   [COORD @D7799, AGR [COUNT @D7798, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   ASSOCIATE, 
   [COORD @D7801, AGR [COUNT @D7800, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : 
   ASSOCIATE, 
   [COORD @D7805, AGR [COUNT @D7804, PER @D7803, PLU @D7802, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ASSOCIATE, 
   [COORD @D7811, PAST @D7810, AGR [CASE @D7809, COUNT @D7808, 
            PER @D7807, PLU @D7806, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ASSOCIATE.

WORD associated : 
   [COORD @D7824, AGR [CASE @D7823, COUNT @D7822, PER @D7821, 
            PLU @D7820, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7829, AGR [CASE @D7828, COUNT @D7827, PER @D7826, 
            PLU @D7825, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7834, AGR [CASE @D7833, COUNT @D7832, PER @D7831, 
            PLU @D7830, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7839, AGR [CASE @D7838, COUNT @D7837, PER @D7836, 
            PLU @D7835, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASSOCIATE, 
   [COORD @D7844, AGR [CASE @D7843, COUNT @D7842, PER @D7841, 
            PLU @D7840, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ASSOCIATE, 
   [COORD @D7849, AGR [CASE @D7848, COUNT @D7847, PER @D7846, 
            PLU @D7845, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ASSOCIATE, 
   [COORD @D7854, AGR [CASE @D7853, COUNT @D7852, PER @D7851, 
            PLU @D7850, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7859, AGR [CASE @D7858, COUNT @D7857, PER @D7856, 
            PLU @D7855, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7864, AGR [CASE @D7863, COUNT @D7862, PER @D7861, 
            PLU @D7860, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7869, AGR [CASE @D7868, COUNT @D7867, PER @D7866, 
            PLU @D7865, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ASSOCIATE.

WORD associates : 
   [COORD @D7879, AGR [COUNT @D7878, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ASSOCIATE, 
   [COORD @D7881, AGR [COUNT @D7880, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7883, 
      AGR [COUNT @D7882, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   ASSOCIATE, 
   [COORD @D7885, AGR [COUNT @D7884, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSOCIATE.

WORD associating : 
   [COORD @D7898, PRD @D7897, AGR [CASE @D7896, COUNT @D7895, 
            PER @D7894, PLU @D7893, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7904, PRD @D7903, 
      AGR [CASE @D7902, COUNT @D7901, PER @D7900, PLU @D7899, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSOCIATE, 
   [COORD @D7910, PRD @D7909, 
      AGR [CASE @D7908, COUNT @D7907, PER @D7906, PLU @D7905, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ASSOCIATE, 
   [COORD @D7916, PRD @D7915, AGR [CASE @D7914, COUNT @D7913, 
            PER @D7912, PLU @D7911, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASSOCIATE.

WORD assume : 
   [COORD @D7924, AGR [COUNT @D7923, PER @D7922, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7926, AGR [COUNT @D7925, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7928, 
      AGR [COUNT @D7927, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7932, 
      AGR [COUNT @D7931, PER @D7930, PLU @D7929, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7938, PAST @D7937, AGR [CASE @D7936, COUNT @D7935, 
            PER @D7934, PLU @D7933, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7941, AGR [COUNT @D7940, PER @D7939, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7943, AGR [COUNT @D7942, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7945, AGR [COUNT @D7944, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7949, AGR [COUNT @D7948, PER @D7947, PLU @D7946, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7955, PAST @D7954, AGR [CASE @D7953, COUNT @D7952, 
            PER @D7951, PLU @D7950, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_NP, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7958, AGR [COUNT @D7957, PER @D7956, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7960, AGR [COUNT @D7959, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7962, AGR [COUNT @D7961, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7966, AGR [COUNT @D7965, PER @D7964, PLU @D7963, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7972, PAST @D7971, AGR [CASE @D7970, COUNT @D7969, 
            PER @D7968, PLU @D7967, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7975, AGR [COUNT @D7974, PER @D7973, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7977, AGR [COUNT @D7976, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7979, AGR [COUNT @D7978, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, ARITY 2] : 
   ASSUME, 
   [COORD @D7983, AGR [COUNT @D7982, PER @D7981, PLU @D7980, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7989, PAST @D7988, AGR [CASE @D7987, COUNT @D7986, 
            PER @D7985, PLU @D7984, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7992, AGR [COUNT @D7991, PER @D7990, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D7994, AGR [COUNT @D7993, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASSUME, 
   [COORD @D7996, 
      AGR [COUNT @D7995, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ASSUME, 
   [COORD @D8000, 
      AGR [COUNT @D7999, PER @D7998, PLU @D7997, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ASSUME, 
   [COORD @D8006, PAST @D8005, AGR [CASE @D8004, COUNT @D8003, 
            PER @D8002, PLU @D8001, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ASSUME.

WORD assumed : 
   [COORD @D8017, AGR [UB @D8016, VFORM @D8015, SUBJ @D8014, FIN @D8013, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8022, 
      AGR [CASE @D8021, COUNT @D8020, PER @D8019, PLU @D8018, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8027, 
      AGR [CASE @D8026, COUNT @D8025, PER @D8024, PLU @D8023, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8032, 
      AGR [CASE @D8031, COUNT @D8030, PER @D8029, PLU @D8028, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT OC_NP, CONJ NULL, 
      SUBTYPE RAIS, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8037, 
      AGR [CASE @D8036, COUNT @D8035, PER @D8034, PLU @D8033, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8042, 
      AGR [CASE @D8041, COUNT @D8040, PER @D8039, PLU @D8038, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8048, 
      AGR [CASE @D8047, NFORM @D8046, COUNT @D8045, PER @D8044, 
            PLU @D8043, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASSUME, 
   [COORD @D8053, AGR [UB @D8052, VFORM @D8051, SUBJ @D8050, FIN @D8049, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8058, 
      AGR [CASE @D8057, COUNT @D8056, PER @D8055, PLU @D8054, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8063, 
      AGR [CASE @D8062, COUNT @D8061, PER @D8060, PLU @D8059, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8068, 
      AGR [CASE @D8067, COUNT @D8066, PER @D8065, PLU @D8064, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8073, 
      AGR [CASE @D8072, COUNT @D8071, PER @D8070, PLU @D8069, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8079, 
      AGR [CASE @D8078, NFORM @D8077, COUNT @D8076, PER @D8075, 
            PLU @D8074, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ASSUME, 
   [COORD @D8084, AGR [UB @D8083, VFORM @D8082, SUBJ @D8081, FIN @D8080, 
            N -, V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, 
      FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8089, 
      AGR [CASE @D8088, COUNT @D8087, PER @D8086, PLU @D8085, NFORM NORM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8094, 
      AGR [CASE @D8093, COUNT @D8092, PER @D8091, PLU @D8090, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, 
      PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8099, 
      AGR [CASE @D8098, COUNT @D8097, PER @D8096, PLU @D8095, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, V +, N -] : ASSUME.

WORD assumes : 
   [COORD @D8107, AGR [COUNT @D8106, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8109, 
      AGR [COUNT @D8108, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8111, 
      AGR [COUNT @D8110, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8113, 
      AGR [COUNT @D8112, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8115, 
      AGR [COUNT @D8114, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ASSUME.

WORD assuming : 
   [COORD @D8126, PRD @D8125, AGR [CASE @D8124, COUNT @D8123, 
            PER @D8122, PLU @D8121, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8132, PRD @D8131, 
      AGR [CASE @D8130, COUNT @D8129, PER @D8128, PLU @D8127, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8138, PRD @D8137, 
      AGR [CASE @D8136, COUNT @D8135, PER @D8134, PLU @D8133, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8144, PRD @D8143, 
      AGR [CASE @D8142, COUNT @D8141, PER @D8140, PLU @D8139, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME, 
   [COORD @D8150, PRD @D8149, 
      AGR [CASE @D8148, COUNT @D8147, PER @D8146, PLU @D8145, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ASSUME.

WORD attach : 
   [COORD @D8161, AGR [COUNT @D8160, PER @D8159, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM TO, ARITY 3] : ATTACH, 
   [COORD @D8163, AGR [COUNT @D8162, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM TO, ARITY 3] : ATTACH, 
   [COORD @D8165, AGR [COUNT @D8164, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM TO, ARITY 3] : ATTACH, 
   [COORD @D8169, AGR [COUNT @D8168, PER @D8167, PLU @D8166, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM TO, ARITY 3] : ATTACH, 
   [COORD @D8175, PAST @D8174, 
      AGR [CASE @D8173, COUNT @D8172, PER @D8171, PLU @D8170, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM TO, ARITY 3] : 
   ATTACH, 
   [COORD @D8178, AGR [COUNT @D8177, PER @D8176, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ATTACH, 
   [COORD @D8180, AGR [COUNT @D8179, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ATTACH, 
   [COORD @D8182, AGR [COUNT @D8181, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, LAT -, 
      ARITY 3] : ATTACH, 
   [COORD @D8186, AGR [COUNT @D8185, PER @D8184, PLU @D8183, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, PFORM TO, 
      LAT -, ARITY 3] : ATTACH, 
   [COORD @D8192, PAST @D8191, AGR [CASE @D8190, COUNT @D8189, 
            PER @D8188, PLU @D8187, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM TO, LAT -, ARITY 3] : ATTACH, 
   [COORD @D8195, AGR [COUNT @D8194, PER @D8193, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP TO, ARITY 2] : ATTACH, 
   [COORD @D8197, AGR [COUNT @D8196, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP TO, ARITY 2] : ATTACH, 
   [COORD @D8199, AGR [COUNT @D8198, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP TO, ARITY 2] : ATTACH, 
   [COORD @D8203, AGR [COUNT @D8202, PER @D8201, PLU @D8200, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP TO, ARITY 2] : ATTACH, 
   [COORD @D8209, PAST @D8208, 
      AGR [CASE @D8207, COUNT @D8206, PER @D8205, PLU @D8204, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, PREP TO, 
      ARITY 2] : ATTACH, 
   [COORD @D8212, AGR [COUNT @D8211, PER @D8210, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ATTACH, 
   [COORD @D8214, AGR [COUNT @D8213, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ATTACH, 
   [COORD @D8216, AGR [COUNT @D8215, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ATTACH, 
   [COORD @D8220, AGR [COUNT @D8219, PER @D8218, PLU @D8217, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : ATTACH, 
   [COORD @D8226, PAST @D8225, AGR [CASE @D8224, COUNT @D8223, 
            PER @D8222, PLU @D8221, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, ARITY 2] : ATTACH, 
   [COORD @D8229, 
      AGR [COUNT @D8228, PER @D8227, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACH, 
   [COORD @D8231, 
      AGR [COUNT @D8230, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACH, 
   [COORD @D8233, 
      AGR [COUNT @D8232, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACH, 
   [COORD @D8237, 
      AGR [COUNT @D8236, PER @D8235, PLU @D8234, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ATTACH, 
   [COORD @D8243, PAST @D8242, AGR [CASE @D8241, COUNT @D8240, 
            PER @D8239, PLU @D8238, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ATTACH.

WORD attached : 
   [COORD @D8253, AGR [CASE @D8252, COUNT @D8251, PER @D8250, 
            PLU @D8249, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE PVERB, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTACH, 
   [COORD @D8258, AGR [CASE @D8257, COUNT @D8256, PER @D8255, 
            PLU @D8254, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8263, AGR [CASE @D8262, COUNT @D8261, PER @D8260, 
            PLU @D8259, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8268, AGR [CASE @D8267, COUNT @D8266, PER @D8265, 
            PLU @D8264, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTACH, 
   [COORD @D8273, AGR [CASE @D8272, COUNT @D8271, PER @D8270, 
            PLU @D8269, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8278, AGR [CASE @D8277, COUNT @D8276, PER @D8275, 
            PLU @D8274, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8283, AGR [CASE @D8282, COUNT @D8281, PER @D8280, 
            PLU @D8279, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8288, AGR [CASE @D8287, COUNT @D8286, PER @D8285, 
            PLU @D8284, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8293, AGR [CASE @D8292, COUNT @D8291, PER @D8290, 
            PLU @D8289, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8298, AGR [CASE @D8297, COUNT @D8296, PER @D8295, 
            PLU @D8294, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8303, AGR [CASE @D8302, COUNT @D8301, PER @D8300, 
            PLU @D8299, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM TO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTACH, 
   [COORD @D8308, AGR [CASE @D8307, COUNT @D8306, PER @D8305, 
            PLU @D8304, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ATTACH, 
   [COORD @D8313, AGR [CASE @D8312, COUNT @D8311, PER @D8310, 
            PLU @D8309, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ATTACH, 
   [COORD @D8318, AGR [CASE @D8317, COUNT @D8316, PER @D8315, 
            PLU @D8314, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ATTACH.

WORD attaching : 
   [COORD @D8331, PRD @D8330, AGR [CASE @D8329, COUNT @D8328, 
            PER @D8327, PLU @D8326, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8337, PRD @D8336, 
      AGR [CASE @D8335, COUNT @D8334, PER @D8333, PLU @D8332, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   ATTACH, 
   [COORD @D8343, PRD @D8342, AGR [CASE @D8341, COUNT @D8340, PER 
               @D8339, PLU @D8338, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : ATTACH, 
   [COORD @D8349, PRD @D8348, 
      AGR [CASE @D8347, COUNT @D8346, PER @D8345, PLU @D8344, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ATTACH, 
   [COORD @D8355, PRD @D8354, AGR [CASE @D8353, COUNT @D8352, 
            PER @D8351, PLU @D8350, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ATTACH.

WORD attack : 
   [COORD @D8369, REFL @D8368, COUNT @D8367, PRD @D8366, CASE @D8365, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ATTACK, 
   [COORD @D8373, REFL @D8372, PRD @D8371, CASE @D8370, FIX NOT, INFL +, 
      BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM ON, COUNT +] : ATTACK, 
   [COORD @D8377, REFL @D8376, PRD @D8375, CASE @D8374, FIX NOT, INFL +, 
      BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM OF, COUNT +] : ATTACK, 
   [COORD @D8380, 
      AGR [COUNT @D8379, PER @D8378, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACK, 
   [COORD @D8382, 
      AGR [COUNT @D8381, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACK, 
   [COORD @D8384, 
      AGR [COUNT @D8383, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTACK, 
   [COORD @D8388, 
      AGR [COUNT @D8387, PER @D8386, PLU @D8385, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ATTACK, 
   [COORD @D8394, PAST @D8393, AGR [CASE @D8392, COUNT @D8391, 
            PER @D8390, PLU @D8389, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ATTACK, 
   [COORD @D8397, AGR [COUNT @D8396, PER @D8395, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ATTACK, 
   [COORD @D8399, AGR [COUNT @D8398, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ATTACK, 
   [COORD @D8401, 
      AGR [COUNT @D8400, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, ARITY 1] : ATTACK, 
   [COORD @D8405, 
      AGR [COUNT @D8404, PER @D8403, PLU @D8402, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : ATTACK, 
   [COORD @D8411, PAST @D8410, AGR [CASE @D8409, COUNT @D8408, 
            PER @D8407, PLU @D8406, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : ATTACK.

WORD attacked : 
   [COORD @D8422, AGR [CASE @D8421, COUNT @D8420, PER @D8419, 
            PLU @D8418, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ATTACK, 
   [COORD @D8427, AGR [CASE @D8426, COUNT @D8425, PER @D8424, 
            PLU @D8423, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ATTACK, 
   [COORD @D8432, AGR [CASE @D8431, COUNT @D8430, PER @D8429, 
            PLU @D8428, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ATTACK, 
   [COORD @D8437, AGR [CASE @D8436, COUNT @D8435, PER @D8434, 
            PLU @D8433, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTACK, 
   [COORD @D8442, AGR [CASE @D8441, COUNT @D8440, PER @D8439, 
            PLU @D8438, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ATTACK.

WORD attacking : 
   [COORD @D8458, PRD @D8457, AGR [CASE @D8456, COUNT @D8455, 
            PER @D8454, PLU @D8453, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ATTACK, 
   [COORD @D8464, PRD @D8463, 
      AGR [CASE @D8462, COUNT @D8461, PER @D8460, PLU @D8459, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ATTACK.

WORD attacks : 
   [COORD @D8475, DEMON @D8474, REFL @D8473, PRD @D8472, CASE @D8471, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTACK, 
   [COORD @D8480, DEMON @D8479, REFL @D8478, PRD @D8477, CASE @D8476, 
      COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, SUBCAT PP, 
      PFORM ON, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, 
      NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTACK, 
   [COORD @D8485, DEMON @D8484, REFL @D8483, PRD @D8482, CASE @D8481, 
      COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, SUBCAT PP, 
      PFORM OF, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, 
      NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTACK, 
   [COORD @D8487, 
      AGR [COUNT @D8486, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ATTACK, 
   [COORD @D8489, 
      AGR [COUNT @D8488, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ATTACK.

WORD attempt : 
   [COORD @D8497, REFL @D8496, PRD @D8495, CASE @D8494, FIX NOT, INFL +, 
      BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM AT, COUNT +] : ATTEMPT, 
   [COORD @D8501, REFL @D8500, PRD @D8499, CASE @D8498, FIX NOT, INFL +, 
      BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT VPINF, COUNT +] : ATTEMPT, 
   [COORD @D8506, REFL @D8505, COUNT @D8504, PRD @D8503, CASE @D8502, 
      FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, 
      PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : ATTEMPT, 
   [COORD @D8509, 
      AGR [COUNT @D8508, PER @D8507, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8511, 
      AGR [COUNT @D8510, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8513, 
      AGR [COUNT @D8512, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8517, 
      AGR [COUNT @D8516, PER @D8515, PLU @D8514, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, LAT -, 
      ARITY 2] : ATTEMPT, 
   [COORD @D8523, PAST @D8522, AGR [CASE @D8521, COUNT @D8520, 
            PER @D8519, PLU @D8518, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_ING, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8526, AGR [COUNT @D8525, PER @D8524, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ATTEMPT, 
   [COORD @D8528, AGR [COUNT @D8527, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ATTEMPT, 
   [COORD @D8530, AGR [COUNT @D8529, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, ARITY 2] : 
   ATTEMPT, 
   [COORD @D8534, AGR [COUNT @D8533, PER @D8532, PLU @D8531, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, LAT -, 
      ARITY 2] : ATTEMPT, 
   [COORD @D8540, PAST @D8539, AGR [CASE @D8538, COUNT @D8537, 
            PER @D8536, PLU @D8535, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, CONJ NULL, COMPOUND NOT, 
      SUBCAT SC_INF, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8543, AGR [COUNT @D8542, PER @D8541, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ATTEMPT, 
   [COORD @D8545, AGR [COUNT @D8544, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8547, 
      AGR [COUNT @D8546, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 2, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, ARITY 2] : ATTEMPT, 
   [COORD @D8551, 
      AGR [COUNT @D8550, PER @D8549, PLU @D8548, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : ATTEMPT, 
   [COORD @D8557, PAST @D8556, AGR [CASE @D8555, COUNT @D8554, 
            PER @D8553, PLU @D8552, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : ATTEMPT.

WORD attempted : 
   [COORD @D8568, AGR [CASE @D8567, COUNT @D8566, PER @D8565, 
            PLU @D8564, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8573, AGR [CASE @D8572, COUNT @D8571, PER @D8570, 
            PLU @D8569, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8578, AGR [CASE @D8577, COUNT @D8576, PER @D8575, 
            PLU @D8574, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8583, AGR [CASE @D8582, COUNT @D8581, PER @D8580, 
            PLU @D8579, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8588, AGR [CASE @D8587, COUNT @D8586, PER @D8585, 
            PLU @D8584, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : ATTEMPT, 
   [COORD @D8593, AGR [CASE @D8592, COUNT @D8591, PER @D8590, 
            PLU @D8589, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : ATTEMPT, 
   [COORD @D8598, AGR [CASE @D8597, COUNT @D8596, PER @D8595, 
            PLU @D8594, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : ATTEMPT.

WORD attempting : 
   [COORD @D8614, PRD @D8613, AGR [CASE @D8612, COUNT @D8611, 
            PER @D8610, PLU @D8609, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8620, PRD @D8619, 
      AGR [CASE @D8618, COUNT @D8617, PER @D8616, PLU @D8615, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8626, PRD @D8625, 
      AGR [CASE @D8624, COUNT @D8623, PER @D8622, PLU @D8621, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : ATTEMPT.

WORD attempts : 
   [COORD @D8637, DEMON @D8636, REFL @D8635, PRD @D8634, CASE @D8633, 
      COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, SUBCAT PP, 
      PFORM AT, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, 
      NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTEMPT, 
   [COORD @D8642, DEMON @D8641, REFL @D8640, PRD @D8639, CASE @D8638, 
      COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, SUBCAT VPINF, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTEMPT, 
   [COORD @D8647, DEMON @D8646, REFL @D8645, PRD @D8644, CASE @D8643, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : ATTEMPT, 
   [COORD @D8649, 
      AGR [COUNT @D8648, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8651, 
      AGR [COUNT @D8650, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ATTEMPT, 
   [COORD @D8653, 
      AGR [COUNT @D8652, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : ATTEMPT.

WORD back : [FIX NOT, PRT BACK, INFL -] : BACK, 
   [COORD @D8661, AGR [COUNT @D8660, PER @D8659, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM WITH, ARITY 3] : BACK, 
   [COORD @D8663, AGR [COUNT @D8662, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : BACK, 
   [COORD @D8665, AGR [COUNT @D8664, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : BACK, 
   [COORD @D8669, AGR [COUNT @D8668, PER @D8667, PLU @D8666, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM WITH, ARITY 3] : BACK, 
   [COORD @D8675, PAST @D8674, 
      AGR [CASE @D8673, COUNT @D8672, PER @D8671, PLU @D8670, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM WITH, 
      ARITY 3] : BACK, 
   [COORD @D8678, AGR [COUNT @D8677, PER @D8676, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM IN, ARITY 3] : BACK, 
   [COORD @D8680, AGR [COUNT @D8679, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, 
      ARITY 3] : BACK, 
   [COORD @D8682, AGR [COUNT @D8681, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, 
      ARITY 3] : BACK, 
   [COORD @D8686, AGR [COUNT @D8685, PER @D8684, PLU @D8683, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, PFORM IN, ARITY 3] : BACK, 
   [COORD @D8692, PAST @D8691, 
      AGR [CASE @D8690, COUNT @D8689, PER @D8688, PLU @D8687, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, PFORM IN, 
      ARITY 3] : BACK, 
   [COORD @D8695, AGR [COUNT @D8694, PER @D8693, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BACK, 
   [COORD @D8697, AGR [COUNT @D8696, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BACK, 
   [COORD @D8699, AGR [COUNT @D8698, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BACK, 
   [COORD @D8703, AGR [COUNT @D8702, PER @D8701, PLU @D8700, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BACK, 
   [COORD @D8709, PAST @D8708, AGR [CASE @D8707, COUNT @D8706, 
            PER @D8705, PLU @D8704, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BACK, 
   [COORD @D8712, AGR [COUNT @D8711, PER @D8710, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ONTO, ARITY 2] : BACK, 
   [COORD @D8714, AGR [COUNT @D8713, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ONTO, ARITY 2] : BACK, 
   [COORD @D8716, AGR [COUNT @D8715, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ONTO, ARITY 2] : BACK, 
   [COORD @D8720, AGR [COUNT @D8719, PER @D8718, PLU @D8717, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ONTO, ARITY 2] : BACK, 
   [COORD @D8726, PAST @D8725, AGR [CASE @D8724, COUNT @D8723, 
            PER @D8722, PLU @D8721, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM ONTO, ARITY 2] : BACK, 
   [COORD @D8729, 
      AGR [COUNT @D8728, PER @D8727, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM OF, ARITY 2] : BACK, 
   [COORD @D8731, AGR [COUNT @D8730, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM OF, ARITY 2] : BACK, 
   [COORD @D8733, AGR [COUNT @D8732, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM OF, ARITY 2] : BACK, 
   [COORD @D8737, AGR [COUNT @D8736, PER @D8735, PLU @D8734, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT OUT, PFORM OF, ARITY 2] : BACK, 
   [COORD @D8743, PAST @D8742, AGR [CASE @D8741, COUNT @D8740, 
            PER @D8739, PLU @D8738, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PRT OUT, PFORM OF, ARITY 2] : BACK, 
   [COORD @D8746, 
      AGR [COUNT @D8745, PER @D8744, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8748, AGR [COUNT @D8747, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8750, AGR [COUNT @D8749, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8754, AGR [COUNT @D8753, PER @D8752, PLU @D8751, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT OUT, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8760, PAST @D8759, AGR 
         [CASE @D8758, COUNT @D8757, PER @D8756, PLU @D8755, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OUT, PFORM FROM, 
      ARITY 2] : BACK, 
   [COORD @D8763, AGR [COUNT @D8762, PER @D8761, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT OFF, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8765, AGR [COUNT @D8764, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OFF, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8767, AGR [COUNT @D8766, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OFF, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8771, AGR [COUNT @D8770, PER @D8769, PLU @D8768, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT OFF, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8777, PAST @D8776, AGR 
         [CASE @D8775, COUNT @D8774, PER @D8773, PLU @D8772, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT OFF, PFORM FROM, 
      ARITY 2] : BACK, 
   [COORD @D8780, AGR [COUNT @D8779, PER @D8778, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT DOWN, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8782, AGR [COUNT @D8781, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT DOWN, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8784, AGR [COUNT @D8783, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT DOWN, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8788, AGR [COUNT @D8787, PER @D8786, PLU @D8785, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT DOWN, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8794, PAST @D8793, 
      AGR [CASE @D8792, COUNT @D8791, PER @D8790, PLU @D8789, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT DOWN, PFORM FROM, 
      ARITY 2] : BACK, 
   [COORD @D8797, AGR [COUNT @D8796, PER @D8795, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT AWAY, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8799, AGR [COUNT @D8798, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT AWAY, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8801, AGR [COUNT @D8800, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT AWAY, 
      PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8805, AGR [COUNT @D8804, PER @D8803, PLU @D8802, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT AWAY, PFORM FROM, ARITY 2] : BACK, 
   [COORD @D8811, PAST @D8810, 
      AGR [CASE @D8809, COUNT @D8808, PER @D8807, PLU @D8806, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT AWAY, PFORM FROM, 
      ARITY 2] : BACK, 
   [COORD @D8814, AGR [COUNT @D8813, PER @D8812, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : BACK, 
   [COORD @D8816, AGR [COUNT @D8815, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BACK, 
   [COORD @D8818, AGR [COUNT @D8817, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BACK, 
   [COORD @D8822, AGR [COUNT @D8821, PER @D8820, PLU @D8819, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : BACK, 
   [COORD @D8828, PAST @D8827, AGR [CASE @D8826, COUNT @D8825, 
            PER @D8824, PLU @D8823, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT UP, ARITY 2] : BACK, 
   [COORD @D8831, AGR [COUNT @D8830, PER @D8829, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BACK, 
   [COORD @D8833, AGR [COUNT @D8832, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BACK, 
   [COORD @D8835, AGR [COUNT @D8834, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BACK, 
   [COORD @D8839, AGR [COUNT @D8838, PER @D8837, PLU @D8836, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BACK, 
   [COORD @D8845, PAST @D8844, AGR [CASE @D8843, COUNT @D8842, 
            PER @D8841, PLU @D8840, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : BACK, 
   [COORD @D8848, AGR [COUNT @D8847, PER @D8846, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BACK, 
   [COORD @D8850, AGR [COUNT @D8849, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : BACK, 
   [COORD @D8852, AGR [COUNT @D8851, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : BACK, 
   [COORD @D8856, AGR [COUNT @D8855, PER @D8854, PLU @D8853, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BACK, 
   [COORD @D8862, PAST @D8861, AGR 
         [CASE @D8860, COUNT @D8859, PER @D8858, PLU @D8857, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, ARITY 1] : 
   BACK, 
   [COORD @D8865, AGR [COUNT @D8864, PER @D8863, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BACK, 
   [COORD @D8867, AGR [COUNT @D8866, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : BACK, 
   [COORD @D8869, AGR [COUNT @D8868, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : BACK, 
   [COORD @D8873, AGR [COUNT @D8872, PER @D8871, PLU @D8870, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BACK, 
   [COORD @D8879, PAST @D8878, 
      AGR [CASE @D8877, COUNT @D8876, PER @D8875, PLU @D8874, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, ARITY 1] : 
   BACK, 
   [COORD @D8882, AGR [COUNT @D8881, PER @D8880, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BACK, 
   [COORD @D8884, AGR [COUNT @D8883, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OFF, 
      ARITY 1] : BACK, 
   [COORD @D8886, AGR [COUNT @D8885, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OFF, 
      ARITY 1] : BACK, 
   [COORD @D8890, AGR [COUNT @D8889, PER @D8888, PLU @D8887, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BACK, 
   [COORD @D8896, PAST @D8895, 
      AGR [CASE @D8894, COUNT @D8893, PER @D8892, PLU @D8891, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OFF, ARITY 1] : 
   BACK, 
   [COORD @D8899, AGR [COUNT @D8898, PER @D8897, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BACK, 
   [COORD @D8901, AGR [COUNT @D8900, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT DOWN, 
      ARITY 1] : BACK, 
   [COORD @D8903, AGR [COUNT @D8902, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT DOWN, 
      ARITY 1] : BACK, 
   [COORD @D8907, AGR [COUNT @D8906, PER @D8905, PLU @D8904, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BACK, 
   [COORD @D8913, PAST @D8912, 
      AGR [CASE @D8911, COUNT @D8910, PER @D8909, PLU @D8908, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT DOWN, ARITY 1] : 
   BACK, 
   [COORD @D8916, AGR [COUNT @D8915, PER @D8914, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BACK, 
   [COORD @D8918, AGR [COUNT @D8917, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT AWAY, 
      ARITY 1] : BACK, 
   [COORD @D8920, AGR [COUNT @D8919, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT AWAY, 
      ARITY 1] : BACK, 
   [COORD @D8924, AGR [COUNT @D8923, PER @D8922, PLU @D8921, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BACK, 
   [COORD @D8930, PAST @D8929, 
      AGR [CASE @D8928, COUNT @D8927, PER @D8926, PLU @D8925, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT AWAY, ARITY 1] : 
   BACK.

WORD backed : 
   [COORD @D8942, AGR [CASE @D8941, COUNT @D8940, PER @D8939, PLU 
               @D8938, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D8947, AGR [CASE @D8946, COUNT @D8945, PER @D8944, 
            PLU @D8943, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D8952, AGR [CASE @D8951, COUNT @D8950, PER @D8949, 
            PLU @D8948, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D8957, AGR [CASE @D8956, COUNT @D8955, PER @D8954, 
            PLU @D8953, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, SUBTYPE NONE, CONJ NULL, PFORM IN, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D8962, AGR [CASE @D8961, COUNT @D8960, PER @D8959, 
            PLU @D8958, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D8967, AGR [CASE @D8966, COUNT @D8965, PER @D8964, 
            PLU @D8963, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D8972, AGR [CASE @D8971, COUNT @D8970, PER @D8969, 
            PLU @D8968, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BACK, 
   [COORD @D8977, AGR [CASE @D8976, COUNT @D8975, PER @D8974, 
            PLU @D8973, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BACK, 
   [COORD @D8982, AGR [CASE @D8981, COUNT @D8980, PER @D8979, 
            PLU @D8978, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : BACK, 
   [COORD @D8987, AGR [CASE @D8986, COUNT @D8985, PER @D8984, 
            PLU @D8983, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ONTO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D8992, AGR [CASE @D8991, COUNT @D8990, PER @D8989, 
            PLU @D8988, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ONTO, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D8997, AGR [CASE @D8996, COUNT @D8995, PER @D8994, 
            PLU @D8993, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM ONTO, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D9002, AGR [CASE @D9001, COUNT @D9000, PER @D8999, 
            PLU @D8998, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OUT, PFORM OF, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9007, AGR [CASE @D9006, COUNT @D9005, PER @D9004, 
            PLU @D9003, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OUT, PFORM OF, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9012, AGR [CASE @D9011, COUNT @D9010, PER @D9009, 
            PLU @D9008, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OUT, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9017, AGR [CASE @D9016, COUNT @D9015, PER @D9014, 
            PLU @D9013, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OUT, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9022, AGR [CASE @D9021, COUNT @D9020, PER @D9019, 
            PLU @D9018, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OFF, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9027, AGR [CASE @D9026, COUNT @D9025, PER @D9024, 
            PLU @D9023, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OFF, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9032, AGR [CASE @D9031, COUNT @D9030, PER @D9029, 
            PLU @D9028, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT DOWN, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9037, AGR [CASE @D9036, COUNT @D9035, PER @D9034, 
            PLU @D9033, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT DOWN, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9042, AGR [CASE @D9041, COUNT @D9040, PER @D9039, 
            PLU @D9038, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT AWAY, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9047, AGR [CASE @D9046, COUNT @D9045, PER @D9044, 
            PLU @D9043, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT AWAY, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9052, AGR [CASE @D9051, COUNT @D9050, PER @D9049, 
            PLU @D9048, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9057, AGR [CASE @D9056, COUNT @D9055, PER @D9054, 
            PLU @D9053, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9062, AGR [CASE @D9061, COUNT @D9060, PER @D9059, 
            PLU @D9058, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D9067, AGR [CASE @D9066, COUNT @D9065, PER @D9064, 
            PLU @D9063, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D9072, AGR [CASE @D9071, COUNT @D9070, PER @D9069, 
            PLU @D9068, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : BACK, 
   [COORD @D9077, AGR [CASE @D9076, COUNT @D9075, PER @D9074, 
            PLU @D9073, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9082, AGR [CASE @D9081, COUNT @D9080, PER @D9079, 
            PLU @D9078, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9087, AGR [CASE @D9086, COUNT @D9085, PER @D9084, 
            PLU @D9083, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9092, AGR [CASE @D9091, COUNT @D9090, PER @D9089, 
            PLU @D9088, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9097, AGR [CASE @D9096, COUNT @D9095, PER @D9094, 
            PLU @D9093, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OFF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9102, AGR [CASE @D9101, COUNT @D9100, PER @D9099, 
            PLU @D9098, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OFF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9107, AGR [CASE @D9106, COUNT @D9105, PER @D9104, 
            PLU @D9103, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9112, AGR [CASE @D9111, COUNT @D9110, PER @D9109, 
            PLU @D9108, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK, 
   [COORD @D9117, AGR [CASE @D9116, COUNT @D9115, PER @D9114, 
            PLU @D9113, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT AWAY, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9122, AGR [CASE @D9121, COUNT @D9120, PER @D9119, 
            PLU @D9118, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT AWAY, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BACK.

WORD backing : 
   [COORD @D9137, PRD @D9136, AGR [CASE @D9135, COUNT @D9134, 
            PER @D9133, PLU @D9132, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9143, PRD @D9142, 
      AGR [CASE @D9141, COUNT @D9140, PER @D9139, PLU @D9138, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9149, PRD @D9148, AGR [CASE @D9147, COUNT @D9146, PER 
               @D9145, PLU @D9144, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9155, PRD @D9154, AGR [CASE @D9153, COUNT @D9152, 
            PER @D9151, PLU @D9150, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ONTO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9161, PRD @D9160, 
      AGR [CASE @D9159, COUNT @D9158, PER @D9157, PLU @D9156, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT OUT, PFORM OF, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BACK, 
   [COORD @D9167, PRD @D9166, AGR [CASE @D9165, COUNT @D9164, 
            PER @D9163, PLU @D9162, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT OUT, 
      PFORM FROM, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9173, PRD @D9172, 
      AGR [CASE @D9171, COUNT @D9170, PER @D9169, PLU @D9168, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT OFF, PFORM FROM, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BACK, 
   [COORD @D9179, PRD @D9178, AGR [CASE @D9177, COUNT @D9176, 
            PER @D9175, PLU @D9174, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT DOWN, 
      PFORM FROM, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9185, PRD @D9184, 
      AGR [CASE @D9183, COUNT @D9182, PER @D9181, PLU @D9180, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT AWAY, PFORM FROM, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BACK, 
   [COORD @D9191, PRD @D9190, AGR [CASE @D9189, COUNT @D9188, 
            PER @D9187, PLU @D9186, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9197, PRD @D9196, 
      AGR [CASE @D9195, COUNT @D9194, PER @D9193, PLU @D9192, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9203, PRD @D9202, 
      AGR [CASE @D9201, COUNT @D9200, PER @D9199, PLU @D9198, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9209, PRD @D9208, AGR [CASE @D9207, COUNT @D9206, PER 
               @D9205, PLU @D9204, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9215, PRD @D9214, 
      AGR [CASE @D9213, COUNT @D9212, PER @D9211, PLU @D9210, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OFF, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9221, PRD @D9220, AGR [CASE @D9219, COUNT @D9218, PER 
               @D9217, PLU @D9216, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT DOWN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK, 
   [COORD @D9227, PRD @D9226, 
      AGR [CASE @D9225, COUNT @D9224, PER @D9223, PLU @D9222, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT AWAY, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BACK.

WORD backs : 
   [COORD @D9236, AGR [COUNT @D9235, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9238, AGR [COUNT @D9237, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9240, 
      AGR [COUNT @D9239, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9242, 
      AGR [COUNT @D9241, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM ONTO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9244, 
      AGR [COUNT @D9243, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT OUT, PFORM OF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9246, AGR [COUNT @D9245, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT OUT, PFORM FROM, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9248, AGR [COUNT @D9247, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT OFF, PFORM FROM, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BACK, 
   [COORD @D9250, AGR [COUNT @D9249, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT DOWN, PFORM FROM, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BACK, 
   [COORD @D9252, AGR [COUNT @D9251, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT AWAY, PFORM FROM, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BACK, 
   [COORD @D9254, AGR [COUNT @D9253, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9256, 
      AGR [COUNT @D9255, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9258, 
      AGR [COUNT @D9257, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9260, 
      AGR [COUNT @D9259, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9262, 
      AGR [COUNT @D9261, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OFF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9264, 
      AGR [COUNT @D9263, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK, 
   [COORD @D9266, 
      AGR [COUNT @D9265, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT AWAY, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BACK.

WORD bag : 
   [COORD @D9275, REFL @D9274, PRD @D9273, CASE @D9272, FIX NOT, BAR 0, 
      SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, COUNT +] : BAG, 
   [COORD @D9278, AGR [COUNT @D9277, PER @D9276, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BAG, 
   [COORD @D9280, AGR [COUNT @D9279, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : BAG, 
   
   [COORD @D9282, AGR [COUNT @D9281, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : BAG, 
   
   [COORD @D9286, AGR [COUNT @D9285, PER @D9284, PLU @D9283, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BAG, 
   [COORD @D9292, PAST @D9291, AGR [CASE @D9290, COUNT @D9289, 
            PER @D9288, PLU @D9287, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BAG, 
   [COORD @D9295, AGR [COUNT @D9294, PER @D9293, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BAG, 
   [COORD @D9297, AGR [COUNT @D9296, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BAG, 
   [COORD @D9299, AGR [COUNT @D9298, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BAG, 
   [COORD @D9303, AGR [COUNT @D9302, PER @D9301, PLU @D9300, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BAG, 
   [COORD @D9309, PAST @D9308, AGR [CASE @D9307, COUNT @D9306, 
            PER @D9305, PLU @D9304, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : BAG, 
   [COORD @D9312, AGR [COUNT @D9311, PER @D9310, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BAG, 
   [COORD @D9314, AGR [COUNT @D9313, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : BAG, 
   [COORD @D9316, AGR [COUNT @D9315, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : BAG, 
   [COORD @D9320, AGR [COUNT @D9319, PER @D9318, PLU @D9317, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BAG, 
   [COORD @D9326, PAST @D9325, AGR 
         [CASE @D9324, COUNT @D9323, PER @D9322, PLU @D9321, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, ARITY 1] : 
   BAG.

WORD bagged : 
   [COORD @D9338, AGR [CASE @D9337, COUNT @D9336, PER @D9335, PLU 
               @D9334, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BAG, 
   [COORD @D9343, AGR [CASE @D9342, COUNT @D9341, PER @D9340, 
            PLU @D9339, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : BAG, 
   [COORD @D9348, AGR [CASE @D9347, COUNT @D9346, PER @D9345, 
            PLU @D9344, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BAG, 
   [COORD @D9353, AGR [CASE @D9352, COUNT @D9351, PER @D9350, 
            PLU @D9349, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BAG, 
   [COORD @D9358, AGR [CASE @D9357, COUNT @D9356, PER @D9355, 
            PLU @D9354, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : BAG, 
   [COORD @D9363, AGR [CASE @D9362, COUNT @D9361, PER @D9360, 
            PLU @D9359, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BAG, 
   [COORD @D9368, AGR [CASE @D9367, COUNT @D9366, PER @D9365, 
            PLU @D9364, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BAG.

WORD bagging : 
   [COORD @D9381, PRD @D9380, AGR [CASE @D9379, COUNT @D9378, 
            PER @D9377, PLU @D9376, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BAG, 
   [COORD @D9387, PRD @D9386, AGR [CASE @D9385, COUNT @D9384, 
            PER @D9383, PLU @D9382, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BAG, 
   [COORD @D9393, PRD @D9392, AGR [CASE @D9391, COUNT @D9390, 
            PER @D9389, PLU @D9388, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OUT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BAG.

WORD bags : 
   [COORD @D9404, REFL @D9403, PRD @D9402, CASE @D9401, FIX NOT, N +, 
      V -, POSS -, PRO -, PROTYPE NONE, BAR 0, PN -, NFORM NORM, PER 3, 
      ADV -, PART -, DEMON -, INFL -, PLU +, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, REG -, PFORM OF, COUNT +] : BAGS, 
   [COORD @D9408, REFL @D9407, PRD @D9406, CASE @D9405, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, INFL -, PLU +, NUM -, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, REG -, COUNT +] : BAGS, 
   [COORD @D9413, DEMON @D9412, REFL @D9411, PRD @D9410, CASE @D9409, 
      COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, CONJ NULL, 
      PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, PLU +, NUM -, 
      AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BAG, 
   [COORD @D9415, 
      AGR [COUNT @D9414, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BAG, 
   [COORD @D9417, 
      AGR [COUNT @D9416, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BAG, 
   [COORD @D9419, 
      AGR [COUNT @D9418, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BAG.

WORD bank : 
   [COORD @D9439, AGR [COUNT @D9438, PER @D9437, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OE, 
      SUBCAT OC_PP_INF, PFORM ON, ARITY 3] : BANK, 
   [COORD @D9441, AGR [COUNT @D9440, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OE, 
      SUBCAT OC_PP_INF, PFORM ON, ARITY 3] : BANK, 
   [COORD @D9443, AGR [COUNT @D9442, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OE, 
      SUBCAT OC_PP_INF, PFORM ON, ARITY 3] : BANK, 
   [COORD @D9447, AGR [COUNT @D9446, PER @D9445, PLU @D9444, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OE, 
      SUBCAT OC_PP_INF, PFORM ON, ARITY 3] : BANK, 
   [COORD @D9453, PAST @D9452, 
      AGR [CASE @D9451, COUNT @D9450, PER @D9449, PLU @D9448, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB_OE, SUBCAT OC_PP_INF, PFORM ON, 
      ARITY 3] : BANK, 
   [COORD @D9456, AGR [COUNT @D9455, PER @D9454, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BANK, 
   [COORD @D9458, AGR [COUNT @D9457, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BANK, 
   [COORD @D9460, AGR [COUNT @D9459, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BANK, 
   [COORD @D9464, AGR [COUNT @D9463, PER @D9462, PLU @D9461, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BANK, 
   [COORD @D9470, PAST @D9469, AGR [CASE @D9468, COUNT @D9467, 
            PER @D9466, PLU @D9465, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BANK, 
   [COORD @D9473, AGR [COUNT @D9472, PER @D9471, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP ON, ARITY 2] : BANK, 
   [COORD @D9475, AGR [COUNT @D9474, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP ON, ARITY 2] : BANK, 
   [COORD @D9477, AGR [COUNT @D9476, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP ON, ARITY 2] : BANK, 
   [COORD @D9481, AGR [COUNT @D9480, PER @D9479, PLU @D9478, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP ON, ARITY 2] : BANK, 
   [COORD @D9487, PAST @D9486, 
      AGR [CASE @D9485, COUNT @D9484, PER @D9483, PLU @D9482, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, SUBTYPE EQUI, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, PREP ON, 
      ARITY 2] : BANK, 
   [COORD @D9490, AGR [COUNT @D9489, PER @D9488, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BANK, 
   [COORD @D9492, AGR [COUNT @D9491, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      ARITY 2] : BANK, 
   [COORD @D9494, AGR [COUNT @D9493, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM WITH, 
      ARITY 2] : BANK, 
   [COORD @D9498, AGR [COUNT @D9497, PER @D9496, PLU @D9495, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BANK, 
   [COORD @D9504, PAST @D9503, AGR [CASE @D9502, COUNT @D9501, 
            PER @D9500, PLU @D9499, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, PFORM WITH, ARITY 2] : BANK, 
   [COORD @D9507, 
      AGR [COUNT @D9506, PER @D9505, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM ON, 
      ARITY 2] : BANK, 
   [COORD @D9509, AGR [COUNT @D9508, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BANK, 
   [COORD @D9511, AGR [COUNT @D9510, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BANK, 
   [COORD @D9515, AGR [COUNT @D9514, PER @D9513, PLU @D9512, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BANK, 
   [COORD @D9521, PAST @D9520, AGR [CASE @D9519, COUNT @D9518, 
            PER @D9517, PLU @D9516, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM ON, ARITY 2] : BANK, 
   [COORD @D9524, 
      AGR [COUNT @D9523, PER @D9522, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, 
      PFORM ON, ARITY 2] : BANK, 
   [COORD @D9526, AGR [COUNT @D9525, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM ON, ARITY 2] : BANK, 
   [COORD @D9528, AGR [COUNT @D9527, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM ON, ARITY 2] : BANK, 
   [COORD @D9532, AGR [COUNT @D9531, PER @D9530, PLU @D9529, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM ON, ARITY 2] : BANK, 
   [COORD @D9538, PAST @D9537, 
      AGR [CASE @D9536, COUNT @D9535, PER @D9534, PLU @D9533, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM ON, 
      ARITY 2] : BANK, 
   [COORD @D9541, AGR [COUNT @D9540, PER @D9539, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : BANK, 
   [COORD @D9543, AGR [COUNT @D9542, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BANK, 
   [COORD @D9545, AGR [COUNT @D9544, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BANK, 
   [COORD @D9549, AGR [COUNT @D9548, PER @D9547, PLU @D9546, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : BANK, 
   [COORD @D9555, PAST @D9554, AGR [CASE @D9553, COUNT @D9552, 
            PER @D9551, PLU @D9550, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT UP, ARITY 2] : BANK, 
   [COORD @D9558, AGR [COUNT @D9557, PER @D9556, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BANK, 
   [COORD @D9560, AGR [COUNT @D9559, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BANK, 
   [COORD @D9562, AGR [COUNT @D9561, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, ARITY 1] : 
   BANK, 
   [COORD @D9566, AGR [COUNT @D9565, PER @D9564, PLU @D9563, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BANK, 
   [COORD @D9572, PAST @D9571, AGR [CASE @D9570, COUNT @D9569, 
            PER @D9568, PLU @D9567, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : BANK, 
   [COORD @D9575, AGR [COUNT @D9574, PER @D9573, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BANK, 
   [COORD @D9577, AGR [COUNT @D9576, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : BANK, 
   [COORD @D9579, AGR [COUNT @D9578, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : BANK, 
   [COORD @D9583, AGR [COUNT @D9582, PER @D9581, PLU @D9580, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BANK, 
   [COORD @D9589, PAST @D9588, AGR 
         [CASE @D9587, COUNT @D9586, PER @D9585, PLU @D9584, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, ARITY 1] : 
   BANK.

WORD banked : 
   [COORD @D9600, AGR [CASE @D9599, COUNT @D9598, PER @D9597, PLU 
               @D9596, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_INF, CONJ NULL, SUBTYPE PVERB_OE, PFORM ON, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9605, AGR [CASE @D9604, COUNT @D9603, PER @D9602, 
            PLU @D9601, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OE, SUBCAT OC_PP_INF, PFORM ON, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9610, AGR [CASE @D9609, COUNT @D9608, PER @D9607, 
            PLU @D9606, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OE, SUBCAT OC_PP_INF, PFORM ON, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9615, AGR [CASE @D9614, COUNT @D9613, PER @D9612, 
            PLU @D9611, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, PSVE +, PRO -, 
      VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BANK, 
   [COORD @D9620, AGR [CASE @D9619, COUNT @D9618, PER @D9617, 
            PLU @D9616, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BANK, 
   [COORD @D9625, AGR [CASE @D9624, COUNT @D9623, PER @D9622, 
            PLU @D9621, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, BAR 0, 
      V +, N -] : BANK, 
   [COORD @D9630, AGR [CASE @D9629, COUNT @D9628, PER @D9627, 
            PLU @D9626, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9635, AGR [CASE @D9634, COUNT @D9633, PER @D9632, 
            PLU @D9631, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9640, AGR [CASE @D9639, COUNT @D9638, PER @D9637, 
            PLU @D9636, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9645, AGR [CASE @D9644, COUNT @D9643, PER @D9642, 
            PLU @D9641, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9650, AGR [CASE @D9649, COUNT @D9648, PER @D9647, 
            PLU @D9646, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9655, AGR [CASE @D9654, COUNT @D9653, PER @D9652, 
            PLU @D9651, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9660, AGR [CASE @D9659, COUNT @D9658, PER @D9657, 
            PLU @D9656, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM ON, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9665, AGR [CASE @D9664, COUNT @D9663, PER @D9662, 
            PLU @D9661, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT OC_PP_ING, CONJ NULL, SUBTYPE PVERB_OR, PFORM ON, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9670, AGR [CASE @D9669, COUNT @D9668, PER @D9667, 
            PLU @D9666, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM ON, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9675, AGR [CASE @D9674, COUNT @D9673, PER @D9672, 
            PLU @D9671, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM ON, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9680, AGR [CASE @D9679, COUNT @D9678, PER @D9677, 
            PLU @D9676, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9685, AGR [CASE @D9684, COUNT @D9683, PER @D9682, 
            PLU @D9681, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BANK, 
   [COORD @D9690, AGR [CASE @D9689, COUNT @D9688, PER @D9687, 
            PLU @D9686, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9695, AGR [CASE @D9694, COUNT @D9693, PER @D9692, 
            PLU @D9691, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9700, AGR [CASE @D9699, COUNT @D9698, PER @D9697, 
            PLU @D9696, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, 
      REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9705, AGR [CASE @D9704, COUNT @D9703, PER @D9702, 
            PLU @D9701, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9710, AGR [CASE @D9709, COUNT @D9708, PER @D9707, 
            PLU @D9706, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BANK.

WORD banking : 
   [COORD @D9722, REFL @D9721, PRD @D9720, CASE @D9719, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, COUNT -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : BANKING, 
   [COORD @D9728, PRD @D9727, 
      AGR [CASE @D9726, COUNT @D9725, PER @D9724, PLU @D9723, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OE, SUBCAT OC_PP_INF, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9734, PRD @D9733, AGR [CASE @D9732, COUNT @D9731, 
            PER @D9730, PLU @D9729, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9740, PRD @D9739, AGR [CASE @D9738, COUNT @D9737, 
            PER @D9736, PLU @D9735, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP ON, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9746, PRD @D9745, 
      AGR [CASE @D9744, COUNT @D9743, PER @D9742, PLU @D9741, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BANK, 
   [COORD @D9752, PRD @D9751, AGR [CASE @D9750, COUNT @D9749, PER 
               @D9748, PLU @D9747, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM ON, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9758, PRD @D9757, 
      AGR [CASE @D9756, COUNT @D9755, PER @D9754, PLU @D9753, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OR, SUBCAT OC_PP_ING, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9764, PRD @D9763, AGR [CASE @D9762, COUNT @D9761, 
            PER @D9760, PLU @D9759, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9770, PRD @D9769, 
      AGR [CASE @D9768, COUNT @D9767, PER @D9766, PLU @D9765, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BANK, 
   [COORD @D9776, PRD @D9775, 
      AGR [CASE @D9774, COUNT @D9773, PER @D9772, PLU @D9771, BAR 2, V -, 
            N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BANK.

WORD banks : 
   [COORD @D9794, AGR [COUNT @D9793, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB_OE, SUBCAT OC_PP_INF, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, 
      BAR 0, V +, N -] : BANK, 
   [COORD @D9796, AGR [COUNT @D9795, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9798, 
      AGR [COUNT @D9797, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9800, 
      AGR [COUNT @D9799, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9802, 
      AGR [COUNT @D9801, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9804, 
      AGR [COUNT @D9803, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB_OR, 
      SUBCAT OC_PP_ING, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BANK, 
   [COORD @D9806, AGR [COUNT @D9805, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9808, 
      AGR [COUNT @D9807, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK, 
   [COORD @D9810, 
      AGR [COUNT @D9809, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BANK.

WORD base : 
   [COORD @D9819, AGR [COUNT @D9818, PER @D9817, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM ON, ARITY 3] : BASE, 
   [COORD @D9821, AGR [COUNT @D9820, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM ON, ARITY 3] : BASE, 
   [COORD @D9823, AGR [COUNT @D9822, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM ON, ARITY 3] : BASE, 
   [COORD @D9827, AGR [COUNT @D9826, PER @D9825, PLU @D9824, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM ON, ARITY 3] : BASE, 
   [COORD @D9833, PAST @D9832, 
      AGR [CASE @D9831, COUNT @D9830, PER @D9829, PLU @D9828, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM ON, ARITY 3] : 
   BASE.

WORD based : 
   [COORD @D9845, AGR [CASE @D9844, COUNT @D9843, PER @D9842, PLU 
               @D9841, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBCAT NP_PP, CONJ NULL, SUBTYPE PVERB, PFORM ON, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BASE, 
   [COORD @D9850, AGR [CASE @D9849, COUNT @D9848, PER @D9847, 
            PLU @D9846, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BASE, 
   [COORD @D9855, AGR [CASE @D9854, COUNT @D9853, PER @D9852, 
            PLU @D9851, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BASE.

WORD bases : 
   [COORD @D9864, AGR [COUNT @D9863, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT NP_PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BASE.

WORD basing : 
   [COORD @D9876, PRD @D9875, AGR [CASE @D9874, COUNT @D9873, PER 
               @D9872, PLU @D9871, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM ON, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BASE.

WORD bear : 
   [COORD @D9886, REFL @D9885, PRD @D9884, CASE @D9883, FIX NOT, BAR 0, 
      SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, COUNT +] : BEAR, 
   [COORD @D9890, REFL @D9889, PRD @D9888, CASE @D9887, FIX NOT, BAR 0, 
      SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, NFORM NORM, 
      PER 3, ADV -, PART -, DEMON -, INFL -, PLU +, NUM -, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, REG -, COUNT +] : BEAR, 
   [COORD @D9893, AGR [COUNT @D9892, PER @D9891, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BEAR, 
   [COORD @D9895, AGR [COUNT @D9894, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BEAR, 
   [COORD @D9897, AGR [COUNT @D9896, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BEAR, 
   [COORD @D9901, AGR [COUNT @D9900, PER @D9899, PLU @D9898, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM WITH, ARITY 2] : BEAR, 
   [COORD @D9907, PAST @D9906, AGR [CASE @D9905, COUNT @D9904, 
            PER @D9903, PLU @D9902, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM WITH, ARITY 2] : BEAR, 
   [COORD @D9910, 
      AGR [COUNT @D9909, PER @D9908, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM UNDER, ARITY 2] : BEAR, 
   [COORD @D9912, AGR [COUNT @D9911, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM UNDER, ARITY 2] : BEAR, 
   [COORD @D9914, AGR [COUNT @D9913, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, 
      PFORM UNDER, ARITY 2] : BEAR, 
   [COORD @D9918, AGR [COUNT @D9917, PER @D9916, PLU @D9915, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      PRT UP, PFORM UNDER, ARITY 2] : BEAR, 
   [COORD @D9924, PAST @D9923, AGR 
         [CASE @D9922, COUNT @D9921, PER @D9920, PLU @D9919, BAR 2, V -, 
            N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PRT UP, PFORM UNDER, 
      ARITY 2] : BEAR, 
   [COORD @D9927, AGR [COUNT @D9926, PER @D9925, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9929, AGR [COUNT @D9928, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9931, AGR [COUNT @D9930, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9935, AGR [COUNT @D9934, PER @D9933, PLU @D9932, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9941, PAST @D9940, AGR [CASE @D9939, COUNT @D9938, 
            PER @D9937, PLU @D9936, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9944, 
      AGR [COUNT @D9943, PER @D9942, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PRT DOWN, 
      PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9946, AGR [COUNT @D9945, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PRT DOWN, PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9948, AGR [COUNT @D9947, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PRT DOWN, PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9952, AGR [COUNT @D9951, PER @D9950, PLU @D9949, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PRT DOWN, PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9958, PAST @D9957, AGR [CASE @D9956, COUNT @D9955, 
            PER @D9954, PLU @D9953, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, PRT DOWN, PFORM ON, ARITY 2] : BEAR, 
   [COORD @D9961, 
      AGR [COUNT @D9960, PER @D9959, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BEAR, 
   [COORD @D9963, AGR [COUNT @D9962, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BEAR, 
   [COORD @D9965, AGR [COUNT @D9964, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT UP, ARITY 2] : 
   BEAR, 
   [COORD @D9969, AGR [COUNT @D9968, PER @D9967, PLU @D9966, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT UP, ARITY 2] : BEAR, 
   [COORD @D9975, PAST @D9974, AGR [CASE @D9973, COUNT @D9972, 
            PER @D9971, PLU @D9970, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT UP, ARITY 2] : BEAR, 
   [COORD @D9978, AGR [COUNT @D9977, PER @D9976, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT OUT, ARITY 2] : BEAR, 
   [COORD @D9980, AGR [COUNT @D9979, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OUT, 
      ARITY 2] : BEAR, 
   [COORD @D9982, AGR [COUNT @D9981, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OUT, 
      ARITY 2] : BEAR, 
   [COORD @D9986, AGR [COUNT @D9985, PER @D9984, PLU @D9983, N +, V -, 
            BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT OUT, ARITY 2] : BEAR, 
   [COORD @D9992, PAST @D9991, AGR [CASE @D9990, COUNT @D9989, 
            PER @D9988, PLU @D9987, BAR 2, V -, N +, NFORM NORM], FIX NOT, 
      V +, N -, SUBCAT NP, SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OUT, ARITY 2] : BEAR, 
   [COORD @D9995, AGR [COUNT @D9994, PER @D9993, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT OFF, ARITY 2] : BEAR, 
   [COORD @D9997, AGR [COUNT @D9996, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OFF, 
      ARITY 2] : BEAR, 
   [COORD @D9999, AGR [COUNT @D9998, N +, V -, BAR 2, NFORM NORM, CASE NOM, 
            PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OFF, 
      ARITY 2] : BEAR, 
   [COORD @D10003, AGR [COUNT @D10002, PER @D10001, PLU @D10000, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OFF, ARITY 2] : BEAR, 
   [COORD @D10009, PAST @D10008, 
      AGR [CASE @D10007, COUNT @D10006, PER @D10005, PLU @D10004, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OFF, 
      ARITY 2] : BEAR, 
   [COORD @D10012, AGR [COUNT @D10011, PER @D10010, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT DOWN, ARITY 2] : BEAR, 
   [COORD @D10014, AGR [COUNT @D10013, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT DOWN, ARITY 2] : BEAR, 
   [COORD @D10016, AGR [COUNT @D10015, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT DOWN, ARITY 2] : BEAR, 
   [COORD @D10020, AGR [COUNT @D10019, PER @D10018, PLU @D10017, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT DOWN, ARITY 2] : BEAR, 
   [COORD @D10026, PAST @D10025, 
      AGR [CASE @D10024, COUNT @D10023, PER @D10022, PLU @D10021, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT DOWN, ARITY 2] : BEAR, 
   [COORD @D10029, AGR [COUNT @D10028, PER @D10027, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT AWAY, ARITY 2] : BEAR, 
   [COORD @D10031, AGR [COUNT @D10030, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT AWAY, ARITY 2] : BEAR, 
   [COORD @D10033, AGR [COUNT @D10032, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT AWAY, ARITY 2] : BEAR, 
   [COORD @D10037, AGR [COUNT @D10036, PER @D10035, PLU @D10034, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT AWAY, ARITY 2] : BEAR, 
   [COORD @D10043, PAST @D10042, 
      AGR [CASE @D10041, COUNT @D10040, PER @D10039, PLU @D10038, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT AWAY, ARITY 2] : BEAR, 
   [COORD @D10046, AGR [COUNT @D10045, PER @D10044, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BEAR, 
   [COORD @D10048, AGR [COUNT @D10047, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BEAR, 
   [COORD @D10050, AGR [COUNT @D10049, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BEAR, 
   [COORD @D10054, AGR [COUNT @D10053, PER @D10052, PLU @D10051, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT UP, ARITY 1] : BEAR, 
   [COORD @D10060, PAST @D10059, 
      AGR [CASE @D10058, COUNT @D10057, PER @D10056, PLU @D10055, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT UP, 
      ARITY 1] : BEAR, 
   [COORD @D10063, AGR [COUNT @D10062, PER @D10061, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BEAR, 
   [COORD @D10065, AGR [COUNT @D10064, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BEAR, 
   [COORD @D10067, AGR [COUNT @D10066, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BEAR, 
   [COORD @D10071, AGR [COUNT @D10070, PER @D10069, PLU @D10068, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OUT, ARITY 1] : BEAR, 
   [COORD @D10077, PAST @D10076, 
      AGR [CASE @D10075, COUNT @D10074, PER @D10073, PLU @D10072, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OUT, 
      ARITY 1] : BEAR, 
   [COORD @D10080, AGR [COUNT @D10079, PER @D10078, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BEAR, 
   [COORD @D10082, AGR [COUNT @D10081, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BEAR, 
   [COORD @D10084, AGR [COUNT @D10083, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BEAR, 
   [COORD @D10088, AGR [COUNT @D10087, PER @D10086, PLU @D10085, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT OFF, ARITY 1] : BEAR, 
   [COORD @D10094, PAST @D10093, 
      AGR [CASE @D10092, COUNT @D10091, PER @D10090, PLU @D10089, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT OFF, 
      ARITY 1] : BEAR, 
   [COORD @D10097, AGR [COUNT @D10096, PER @D10095, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BEAR, 
   [COORD @D10099, AGR [COUNT @D10098, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BEAR, 
   [COORD @D10101, AGR [COUNT @D10100, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BEAR, 
   [COORD @D10105, AGR [COUNT @D10104, PER @D10103, PLU @D10102, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT DOWN, ARITY 1] : BEAR, 
   [COORD @D10111, PAST @D10110, 
      AGR [CASE @D10109, COUNT @D10108, PER @D10107, PLU @D10106, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT DOWN, 
      ARITY 1] : BEAR, 
   [COORD @D10114, AGR [COUNT @D10113, PER @D10112, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BEAR, 
   [COORD @D10116, AGR [COUNT @D10115, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BEAR, 
   [COORD @D10118, AGR [COUNT @D10117, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BEAR, 
   [COORD @D10122, AGR [COUNT @D10121, PER @D10120, PLU @D10119, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, PRT AWAY, ARITY 1] : BEAR, 
   [COORD @D10128, PAST @D10127, 
      AGR [CASE @D10126, COUNT @D10125, PER @D10124, PLU @D10123, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, INFL +, 
      REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, PRT AWAY, 
      ARITY 1] : BEAR.

WORD bearing : 
   [COORD @D10144, REFL @D10143, PRD @D10142, CASE @D10141, FIX NOT, 
      BAR 0, SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, REG -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BEARING, 
   [COORD @D10149, REFL @D10148, COUNT @D10147, PRD @D10146, 
      CASE @D10145, FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, 
      PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, 
      DEMON -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : BEARING, 
   [COORD @D10155, PRD @D10154, 
      AGR [CASE @D10153, COUNT @D10152, PER @D10151, PLU @D10150, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BEAR, 
   [COORD @D10161, PRD @D10160, AGR [CASE @D10159, COUNT @D10158, 
            PER @D10157, PLU @D10156, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PRT UP, 
      PFORM UNDER, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, 
      FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10167, PRD @D10166, 
      AGR [CASE @D10165, COUNT @D10164, PER @D10163, PLU @D10162, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10173, PRD @D10172, AGR [CASE @D10171, COUNT @D10170, 
            PER @D10169, PLU @D10168, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PRT DOWN, 
      PFORM ON, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10179, PRD @D10178, 
      AGR [CASE @D10177, COUNT @D10176, PER @D10175, PLU @D10174, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10185, PRD @D10184, AGR [CASE @D10183, COUNT @D10182, 
            PER @D10181, PLU @D10180, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT OUT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10191, PRD @D10190, 
      AGR [CASE @D10189, COUNT @D10188, PER @D10187, PLU @D10186, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT OFF, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10197, PRD @D10196, AGR [CASE @D10195, COUNT @D10194, 
            PER @D10193, PLU @D10192, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT DOWN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10203, PRD @D10202, 
      AGR [CASE @D10201, COUNT @D10200, PER @D10199, PLU @D10198, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT AWAY, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10209, PRD @D10208, AGR [CASE @D10207, COUNT @D10206, 
            PER @D10205, PLU @D10204, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10215, PRD @D10214, 
      AGR [CASE @D10213, COUNT @D10212, PER @D10211, PLU @D10210, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10221, PRD @D10220, AGR [CASE @D10219, COUNT @D10218, 
            PER @D10217, PLU @D10216, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OFF, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR, 
   [COORD @D10227, PRD @D10226, 
      AGR [CASE @D10225, COUNT @D10224, PER @D10223, PLU @D10222, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAR, 
   [COORD @D10233, PRD @D10232, AGR [CASE @D10231, COUNT @D10230, 
            PER @D10229, PLU @D10228, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT AWAY, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAR.

WORD bearings : 
   [COORD @D10252, REFL @D10251, PRD @D10250, CASE @D10249, FIX NOT, 
      BAR 0, SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, INFL -, PLU +, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, COUNT +] : BEARINGS, 
   [COORD @D10257, DEMON @D10256, REFL @D10255, PRD @D10254, 
      CASE @D10253, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BEARING.

WORD bears : 
   [COORD @D10288, DEMON @D10287, REFL @D10286, PRD @D10285, CASE 
         @D10284, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BEAR, 
   [COORD @D10290, 
      AGR [COUNT @D10289, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM WITH, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10292, 
      AGR [COUNT @D10291, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT UP, PFORM UNDER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, 
      PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : 
   BEAR, 
   [COORD @D10294, AGR [COUNT @D10293, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BEAR, 
   [COORD @D10296, AGR [COUNT @D10295, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PRT DOWN, PFORM ON, AUX -, INV -, NEG -, 
      PSVE -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, 
      BAR 0, V +, N -] : BEAR, 
   [COORD @D10298, AGR [COUNT @D10297, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10300, 
      AGR [COUNT @D10299, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10302, 
      AGR [COUNT @D10301, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OFF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10304, 
      AGR [COUNT @D10303, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10306, 
      AGR [COUNT @D10305, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT AWAY, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10308, 
      AGR [COUNT @D10307, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10310, 
      AGR [COUNT @D10309, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10312, 
      AGR [COUNT @D10311, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OFF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10314, 
      AGR [COUNT @D10313, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR, 
   [COORD @D10316, 
      AGR [COUNT @D10315, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT AWAY, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAR.

WORD beat : 
   [COORD @D10325, AGR [COUNT @D10324, PER @D10323, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PRT DOWN, PFORM TO, ARITY 3] : BEAT, 
   [COORD @D10327, AGR [COUNT @D10326, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PRT DOWN, PFORM TO, ARITY 3] : BEAT, 
   [COORD @D10329, AGR [COUNT @D10328, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PRT DOWN, PFORM TO, ARITY 3] : BEAT, 
   [COORD @D10333, AGR [COUNT @D10332, PER @D10331, PLU @D10330, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, REG -, PRT DOWN, PFORM TO, ARITY 3] : BEAT, 
   [COORD @D10339, PAST @D10338, 
      AGR [CASE @D10337, COUNT @D10336, PER @D10335, PLU @D10334, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, PRT DOWN, 
      PFORM TO, ARITY 3] : BEAT, 
   [COORD @D10342, AGR [COUNT @D10341, PER @D10340, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, REG -, LAT -, 
      ARITY 3] : BEAT, 
   [COORD @D10344, AGR [COUNT @D10343, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, REG -, LAT -, 
      ARITY 3] : BEAT, 
   [COORD @D10346, AGR [COUNT @D10345, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, REG -, LAT -, 
      ARITY 3] : BEAT, 
   [COORD @D10350, AGR [COUNT @D10349, PER @D10348, PLU @D10347, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, REG -, 
      LAT -, ARITY 3] : BEAT, 
   [COORD @D10356, PAST @D10355, AGR [CASE @D10354, COUNT @D10353, 
            PER @D10352, PLU @D10351, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP_ADL, REG -, LAT -, ARITY 3] : BEAT, 
   [COORD @D10360, AGR [COUNT @D10359, PER @D10358, PLU @D10357, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, 
      PRT DOWN, PFORM TO, PAST +, ARITY 3] : BEAT, 
   [COORD @D10364, AGR [COUNT @D10363, PER @D10362, PLU @D10361, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, REG -, PAST +, LAT -, 
      ARITY 3] : BEAT, 
   [COORD @D10367, AGR [COUNT @D10366, PER @D10365, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PRT ABOUT, PFORM FOR, ARITY 2] : BEAT, 
   [COORD @D10369, AGR [COUNT @D10368, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PRT ABOUT, PFORM FOR, ARITY 2] : BEAT, 
   [COORD @D10371, AGR [COUNT @D10370, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PRT ABOUT, PFORM FOR, ARITY 2] : BEAT, 
   [COORD @D10375, AGR [COUNT @D10374, PER @D10373, PLU @D10372, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      REG -, PRT ABOUT, PFORM FOR, ARITY 2] : BEAT, 
   [COORD @D10381, PAST @D10380, 
      AGR [CASE @D10379, COUNT @D10378, PER @D10377, PLU @D10376, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, PRT ABOUT, 
      PFORM FOR, ARITY 2] : BEAT, 
   [COORD @D10384, AGR [COUNT @D10383, PER @D10382, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT UP, ARITY 2] : BEAT, 
   [COORD @D10386, AGR [COUNT @D10385, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT UP, ARITY 2] : BEAT, 
   [COORD @D10388, AGR [COUNT @D10387, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT UP, ARITY 2] : BEAT, 
   [COORD @D10392, AGR [COUNT @D10391, PER @D10390, PLU @D10389, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT UP, ARITY 2] : BEAT, 
   [COORD @D10398, PAST @D10397, 
      AGR [CASE @D10396, COUNT @D10395, PER @D10394, PLU @D10393, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT UP, 
      ARITY 2] : BEAT, 
   [COORD @D10401, AGR [COUNT @D10400, PER @D10399, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, ARITY 2] : BEAT, 
   [COORD @D10403, AGR [COUNT @D10402, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, ARITY 2] : BEAT, 
   [COORD @D10405, AGR [COUNT @D10404, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, ARITY 2] : BEAT, 
   [COORD @D10409, AGR [COUNT @D10408, PER @D10407, PLU @D10406, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OUT, ARITY 2] : BEAT, 
   [COORD @D10415, PAST @D10414, 
      AGR [CASE @D10413, COUNT @D10412, PER @D10411, PLU @D10410, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OUT, 
      ARITY 2] : BEAT, 
   [COORD @D10418, AGR [COUNT @D10417, PER @D10416, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT IN, ARITY 2] : BEAT, 
   [COORD @D10420, AGR [COUNT @D10419, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT IN, ARITY 2] : BEAT, 
   [COORD @D10422, AGR [COUNT @D10421, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT IN, ARITY 2] : BEAT, 
   [COORD @D10426, AGR [COUNT @D10425, PER @D10424, PLU @D10423, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT IN, ARITY 2] : BEAT, 
   [COORD @D10432, PAST @D10431, 
      AGR [CASE @D10430, COUNT @D10429, PER @D10428, PLU @D10427, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT IN, 
      ARITY 2] : BEAT, 
   [COORD @D10435, AGR [COUNT @D10434, PER @D10433, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT DOWN, ARITY 2] : BEAT, 
   [COORD @D10437, AGR [COUNT @D10436, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT DOWN, ARITY 2] : BEAT, 
   [COORD @D10439, AGR [COUNT @D10438, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT DOWN, ARITY 2] : BEAT, 
   [COORD @D10443, AGR [COUNT @D10442, PER @D10441, PLU @D10440, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT DOWN, ARITY 2] : BEAT, 
   [COORD @D10449, PAST @D10448, 
      AGR [CASE @D10447, COUNT @D10446, PER @D10445, PLU @D10444, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT DOWN, ARITY 2] : BEAT, 
   [COORD @D10452, AGR [COUNT @D10451, PER @D10450, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10454, AGR [COUNT @D10453, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10456, AGR [COUNT @D10455, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10460, AGR [COUNT @D10459, PER @D10458, PLU @D10457, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10466, PAST @D10465, AGR [CASE @D10464, COUNT @D10463, 
            PER @D10462, PLU @D10461, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, REG -, LAT -, ARITY 2] : BEAT, 
   [COORD @D10469, AGR [COUNT @D10468, PER @D10467, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADL, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10471, AGR [COUNT @D10470, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADL, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10473, AGR [COUNT @D10472, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADL, REG -, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10477, AGR [COUNT @D10476, PER @D10475, PLU @D10474, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADL, REG -, 
      LAT -, ARITY 2] : BEAT, 
   [COORD @D10483, PAST @D10482, AGR [CASE @D10481, COUNT @D10480, 
            PER @D10479, PLU @D10478, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT ADL, REG -, LAT -, ARITY 2] : BEAT, 
   [COORD @D10487, AGR [COUNT @D10486, PER @D10485, PLU @D10484, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PRT ABOUT, PFORM FOR, PAST +, ARITY 2] : BEAT, 
   [COORD @D10491, AGR [COUNT @D10490, PER @D10489, PLU @D10488, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT UP, PAST +, ARITY 2] : BEAT, 
   [COORD @D10495, AGR [COUNT @D10494, PER @D10493, PLU @D10492, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, PAST +, ARITY 2] : BEAT, 
   [COORD @D10499, AGR [COUNT @D10498, PER @D10497, PLU @D10496, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT IN, PAST +, ARITY 2] : BEAT, 
   [COORD @D10503, AGR [COUNT @D10502, PER @D10501, PLU @D10500, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT DOWN, PAST +, ARITY 2] : BEAT, 
   [COORD @D10507, AGR [COUNT @D10506, PER @D10505, PLU @D10504, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, PAST +, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10511, AGR [COUNT @D10510, PER @D10509, PLU @D10508, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT ADL, REG -, PAST +, LAT -, 
      ARITY 2] : BEAT, 
   [COORD @D10514, AGR [COUNT @D10513, PER @D10512, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT UP, ARITY 1] : BEAT, 
   [COORD @D10516, AGR [COUNT @D10515, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT UP, ARITY 1] : BEAT, 
   [COORD @D10518, AGR [COUNT @D10517, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT UP, ARITY 1] : BEAT, 
   [COORD @D10522, AGR [COUNT @D10521, PER @D10520, PLU @D10519, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT UP, ARITY 1] : BEAT, 
   [COORD @D10528, PAST @D10527, 
      AGR [CASE @D10526, COUNT @D10525, PER @D10524, PLU @D10523, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT UP, 
      ARITY 1] : BEAT, 
   [COORD @D10531, AGR [COUNT @D10530, PER @D10529, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OUT, ARITY 1] : BEAT, 
   [COORD @D10533, AGR [COUNT @D10532, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OUT, ARITY 1] : BEAT, 
   [COORD @D10535, AGR [COUNT @D10534, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OUT, ARITY 1] : BEAT, 
   [COORD @D10539, AGR [COUNT @D10538, PER @D10537, PLU @D10536, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT OUT, ARITY 1] : BEAT, 
   [COORD @D10545, PAST @D10544, 
      AGR [CASE @D10543, COUNT @D10542, PER @D10541, PLU @D10540, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT OUT, 
      ARITY 1] : BEAT, 
   [COORD @D10548, AGR [COUNT @D10547, PER @D10546, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT IN, ARITY 1] : BEAT, 
   [COORD @D10550, AGR [COUNT @D10549, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT IN, ARITY 1] : BEAT, 
   [COORD @D10552, AGR [COUNT @D10551, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT IN, ARITY 1] : BEAT, 
   [COORD @D10556, AGR [COUNT @D10555, PER @D10554, PLU @D10553, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT IN, ARITY 1] : BEAT, 
   [COORD @D10562, PAST @D10561, 
      AGR [CASE @D10560, COUNT @D10559, PER @D10558, PLU @D10557, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT IN, 
      ARITY 1] : BEAT, 
   [COORD @D10565, AGR [COUNT @D10564, PER @D10563, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT DOWN, ARITY 1] : BEAT, 
   [COORD @D10567, AGR [COUNT @D10566, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT DOWN, ARITY 1] : BEAT, 
   [COORD @D10569, AGR [COUNT @D10568, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT DOWN, ARITY 1] : BEAT, 
   [COORD @D10573, AGR [COUNT @D10572, PER @D10571, PLU @D10570, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT DOWN, ARITY 1] : BEAT, 
   [COORD @D10579, PAST @D10578, 
      AGR [CASE @D10577, COUNT @D10576, PER @D10575, PLU @D10574, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT DOWN, 
      ARITY 1] : BEAT, 
   [COORD @D10582, AGR [COUNT @D10581, PER @D10580, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT ABOUT, ARITY 1] : BEAT, 
   [COORD @D10584, AGR [COUNT @D10583, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT ABOUT, ARITY 1] : BEAT, 
   [COORD @D10586, AGR [COUNT @D10585, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT ABOUT, ARITY 1] : BEAT, 
   [COORD @D10590, AGR [COUNT @D10589, PER @D10588, PLU @D10587, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT ABOUT, ARITY 1] : BEAT, 
   [COORD @D10596, PAST @D10595, 
      AGR [CASE @D10594, COUNT @D10593, PER @D10592, PLU @D10591, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT ABOUT, 
      ARITY 1] : BEAT, 
   [COORD @D10599, AGR [COUNT @D10598, PER @D10597, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEAT, 
   [COORD @D10601, AGR [COUNT @D10600, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEAT, 
   [COORD @D10603, AGR [COUNT @D10602, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEAT, 
   [COORD @D10607, AGR [COUNT @D10606, PER @D10605, PLU @D10604, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, 
      LAT -, ARITY 1] : BEAT, 
   [COORD @D10613, PAST @D10612, AGR [CASE @D10611, COUNT @D10610, 
            PER @D10609, PLU @D10608, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, REG -, LAT -, ARITY 1] : BEAT, 
   [COORD @D10617, AGR [COUNT @D10616, PER @D10615, PLU @D10614, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT UP, PAST +, ARITY 1] : BEAT, 
   [COORD @D10621, AGR [COUNT @D10620, PER @D10619, PLU @D10618, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT OUT, PAST +, ARITY 1] : BEAT, 
   [COORD @D10625, AGR [COUNT @D10624, PER @D10623, PLU @D10622, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT IN, PAST +, ARITY 1] : BEAT, 
   [COORD @D10629, AGR [COUNT @D10628, PER @D10627, PLU @D10626, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT DOWN, PAST +, ARITY 1] : BEAT, 
   [COORD @D10633, AGR [COUNT @D10632, PER @D10631, PLU @D10630, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT ABOUT, PAST +, ARITY 1] : BEAT, 
   [COORD @D10637, AGR [COUNT @D10636, PER @D10635, PLU @D10634, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, PAST +, LAT -, 
      ARITY 1] : BEAT.

WORD beaten : 
   [COORD @D10650, PAST @D10649, AGR [CASE @D10648, COUNT @D10647, 
            PER @D10646, PLU @D10645, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, 
      PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, REG -, PRT DOWN, PFORM TO, FIN -, ARITY 3] : BEAT, 
   [COORD @D10656, PAST @D10655, 
      AGR [CASE @D10654, COUNT @D10653, PER @D10652, PLU @D10651, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, PRT DOWN, PFORM TO, 
      FIN -, ARITY 3] : BEAT, 
   [COORD @D10662, PAST @D10661, AGR [CASE @D10660, COUNT @D10659, 
            PER @D10658, PLU @D10657, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, 
      PRO -, NEG -, INFL -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_ADL, 
      REG -, LAT -, FIN -, ARITY 3] : BEAT, 
   [COORD @D10668, PAST @D10667, 
      AGR [CASE @D10666, COUNT @D10665, PER @D10664, PLU @D10663, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      COMPOUND NOT, SUBCAT NP_ADL, REG -, LAT -, FIN -, ARITY 3] : BEAT, 
   [COORD @D10674, PAST @D10673, 
      AGR [CASE @D10672, COUNT @D10671, PER @D10670, PLU @D10669, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, PRT ABOUT, PFORM FOR, 
      FIN -, ARITY 2] : BEAT, 
   [COORD @D10680, PAST @D10679, AGR [CASE @D10678, COUNT @D10677, 
            PER @D10676, PLU @D10675, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT UP, FIN -, ARITY 2] : BEAT, 
   [COORD @D10686, PAST @D10685, 
      AGR [CASE @D10684, COUNT @D10683, PER @D10682, PLU @D10681, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT UP, 
      FIN -, ARITY 2] : BEAT, 
   [COORD @D10692, PAST @D10691, AGR [CASE @D10690, COUNT @D10689, 
            PER @D10688, PLU @D10687, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OUT, FIN -, ARITY 2] : BEAT, 
   [COORD @D10698, PAST @D10697, 
      AGR [CASE @D10696, COUNT @D10695, PER @D10694, PLU @D10693, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OUT, 
      FIN -, ARITY 2] : BEAT, 
   [COORD @D10704, PAST @D10703, AGR [CASE @D10702, COUNT @D10701, 
            PER @D10700, PLU @D10699, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT IN, FIN -, ARITY 2] : BEAT, 
   [COORD @D10710, PAST @D10709, 
      AGR [CASE @D10708, COUNT @D10707, PER @D10706, PLU @D10705, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT IN, 
      FIN -, ARITY 2] : BEAT, 
   [COORD @D10716, PAST @D10715, AGR [CASE @D10714, COUNT @D10713, 
            PER @D10712, PLU @D10711, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT DOWN, FIN -, ARITY 2] : BEAT, 
   [COORD @D10722, PAST @D10721, 
      AGR [CASE @D10720, COUNT @D10719, PER @D10718, PLU @D10717, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT DOWN, 
      FIN -, ARITY 2] : BEAT, 
   [COORD @D10728, PAST @D10727, AGR [CASE @D10726, COUNT @D10725, 
            PER @D10724, PLU @D10723, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, 
      PRO -, NEG -, INFL -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, 
      LAT -, FIN -, ARITY 2] : BEAT, 
   [COORD @D10734, PAST @D10733, AGR [CASE @D10732, COUNT @D10731, 
            PER @D10730, PLU @D10729, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, 
      REG -, LAT -, FIN -, ARITY 2] : BEAT, 
   [COORD @D10740, PAST @D10739, 
      AGR [CASE @D10738, COUNT @D10737, PER @D10736, PLU @D10735, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      COMPOUND NOT, SUBCAT ADL, REG -, LAT -, FIN -, ARITY 2] : BEAT, 
   [COORD @D10746, PAST @D10745, 
      AGR [CASE @D10744, COUNT @D10743, PER @D10742, PLU @D10741, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT UP, FIN -, 
      ARITY 1] : BEAT, 
   [COORD @D10752, PAST @D10751, AGR [CASE @D10750, COUNT @D10749, 
            PER @D10748, PLU @D10747, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT OUT, FIN -, ARITY 1] : BEAT, 
   [COORD @D10758, PAST @D10757, 
      AGR [CASE @D10756, COUNT @D10755, PER @D10754, PLU @D10753, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT IN, FIN -, 
      ARITY 1] : BEAT, 
   [COORD @D10764, PAST @D10763, AGR [CASE @D10762, COUNT @D10761, 
            PER @D10760, PLU @D10759, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT DOWN, FIN -, ARITY 1] : BEAT, 
   [COORD @D10770, PAST @D10769, 
      AGR [CASE @D10768, COUNT @D10767, PER @D10766, PLU @D10765, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT ABOUT, FIN -, 
      ARITY 1] : BEAT, 
   [COORD @D10776, PAST @D10775, AGR [CASE @D10774, COUNT @D10773, 
            PER @D10772, PLU @D10771, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      REG -, LAT -, FIN -, ARITY 1] : BEAT.

WORD beating : 
   [COORD @D10814, REFL @D10813, COUNT @D10812, PRD @D10811, 
      CASE @D10810, FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, 
      PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, 
      DEMON -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : BEATING, 
   [COORD @D10820, PRD @D10819, 
      AGR [CASE @D10818, COUNT @D10817, PER @D10816, PLU @D10815, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP_PP, PRT DOWN, PFORM TO, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BEAT, 
   [COORD @D10826, PRD @D10825, AGR [CASE @D10824, COUNT @D10823, 
            PER @D10822, PLU @D10821, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_ADL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10832, PRD @D10831, 
      AGR [CASE @D10830, COUNT @D10829, PER @D10828, PLU @D10827, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT PP, PRT ABOUT, PFORM FOR, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BEAT, 
   [COORD @D10838, PRD @D10837, AGR [CASE @D10836, COUNT @D10835, 
            PER @D10834, PLU @D10833, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10844, PRD @D10843, 
      AGR [CASE @D10842, COUNT @D10841, PER @D10840, PLU @D10839, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAT, 
   [COORD @D10850, PRD @D10849, AGR [CASE @D10848, COUNT @D10847, 
            PER @D10846, PLU @D10845, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, PRT IN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10856, PRD @D10855, 
      AGR [CASE @D10854, COUNT @D10853, PER @D10852, PLU @D10851, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAT, 
   [COORD @D10862, PRD @D10861, AGR [CASE @D10860, COUNT @D10859, 
            PER @D10858, PLU @D10857, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10868, PRD @D10867, 
      AGR [CASE @D10866, COUNT @D10865, PER @D10864, PLU @D10863, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT ADL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BEAT, 
   [COORD @D10874, PRD @D10873, AGR [CASE @D10872, COUNT @D10871, 
            PER @D10870, PLU @D10869, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT UP, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10880, PRD @D10879, 
      AGR [CASE @D10878, COUNT @D10877, PER @D10876, PLU @D10875, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAT, 
   [COORD @D10886, PRD @D10885, AGR [CASE @D10884, COUNT @D10883, 
            PER @D10882, PLU @D10881, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT IN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10892, PRD @D10891, 
      AGR [CASE @D10890, COUNT @D10889, PER @D10888, PLU @D10887, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BEAT, 
   [COORD @D10898, PRD @D10897, AGR [CASE @D10896, COUNT @D10895, 
            PER @D10894, PLU @D10893, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT ABOUT, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT, 
   [COORD @D10904, PRD @D10903, 
      AGR [CASE @D10902, COUNT @D10901, PER @D10900, PLU @D10899, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BEAT.

WORD beatings : 
   [COORD @D10920, DEMON @D10919, REFL @D10918, PRD @D10917, 
      CASE @D10916, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BEATING.

WORD beats : 
   [COORD @D10929, AGR [COUNT @D10928, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PRT DOWN, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BEAT, 
   [COORD @D10931, AGR [COUNT @D10930, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_ADL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10933, 
      AGR [COUNT @D10932, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PRT ABOUT, PFORM FOR, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BEAT, 
   [COORD @D10935, AGR [COUNT @D10934, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10937, 
      AGR [COUNT @D10936, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10939, 
      AGR [COUNT @D10938, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10941, 
      AGR [COUNT @D10940, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10943, 
      AGR [COUNT @D10942, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10945, 
      AGR [COUNT @D10944, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT ADL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10947, 
      AGR [COUNT @D10946, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT UP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10949, 
      AGR [COUNT @D10948, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10951, 
      AGR [COUNT @D10950, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10953, 
      AGR [COUNT @D10952, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT DOWN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10955, 
      AGR [COUNT @D10954, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT ABOUT, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT, 
   [COORD @D10957, 
      AGR [COUNT @D10956, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEAT.

WORD begin : 
   [COORD @D10966, AGR [COUNT @D10965, PER @D10964, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEGIN, 
   [COORD @D10968, AGR [COUNT @D10967, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEGIN, 
   [COORD @D10970, AGR [COUNT @D10969, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEGIN, 
   [COORD @D10974, AGR [COUNT @D10973, PER @D10972, PLU @D10971, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, LAT -, 
      ARITY 2] : BEGIN, 
   [COORD @D10980, PAST @D10979, AGR [CASE @D10978, COUNT @D10977, 
            PER @D10976, PLU @D10975, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, REG -, LAT -, ARITY 2] : BEGIN, 
   [COORD @D10982, AGR [COUNT @D10981, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D10984, AGR [COUNT @D10983, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D10988, AGR [NFORM @D10987, COUNT @D10986, PER @D10985, N +, 
            V -, BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D10992, AGR [COUNT @D10991, PER @D10990, PLU @D10989, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_ING, REG -, 
      LAT -, ARITY 1] : BEGIN, 
   [COORD @D10995, AGR @D10994, PAST @D10993, FIX NOT, V +, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_ING, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D10997, AGR [COUNT @D10996, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D10999, AGR [COUNT @D10998, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11003, AGR [NFORM @D11002, COUNT @D11001, PER @D11000, N +, 
            V -, BAR 2, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11007, AGR [COUNT @D11006, PER @D11005, PLU @D11004, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, SUBTYPE RAIS, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SC_INF, REG -, 
      LAT -, ARITY 1] : BEGIN, 
   [COORD @D11010, AGR @D11009, PAST @D11008, FIX NOT, V +, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT SC_INF, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11013, AGR [COUNT @D11012, PER @D11011, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11015, AGR [COUNT @D11014, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11017, AGR [COUNT @D11016, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, LAT -, 
      ARITY 1] : BEGIN, 
   [COORD @D11021, AGR [COUNT @D11020, PER @D11019, PLU @D11018, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, 
      LAT -, ARITY 1] : BEGIN, 
   [COORD @D11027, PAST @D11026, AGR [CASE @D11025, COUNT @D11024, 
            PER @D11023, PLU @D11022, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, REG -, LAT -, ARITY 1] : BEGIN.

WORD beginning : 
   [COORD @D11047, REFL @D11046, COUNT @D11045, PRD @D11044, 
      CASE @D11043, FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, 
      PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, 
      DEMON -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : BEGINNING, 
   [COORD @D11053, PRD @D11052, 
      AGR [CASE @D11051, COUNT @D11050, PER @D11049, PLU @D11048, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BEGIN, 
   [COORD @D11056, AGR @D11055, PRD @D11054, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_ING, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BEGIN, 
   [COORD @D11059, AGR @D11058, PRD @D11057, COMPOUND NOT, FIX NOT, 
      CONJ NULL, SUBTYPE RAIS, SUBCAT SC_INF, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BEGIN, 
   [COORD @D11065, PRD @D11064, AGR [CASE @D11063, COUNT @D11062, 
            PER @D11061, PLU @D11060, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BEGIN.

WORD beginnings : 
   [COORD @D11080, DEMON @D11079, REFL @D11078, PRD @D11077, 
      CASE @D11076, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : 
   BEGINNING.

WORD begins : 
   [COORD @D11089, AGR [COUNT @D11088, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN, 
   [COORD @D11093, 
      AGR [CASE @D11092, NFORM @D11091, COUNT @D11090, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_ING, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN, 
   [COORD @D11098, 
      AGR [UB @D11097, VFORM @D11096, SUBJ @D11095, FIN @D11094, N -, 
            V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_ING, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN, 
   [COORD @D11102, 
      AGR [CASE @D11101, NFORM @D11100, COUNT @D11099, PLU -, PER 3, N +, 
            V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_INF, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN, 
   [COORD @D11107, 
      AGR [UB @D11106, VFORM @D11105, SUBJ @D11104, FIN @D11103, N -, 
            V +, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE RAIS, SUBCAT SC_INF, 
      CONJ NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN, 
   [COORD @D11109, 
      AGR [COUNT @D11108, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BEGIN.

WORD believe : 
   [COORD @D11119, AGR [COUNT @D11118, PER @D11117, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP IN, ARITY 2] : BELIEVE, 
   [COORD @D11121, AGR [COUNT @D11120, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP IN, ARITY 2] : BELIEVE, 
   [COORD @D11123, AGR [COUNT @D11122, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP IN, ARITY 2] : BELIEVE, 
   [COORD @D11127, AGR [COUNT @D11126, PER @D11125, PLU @D11124, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT SC_ING, PREP IN, ARITY 2] : BELIEVE, 
   [COORD @D11133, PAST @D11132, 
      AGR [CASE @D11131, COUNT @D11130, PER @D11129, PLU @D11128, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, 
      SUBTYPE EQUI, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT SC_ING, 
      PREP IN, ARITY 2] : BELIEVE, 
   [COORD @D11136, AGR [COUNT @D11135, PER @D11134, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM IN, ARITY 2] : BELIEVE, 
   [COORD @D11138, AGR [COUNT @D11137, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM IN, ARITY 2] : BELIEVE, 
   [COORD @D11140, AGR [COUNT @D11139, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM IN, ARITY 2] : BELIEVE, 
   [COORD @D11144, AGR [COUNT @D11143, PER @D11142, PLU @D11141, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, PFORM IN, ARITY 2] : BELIEVE, 
   [COORD @D11150, PAST @D11149, 
      AGR [CASE @D11148, COUNT @D11147, PER @D11146, PLU @D11145, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM IN, 
      ARITY 2] : BELIEVE, 
   [COORD @D11153, AGR [COUNT @D11152, PER @D11151, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11155, AGR [COUNT @D11154, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11157, AGR [COUNT @D11156, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11161, AGR [COUNT @D11160, PER @D11159, PLU @D11158, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT SFIN, 
      LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11167, PAST @D11166, AGR [CASE @D11165, COUNT @D11164, 
            PER @D11163, PLU @D11162, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT SFIN, LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11170, AGR [COUNT @D11169, PER @D11168, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11172, AGR [COUNT @D11171, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11174, AGR [COUNT @D11173, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11178, AGR [COUNT @D11177, PER @D11176, PLU @D11175, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_NP, 
      LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11184, PAST @D11183, AGR [CASE @D11182, COUNT @D11181, 
            PER @D11180, PLU @D11179, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_NP, LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11187, AGR [COUNT @D11186, PER @D11185, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11189, AGR [COUNT @D11188, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11191, AGR [COUNT @D11190, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11195, AGR [COUNT @D11194, PER @D11193, PLU @D11192, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_INF, 
      LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11201, PAST @D11200, AGR [CASE @D11199, COUNT @D11198, 
            PER @D11197, PLU @D11196, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_INF, LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11204, AGR [COUNT @D11203, PER @D11202, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11206, AGR [COUNT @D11205, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11208, AGR [COUNT @D11207, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11212, AGR [COUNT @D11211, PER @D11210, PLU @D11209, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, SUBCAT OC_AP, 
      LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11218, PAST @D11217, AGR [CASE @D11216, COUNT @D11215, 
            PER @D11214, PLU @D11213, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE RAIS, 
      SUBCAT OC_AP, LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11221, AGR [COUNT @D11220, PER @D11219, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11223, AGR [COUNT @D11222, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11225, AGR [COUNT @D11224, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11229, AGR [COUNT @D11228, PER @D11227, PLU @D11226, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BELIEVE, 
   [COORD @D11235, PAST @D11234, AGR [CASE @D11233, COUNT @D11232, 
            PER @D11231, PLU @D11230, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : BELIEVE, 
   [COORD @D11238, AGR [COUNT @D11237, PER @D11236, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELIEVE, 
   [COORD @D11240, AGR [COUNT @D11239, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELIEVE, 
   [COORD @D11242, AGR [COUNT @D11241, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELIEVE, 
   [COORD @D11246, AGR [COUNT @D11245, PER @D11244, PLU @D11243, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      LAT -, ARITY 1] : BELIEVE, 
   [COORD @D11252, PAST @D11251, AGR [CASE @D11250, COUNT @D11249, 
            PER @D11248, PLU @D11247, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : BELIEVE.

WORD believed : 
   [COORD @D11265, AGR [CASE @D11264, COUNT @D11263, PER @D11262, 
            PLU @D11261, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP IN, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11270, AGR [CASE @D11269, COUNT @D11268, PER @D11267, 
            PLU @D11266, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP IN, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11275, AGR [CASE @D11274, COUNT @D11273, PER @D11272, 
            PLU @D11271, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM IN, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11280, AGR [CASE @D11279, COUNT @D11278, PER @D11277, 
            PLU @D11276, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM IN, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11285, AGR [CASE @D11284, COUNT @D11283, PER @D11282, 
            PLU @D11281, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM IN, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11290, AGR [UB @D11289, VFORM @D11288, SUBJ @D11287, 
            FIN @D11286, N -, V +, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE NONE, SUBCAT SFIN, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BELIEVE, 
   [COORD @D11295, AGR [CASE @D11294, COUNT @D11293, PER @D11292, 
            PLU @D11291, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11300, AGR [CASE @D11299, COUNT @D11298, PER @D11297, 
            PLU @D11296, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11305, AGR [CASE @D11304, COUNT @D11303, PER @D11302, 
            PLU @D11301, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT OC_NP, CONJ NULL, SUBTYPE RAIS, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11310, AGR [CASE @D11309, COUNT @D11308, PER @D11307, 
            PLU @D11306, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11315, AGR [CASE @D11314, COUNT @D11313, PER @D11312, 
            PLU @D11311, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11321, AGR [CASE @D11320, NFORM @D11319, COUNT @D11318, 
            PER @D11317, PLU @D11316, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE RAIS, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11326, AGR [UB @D11325, VFORM @D11324, SUBJ @D11323, 
            FIN @D11322, N -, V +, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_INF, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BELIEVE, 
   [COORD @D11331, AGR [CASE @D11330, COUNT @D11329, PER @D11328, 
            PLU @D11327, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_INF, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11336, AGR [CASE @D11335, COUNT @D11334, PER @D11333, 
            PLU @D11332, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_INF, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11341, AGR [CASE @D11340, COUNT @D11339, PER @D11338, 
            PLU @D11337, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11346, AGR [CASE @D11345, COUNT @D11344, PER @D11343, 
            PLU @D11342, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11352, AGR [CASE @D11351, NFORM @D11350, COUNT @D11349, 
            PER @D11348, PLU @D11347, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE RAIS, SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11357, AGR [UB @D11356, VFORM @D11355, SUBJ @D11354, 
            FIN @D11353, N -, V +, BAR 2], COMPOUND NOT, FIX NOT, 
      SUBTYPE RAIS, SUBCAT OC_AP, CONJ NULL, AUX -, INV -, NEG -, PSVE +, 
      PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BELIEVE, 
   [COORD @D11362, AGR [CASE @D11361, COUNT @D11360, PER @D11359, 
            PLU @D11358, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11367, AGR [CASE @D11366, COUNT @D11365, PER @D11364, 
            PLU @D11363, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11372, AGR [CASE @D11371, COUNT @D11370, PER @D11369, 
            PLU @D11368, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11377, AGR [CASE @D11376, COUNT @D11375, PER @D11374, 
            PLU @D11373, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11382, AGR [CASE @D11381, COUNT @D11380, PER @D11379, 
            PLU @D11378, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELIEVE.

WORD believes : 
   [COORD @D11392, AGR [COUNT @D11391, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, 
      SUBCAT SC_ING, PREP IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11394, 
      AGR [COUNT @D11393, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM IN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11396, 
      AGR [COUNT @D11395, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT SFIN, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11398, 
      AGR [COUNT @D11397, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11400, 
      AGR [COUNT @D11399, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11402, 
      AGR [COUNT @D11401, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, 
      SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11404, 
      AGR [COUNT @D11403, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11406, 
      AGR [COUNT @D11405, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELIEVE.

WORD believing : 
   [COORD @D11419, PRD @D11418, AGR [CASE @D11417, COUNT @D11416, 
            PER @D11415, PLU @D11414, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE EQUI, CONJ NULL, SUBCAT SC_ING, PREP IN, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11425, PRD @D11424, 
      AGR [CASE @D11423, COUNT @D11422, PER @D11421, PLU @D11420, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM IN, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BELIEVE, 
   [COORD @D11431, PRD @D11430, AGR [CASE @D11429, COUNT @D11428, 
            PER @D11427, PLU @D11426, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT SFIN, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11437, PRD @D11436, 
      AGR [CASE @D11435, COUNT @D11434, PER @D11433, PLU @D11432, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BELIEVE, 
   [COORD @D11443, PRD @D11442, AGR [CASE @D11441, COUNT @D11440, 
            PER @D11439, PLU @D11438, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE RAIS, SUBCAT OC_INF, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11449, PRD @D11448, 
      AGR [CASE @D11447, COUNT @D11446, PER @D11445, PLU @D11444, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE RAIS, SUBCAT OC_AP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BELIEVE, 
   [COORD @D11455, PRD @D11454, AGR [CASE @D11453, COUNT @D11452, 
            PER @D11451, PLU @D11450, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELIEVE, 
   [COORD @D11461, PRD @D11460, 
      AGR [CASE @D11459, COUNT @D11458, PER @D11457, PLU @D11456, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BELIEVE.

WORD belong : 
   [COORD @D11470, AGR [COUNT @D11469, PER @D11468, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : BELONG, 
   [COORD @D11472, AGR [COUNT @D11471, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : BELONG, 
   [COORD @D11474, AGR [COUNT @D11473, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM TO, ARITY 2] : BELONG, 
   [COORD @D11478, AGR [COUNT @D11477, PER @D11476, PLU @D11475, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, PFORM TO, ARITY 2] : BELONG, 
   [COORD @D11484, PAST @D11483, 
      AGR [CASE @D11482, COUNT @D11481, PER @D11480, PLU @D11479, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM TO, 
      ARITY 2] : BELONG, 
   [COORD @D11487, AGR [COUNT @D11486, PER @D11485, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BELONG, 
   [COORD @D11489, AGR [COUNT @D11488, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BELONG, 
   [COORD @D11491, AGR [COUNT @D11490, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BELONG, 
   [COORD @D11495, AGR [COUNT @D11494, PER @D11493, PLU @D11492, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, 
      LAT -, ARITY 2] : BELONG, 
   [COORD @D11501, PAST @D11500, AGR [CASE @D11499, COUNT @D11498, 
            PER @D11497, PLU @D11496, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT LOC, LAT -, ARITY 2] : BELONG, 
   [COORD @D11504, AGR [COUNT @D11503, PER @D11502, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELONG, 
   [COORD @D11506, AGR [COUNT @D11505, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELONG, 
   [COORD @D11508, AGR [COUNT @D11507, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BELONG, 
   [COORD @D11512, AGR [COUNT @D11511, PER @D11510, PLU @D11509, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      LAT -, ARITY 1] : BELONG, 
   [COORD @D11518, PAST @D11517, AGR [CASE @D11516, COUNT @D11515, 
            PER @D11514, PLU @D11513, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : BELONG.

WORD belonged : 
   [COORD @D11530, AGR [CASE @D11529, COUNT @D11528, PER @D11527, 
            PLU @D11526, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11535, AGR [CASE @D11534, COUNT @D11533, PER @D11532, 
            PLU @D11531, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11540, AGR [CASE @D11539, COUNT @D11538, PER @D11537, 
            PLU @D11536, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM TO, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11545, AGR [CASE @D11544, COUNT @D11543, PER @D11542, 
            PLU @D11541, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11550, AGR [CASE @D11549, COUNT @D11548, PER @D11547, 
            PLU @D11546, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11555, AGR [CASE @D11554, COUNT @D11553, PER @D11552, 
            PLU @D11551, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11560, AGR [CASE @D11559, COUNT @D11558, PER @D11557, 
            PLU @D11556, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BELONG.

WORD belonging : 
   [COORD @D11575, PRD @D11574, AGR [CASE @D11573, COUNT @D11572, 
            PER @D11571, PLU @D11570, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BELONG, 
   [COORD @D11581, PRD @D11580, 
      AGR [CASE @D11579, COUNT @D11578, PER @D11577, PLU @D11576, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BELONG, 
   [COORD @D11587, PRD @D11586, AGR [CASE @D11585, COUNT @D11584, 
            PER @D11583, PLU @D11582, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BELONG.

WORD belongs : 
   [COORD @D11596, AGR [COUNT @D11595, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BELONG, 
   [COORD @D11598, AGR [COUNT @D11597, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELONG, 
   [COORD @D11600, 
      AGR [COUNT @D11599, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BELONG.

WORD bend : 
   [COORD @D11609, AGR [COUNT @D11608, PER @D11607, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM TO, ARITY 2] : BEND, 
   [COORD @D11611, AGR [COUNT @D11610, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM TO, ARITY 2] : BEND, 
   [COORD @D11613, AGR [COUNT @D11612, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM TO, ARITY 2] : BEND, 
   [COORD @D11617, AGR [COUNT @D11616, PER @D11615, PLU @D11614, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      REG -, PFORM TO, ARITY 2] : BEND, 
   [COORD @D11623, PAST @D11622, AGR [CASE @D11621, COUNT @D11620, 
            PER @D11619, PLU @D11618, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBTYPE PVERB, SUBCAT PP, REG -, PFORM TO, ARITY 2] : BEND, 
   [COORD @D11626, 
      AGR [COUNT @D11625, PER @D11624, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, PFORM BEFORE, 
      ARITY 2] : BEND, 
   [COORD @D11628, AGR [COUNT @D11627, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM BEFORE, ARITY 2] : BEND, 
   [COORD @D11630, AGR [COUNT @D11629, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM BEFORE, ARITY 2] : BEND, 
   [COORD @D11634, AGR [COUNT @D11633, PER @D11632, PLU @D11631, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      REG -, PFORM BEFORE, ARITY 2] : BEND, 
   [COORD @D11640, PAST @D11639, 
      AGR [CASE @D11638, COUNT @D11637, PER @D11636, PLU @D11635, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, PFORM BEFORE, 
      ARITY 2] : BEND.

WORD bending : 
   [COORD @D11655, PRD @D11654, AGR [CASE @D11653, COUNT @D11652, 
            PER @D11651, PLU @D11650, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM TO, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BEND, 
   [COORD @D11661, PRD @D11660, 
      AGR [CASE @D11659, COUNT @D11658, PER @D11657, PLU @D11656, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BEND.

WORD bends : 
   [COORD @D11670, AGR [COUNT @D11669, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BEND, 
   [COORD @D11672, AGR [COUNT @D11671, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM BEFORE, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BEND.

WORD benefit : 
   [COORD @D11683, REFL @D11682, COUNT @D11681, PRD @D11680, 
      CASE @D11679, FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, 
      PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, 
      DEMON -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : BENEFIT, 
   [COORD @D11686, 
      AGR [COUNT @D11685, PER @D11684, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BENEFIT, 
   [COORD @D11688, AGR [COUNT @D11687, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BENEFIT, 
   [COORD @D11690, AGR [COUNT @D11689, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BENEFIT, 
   [COORD @D11694, AGR [COUNT @D11693, PER @D11692, PLU @D11691, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP, ARITY 2] : BENEFIT, 
   [COORD @D11700, PAST @D11699, AGR [CASE @D11698, COUNT @D11697, 
            PER @D11696, PLU @D11695, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BENEFIT, 
   [COORD @D11703, AGR [COUNT @D11702, PER @D11701, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FROM, ARITY 2] : BENEFIT, 
   [COORD @D11705, AGR [COUNT @D11704, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FROM, ARITY 2] : BENEFIT, 
   [COORD @D11707, AGR [COUNT @D11706, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, 
      PFORM FROM, ARITY 2] : BENEFIT, 
   [COORD @D11711, AGR [COUNT @D11710, PER @D11709, PLU @D11708, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FROM, ARITY 2] : BENEFIT, 
   [COORD @D11717, PAST @D11716, 
      AGR [CASE @D11715, COUNT @D11714, PER @D11713, PLU @D11712, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, PFORM FROM, 
      ARITY 2] : BENEFIT.

WORD benefits : 
   [COORD @D11730, DEMON @D11729, REFL @D11728, PRD @D11727, 
      CASE @D11726, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BENEFIT, 
   
   [COORD @D11732, AGR [COUNT @D11731, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11734, 
      AGR [COUNT @D11733, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, 
      SUBCAT PP, PFORM FROM, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BENEFIT.

WORD benefitted : 
   [COORD @D11747, AGR [CASE @D11746, COUNT @D11745, PER @D11744, 
            PLU @D11743, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11752, AGR [CASE @D11751, COUNT @D11750, PER @D11749, 
            PLU @D11748, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11757, AGR [CASE @D11756, COUNT @D11755, PER @D11754, 
            PLU @D11753, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11762, AGR [CASE @D11761, COUNT @D11760, PER @D11759, 
            PLU @D11758, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBTYPE PVERB, SUBCAT PP, CONJ NULL, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11767, AGR [CASE @D11766, COUNT @D11765, PER @D11764, 
            PLU @D11763, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11772, AGR [CASE @D11771, COUNT @D11770, PER @D11769, 
            PLU @D11768, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT PP, PFORM FROM, AUX -, INV -, 
      NEG -, PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, 
      LAT +, PAST +, BAR 0, V +, N -] : BENEFIT.

WORD benefitting : 
   [COORD @D11790, PRD @D11789, AGR [CASE @D11788, COUNT @D11787, 
            PER @D11786, PLU @D11785, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BENEFIT, 
   [COORD @D11796, PRD @D11795, 
      AGR [CASE @D11794, COUNT @D11793, PER @D11792, PLU @D11791, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT PP, PFORM FROM, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BENEFIT.

WORD bent : 
   [COADV @D11810, COORD @D11809, DEF @D11808, PRD @D11807, AGR 
            [CASE @D11806, COUNT @D11805, PER @D11804, PLU @D11803, 
            BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, 
      BAR 0, N +, GRADE +, ADV -, AFORM NONE, PART -, NEG -, SUBCAT NULL, 
      DISTR ATT, QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : 
   BENT_ON, 
   [COADV @D11818, COORD @D11817, DEF @D11816, PRD @D11815, AGR 
            [CASE @D11814, COUNT @D11813, PER @D11812, PLU @D11811, 
            BAR 2, V -, N +, NFORM NORM], FIX NOT, INFL +, BAR 0, V +, N +, 
      GRADE +, ADV -, AFORM NONE, PART -, NEG -, QUA -, NUM -, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT PPING, PFORM ON, 
      DISTR PRD, ARITY 2] : BENT_ON, 
   [COADV @D11826, COORD @D11825, DEF @D11824, PRD @D11823, 
      AGR [CASE @D11822, COUNT @D11821, PER @D11820, PLU @D11819, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, 
      N +, GRADE +, ADV -, AFORM NONE, PART -, NEG -, QUA -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM ON, DISTR PRD, 
      ARITY 2] : BENT_ON, 
   [COORD @D11830, REFL @D11829, PRD @D11828, CASE @D11827, FIX NOT, 
      BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, 
      PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BENT, 
   [COORD @D11834, REFL @D11833, PRD @D11832, CASE @D11831, FIX NOT, 
      INFL +, BAR 0, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBCAT PP, PFORM FOR, COUNT +] : BENT, 
   [COORD @D11840, PAST @D11839, 
      AGR [CASE @D11838, COUNT @D11837, PER @D11836, PLU @D11835, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, SUBCAT PP, SUBTYPE PVERB, 
      PSVE +, PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, INFL -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PFORM TO, FIN -, 
      ARITY 2] : BEND, 
   [COORD @D11846, PAST @D11845, AGR [CASE @D11844, COUNT @D11843, 
            PER @D11842, PLU @D11841, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, REG -, PFORM TO, FIN -, ARITY 2] : BEND, 
   [COORD @D11852, PAST @D11851, 
      AGR [CASE @D11850, COUNT @D11849, PER @D11848, PLU @D11847, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, SUBCAT PP, SUBTYPE PVERB, 
      PSVE +, PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, INFL -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PFORM BEFORE, 
      FIN -, ARITY 2] : BEND, 
   [COORD @D11858, PAST @D11857, AGR [CASE @D11856, COUNT @D11855, 
            PER @D11854, PLU @D11853, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT PP, REG -, PFORM BEFORE, FIN -, ARITY 2] : BEND, 
   [COORD @D11862, 
      AGR [COUNT @D11861, PER @D11860, PLU @D11859, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, PFORM TO, 
      PAST +, ARITY 2] : BEND, 
   [COORD @D11866, AGR [COUNT @D11865, PER @D11864, PLU @D11863, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT PP, REG -, 
      PFORM BEFORE, PAST +, ARITY 2] : BEND.

WORD bents : 
   [COORD @D11902, DEMON @D11901, REFL @D11900, PRD @D11899, CASE 
         @D11898, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BENT, 
   [COORD @D11907, DEMON @D11906, REFL @D11905, PRD @D11904, 
      CASE @D11903, COMPOUND NOT, FIX NOT, PN -, ADV -, PART -, CONJ NULL, 
      SUBCAT PP, PFORM FOR, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, 
      INFL -, PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : 
   BENT.

WORD bid : 
   [COORD @D11917, REFL @D11916, PRD @D11915, CASE @D11914, FIX NOT, 
      BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, 
      PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BID, 
   [COORD @D11920, 
      AGR [COUNT @D11919, PER @D11918, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, REG -, ARITY 3] : 
   BID, 
   [COORD @D11922, AGR [COUNT @D11921, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, 
      REG -, ARITY 3] : BID, 
   [COORD @D11924, AGR [COUNT @D11923, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, 
      REG -, ARITY 3] : BID, 
   [COORD @D11928, AGR [COUNT @D11927, PER @D11926, PLU @D11925, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_INF, REG -, ARITY 3] : BID, 
   [COORD @D11934, PAST @D11933, 
      AGR [CASE @D11932, COUNT @D11931, PER @D11930, PLU @D11929, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, REG -, ARITY 3] : 
   BID, 
   [COORD @D11937, AGR [COUNT @D11936, PER @D11935, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, 
      REG -, ARITY 3] : BID, 
   [COORD @D11939, AGR [COUNT @D11938, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, 
      REG -, ARITY 3] : BID, 
   [COORD @D11941, AGR [COUNT @D11940, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, 
      REG -, ARITY 3] : BID, 
   [COORD @D11945, AGR [COUNT @D11944, PER @D11943, PLU @D11942, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_BSE, REG -, ARITY 3] : BID, 
   [COORD @D11951, PAST @D11950, 
      AGR [CASE @D11949, COUNT @D11948, PER @D11947, PLU @D11946, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, REG -, ARITY 3] : 
   BID, 
   [COORD @D11954, AGR [COUNT @D11953, PER @D11952, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, 
      REG -, ARITY 3] : BID, 
   [COORD @D11956, AGR [COUNT @D11955, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, 
      REG -, ARITY 3] : BID, 
   [COORD @D11958, AGR [COUNT @D11957, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, 
      REG -, ARITY 3] : BID, 
   [COORD @D11962, AGR [COUNT @D11961, PER @D11960, PLU @D11959, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_NP, REG -, ARITY 3] : BID, 
   [COORD @D11968, PAST @D11967, 
      AGR [CASE @D11966, COUNT @D11965, PER @D11964, PLU @D11963, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, REG -, ARITY 3] : 
   BID, 
   [COORD @D11971, AGR [COUNT @D11970, PER @D11969, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BID, 
   [COORD @D11973, AGR [COUNT @D11972, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BID, 
   [COORD @D11975, AGR [COUNT @D11974, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BID, 
   [COORD @D11979, AGR [COUNT @D11978, PER @D11977, PLU @D11976, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, REG -, PFORM TO, ARITY 3] : BID, 
   [COORD @D11985, PAST @D11984, 
      AGR [CASE @D11983, COUNT @D11982, PER @D11981, PLU @D11980, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, REG -, PFORM TO, 
      ARITY 3] : BID, 
   [COORD @D11988, AGR [COUNT @D11987, PER @D11986, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PFORM FOR, ARITY 3] : BID, 
   [COORD @D11990, AGR [COUNT @D11989, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PFORM FOR, ARITY 3] : BID, 
   [COORD @D11992, AGR [COUNT @D11991, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PFORM FOR, ARITY 3] : BID, 
   [COORD @D11996, AGR [COUNT @D11995, PER @D11994, PLU @D11993, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, REG -, PFORM FOR, ARITY 3] : BID, 
   [COORD @D12002, PAST @D12001, 
      AGR [CASE @D12000, COUNT @D11999, PER @D11998, PLU @D11997, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM FOR, 
      ARITY 3] : BID, 
   [COORD @D12008, PAST @D12007, AGR [CASE @D12006, COUNT @D12005, 
            PER @D12004, PLU @D12003, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, 
      INFL -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_INF, REG -, FIN -, ARITY 3] : BID, 
   [COORD @D12014, PAST @D12013, 
      AGR [CASE @D12012, COUNT @D12011, PER @D12010, PLU @D12009, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, REG -, FIN -, ARITY 3] : 
   BID, 
   [COORD @D12020, PAST @D12019, AGR [CASE @D12018, COUNT @D12017, 
            PER @D12016, PLU @D12015, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, 
      INFL -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_BSE, REG -, FIN -, ARITY 3] : BID, 
   [COORD @D12026, PAST @D12025, 
      AGR [CASE @D12024, COUNT @D12023, PER @D12022, PLU @D12021, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, REG -, FIN -, ARITY 3] : 
   BID, 
   [COORD @D12032, PAST @D12031, AGR [CASE @D12030, COUNT @D12029, 
            PER @D12028, PLU @D12027, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, 
      PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_NP, REG -, FIN -, ARITY 3] : BID, 
   [COORD @D12038, PAST @D12037, 
      AGR [CASE @D12036, COUNT @D12035, PER @D12034, PLU @D12033, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, REG -, FIN -, ARITY 3] : BID, 
   [COORD @D12044, PAST @D12043, 
      AGR [CASE @D12042, COUNT @D12041, PER @D12040, PLU @D12039, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, REG -, PFORM TO, FIN -, 
      ARITY 3] : BID, 
   [COORD @D12050, PAST @D12049, AGR [CASE @D12048, COUNT @D12047, 
            PER @D12046, PLU @D12045, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, REG -, PFORM TO, FIN -, ARITY 3] : BID, 
   [COORD @D12056, PAST @D12055, 
      AGR [CASE @D12054, COUNT @D12053, PER @D12052, PLU @D12051, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM FOR, 
      FIN -, ARITY 3] : BID, 
   [COORD @D12062, PAST @D12061, AGR [CASE @D12060, COUNT @D12059, 
            PER @D12058, PLU @D12057, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_PP, REG -, PFORM FOR, FIN -, ARITY 3] : BID, 
   [COORD @D12066, 
      AGR [COUNT @D12065, PER @D12064, PLU @D12063, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, REG -, PAST +, 
      ARITY 3] : BID, 
   [COORD @D12071, AGR [CASE @D12070, COUNT @D12069, PER @D12068, 
            PLU @D12067, N +, V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, 
      PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_INF, REG -, PAST +, ARITY 3] : BID, 
   [COORD @D12075, AGR [COUNT @D12074, PER @D12073, PLU @D12072, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, FIN +, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_INF, REG -, PAST +, 
      ARITY 3] : BID, 
   [COORD @D12079, AGR [COUNT @D12078, PER @D12077, PLU @D12076, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, 
      REG -, PAST +, ARITY 3] : BID, 
   [COORD @D12084, AGR [CASE @D12083, COUNT @D12082, PER @D12081, 
            PLU @D12080, N +, V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, 
      PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, 
      SUBCAT OC_BSE, REG -, PAST +, ARITY 3] : BID, 
   [COORD @D12088, AGR [COUNT @D12087, PER @D12086, PLU @D12085, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, FIN +, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_BSE, REG -, PAST +, 
      ARITY 3] : BID, 
   [COORD @D12092, AGR [COUNT @D12091, PER @D12090, PLU @D12089, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, REG -, 
      PAST +, ARITY 3] : BID, 
   [COORD @D12097, AGR [CASE @D12096, COUNT @D12095, PER @D12094, 
            PLU @D12093, N +, V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, 
      PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP_NP, REG -, PAST +, ARITY 3] : BID, 
   [COORD @D12101, AGR [COUNT @D12100, PER @D12099, PLU @D12098, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_NP, REG -, 
      PAST +, ARITY 3] : BID, 
   [COORD @D12105, AGR [COUNT @D12104, PER @D12103, PLU @D12102, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      REG -, PFORM TO, PAST +, ARITY 3] : BID, 
   [COORD @D12110, AGR [CASE @D12109, COUNT @D12108, PER @D12107, 
            PLU @D12106, N +, V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, 
      PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE DMOVT, 
      SUBCAT NP_PP, REG -, PFORM TO, PAST +, ARITY 3] : BID, 
   [COORD @D12114, 
      AGR [COUNT @D12113, PER @D12112, PLU @D12111, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL -, VFORM EN, FIN +, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, REG -, PFORM TO, 
      PAST +, ARITY 3] : BID, 
   [COORD @D12118, AGR [COUNT @D12117, PER @D12116, PLU @D12115, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP_PP, REG -, 
      PFORM FOR, PAST +, ARITY 3] : BID, 
   [COORD @D12121, AGR [COUNT @D12120, PER @D12119, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, 
      ARITY 2] : BID, 
   [COORD @D12123, AGR [COUNT @D12122, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, 
      ARITY 2] : BID, 
   [COORD @D12125, AGR [COUNT @D12124, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, 
      ARITY 2] : BID, 
   [COORD @D12129, AGR [COUNT @D12128, PER @D12127, PLU @D12126, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      REG -, ARITY 2] : BID, 
   [COORD @D12135, PAST @D12134, AGR [CASE @D12133, COUNT @D12132, 
            PER @D12131, PLU @D12130, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, REG -, ARITY 2] : BID, 
   [COORD @D12138, AGR [COUNT @D12137, PER @D12136, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM ON, ARITY 2] : BID, 
   [COORD @D12140, AGR [COUNT @D12139, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM ON, ARITY 2] : BID, 
   [COORD @D12142, AGR [COUNT @D12141, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM ON, ARITY 2] : BID, 
   [COORD @D12146, AGR [COUNT @D12145, PER @D12144, PLU @D12143, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      REG -, PFORM ON, ARITY 2] : BID, 
   [COORD @D12152, PAST @D12151, AGR [CASE @D12150, COUNT @D12149, 
            PER @D12148, PLU @D12147, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, REG -, PFORM ON, ARITY 2] : BID, 
   [COORD @D12155, 
      AGR [COUNT @D12154, PER @D12153, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, PFORM FOR, 
      ARITY 2] : BID, 
   [COORD @D12157, AGR [COUNT @D12156, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM FOR, ARITY 2] : BID, 
   [COORD @D12159, AGR [COUNT @D12158, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM FOR, ARITY 2] : BID, 
   [COORD @D12163, AGR [COUNT @D12162, PER @D12161, PLU @D12160, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, 
      REG -, PFORM FOR, ARITY 2] : BID, 
   [COORD @D12169, PAST @D12168, AGR [CASE @D12167, COUNT @D12166, 
            PER @D12165, PLU @D12164, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT PP, REG -, PFORM FOR, ARITY 2] : BID, 
   [COORD @D12175, PAST @D12174, 
      AGR [CASE @D12173, COUNT @D12172, PER @D12171, PLU @D12170, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, FIN -, 
      ARITY 2] : BID, 
   [COORD @D12181, PAST @D12180, AGR [CASE @D12179, COUNT @D12178, 
            PER @D12177, PLU @D12176, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP, REG -, FIN -, ARITY 2] : BID, 
   [COORD @D12187, PAST @D12186, 
      AGR [CASE @D12185, COUNT @D12184, PER @D12183, PLU @D12182, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, PFORM ON, FIN -, 
      ARITY 2] : BID, 
   [COORD @D12193, PAST @D12192, AGR [CASE @D12191, COUNT @D12190, 
            PER @D12189, PLU @D12188, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT PP, REG -, PFORM FOR, FIN -, ARITY 2] : BID, 
   [COORD @D12197, 
      AGR [COUNT @D12196, PER @D12195, PLU @D12194, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, PAST +, 
      ARITY 2] : BID, 
   [COORD @D12202, AGR [CASE @D12201, COUNT @D12200, PER @D12199, 
            PLU @D12198, N +, V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, 
      PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      REG -, PAST +, ARITY 2] : BID, 
   [COORD @D12206, AGR [COUNT @D12205, PER @D12204, PLU @D12203, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, PAST +, 
      ARITY 2] : BID, 
   [COORD @D12210, AGR [COUNT @D12209, PER @D12208, PLU @D12207, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM ON, PAST +, ARITY 2] : BID, 
   [COORD @D12214, AGR [COUNT @D12213, PER @D12212, PLU @D12211, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, REG -, 
      PFORM FOR, PAST +, ARITY 2] : BID, 
   [COORD @D12217, AGR [COUNT @D12216, PER @D12215, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, ARITY 1] : BID, 
   [COORD @D12219, AGR [COUNT @D12218, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, ARITY 1] : BID, 
   [COORD @D12221, AGR [COUNT @D12220, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, ARITY 1] : BID, 
   [COORD @D12225, AGR [COUNT @D12224, PER @D12223, PLU @D12222, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, ARITY 1] : BID, 
   [COORD @D12231, PAST @D12230, AGR 
         [CASE @D12229, COUNT @D12228, PER @D12227, PLU @D12226, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, ARITY 1] : 
   BID, 
   [COORD @D12237, PAST @D12236, AGR [CASE @D12235, COUNT @D12234, 
            PER @D12233, PLU @D12232, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, FIN -, ARITY 1] : BID, 
   [COORD @D12241, AGR [COUNT @D12240, PER @D12239, PLU @D12238, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PAST +, ARITY 1] : BID.

WORD bidding : 
   [COORD @D12269, PRD @D12268, AGR [CASE @D12267, COUNT @D12266, 
            PER @D12265, PLU @D12264, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, SUBCAT OC_INF, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BID, 
   [COORD @D12275, PRD @D12274, AGR 
         [CASE @D12273, COUNT @D12272, PER @D12271, PLU @D12270, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE EQUI, SUBCAT OC_BSE, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BID, 
   
   [COORD @D12281, PRD @D12280, AGR [CASE @D12279, COUNT @D12278, PER 
               @D12277, PLU @D12276, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BID, 
   [COORD @D12287, PRD @D12286, AGR 
         [CASE @D12285, COUNT @D12284, PER @D12283, PLU @D12282, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE DMOVT, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, 
      V +, N -] : BID, 
   [COORD @D12293, PRD @D12292, AGR [CASE @D12291, COUNT @D12290, 
            PER @D12289, PLU @D12288, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP_PP, 
      PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BID, 
   [COORD @D12299, PRD @D12298, 
      AGR [CASE @D12297, COUNT @D12296, PER @D12295, PLU @D12294, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BID, 
   
   [COORD @D12305, PRD @D12304, AGR [CASE @D12303, COUNT @D12302, PER 
               @D12301, PLU @D12300, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT PP, PFORM ON, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BID, 
   [COORD @D12311, PRD @D12310, 
      AGR [CASE @D12309, COUNT @D12308, PER @D12307, PLU @D12306, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BID, 
   [COORD @D12317, PRD @D12316, AGR [CASE @D12315, COUNT @D12314, 
            PER @D12313, PLU @D12312, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BID.

WORD bids : 
   [COORD @D12330, DEMON @D12329, REFL @D12328, PRD @D12327, CASE 
         @D12326, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BID, 
   [COORD @D12332, 
      AGR [COUNT @D12331, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, 
      SUBCAT OC_INF, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12334, 
      AGR [COUNT @D12333, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE EQUI, 
      SUBCAT OC_BSE, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12336, 
      AGR [COUNT @D12335, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12338, 
      AGR [COUNT @D12337, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE DMOVT, 
      SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12340, 
      AGR [COUNT @D12339, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP_PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12342, 
      AGR [COUNT @D12341, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12344, 
      AGR [COUNT @D12343, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM ON, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12346, 
      AGR [COUNT @D12345, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT PP, PFORM FOR, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID, 
   [COORD @D12348, 
      AGR [COUNT @D12347, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BID.

WORD bind : 
   [COORD @D12357, AGR [COUNT @D12356, PER @D12355, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BIND, 
   [COORD @D12359, AGR [COUNT @D12358, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BIND, 
   [COORD @D12361, AGR [COUNT @D12360, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      REG -, PFORM TO, ARITY 3] : BIND, 
   [COORD @D12365, AGR [COUNT @D12364, PER @D12363, PLU @D12362, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, REG -, PFORM TO, ARITY 3] : BIND, 
   [COORD @D12371, PAST @D12370, 
      AGR [CASE @D12369, COUNT @D12368, PER @D12367, PLU @D12366, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, 
      LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, REG -, PFORM TO, 
      ARITY 3] : BIND, 
   [COORD @D12374, AGR [COUNT @D12373, PER @D12372, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OVER, ARITY 2] : BIND, 
   [COORD @D12376, AGR [COUNT @D12375, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OVER, ARITY 2] : BIND, 
   [COORD @D12378, AGR [COUNT @D12377, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OVER, ARITY 2] : BIND, 
   [COORD @D12382, AGR [COUNT @D12381, PER @D12380, PLU @D12379, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OVER, ARITY 2] : BIND, 
   [COORD @D12388, PAST @D12387, 
      AGR [CASE @D12386, COUNT @D12385, PER @D12384, PLU @D12383, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, 
      VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OVER, ARITY 2] : BIND, 
   [COORD @D12391, AGR [COUNT @D12390, PER @D12389, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OVER, ARITY 1] : BIND, 
   [COORD @D12393, AGR [COUNT @D12392, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OVER, ARITY 1] : BIND, 
   [COORD @D12395, AGR [COUNT @D12394, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, 
      REG -, PRT OVER, ARITY 1] : BIND, 
   [COORD @D12399, AGR [COUNT @D12398, PER @D12397, PLU @D12396, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT OVER, ARITY 1] : BIND, 
   [COORD @D12405, PAST @D12404, 
      AGR [CASE @D12403, COUNT @D12402, PER @D12401, PLU @D12400, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL +, FIN -, VFORM BSE, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT OVER, 
      ARITY 1] : BIND.

WORD binding : 
   [COORD @D12420, PRD @D12419, AGR [CASE @D12418, COUNT @D12417, 
            PER @D12416, PLU @D12415, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, CONJ NULL, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM TO, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, 
      PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : BIND, 
   [COORD @D12426, PRD @D12425, 
      AGR [CASE @D12424, COUNT @D12423, PER @D12422, PLU @D12421, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBCAT NP, 
      SUBTYPE NONE, CONJ NULL, PRT OVER, AUX -, INV -, NEG -, PSVE -, REG -, 
      PRO -, VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, 
      N -] : BIND, 
   [COORD @D12432, PRD @D12431, AGR [CASE @D12430, COUNT @D12429, 
            PER @D12428, PLU @D12427, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, PRT OVER, 
      AUX -, INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, 
      INFL -, AT +, LAT +, BAR 0, V +, N -] : BIND.

WORD binds : 
   [COORD @D12441, AGR [COUNT @D12440, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, CONJ NULL, 
      SUBTYPE PVERB, SUBCAT NP_PP, PFORM TO, AUX -, INV -, NEG -, PSVE -, 
      VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, 
      V +, N -] : BIND, 
   [COORD @D12443, AGR [COUNT @D12442, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBCAT NP, SUBTYPE NONE, 
      CONJ NULL, PRT OVER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BIND, 
   [COORD @D12445, 
      AGR [COUNT @D12444, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, PRT OVER, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, 
      PRD -, INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BIND.

WORD bore : 
   [COORD @D12454, AGR [COUNT @D12453, PER @D12452, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BORE, 
   [COORD @D12456, AGR [COUNT @D12455, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BORE, 
   [COORD @D12458, AGR [COUNT @D12457, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BORE, 
   [COORD @D12462, AGR [COUNT @D12461, PER @D12460, PLU @D12459, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP, ARITY 2] : BORE, 
   [COORD @D12468, PAST @D12467, AGR [CASE @D12466, COUNT @D12465, 
            PER @D12464, PLU @D12463, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BORE, 
   [COORD @D12471, AGR [COUNT @D12470, PER @D12469, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12473, AGR [COUNT @D12472, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12475, AGR [COUNT @D12474, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12479, AGR [COUNT @D12478, PER @D12477, PLU @D12476, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12485, PAST @D12484, AGR [CASE @D12483, COUNT @D12482, 
            PER @D12481, PLU @D12480, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NP, LAT -, ARITY 2] : BORE, 
   [COORD @D12488, AGR [COUNT @D12487, PER @D12486, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12490, AGR [COUNT @D12489, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12492, AGR [COUNT @D12491, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, LAT -, 
      ARITY 2] : BORE, 
   [COORD @D12496, AGR [COUNT @D12495, PER @D12494, PLU @D12493, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT LOC, 
      LAT -, ARITY 2] : BORE, 
   [COORD @D12502, PAST @D12501, AGR [CASE @D12500, COUNT @D12499, 
            PER @D12498, PLU @D12497, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT LOC, LAT -, ARITY 2] : BORE, 
   [COORD @D12506, AGR [COUNT @D12505, PER @D12504, PLU @D12503, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, REG -, PAST +, 
      ARITY 2] : BARE, 
   [COORD @D12509, AGR [COUNT @D12508, PER @D12507, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BORE, 
   [COORD @D12511, AGR [COUNT @D12510, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BORE, 
   [COORD @D12513, AGR [COUNT @D12512, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BORE, 
   [COORD @D12517, AGR [COUNT @D12516, PER @D12515, PLU @D12514, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, ARITY 1] : BORE, 
   [COORD @D12523, PAST @D12522, AGR [CASE @D12521, COUNT @D12520, 
            PER @D12519, PLU @D12518, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NULL, ARITY 1] : BORE, 
   [COORD @D12526, AGR [COUNT @D12525, PER @D12524, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BORE, 
   [COORD @D12528, AGR [COUNT @D12527, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BORE, 
   [COORD @D12530, AGR [COUNT @D12529, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, LAT -, 
      ARITY 1] : BORE, 
   [COORD @D12534, AGR [COUNT @D12533, PER @D12532, PLU @D12531, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      LAT -, ARITY 1] : BORE, 
   [COORD @D12540, PAST @D12539, AGR [CASE @D12538, COUNT @D12537, 
            PER @D12536, PLU @D12535, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBCAT NULL, LAT -, ARITY 1] : BORE.

WORD bored : 
   [COORD @D12552, AGR [CASE @D12551, COUNT @D12550, PER @D12549, 
            PLU @D12548, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BORE, 
   [COORD @D12557, AGR [CASE @D12556, COUNT @D12555, PER @D12554, 
            PLU @D12553, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12562, AGR [CASE @D12561, COUNT @D12560, PER @D12559, 
            PLU @D12558, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BORE, 
   [COORD @D12567, AGR [CASE @D12566, COUNT @D12565, PER @D12564, 
            PLU @D12563, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12572, AGR [CASE @D12571, COUNT @D12570, PER @D12569, 
            PLU @D12568, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BORE, 
   [COORD @D12577, AGR [CASE @D12576, COUNT @D12575, PER @D12574, 
            PLU @D12573, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BORE, 
   [COORD @D12582, AGR [CASE @D12581, COUNT @D12580, PER @D12579, 
            PLU @D12578, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12587, AGR [CASE @D12586, COUNT @D12585, PER @D12584, 
            PLU @D12583, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BORE, 
   [COORD @D12592, AGR [CASE @D12591, COUNT @D12590, PER @D12589, 
            PLU @D12588, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12597, AGR [CASE @D12596, COUNT @D12595, PER @D12594, 
            PLU @D12593, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BORE, 
   [COORD @D12602, AGR [CASE @D12601, COUNT @D12600, PER @D12599, 
            PLU @D12598, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12607, AGR [CASE @D12606, COUNT @D12605, PER @D12604, 
            PLU @D12603, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BORE.

WORD bores : 
   [COORD @D12616, AGR [COUNT @D12615, NFORM NORM, PLU -, PER 3, CASE NOM, 
            N +, V -, BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BORE, 
   [COORD @D12618, 
      AGR [COUNT @D12617, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BORE, 
   [COORD @D12620, 
      AGR [COUNT @D12619, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT LOC, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BORE, 
   [COORD @D12622, 
      AGR [COUNT @D12621, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BORE, 
   [COORD @D12624, 
      AGR [COUNT @D12623, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BORE.

WORD boring : 
   [COORD @D12636, PRD @D12635, AGR [CASE @D12634, COUNT @D12633, 
            PER @D12632, PLU @D12631, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12642, PRD @D12641, 
      AGR [CASE @D12640, COUNT @D12639, PER @D12638, PLU @D12637, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BORE, 
   [COORD @D12648, PRD @D12647, AGR [CASE @D12646, COUNT @D12645, 
            PER @D12644, PLU @D12643, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT LOC, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BORE, 
   [COORD @D12654, PRD @D12653, 
      AGR [CASE @D12652, COUNT @D12651, PER @D12650, PLU @D12649, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT NULL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BORE, 
   [COORD @D12660, PRD @D12659, AGR [CASE @D12658, COUNT @D12657, 
            PER @D12656, PLU @D12655, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NULL, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BORE.

WORD bought : 
   [COORD @D12677, PAST @D12676, AGR [CASE @D12675, COUNT @D12674, 
            PER @D12673, PLU @D12672, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OUT, PFORM OF, FIN -, ARITY 3] : BUY, 
   [COORD @D12683, PAST @D12682, 
      AGR [CASE @D12681, COUNT @D12680, PER @D12679, PLU @D12678, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP_PP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OUT, 
      PFORM OF, FIN -, ARITY 3] : BUY, 
   [COORD @D12689, PAST @D12688, AGR [CASE @D12687, COUNT @D12686, 
            PER @D12685, PLU @D12684, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, 
      INFL -, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_AP, 
      REG -, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12695, PAST @D12694, 
      AGR [CASE @D12693, COUNT @D12692, PER @D12691, PLU @D12690, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, 
      SUBTYPE EQUI, SUBCAT OC_AP, REG -, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12701, PAST @D12700, 
      AGR [CASE @D12699, COUNT @D12698, PER @D12697, PLU @D12696, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, REG -, LAT -, FIN -, ARITY 3] : 
   BUY, 
   [COORD @D12707, PAST @D12706, AGR [CASE @D12705, COUNT @D12704, 
            PER @D12703, PLU @D12702, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, 
      REG -, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12713, PAST @D12712, 
      AGR [CASE @D12711, COUNT @D12710, PER @D12709, PLU @D12708, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM WITH, LAT -, FIN -, 
      ARITY 3] : BUY, 
   [COORD @D12719, PAST @D12718, AGR [CASE @D12717, COUNT @D12716, 
            PER @D12715, PLU @D12714, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PFORM WITH, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12725, PAST @D12724, 
      AGR [CASE @D12723, COUNT @D12722, PER @D12721, PLU @D12720, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM FROM, LAT -, FIN -, 
      ARITY 3] : BUY, 
   [COORD @D12731, PAST @D12730, AGR [CASE @D12729, COUNT @D12728, 
            PER @D12727, PLU @D12726, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, 
      REG -, PFORM FROM, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12737, PAST @D12736, 
      AGR [CASE @D12735, COUNT @D12734, PER @D12733, PLU @D12732, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, 
      COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, REG -, PFORM FOR, LAT -, 
      FIN -, ARITY 3] : BUY, 
   [COORD @D12743, PAST @D12742, AGR [CASE @D12741, COUNT @D12740, 
            PER @D12739, PLU @D12738, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, 
      REG -, PFORM FOR, LAT -, FIN -, ARITY 3] : BUY, 
   [COORD @D12747, AGR [COUNT @D12746, PER @D12745, PLU @D12744, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP_PP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, PFORM OF, PAST +, ARITY 3] : BUY, 
   [COORD @D12751, AGR [COUNT @D12750, PER @D12749, PLU @D12748, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_AP, REG -, PAST +, 
      LAT -, ARITY 3] : BUY, 
   [COORD @D12755, AGR [COUNT @D12754, PER @D12753, PLU @D12752, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_NP, REG -, PAST +, LAT -, 
      ARITY 3] : BUY, 
   [COORD @D12759, AGR [COUNT @D12758, PER @D12757, PLU @D12756, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM WITH, 
      PAST +, LAT -, ARITY 3] : BUY, 
   [COORD @D12763, AGR [COUNT @D12762, PER @D12761, PLU @D12760, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP_PP, REG -, PFORM FROM, 
      PAST +, LAT -, ARITY 3] : BUY, 
   [COORD @D12767, AGR [COUNT @D12766, PER @D12765, PLU @D12764, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, 
      AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE DMOVT, SUBCAT NP_PP, REG -, PFORM FOR, 
      PAST +, LAT -, ARITY 3] : BUY, 
   [COORD @D12773, PAST @D12772, AGR [CASE @D12771, COUNT @D12770, 
            PER @D12769, PLU @D12768, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT UP, FIN -, ARITY 2] : BUY, 
   [COORD @D12779, PAST @D12778, 
      AGR [CASE @D12777, COUNT @D12776, PER @D12775, PLU @D12774, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT UP, 
      FIN -, ARITY 2] : BUY, 
   [COORD @D12785, PAST @D12784, AGR [CASE @D12783, COUNT @D12782, 
            PER @D12781, PLU @D12780, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OUT, FIN -, ARITY 2] : BUY, 
   [COORD @D12791, PAST @D12790, 
      AGR [CASE @D12789, COUNT @D12788, PER @D12787, PLU @D12786, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OUT, 
      FIN -, ARITY 2] : BUY, 
   [COORD @D12797, PAST @D12796, AGR [CASE @D12795, COUNT @D12794, 
            PER @D12793, PLU @D12792, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OFF, FIN -, ARITY 2] : BUY, 
   [COORD @D12803, PAST @D12802, 
      AGR [CASE @D12801, COUNT @D12800, PER @D12799, PLU @D12798, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OFF, 
      FIN -, ARITY 2] : BUY, 
   [COORD @D12809, PAST @D12808, AGR [CASE @D12807, COUNT @D12806, 
            PER @D12805, PLU @D12804, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, 
      AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT IN, FIN -, ARITY 2] : BUY, 
   [COORD @D12815, PAST @D12814, 
      AGR [CASE @D12813, COUNT @D12812, PER @D12811, PLU @D12810, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT IN, 
      FIN -, ARITY 2] : BUY, 
   [COORD @D12821, PAST @D12820, AGR [CASE @D12819, COUNT @D12818, 
            PER @D12817, PLU @D12816, N +, V -, BAR 2, NFORM NORM], 
      VFORM EN, PSVE +, PRD +, FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, 
      PRO -, NEG -, INFL -, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, 
      LAT -, FIN -, ARITY 2] : BUY, 
   [COORD @D12827, PAST @D12826, AGR [CASE @D12825, COUNT @D12824, 
            PER @D12823, PLU @D12822, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, 
      REG -, LAT -, FIN -, ARITY 2] : BUY, 
   [COORD @D12833, PAST @D12832, 
      AGR [CASE @D12831, COUNT @D12830, PER @D12829, PLU @D12828, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, LAT -, FIN -, ARITY 2] : 
   BUY, 
   [COORD @D12839, PAST @D12838, AGR [CASE @D12837, COUNT @D12836, 
            PER @D12835, PLU @D12834, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, 
      REG -, PFORM FOR, LAT -, FIN -, ARITY 2] : BUY, 
   [COORD @D12843, AGR [COUNT @D12842, PER @D12841, PLU @D12840, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT UP, PAST +, ARITY 2] : BUY, 
   [COORD @D12847, AGR [COUNT @D12846, PER @D12845, PLU @D12844, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OUT, PAST +, ARITY 2] : BUY, 
   [COORD @D12851, AGR [COUNT @D12850, PER @D12849, PLU @D12848, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OFF, PAST +, ARITY 2] : BUY, 
   [COORD @D12855, AGR [COUNT @D12854, PER @D12853, PLU @D12852, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT IN, PAST +, ARITY 2] : BUY, 
   [COORD @D12859, AGR [COUNT @D12858, PER @D12857, PLU @D12856, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NP, REG -, PAST +, LAT -, 
      ARITY 2] : BUY, 
   [COORD @D12863, AGR [COUNT @D12862, PER @D12861, PLU @D12860, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FROM, PAST +, 
      LAT -, ARITY 2] : BUY, 
   [COORD @D12867, AGR [COUNT @D12866, PER @D12865, PLU @D12864, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT PP, REG -, PFORM FOR, PAST +, 
      LAT -, ARITY 2] : BUY, 
   [COORD @D12873, PAST @D12872, AGR [CASE @D12871, COUNT @D12870, 
            PER @D12869, PLU @D12868, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT UP, FIN -, ARITY 1] : BUY, 
   [COORD @D12879, PAST @D12878, 
      AGR [CASE @D12877, COUNT @D12876, PER @D12875, PLU @D12874, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT OUT, FIN -, 
      ARITY 1] : BUY, 
   [COORD @D12885, PAST @D12884, AGR [CASE @D12883, COUNT @D12882, 
            PER @D12881, PLU @D12880, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT OFF, FIN -, ARITY 1] : BUY, 
   [COORD @D12891, PAST @D12890, 
      AGR [CASE @D12889, COUNT @D12888, PER @D12887, PLU @D12886, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, N -, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, PRT IN, FIN -, 
      ARITY 1] : BUY, 
   [COORD @D12897, PAST @D12896, AGR [CASE @D12895, COUNT @D12894, 
            PER @D12893, PLU @D12892, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, 
      REG -, LAT -, FIN -, ARITY 1] : BUY, 
   [COORD @D12901, AGR [COUNT @D12900, PER @D12899, PLU @D12898, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT UP, PAST +, ARITY 1] : BUY, 
   [COORD @D12905, AGR [COUNT @D12904, PER @D12903, PLU @D12902, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT OUT, PAST +, ARITY 1] : BUY, 
   [COORD @D12909, AGR [COUNT @D12908, PER @D12907, PLU @D12906, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT OFF, PAST +, ARITY 1] : BUY, 
   [COORD @D12913, AGR [COUNT @D12912, PER @D12911, PLU @D12910, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT IN, PAST +, ARITY 1] : BUY, 
   [COORD @D12917, AGR [COUNT @D12916, PER @D12915, PLU @D12914, BAR 2, 
            V -, N +, NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, COMPOUND NOT, SUBCAT NULL, REG -, PAST +, LAT -, 
      ARITY 1] : BUY.

WORD bound : 
   [COADV @D12948, COORD @D12947, DEF @D12946, PRD @D12945, AGR 
            [CASE @D12944, COUNT @D12943, PER @D12942, PLU @D12941, 
            BAR 2, V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, 
      BAR 0, N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, 
      SUBCAT NULL, DISTR ATT, QUA -, NUM -, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT] : BOUND, 
   [COADV @D12956, COORD @D12955, DEF @D12954, PRD @D12953, 
      AGR [CASE @D12952, COUNT @D12951, PER @D12950, PLU @D12949, BAR 2, 
            V -, N +, NFORM NORM], N +, V +, SUBCAT SINF, SUBTYPE NONE, 
      FIX NOT, INFL +, BAR 0, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, 
      NEG -, QUA -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT, DISTR PRD, 
      ARITY 2] : BOUND, 
   [COADV @D12964, COORD @D12963, DEF @D12962, PRD @D12961, 
      AGR [CASE @D12960, COUNT @D12959, PER @D12958, PLU @D12957, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, INFL +, BAR 0, V +, N +, 
      COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, QUA -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE EQUI, SUBCAT SC_INF, 
      DISTR PRD, ARITY 2] : BOUND, 
   [COADV @D12972, COORD @D12971, DEF @D12970, PRD @D12969, 
      AGR [CASE @D12968, COUNT @D12967, PER @D12966, PLU @D12965, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, 
      N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, QUA -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM TO, 
      DISTR PRD, ARITY 2] : BOUND, 
   [COADV @D12980, COORD @D12979, DEF @D12978, PRD @D12977, 
      AGR [CASE @D12976, COUNT @D12975, PER @D12974, PLU @D12973, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, SUBTYPE NONE, INFL +, BAR 0, 
      N +, COMPAR NO, GRADE -, ADV -, AFORM NONE, PART -, NEG -, QUA -, 
      NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT PP, PFORM FOR, 
      DISTR PRD, ARITY 2] : BOUND, 
   [COORD @D12984, REFL @D12983, PRD @D12982, CASE @D12981, FIX NOT, 
      BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, 
      PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BOUND, 
   [COORD @D12990, PAST @D12989, 
      AGR [CASE @D12988, COUNT @D12987, PER @D12986, PLU @D12985, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      N -, AUX -, INV -, PRO -, NEG -, INFL -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, REG -, PFORM TO, FIN -, 
      ARITY 3] : BIND, 
   [COORD @D12996, PAST @D12995, AGR [CASE @D12994, COUNT @D12993, 
            PER @D12992, PLU @D12991, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, 
      VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, REG -, PFORM TO, FIN -, ARITY 3] : BIND, 
   [COORD @D13000, 
      AGR [COUNT @D12999, PER @D12998, PLU @D12997, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, N -, VFORM NOT, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, REG -, 
      PFORM TO, PAST +, ARITY 3] : BIND, 
   [COORD @D13003, AGR [COUNT @D13002, PER @D13001, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BOUND, 
   [COORD @D13005, AGR [COUNT @D13004, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BOUND, 
   [COORD @D13007, AGR [COUNT @D13006, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BOUND, 
   [COORD @D13011, AGR [COUNT @D13010, PER @D13009, PLU @D13008, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP, ARITY 2] : BOUND, 
   [COORD @D13017, PAST @D13016, AGR [CASE @D13015, COUNT @D13014, 
            PER @D13013, PLU @D13012, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BOUND, 
   [COORD @D13020, AGR [COUNT @D13019, PER @D13018, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT ADL, 
      ARITY 2] : BOUND, 
   [COORD @D13022, AGR [COUNT @D13021, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT ADL, 
      ARITY 2] : BOUND, 
   [COORD @D13024, AGR [COUNT @D13023, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT ADL, 
      ARITY 2] : BOUND, 
   [COORD @D13028, AGR [COUNT @D13027, PER @D13026, PLU @D13025, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT ADL, ARITY 2] : BOUND, 
   [COORD @D13034, PAST @D13033, AGR [CASE @D13032, COUNT @D13031, 
            PER @D13030, PLU @D13029, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT ADL, ARITY 2] : BOUND, 
   [COORD @D13040, PAST @D13039, 
      AGR [CASE @D13038, COUNT @D13037, PER @D13036, PLU @D13035, N +, 
            V -, BAR 2, NFORM NORM], VFORM EN, PSVE +, PRD +, FIX NOT, V +, 
      N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, INFL -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, PRT OVER, FIN -, 
      ARITY 2] : BIND, 
   [COORD @D13046, PAST @D13045, AGR [CASE @D13044, COUNT @D13043, 
            PER @D13042, PLU @D13041, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, N -, SUBCAT NP, SUBTYPE NONE, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, REG -, PRT OVER, FIN -, ARITY 2] : BIND, 
   [COORD @D13050, 
      AGR [COUNT @D13049, PER @D13048, PLU @D13047, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, N -, SUBCAT NP, 
      SUBTYPE NONE, VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      INFL -, FIN +, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, 
      PRT OVER, PAST +, ARITY 2] : BIND, 
   [COORD @D13056, PAST @D13055, AGR [CASE @D13054, COUNT @D13053, 
            PER @D13052, PLU @D13051, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, INFL -, VFORM EN, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NULL, REG -, PRT OVER, FIN -, ARITY 1] : BIND, 
   [COORD @D13060, 
      AGR [COUNT @D13059, PER @D13058, PLU @D13057, BAR 2, V -, N +, 
            NFORM NORM, CASE NOM], FIX NOT, V +, SUBTYPE NONE, N -, 
      VFORM NOT, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, INFL -, FIN +, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NULL, REG -, 
      PRT OVER, PAST +, ARITY 1] : BIND.

WORD bounded : 
   [COORD @D13073, AGR [CASE @D13072, COUNT @D13071, PER @D13070, 
            PLU @D13069, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BOUND, 
   [COORD @D13078, AGR [CASE @D13077, COUNT @D13076, PER @D13075, 
            PLU @D13074, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BOUND, 
   [COORD @D13083, AGR [CASE @D13082, COUNT @D13081, PER @D13080, 
            PLU @D13079, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BOUND, 
   [COORD @D13088, AGR [CASE @D13087, COUNT @D13086, PER @D13085, 
            PLU @D13084, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT ADL, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BOUND, 
   [COORD @D13093, AGR [CASE @D13092, COUNT @D13091, PER @D13090, 
            PLU @D13089, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT ADL, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BOUND.

WORD bounding : 
   [COORD @D13113, PRD @D13112, AGR [CASE @D13111, COUNT @D13110, 
            PER @D13109, PLU @D13108, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BOUND, 
   [COORD @D13119, PRD @D13118, 
      AGR [CASE @D13117, COUNT @D13116, PER @D13115, PLU @D13114, BAR 2, 
            V -, N +, NFORM NORM], COMPOUND NOT, FIX NOT, SUBTYPE NONE, 
      CONJ NULL, SUBCAT ADL, AUX -, INV -, NEG -, PSVE -, REG -, PRO -, 
      VFORM ING, FIN -, PAST NOT, INFL -, AT +, LAT +, BAR 0, V +, N -] : 
   BOUND.

WORD bounds : 
   [COORD @D13131, REFL @D13130, PRD @D13129, CASE @D13128, FIX NOT, 
      BAR 0, SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, INFL -, PLU +, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, REG -, COUNT +] : BOUNDS, 
   [COORD @D13136, DEMON @D13135, REFL @D13134, PRD @D13133, 
      CASE @D13132, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BOUND, 
   [COORD @D13138, 
      AGR [COUNT @D13137, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BOUND, 
   [COORD @D13140, 
      AGR [COUNT @D13139, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT ADL, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BOUND.

WORD brain : 
   [COORD @D13165, REFL @D13164, COUNT @D13163, PRD @D13162, CASE 
         @D13161, FIX NOT, BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, 
      PRO -, PROTYPE NONE, PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, 
      DEMON -, NUM -, CONJ NULL, AT +, LAT +, COMPOUND NOT] : BRAIN, 
   [COORD @D13168, 
      AGR [COUNT @D13167, PER @D13166, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, ARITY 2] : 
   BRAIN, 
   [COORD @D13170, AGR [COUNT @D13169, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BRAIN, 
   [COORD @D13172, AGR [COUNT @D13171, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, NEG -, 
      PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBCAT NP, 
      ARITY 2] : BRAIN, 
   [COORD @D13176, AGR [COUNT @D13175, PER @D13174, PLU @D13173, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, SUBTYPE NONE, N -, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      SUBCAT NP, ARITY 2] : BRAIN, 
   [COORD @D13182, PAST @D13181, AGR [CASE @D13180, COUNT @D13179, 
            PER @D13178, PLU @D13177, BAR 2, V -, N +, NFORM NORM], 
      FIX NOT, V +, SUBTYPE NONE, N -, INFL +, REG +, AUX -, INV -, PRO -, 
      NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, SUBCAT NP, ARITY 2] : BRAIN.

WORD brained : 
   [COORD @D13194, AGR [CASE @D13193, COUNT @D13192, PER @D13191, 
            PLU @D13190, NFORM NORM, N +, V -, BAR 2], COMPOUND NOT, 
      FIX NOT, SUBCAT NP, SUBTYPE NONE, CONJ NULL, AUX -, INV -, NEG -, 
      PSVE +, PRO -, VFORM EN, FIN -, PAST NOT, PRD +, INFL -, AT +, LAT +, 
      BAR 0, V +, N -] : BRAIN, 
   [COORD @D13199, AGR [CASE @D13198, COUNT @D13197, PER @D13196, 
            PLU @D13195, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, PRO -, VFORM EN, FIN -, PAST NOT, PRD -, INFL -, AT +, 
      LAT +, BAR 0, V +, N -] : BRAIN, 
   [COORD @D13204, AGR [CASE @D13203, COUNT @D13202, PER @D13201, 
            PLU @D13200, BAR 2, V -, N +, NFORM NORM], COMPOUND NOT, 
      FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, INV -, NEG -, 
      PSVE -, REG -, VFORM NOT, PRO -, PRD -, INFL -, FIN +, AT +, LAT +, 
      PAST +, BAR 0, V +, N -] : BRAIN.

WORD braining : 
   [COORD @D13221, PRD @D13220, AGR [CASE @D13219, COUNT @D13218, 
            PER @D13217, PLU @D13216, BAR 2, V -, N +, NFORM NORM], 
      COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, SUBCAT NP, AUX -, 
      INV -, NEG -, PSVE -, REG -, PRO -, VFORM ING, FIN -, PAST NOT, INFL -, 
      AT +, LAT +, BAR 0, V +, N -] : BRAIN.

WORD brains : 
   [COORD @D13232, REFL @D13231, PRD @D13230, CASE @D13229, FIX NOT, 
      BAR 0, SUBCAT NULL, N +, V -, POSS -, PRO -, PROTYPE NONE, PN -, PLU -, 
      NFORM NORM, PER 3, ADV -, PART -, DEMON -, COUNT -, INFL -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT] : BRAINS, 
   [COORD @D13237, DEMON @D13236, REFL @D13235, PRD @D13234, 
      CASE @D13233, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BRAIN, 
   [COORD @D13239, 
      AGR [COUNT @D13238, NFORM NORM, PLU -, PER 3, CASE NOM, N +, V -, 
            BAR 2], COMPOUND NOT, FIX NOT, SUBTYPE NONE, CONJ NULL, 
      SUBCAT NP, AUX -, INV -, NEG -, PSVE -, VFORM NOT, PRO -, PRD -, 
      INFL -, FIN +, AT +, LAT +, PAST -, BAR 0, V +, N -] : BRAIN.

WORD branch : 
   [COORD @D13260, REFL @D13259, PRD @D13258, CASE @D13257, FIX NOT, 
      BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, 
      PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BRANCH.

WORD branches : 
   [COORD @D13277, DEMON @D13276, REFL @D13275, PRD @D13274, 
      CASE @D13273, COMPOUND NOT, FIX NOT, SUBCAT NULL, PN -, ADV -, PART -, 
      CONJ NULL, PROTYPE NONE, REG -, PRO -, NFORM NORM, PER 3, INFL -, 
      PLU +, NUM -, AT +, LAT +, COUNT +, POSS -, BAR 0, N +, V -] : BRANCH.

WORD break : 
   [COORD @D13300, REFL @D13299, PRD @D13298, CASE @D13297, FIX NOT, 
      BAR 0, SUBCAT NULL, INFL +, N +, V -, POSS -, PRO -, PROTYPE NONE, 
      PN -, PLU -, NFORM NORM, PER 3, ADV -, PART -, DEMON -, NUM -, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, COUNT +] : BREAK, 
   [COORD @D13303, 
      AGR [COUNT @D13302, PER @D13301, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, 
      N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, 
      PFORM OF, ARITY 3] : BREAK, 
   [COORD @D13305, AGR [COUNT @D13304, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM OF, ARITY 3] : BREAK, 
   [COORD @D13307, AGR [COUNT @D13306, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM OF, ARITY 3] : BREAK, 
   [COORD @D13311, AGR [COUNT @D13310, PER @D13309, PLU @D13308, N +, 
            V -, BAR 2, NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, 
      PAST NOT, FIX NOT, V +, N -, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, 
      SUBCAT NP_PP, PFORM OF, ARITY 3] : BREAK, 
   [COORD @D13317, PAST @D13316, 
      AGR [CASE @D13315, COUNT @D13314, PER @D13313, PLU @D13312, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, INFL +, REG +, AUX -, 
      INV -, PRO -, NEG -, PRD -, PSVE -, FIN -, VFORM BSE, BAR 0, CONJ NULL, 
      AT +, LAT +, COMPOUND NOT, SUBTYPE PVERB, SUBCAT NP_PP, PFORM OF, 
      ARITY 3] : BREAK, 
   [COORD @D13320, AGR [COUNT @D13319, PER @D13318, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OFF, PFORM WITH, ARITY 3] : BREAK, 
   [COORD @D13322, 
      AGR [COUNT @D13321, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OFF, 
      PFORM WITH, ARITY 3] : BREAK, 
   [COORD @D13324, AGR [COUNT @D13323, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OFF, PFORM WITH, ARITY 3] : BREAK, 
   [COORD @D13328, 
      AGR [COUNT @D13327, PER @D13326, PLU @D13325, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT OFF, PFORM WITH, ARITY 3] : BREAK, 
   [COORD @D13334, PAST @D13333, 
      AGR [CASE @D13332, COUNT @D13331, PER @D13330, PLU @D13329, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP_PP, 
      SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT OFF, 
      PFORM WITH, ARITY 3] : BREAK, 
   [COORD @D13337, AGR [COUNT @D13336, PER @D13335, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT DOWN, PFORM INTO, ARITY 3] : BREAK, 
   [COORD @D13339, 
      AGR [COUNT @D13338, N +, V -, BAR 2, NFORM NORM, CASE NOM, PER 1, 
            PLU -], VFORM NOT, FIN +, INFL -, PAST -, FIX NOT, V +, N -, 
      SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, PRO -, NEG -, PRD -, 
      PSVE -, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, PRT DOWN, 
      PFORM INTO, ARITY 3] : BREAK, 
   [COORD @D13341, AGR [COUNT @D13340, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT DOWN, PFORM INTO, ARITY 3] : BREAK, 
   [COORD @D13345, 
      AGR [COUNT @D13344, PER @D13343, PLU @D13342, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM], VFORM BSE, FIN +, INFL -, PAST NOT, 
      FIX NOT, V +, N -, SUBCAT NP_PP, SUBTYPE NONE, REG +, AUX -, INV -, 
      PRO -, NEG -, PRD -, PSVE -, BAR 0, CONJ NULL, AT +, LAT +, 
      COMPOUND NOT, PRT DOWN, PFORM INTO, ARITY 3] : BREAK, 
   [COORD @D13351, PAST @D13350, 
      AGR [CASE @D13349, COUNT @D13348, PER @D13347, PLU @D13346, BAR 2, 
            V -, N +, NFORM NORM], FIX NOT, V +, N -, SUBCAT NP_PP, 
      SUBTYPE NONE, INFL +, REG +, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, 
      FIN -, VFORM BSE, BAR 0, CONJ NULL, AT +, LAT +, COMPOUND NOT, 
      PRT DOWN, PFORM INTO, ARITY 3] : BREAK, 
   [COORD @D13354, AGR [COUNT @D13353, PER @D13352, N +, V -, BAR 2, 
            NFORM NORM, CASE NOM, PLU +], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_AP, REG -, LAT -, 
      ARITY 3] : BREAK, 
   [COORD @D13356, AGR [COUNT @D13355, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 1, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE EQUI, SUBCAT OC_AP, REG -, LAT -, 
      ARITY 3] : BREAK, 
   [COORD @D13358, AGR [COUNT @D13357, N +, V -, BAR 2, NFORM NORM, 
            CASE NOM, PER 2, PLU -], VFORM NOT, FIN +, INFL -, PAST -, 
      FIX NOT, V +, N -, AUX -, INV -, PRO -, NEG -, PRD -, PSVE -, BAR 0, 
      CONJ NULL, COMPOUND NOT, SUBTYPE E