;;;
;;; Lisp calls for loading Common Lisp version of Analyser
;;;

(in-package #+(or cltl2 x3j13) common-lisp-user #-(or cltl2 x3j13) 'user)


#-gde-debug
(eval-when (compile load eval)
   (proclaim
      '(optimize (speed 2) (safety 1) (compilation-speed 0)
         (space 0) #+(or cltl2 x3j13) (debug 1))))


;;; *** Give initial directories part of the name of this file; 
;;; everything before the non-directory section of the name.

(defvar *morph-source-dir*
   #+(OR UNIX SUNOS) "/usr/groups/nltools/annlt/gde/cmorph/"
   #+XEROX "{DSK}<lispfiles2>cmorph>"
   #+(OR MACINTOSH :CORAL) "internal:cmorph:"
   )


(eval-when (compile load eval)
   #+POPLOG
   (progn
      (setf pop11::popgctrace t)
      (setf pop11::popmemlim 1500000))
   #+LUCID
   (setf *redefinition-action* nil)
   #+PROCYON
   (pushnew (make-pathname :type #+2.1 "fasl" #-2.1 "fsl")
      *load-pathname-types* :test #'equalp)
   )


(eval-when (load eval)
   (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load
      (concatenate 'string *morph-source-dir* "maload"
         #+POPLOG ".lsp" #+XEROX ".dfasl"))
   (d-maload *morph-source-dir*)
   (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load
      (concatenate 'string *morph-source-dir* "morphan"
         #+POPLOG ".lsp" #+XEROX ".dfasl"))
   (d-initreader))


(eval-when (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load eval)
   (mapc
      #'(lambda (x)
          (unintern x
             (find-package ' #+(or cltl2 x3j13) common-lisp-user
                #-(or cltl2 x3j13) user)))
      '(include allocate concat copy neq ncons
          declare assoc assq delq eq 
          error gensym load member memq remove tyi zerop)))


;;; End of file
