;;;
;;; Lisp calls for compiling Common Lisp version of Analyser
;;;

(in-package #+(or cltl2 x3j13) common-lisp-user #-(or cltl2 x3j13) 'user)


#-gde-debug
(eval-when (compile load eval)
   (proclaim
      '(optimize (speed 2) (safety 1) (compilation-speed 0)
         (space 0) #+(or cltl2 x3j13) (debug 1))))


;;; *** Give initial directories part of the name of this file; 
;;; everything before the non-directory section of the name.

(defvar *morph-source-dir*
   #+(OR UNIX SUNOS) "/usr/groups/nltools/annlt/gde/cmorph/"
   #+XEROX "{DSK}<lispfiles2>cmorph>"
   #+(OR MACINTOSH :CORAL) "internal:cmorph:"
   )


(eval-when (compile load eval)
   #+LUCID
   (setf *redefinition-action* nil)
   #+PROCYON
   (pushnew (make-pathname :type #+2.1 "fasl" #-2.1 "fsl")
      *load-pathname-types* :test #'equalp)
   )


(eval-when (load eval)
   (let
      ((maload
          (concatenate 'string *morph-source-dir* "maload"))
       (smafuncs
          (concatenate 'string *morph-source-dir* "smafuncs")))
      (compile-file (concatenate 'string maload ".lsp"))
      (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load
         (concatenate 'string maload #+XEROX ".dfasl"))
      (compile-file (concatenate 'string smafuncs ".lsp"))
      (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load
         (concatenate 'string smafuncs #+XEROX ".dfasl"))
      (mapc
         #'(lambda (fname)
              (compile-file
                 (concatenate 'string *morph-source-dir* fname ".lsp")))
        '("morphan" "makesp" "makelex"
             "spdebug" "debug" "smkwgram" "mconcat" "analyse"
             "autorun"))))


(eval-when (#+(or cltl2 x3j13) common-lisp:load #-(or cltl2 x3j13) lisp:load eval)
   (mapc
      #'(lambda (x)
          (unintern x
             (find-package ' #+(or cltl2 x3j13) common-lisp-user
                #-(or cltl2 x3j13) user)))
      '(include allocate concat copy neq ncons
          declare assoc assq delq eq 
          error gensym load member memq remove tyi zerop)))


;;; End of file
