;;; Start of file LOAD

;;; GRAMMAR DEVELOPMENT ENVIRONMENT - LOAD FILE
;;;
;;; Author: John Carroll
;;;
;;; Copyright: Ted Briscoe, Bran Boguraev,
;;;            John Carroll, Claire Grover  1986-98
;;;
;;; Loading the GDE. In systems with compile-file, the files
;;; loaded should have already have been compiled. On the other
;;; hand, in systems such as MCL, PROCYON, POPLOG which compile on-
;;; the-fly in load it is the source files that are loaded here.

(in-package #+(or cltl2 x3j13) common-lisp-user #-(or cltl2 x3j13) 'user)


#-gde-debug
(eval-when (compile load eval)
   (proclaim
      '(optimize (speed 2) (safety 1) (compilation-speed 0)
         (space 0) #+(or cltl2 x3j13) (debug 1))))


;;; *** Give Common Lisp pathname representing all but the name
;;; and type of the files to be compiled/loaded.

(defvar *gde-source-pathname*
   (pathname
      #+(OR UNIX SUNOS) "/usr/groups/nltools/annlt/gde/cgde/"      
      #+XEROX "{DSK}<lispfiles2>cgde>"
      #+(OR MACINTOSH :CORAL) "internal:cgde:"
      ))


;;; Specify the default compiler output file type to load for
;;; those systems which do not try looking for files of that type.

(eval-when (load eval)
   (mapc
      #'(lambda (file)
         (load
            (merge-pathnames
               (make-pathname :name file .
                  #+(or MACINTOSH :CORAL POPLOG) (:type "lsp")
                  #+XEROX (:type "dfasl")
                  #-(or MACINTOSH :CORAL POPLOG XEROX) nil)
               *gde-source-pathname*)
            :verbose nil :print nil))
      '("custom" "hdr" "records" "defname" "toploop" "comment"
         "command" "order" "flags" "printer" "syntax"
         "files" "alias" "realias" "dictfns" "dictint"
         "lpexp" "metaexp" "compile"
         "dtree" "parse" "genrate" "semantics"
         "defns" "view" "names"
         "invalid" "graminp" "gramdel"
         "gramed" "gramove" "dpatch")))


;;; Function to call to save a GDE core image to a specified file.
;;; Stash pathnames of open lexicon streams back where they are
;;; stored so that streams can be re-opened when image is restarted.
;;; Arrange for the forms in *gde-init-forms* (set up in file custom)
;;; to be evaluated when image is re-entered, and the gde top loop
;;; to be entered.

(defun save-gde-image (file)
   (dolist (lex d-lexicon)
      (setf (car lex) (namestring (truename (car lex)))))
   #+(and HP T)
      (sys:save-world file
         (append *gde-init-forms*
            '((gde-top-loop) (system:exit)))
         "")

   #+KCL
      (progn
         (setf (symbol-function 'si:top-level)
            `(lambda nil
                ,@ *gde-init-forms*
                (gde-top-loop)))
         (save file))

   #+POPLOG
      (when
         (savelisp
            (concatenate 'string (string file) ".psv"))
         (eval (cons 'progn *gde-init-forms*))
         (gde-top-loop)
         (bye))

   #+ALLEGRO
      (let ((fn
               (compile nil
                 `(lambda nil
                     ,@ *gde-init-forms* (gde-top-loop) (exit 0)))))
         (excl:gc t)
         (if (boundp '*restart-app-function*)
            (progn
               (setq *restart-app-function* fn) ; from v4.? onwards
               (dumplisp :name file))
            (dumplisp :name file :restart-function fn :read-init-file t)))

   #+XEROX
      (progn
         (unless (member 'gde-tidyup il:aroundexitfns)
            (setf (symbol-function 'gde-tidyup)
               `(lambda (event)
                   (if
                      (member event
                         '(il:afterlogout il:aftersysout il:aftermakesys
                             il:aftersavevm))
                      ,@ *gde-init-forms*)))
            (push 'gde-tidyup il:aroundexitfns))
         (if (consp (il:sysout file))
            (gde-top-loop)))

   #+PROCYON
      (save-image :image-file file :start-up-function
         (compile nil
            `(lambda nil
                ,@ *gde-init-forms*
                (gde-top-loop))))

   #+MCL
      (save-application (pathname file) :toplevel-function
         (compile nil
            `(lambda nil
                (ccl::startup-ccl "init")
                ,@ *gde-init-forms*
                (process-run-function "GDE"
                   #'(lambda ()
                        (let ((ccl::*listener-p* t))
                           (gde-top-loop)))))))

   #+LUCID
      (disksave file :restart-function
         ;; Lucid 3.0 gives segmentation violation for restart function
         ;; below so use simpler treatment
         #+LCL3.0 #'gde-top-loop
         #-LCL3.0
         (compile nil
            `(lambda nil
                ,@ *gde-init-forms*
                (gde-top-loop) (quit)))
         #+(or LCL3.0 CLTL2) :full-gc #-(or LCL3.0 CLTL2) :gc t)

   #+LISPWORKS
      (system:save-image file :restart-function
         (compile nil
            `(lambda nil
                ,@ *gde-init-forms*
                (gde-top-loop) (bye))))

   #+CMU
      (extensions:save-lisp file :purify t :print-herald nil
         :init-function
         (compile nil
            `(lambda nil
                ,@ *gde-init-forms*
                (gde-top-loop) (quit))))
   )


;;; End of file
