;;; GRAMMAR DEVELOPMENT ENVIRONMENT - BOOT FILE
;;;
;;; Author: John Carroll
;;;
;;; Copyright: Ted Briscoe, Bran Boguraev,
;;;            John Carroll, Claire Grover  1986-98
;;;
;;; Compiling the GDE for later loading by file 'load'. Compilation
;;; is not necessary in systems such as POPLOG with no
;;; compile-file facility. In these systems, the source files themselves
;;; should be loaded using file 'load' and this file ignored.

(in-package #+(or cltl2 x3j13) common-lisp-user #-(or cltl2 x3j13) 'user)


#-gde-debug
(eval-when (compile load eval)
   (proclaim
      '(optimize (speed 2) (safety 1) (compilation-speed 0)
         (space 0) #+(or cltl2 x3j13) (debug 1))))


;;; *** Give Common Lisp pathname representing all but the name
;;; and type of the files to be compiled/loaded.

(defvar *gde-source-pathname*
   (pathname
      #+(OR UNIX SUNOS) "/usr/groups/nltools/annlt/gde/cgde/"      
      #+XEROX "{DSK}<lispfiles2>cgde>"
      #+(OR MACINTOSH :CORAL) "internal:cgde:"
      ))


(eval-when (load eval)
   (let
      ((files
          (mapcar
             #'(lambda (file)
                (merge-pathnames (make-pathname :name file :type "lsp")
                   *gde-source-pathname*))
             '("custom" "hdr" "records" "defname" "toploop" "comment"
                "command" "order" "flags" "printer" "syntax"
                "files" "alias" "realias" "dictfns" "dictint"
                "lpexp" "metaexp" "compile"
                "dtree" "parse" "genrate" "semantics"
                "defns" "view" "names"
                "invalid" "graminp" "gramdel"
                "gramed" "gramove" "dpatch"))))
         (mapc
            #'(lambda (file)
                 (compile-file file) (load file))
            files)))


;;; End of file
