structure sortingTheory :> sortingTheory =
struct
  open Type Term Thm
  infixr -->
  fun C s t ty = mk_thy_const{Name=s,Thy=t,Ty=ty}
  fun T s t A = mk_thy_type{Tyop=s, Thy=t,Args=A}
  fun V s q = mk_var(s,q)
  val U     = mk_vartype
  
  (*  Parents *)
  local open permTheory
  in end;
  val _ = Theory.link_parents
          ("sorting",981131516,679823)
          [("perm",981131505,426430)];
  val _ = Theory.incorporate_types "sorting" [];
  val _ = Theory.incorporate_consts "sorting"
     [("SORTED_tupled",
       ((T"prod" "pair"
          [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
         bool))),
      ("performs_sorting",
       ((((alpha --> (alpha --> bool)) -->
          (T"list" "list" [alpha] --> T"list" "list" [alpha])) -->
         ((alpha --> (alpha --> bool)) --> bool)))),
      ("SORTED",
       (((alpha --> (alpha --> bool)) -->
         (T"list" "list" [alpha] --> bool))))];
  
  local
  val share_table = Vector.fromList
  [C"=" "min"
    (((T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool)
      -->
      ((T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool)
       --> bool))),
   C"SORTED_tupled" "sorting"
    ((T"prod" "pair" [(alpha --> (alpha --> bool)), T"list" "list" [alpha]]
      --> bool)),
   C"WFREC" "relation"
    (((T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
       (T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))
      -->
      (((T"prod" "pair"
          [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool)
        -->
        (T"prod" "pair"
          [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))
       -->
       (T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
        bool)))),
   C"@" "min"
    ((((T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
        (T"prod" "pair"
          [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))
       --> bool) -->
      (T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
       (T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
        bool)))),
   V"R'"
    ((T"prod" "pair" [(alpha --> (alpha --> bool)), T"list" "list" [alpha]]
      -->
      (T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))),
   C"/\\" "bool" ((bool --> (bool --> bool))),
   C"WF" "relation"
    (((T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] -->
       (T"prod" "pair"
         [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))
      --> bool)), C"!" "bool" (((alpha --> bool) --> bool)), V"x" (alpha),
   C"!" "bool" (((T"list" "list" [alpha] --> bool) --> bool)),
   V"rst" (T"list" "list" [alpha]), V"y" (alpha),
   C"!" "bool" ((((alpha --> (alpha --> bool)) --> bool) --> bool)),
   V"R" ((alpha --> (alpha --> bool))),
   C"," "pair"
    (((alpha --> (alpha --> bool)) -->
      (T"list" "list" [alpha] -->
       T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]]))),
   C"CONS" "list"
    ((alpha --> (T"list" "list" [alpha] --> T"list" "list" [alpha]))),
   V"SORTED_tupled'"
    ((T"prod" "pair" [(alpha --> (alpha --> bool)), T"list" "list" [alpha]]
      --> bool)),
   V"a"
    (T"prod" "pair"
      [(alpha --> (alpha --> bool)), T"list" "list" [alpha]]),
   C"pair_case" "pair"
    ((((alpha --> (alpha --> bool)) --> (T"list" "list" [alpha] --> bool))
      -->
      (T"prod" "pair"
        [(alpha --> (alpha --> bool)), T"list" "list" [alpha]] --> bool))),
   V"v" ((alpha --> (alpha --> bool))), V"v1" (T"list" "list" [alpha]),
   C"list_case" "list"
    ((bool -->
      ((alpha --> (T"list" "list" [alpha] --> bool)) -->
       (T"list" "list" [alpha] --> bool)))), C"T" "bool" (bool),
   V"v2" (alpha), V"v3" (T"list" "list" [alpha]), V"v4" (alpha),
   V"v5" (T"list" "list" [alpha]), V"x" ((alpha --> (alpha --> bool))),
   V"x1" (T"list" "list" [alpha]), C"=" "min" ((bool --> (bool --> bool))),
   C"SORTED" "sorting"
    (((alpha --> (alpha --> bool)) --> (T"list" "list" [alpha] --> bool))),
   C"!" "bool"
    (((((alpha --> (alpha --> bool)) -->
        (T"list" "list" [alpha] --> T"list" "list" [alpha])) --> bool) -->
      bool)),
   V"f"
    (((alpha --> (alpha --> bool)) -->
      (T"list" "list" [alpha] --> T"list" "list" [alpha]))),
   C"performs_sorting" "sorting"
    ((((alpha --> (alpha --> bool)) -->
       (T"list" "list" [alpha] --> T"list" "list" [alpha])) -->
      ((alpha --> (alpha --> bool)) --> bool))),
   V"l" (T"list" "list" [alpha]),
   C"PERM" "perm"
    ((T"list" "list" [alpha] --> (T"list" "list" [alpha] --> bool))),
   C"!" "bool"
    (((((alpha --> (alpha --> bool)) --> (T"list" "list" [alpha] --> bool))
       --> bool) --> bool)),
   V"P"
    (((alpha --> (alpha --> bool)) --> (T"list" "list" [alpha] --> bool))),
   C"==>" "min" ((bool --> (bool --> bool))),
   C"NIL" "list" (T"list" "list" [alpha]), V"L" (T"list" "list" [alpha]),
   C"transitive" "relation" (((alpha --> (alpha --> bool)) --> bool)),
   C"MEM" "list" ((alpha --> (T"list" "list" [alpha] --> bool))),
   V"L1" (T"list" "list" [alpha]), V"L2" (T"list" "list" [alpha]),
   C"APPEND" "list"
    ((T"list" "list" [alpha] -->
      (T"list" "list" [alpha] --> T"list" "list" [alpha])))]
  val DT = Thm.disk_thm share_table
  in
  val SORTED_tupled_primitive_def =
    DT("", [],
       `((%0 %1) ((%2 (%3 (\%4. ((%5 (%6 $0)) (%7 (\%8. (%9 (\%10. (%7
       (\%11. (%12 (\%13. (($4 ((%14 $0) ((%15 $1) $2))) ((%14 $0) ((%15
       $3) ((%15 $1) $2)))))))))))))))) (\%16. (\%17. ((%18 (\%19. (\%20.
       (((%21 %22) (\%23. (\%24. (((%21 %22) (\%25. (\%26. ((%5 (($5 $3)
       $1)) ($7 ((%14 $5) ((%15 $1) $0))))))) $0)))) $0)))) $0)))))`)
  val SORTED_arg_munge_def =
    DT("", [],
       `(%12 (\%27. (%9 (\%28. ((%29 ((%30 $1) $0)) (%1 ((%14 $1)
       $0)))))))`)
  val performs_sorting_def =
    DT("", [],
       `(%31 (\%32. (%12 (\%13. ((%29 ((%33 $1) $0)) (%9 (\%34. ((%5 ((%35
       $0) (($2 $1) $0))) ((%30 $1) (($2 $1) $0))))))))))`)
  val SORTED_ind =
    DT("", [],
       `(%36 (\%37. ((%38 ((%5 (%12 (\%13. (($1 $0) %39)))) ((%5 (%12
       (\%13. (%7 (\%8. (($2 $1) ((%15 $0) %39))))))) (%12 (\%13. (%7 (\%8.
       (%7 (\%11. (%9 (\%10. ((%38 (($4 $3) ((%15 $1) $0))) (($4 $3) ((%15
       $2) ((%15 $1) $0))))))))))))))) (%12 (\%19. (%9 (\%20. (($2 $1)
       $0))))))))`)
  val SORTED_def =
    DT("", [],
       `((%5 ((%29 ((%30 %13) %39)) %22)) ((%5 ((%29 ((%30 %13) ((%15 %8)
       %39))) %22)) ((%29 ((%30 %13) ((%15 %8) ((%15 %11) %10)))) ((%5
       ((%13 %8) %11)) ((%30 %13) ((%15 %11) %10))))))`)
  val SORTED_eq =
    DT("", [],
       `(%12 (\%13. (%9 (\%40. (%7 (\%8. ((%38 (%41 $2)) ((%29 ((%30 $2)
       ((%15 $0) $1))) ((%5 ((%30 $2) $1)) (%7 (\%11. ((%38 ((%42 $0) $2))
       (($3 $1) $0)))))))))))))`)
  val SORTED_APPEND =
    DT("", [],
       `(%12 (\%13. (%9 (\%43. (%9 (\%44. ((%38 ((%5 (%41 $2)) ((%5 ((%30
       $2) $1)) ((%5 ((%30 $2) $0)) (%7 (\%8. (%7 (\%11. ((%38 ((%5 ((%42
       $1) $3)) ((%42 $0) $2))) (($4 $1) $0)))))))))) ((%30 $2) ((%45 $1)
       $0)))))))))`)
  end
  val _ = DB.bindl "sorting"
  [("SORTED_tupled_primitive_def",SORTED_tupled_primitive_def,DB.Def),
   ("SORTED_arg_munge_def",SORTED_arg_munge_def,DB.Def),
   ("performs_sorting_def",performs_sorting_def,DB.Def),
   ("SORTED_ind",SORTED_ind,DB.Thm), ("SORTED_def",SORTED_def,DB.Thm),
   ("SORTED_eq",SORTED_eq,DB.Thm), ("SORTED_APPEND",SORTED_APPEND,DB.Thm)]
  
  local open Portable GrammarSpecials Parse
  in
  val _ = mk_local_grms [("permTheory.perm_grammars",
                          permTheory.perm_grammars)]
  val _ = List.app (update_grms reveal)
            ["SORTED_tupled","SORTED","performs_sorting"]
  
  val sorting_grammars = Parse.current_lgrms()
  end
  
end
