signature sortingTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val SORTED_arg_munge_def : thm
    val SORTED_tupled_primitive_def : thm
    val performs_sorting_def : thm
  
  (*  Theorems  *)
    val SORTED_APPEND : thm
    val SORTED_def : thm
    val SORTED_eq : thm
    val SORTED_ind : thm
  
  val sorting_grammars : parse_type.grammar * term_grammar.grammar
(*
   [perm] Parent theory of "sorting"
   
   [SORTED_arg_munge_def]
   Definition
   [oracles: ] [axioms: ] [] |- !x x1. SORTED x x1 = SORTED_tupled (x,x1)
   
   [SORTED_tupled_primitive_def]
   Definition
   [oracles: ] [axioms: ] []
   |- SORTED_tupled =
      WFREC (@R'. WF R' /\ !x rst y R. R' (R,y::rst) (R,x::y::rst))
        (\SORTED_tupled a.
           pair_case
             (\v v1.
                list_case T
                  (\v2 v3.
                     list_case T
                       (\v4 v5. v v2 v4 /\ SORTED_tupled (v,v4::v5)) v3)
                  v1) a)
   
   [performs_sorting_def]
   Definition
   [oracles: ] [axioms: ] []
   |- !f R. performs_sorting f R = !l. PERM l (f R l) /\ SORTED R (f R l)
   
   [SORTED_APPEND]
   Theorem
   [oracles: ] [axioms: ] []
   |- !R L1 L2.
        transitive R /\ SORTED R L1 /\ SORTED R L2 /\
        (!x y. MEM x L1 /\ MEM y L2 ==> R x y) ==>
        SORTED R (APPEND L1 L2)
   
   [SORTED_def]
   Theorem
   [oracles: ] [axioms: ] []
   |- (SORTED R [] = T) /\ (SORTED R [x] = T) /\
      (SORTED R (x::y::rst) = R x y /\ SORTED R (y::rst))
   
   [SORTED_eq]
   Theorem
   [oracles: ] [axioms: ] []
   |- !R L x.
        transitive R ==>
        (SORTED R (x::L) = SORTED R L /\ !y. MEM y L ==> R x y)
   
   [SORTED_ind]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P.
        (!R. P R []) /\ (!R x. P R [x]) /\
        (!R x y rst. P R (y::rst) ==> P R (x::y::rst)) ==>
        !v v1. P v v1
   
   
*)
end
