signature permTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val PERM_def : thm
  
  (*  Theorems  *)
    val APPEND_PERM_sym : thm
    val CONS_PERM : thm
    val PERM_APPEND : thm
    val PERM_CONS_iff : thm
    val PERM_LENGTH : thm
    val PERM_cong : thm
    val PERM_intro : thm
    val PERM_mono : thm
    val PERM_nil : thm
    val PERM_refl : thm
    val PERM_split : thm
    val PERM_sym : thm
    val PERM_trans : thm
    val PERM_trans1 : thm
  
  val perm_grammars : parse_type.grammar * term_grammar.grammar
(*
   [list] Parent theory of "perm"
   
   [option] Parent theory of "perm"
   
   [PERM_def]
   Definition
   [oracles: ] [axioms: ] []
   |- !L1 L2. PERM L1 L2 = !x. FILTER ($= x) L1 = FILTER ($= x) L2
   
   [APPEND_PERM_sym]
   Theorem
   [oracles: ] [axioms: ] []
   |- !A B C. PERM (APPEND A B) C ==> PERM (APPEND B A) C
   
   [CONS_PERM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !x L M N. PERM L (APPEND M N) ==> PERM (x::L) (APPEND M (x::N))
   
   [PERM_APPEND]
   Theorem
   [oracles: ] [axioms: ] [] |- !l1 l2. PERM (APPEND l1 l2) (APPEND l2 l1)
   
   [PERM_CONS_iff]
   Theorem
   [oracles: ] [axioms: ] [] |- !l2 l1 x. PERM (x::l1) (x::l2) = PERM l1 l2
   
   [PERM_LENGTH]
   Theorem
   [oracles: ] [axioms: ] []
   |- !l1 l2. PERM l1 l2 ==> (LENGTH l1 = LENGTH l2)
   
   [PERM_cong]
   Theorem
   [oracles: ] [axioms: ] []
   |- !L1 L2 L3 L4.
        PERM L1 L3 /\ PERM L2 L4 ==> PERM (APPEND L1 L2) (APPEND L3 L4)
   
   [PERM_intro]
   Theorem
   [oracles: ] [axioms: ] [] |- !x y. (x = y) ==> PERM x y
   
   [PERM_mono]
   Theorem
   [oracles: ] [axioms: ] []
   |- !l1 l2 x. PERM l1 l2 ==> PERM (x::l1) (x::l2)
   
   [PERM_nil]
   Theorem
   [oracles: ] [axioms: ] []
   |- !L. (PERM L [] = (L = [])) /\ (PERM [] L = (L = []))
   
   [PERM_refl]  Theorem  [oracles: ] [axioms: ] [] |- !L. PERM L L
   
   [PERM_split]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P l. PERM l (APPEND (FILTER P l) (FILTER ($~ o P) l))
   
   [PERM_sym]
   Theorem
   [oracles: ] [axioms: ] [] |- !l1 l2. PERM l1 l2 = PERM l2 l1
   
   [PERM_trans]  Theorem  [oracles: ] [axioms: ] [] |- transitive PERM
   
   [PERM_trans1]
   Theorem
   [oracles: ] [axioms: ] [] |- !x y z. PERM x y /\ PERM y z ==> PERM x z
   
   
*)
end
